/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.VolatileCallSite;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.zip.CRC32;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.VMIntrinsicMethod;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotExceptionDispatchPlugin;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotInvocationPluginProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotInvocationPlugins;
import org.graalvm.compiler.hotspot.meta.HotSpotJITClassInitializationPlugin;
import org.graalvm.compiler.hotspot.meta.HotSpotNodePlugin;
import org.graalvm.compiler.hotspot.meta.HotSpotWordOperationPlugin;
import org.graalvm.compiler.hotspot.nodes.CurrentJavaThreadNode;
import org.graalvm.compiler.hotspot.nodes.HotSpotLoadReservedReferenceNode;
import org.graalvm.compiler.hotspot.nodes.HotSpotStoreReservedReferenceNode;
import org.graalvm.compiler.hotspot.replacements.BigIntegerSnippets;
import org.graalvm.compiler.hotspot.replacements.CallSiteTargetNode;
import org.graalvm.compiler.hotspot.replacements.DigestBaseSnippets;
import org.graalvm.compiler.hotspot.replacements.FastNotifyNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotIdentityHashCodeNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotInvocationPluginHelper;
import org.graalvm.compiler.hotspot.replacements.HotSpotReflectionGetCallerClassNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.replacements.HubGetClassNode;
import org.graalvm.compiler.hotspot.replacements.ObjectCloneNode;
import org.graalvm.compiler.hotspot.replacements.UnsafeCopyMemoryNode;
import org.graalvm.compiler.hotspot.word.HotSpotWordTypes;
import org.graalvm.compiler.java.BytecodeParserOptions;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FieldLocationIdentity;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.IntegerTestNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.calc.XorNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.extended.ObjectIsArrayNode;
import org.graalvm.compiler.nodes.graphbuilderconf.ForeignCallPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedPluginFactory;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.java.DynamicNewArrayNode;
import org.graalvm.compiler.nodes.java.DynamicNewInstanceNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.replacements.InlineDuringParsingPlugin;
import org.graalvm.compiler.replacements.InvocationPluginHelper;
import org.graalvm.compiler.replacements.MethodHandlePlugin;
import org.graalvm.compiler.replacements.NodeIntrinsificationProvider;
import org.graalvm.compiler.replacements.ReplacementsImpl;
import org.graalvm.compiler.replacements.SnippetSubstitutionInvocationPlugin;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.StandardGraphBuilderPlugins;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyCallNode;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyForeignCalls;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopySnippets;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.word.LocationIdentity;

public class HotSpotGraphBuilderPlugins {
    public static GraphBuilderConfiguration.Plugins create(final HotSpotGraalRuntimeProvider graalRuntime, CompilerConfiguration compilerConfiguration, final GraalHotSpotVMConfig config, final HotSpotWordTypes wordTypes, final MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection, final SnippetReflectionProvider snippetReflection, final HotSpotHostForeignCallsProvider foreignCalls, final ReplacementsImpl replacements, OptionValues options, final TargetDescription target) {
        final HotSpotInvocationPlugins invocationPlugins = new HotSpotInvocationPlugins(graalRuntime, config, compilerConfiguration, target, options);
        final GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(invocationPlugins);
        plugins.appendNodePlugin(new HotSpotExceptionDispatchPlugin(config, wordTypes.getWordKind()));
        if (!Services.IS_IN_NATIVE_IMAGE) {
            HotSpotWordOperationPlugin wordOperationPlugin = new HotSpotWordOperationPlugin(snippetReflection, wordTypes);
            HotSpotNodePlugin nodePlugin = new HotSpotNodePlugin(wordOperationPlugin);
            plugins.appendTypePlugin(nodePlugin);
            plugins.appendNodePlugin(nodePlugin);
        }
        plugins.appendNodePlugin(new MethodHandlePlugin(constantReflection.getMethodHandleAccess(), !config.supportsMethodHandleDeoptimizationEntry()));
        plugins.appendInlineInvokePlugin(replacements);
        if (BytecodeParserOptions.InlineDuringParsing.getValue(options).booleanValue()) {
            plugins.appendInlineInvokePlugin(new InlineDuringParsingPlugin());
        }
        if (config.instanceKlassInitThreadOffset != -1) {
            plugins.setClassInitializationPlugin(new HotSpotJITClassInitializationPlugin());
        }
        compilerConfiguration.registerGraphBuilderPlugins(plugins, options);
        invocationPlugins.defer(new Runnable(){

            @Override
            public void run() {
                HotSpotGraphBuilderPlugins.registerObjectPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerClassPlugins(plugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerSystemPlugins(invocationPlugins);
                HotSpotGraphBuilderPlugins.registerThreadPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerCallSitePlugins(invocationPlugins);
                HotSpotGraphBuilderPlugins.registerReflectionPlugins(invocationPlugins, replacements, config);
                HotSpotGraphBuilderPlugins.registerAESPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerAdler32Plugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerCRC32Plugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerCRC32CPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerBigIntegerPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerSHAPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerMD5Plugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerGHASHPlugins(invocationPlugins, config, metaAccess, replacements);
                HotSpotGraphBuilderPlugins.registerBase64Plugins(invocationPlugins, config, metaAccess, replacements);
                HotSpotGraphBuilderPlugins.registerUnsafePlugins(invocationPlugins, config, replacements);
                StandardGraphBuilderPlugins.registerInvocationPlugins(snippetReflection, invocationPlugins, replacements, true, false, true, graalRuntime.getHostProviders().getLowerer());
                HotSpotGraphBuilderPlugins.registerArrayPlugins(invocationPlugins, replacements, config);
                HotSpotGraphBuilderPlugins.registerStringPlugins(invocationPlugins, replacements, wordTypes, foreignCalls, config);
                HotSpotGraphBuilderPlugins.registerArraysSupportPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerReferencePlugins(invocationPlugins, replacements);
                HotSpotGraphBuilderPlugins.registerTrufflePlugins(invocationPlugins, wordTypes, config);
                HotSpotGraphBuilderPlugins.registerInstrumentationImplPlugins(invocationPlugins, config, replacements);
                for (HotSpotInvocationPluginProvider p : GraalServices.load(HotSpotInvocationPluginProvider.class)) {
                    p.registerInvocationPlugins(target.arch, plugins.getInvocationPlugins(), replacements);
                }
            }
        });
        if (!Services.IS_IN_NATIVE_IMAGE) {
            NodeIntrinsificationProvider nodeIntrinsificationProvider = new NodeIntrinsificationProvider(metaAccess, snippetReflection, foreignCalls, wordTypes, target);
            invocationPlugins.defer(() -> {
                for (GeneratedPluginFactory factory : GraalServices.load(GeneratedPluginFactory.class)) {
                    factory.registerPlugins(invocationPlugins, nodeIntrinsificationProvider);
                }
            });
        }
        return plugins;
    }

    private static void registerTrufflePlugins(InvocationPlugins plugins, final WordTypes wordTypes, final GraalHotSpotVMConfig config) {
        if (config.jvmciReservedReference0Offset == -1) {
            return;
        }
        InvocationPlugins.Registration tl = new InvocationPlugins.Registration(plugins, "org.graalvm.compiler.truffle.runtime.hotspot.HotSpotFastThreadLocal");
        tl.register(new InvocationPlugin("get", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                int jvmciReservedReference0Offset = config.jvmciReservedReference0Offset;
                GraalError.guarantee(jvmciReservedReference0Offset != -1, "jvmciReservedReference0Offset is not available but used.");
                b.addPush(JavaKind.Object, new HotSpotLoadReservedReferenceNode(b.getMetaAccess(), wordTypes, jvmciReservedReference0Offset));
                return true;
            }
        });
        tl.register(new InvocationPlugin("set", new Type[]{InvocationPlugin.Receiver.class, Object[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                int jvmciReservedReference0Offset = config.jvmciReservedReference0Offset;
                GraalError.guarantee(jvmciReservedReference0Offset != -1, "jvmciReservedReference0Offset is not available but used.");
                b.add(new HotSpotStoreReservedReferenceNode(wordTypes, value, jvmciReservedReference0Offset));
                return true;
            }
        });
    }

    private static void registerObjectPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Object.class), replacements);
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("clone", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode object = receiver.get();
                b.addPush(JavaKind.Object, new ObjectCloneNode(MacroNode.MacroParams.of(b, targetMethod, object)));
                return true;
            }
        });
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("hashCode", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode object = receiver.get();
                b.addPush(JavaKind.Int, new HotSpotIdentityHashCodeNode(object, b.bci()));
                return true;
            }
        });
        if (config.inlineNotify()) {
            r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("notify", new Type[]{InvocationPlugin.Receiver.class}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    ValueNode object = receiver.get();
                    b.add(new FastNotifyNode(object, false, b.bci()));
                    return true;
                }
            });
        }
        if (config.inlineNotifyAll()) {
            r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("notifyAll", new Type[]{InvocationPlugin.Receiver.class}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    ValueNode object = receiver.get();
                    b.add(new FastNotifyNode(object, true, b.bci()));
                    return true;
                }
            });
        }
    }

    private static void registerClassPlugins(GraphBuilderConfiguration.Plugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), (Type)((Object)Class.class), replacements);
        r.register(new InvocationPlugin("getModifiers", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(receiver.get());
                    PiNode nonNullKlass = helper.emitNullReturnGuard(klass, ConstantNode.forInt(1041), 0.25);
                    helper.emitFinalReturn(JavaKind.Int, helper.readKlassModifierFlags(nonNullKlass));
                }
                return true;
            }
        });
        r.register(new InvocationPlugin("isInterface", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(receiver.get());
                    PiNode klassNonNull = helper.emitNullReturnGuard(klass, ConstantNode.forBoolean(false), 0.25);
                    ValueNode accessFlags = helper.readKlassAccessFlags(klassNonNull);
                    LogicNode test = IntegerTestNode.create(accessFlags, ConstantNode.forInt(512), NodeView.DEFAULT);
                    helper.emitFinalReturn(JavaKind.Boolean, ConditionalNode.create(test, ConstantNode.forBoolean(false), ConstantNode.forBoolean(true), NodeView.DEFAULT));
                }
                return true;
            }
        });
        r.register(new InvocationPlugin("isPrimitive", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(receiver.get());
                    LogicNode isNull = b.add(IsNullNode.create(klass));
                    b.addPush(JavaKind.Boolean, ConditionalNode.create(isNull, b.add(ConstantNode.forBoolean(true)), b.add(ConstantNode.forBoolean(false)), NodeView.DEFAULT));
                }
                return true;
            }
        });
        r.register(new InvocationPlugin("getSuperclass", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(receiver.get());
                    ConstantNode nullValue = ConstantNode.defaultForKind(JavaKind.Object);
                    PiNode klassNonNull = helper.emitNullReturnGuard(klass, nullValue, 0.25);
                    ValueNode accessFlags = helper.readKlassAccessFlags(klassNonNull);
                    LogicNode test = IntegerTestNode.create(accessFlags, ConstantNode.forInt(512), NodeView.DEFAULT);
                    helper.emitReturnIfNot(test, nullValue, 0.25);
                    ValueNode layoutHelper = helper.klassLayoutHelper(klassNonNull);
                    ResolvedJavaType objectType = b.getMetaAccess().lookupJavaType(Object.class);
                    ConstantNode objectClass = ConstantNode.forConstant(b.getConstantReflection().asJavaClass(objectType), b.getMetaAccess());
                    helper.emitReturnIf(layoutHelper, Condition.LT, ConstantNode.forInt(config.klassLayoutHelperNeutralValue), objectClass, 0.25);
                    ValueNode superKlass = helper.readKlassSuperKlass(klassNonNull);
                    PiNode superKlassNonNull = helper.emitNullReturnGuard(superKlass, nullValue, 0.25);
                    helper.emitFinalReturn(JavaKind.Object, new HubGetClassNode(b.getMetaAccess(), superKlassNonNull));
                }
                return true;
            }
        });
        r.registerConditional(config.jvmAccIsHiddenClass != 0, new InvocationPlugin("isHidden", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(receiver.get());
                    PiNode nonNullKlass = helper.emitNullReturnGuard(klass, ConstantNode.forBoolean(false), 0.25);
                    ValueNode accessFlags = helper.readKlassAccessFlags(nonNullKlass);
                    LogicNode test = IntegerTestNode.create(accessFlags, ConstantNode.forInt(config.jvmAccIsHiddenClass), NodeView.DEFAULT);
                    helper.emitFinalReturn(JavaKind.Boolean, ConditionalNode.create(test, ConstantNode.forBoolean(false), ConstantNode.forBoolean(true), NodeView.DEFAULT));
                }
                return true;
            }
        });
    }

    private static void registerCallSitePlugins(InvocationPlugins plugins) {
        InvocationPlugin.InlineOnlyInvocationPlugin plugin = new InvocationPlugin.InlineOnlyInvocationPlugin("getTarget", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode callSite = receiver.get();
                ConstantNode folded = CallSiteTargetNode.tryFold(GraphUtil.originalValue(callSite, true), b.getMetaAccess(), b.getAssumptions());
                if (folded != null) {
                    b.addPush(JavaKind.Object, folded);
                } else {
                    b.addPush(JavaKind.Object, new CallSiteTargetNode(MacroNode.MacroParams.of(b, targetMethod, callSite)));
                }
                return true;
            }
        };
        plugins.register((Type)((Object)ConstantCallSite.class), plugin);
        plugins.register((Type)((Object)MutableCallSite.class), plugin);
        plugins.register((Type)((Object)VolatileCallSite.class), plugin);
    }

    private static void registerReflectionPlugins(InvocationPlugins plugins, Replacements replacements, final GraalHotSpotVMConfig config) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.reflect.Reflection", replacements);
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("getCallerClass", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, new HotSpotReflectionGetCallerClassNode(MacroNode.MacroParams.of(b, targetMethod, new ValueNode[0])));
                return true;
            }
        });
        r.register(new InvocationPlugin("getClassAccessFlags", new Type[]{Class.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode klass = helper.readKlassFromClass(b.nullCheckedValue(arg));
                    PiNode klassNonNull = helper.emitNullReturnGuard(klass, ConstantNode.forInt(1041), 0.25);
                    ValueNode accessFlags = helper.readKlassAccessFlags(klassNonNull);
                    helper.emitFinalReturn(JavaKind.Int, new AndNode(accessFlags, ConstantNode.forInt(config.jvmAccWrittenFlags)));
                }
                return true;
            }
        });
    }

    private static void registerUnsafePlugins(InvocationPlugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.misc.Unsafe", replacements);
        r.register(new InvocationPlugin("copyMemory0", new Type[]{InvocationPlugin.Receiver.class, Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode srcBase, ValueNode srcOffset, ValueNode destBase, ValueNode destOffset, ValueNode bytes) {
                b.add(new UnsafeCopyMemoryNode(config.doingUnsafeAccessOffset != Integer.MAX_VALUE, receiver.get(), srcBase, srcOffset, destBase, destOffset, bytes));
                return true;
            }
        });
        r.register(new InvocationPlugin("allocateInstance", new Type[]{InvocationPlugin.Receiver.class, Class.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode clazz) {
                unsafe.get();
                DynamicNewInstanceNode.createAndPush(b, clazz);
                return true;
            }
        });
    }

    private static void registerSystemPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)System.class));
        r.register(new ForeignCallPlugin(HotSpotHostForeignCallsProvider.JAVA_TIME_MILLIS, "currentTimeMillis", new Type[0]));
        r.register(new ForeignCallPlugin(HotSpotHostForeignCallsProvider.JAVA_TIME_NANOS, "nanoTime", new Type[0]));
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("identityHashCode", new Type[]{Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.addPush(JavaKind.Int, new HotSpotIdentityHashCodeNode(object, b.bci()));
                return true;
            }
        });
        ArrayCopySnippets.registerSystemArraycopyPlugin(r);
    }

    private static void registerArrayPlugins(InvocationPlugins plugins, Replacements replacements, final GraalHotSpotVMConfig config) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Array.class), replacements);
        r.setAllowOverwrite(true);
        r.register(new InvocationPlugin("newArray", new Type[]{Class.class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode componentType, ValueNode length) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode nonNullComponentType = b.nullCheckedValue(componentType);
                    ValueNode arrayClass = helper.loadArrayKlass(nonNullComponentType);
                    helper.doFallbackIf(IsNullNode.create(arrayClass), 0.25);
                    helper.emitFinalReturn(JavaKind.Object, new DynamicNewArrayNode(nonNullComponentType, length, true));
                }
                return true;
            }
        });
    }

    private static void registerStringPlugins(InvocationPlugins plugins, Replacements replacements, final WordTypes wordTypes, final ArrayCopyForeignCalls foreignCalls, final GraalHotSpotVMConfig vmConfig) {
        InvocationPlugins.Registration utf16r = new InvocationPlugins.Registration(plugins, "java.lang.StringUTF16", replacements);
        utf16r.register(new InvocationPlugin("toBytes", new Type[]{char[].class, Integer.TYPE, Integer.TYPE}){
            private static final int MAX_LENGTH = 0x3FFFFFFF;

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value, ValueNode srcBegin, ValueNode length) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, vmConfig);){
                    helper.intrinsicRangeCheck(srcBegin, Condition.LT, ConstantNode.forInt(0));
                    helper.intrinsicRangeCheck(length, Condition.LT, ConstantNode.forInt(0));
                    helper.intrinsicRangeCheck(length, Condition.GT, ConstantNode.forInt(0x3FFFFFFF));
                    ArrayLengthNode valueLength = b.add(new ArrayLengthNode(value));
                    SubNode limit = b.add(new SubNode(valueLength, length));
                    helper.intrinsicRangeCheck(srcBegin, Condition.GT, limit);
                    NewArrayNode newArray = b.add(new NewArrayNode(b.getMetaAccess().lookupJavaType(Byte.TYPE), b.add(new LeftShiftNode(length, ConstantNode.forInt(1))), false));
                    b.addPush(JavaKind.Object, newArray);
                    b.add(new ArrayCopyCallNode(foreignCalls, wordTypes, value, srcBegin, newArray, ConstantNode.forInt(0), length, JavaKind.Char, LocationIdentity.init(), false, true, true, vmConfig.heapWordSize));
                }
                return true;
            }
        });
        utf16r.register(new InvocationPlugin("getChars", new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, char[].class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value, ValueNode srcBegin, ValueNode srcEnd, ValueNode dst, ValueNode dstBegin) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, vmConfig);){
                    ValueNode length = helper.sub(srcEnd, srcBegin);
                    helper.intrinsicRangeCheck(srcBegin, Condition.LT, ConstantNode.forInt(0));
                    helper.intrinsicRangeCheck(length, Condition.LT, ConstantNode.forInt(0));
                    ValueNode srcLimit = helper.sub(helper.shr(helper.length(value), 1), length);
                    helper.intrinsicRangeCheck(srcBegin, Condition.GT, srcLimit);
                    ValueNode limit = helper.sub(helper.length(dst), length);
                    helper.intrinsicRangeCheck(dstBegin, Condition.GT, limit);
                    b.add(new ArrayCopyCallNode(foreignCalls, wordTypes, value, srcBegin, dst, dstBegin, length, JavaKind.Char, JavaKind.Byte, JavaKind.Char, false, true, true, vmConfig.heapWordSize));
                }
                return true;
            }
        });
    }

    private static void registerThreadPlugins(InvocationPlugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Thread.class), replacements);
        r.register(new InvocationPlugin("currentThread", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode value = helper.readCurrentThreadObject();
                    b.push(JavaKind.Object, value);
                }
                return true;
            }
        });
        r.registerConditional(config.osThreadInterruptedOffset != Integer.MAX_VALUE && !config.threadObjectFieldIsHandle, new InvocationPlugin("isInterrupted", new Type[]{InvocationPlugin.Receiver.class, Boolean.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode clearInterrupted) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode receiverThreadObject = receiver.get();
                    CurrentJavaThreadNode thread = b.add(new CurrentJavaThreadNode(helper.getWordKind()));
                    ValueNode currentThreadObject = helper.readCurrentThreadObject(thread);
                    helper.doFallbackIf(receiverThreadObject, Condition.NE, currentThreadObject, 0.25);
                    ValueNode osThread = helper.readOsThread(thread);
                    ValueNode interrupted = helper.readOsThreadInterrupted(osThread);
                    helper.emitReturnIf(interrupted, Condition.EQ, ConstantNode.forInt(0), ConstantNode.forBoolean(false), 0.75);
                    helper.doFallbackIf(clearInterrupted, Condition.EQ, ConstantNode.forBoolean(true), 0.25);
                    LogicNode test = helper.createCompare(interrupted, CanonicalCondition.EQ, ConstantNode.forInt(0));
                    helper.emitFinalReturn(JavaKind.Boolean, ConditionalNode.create(test, ConstantNode.forBoolean(false), ConstantNode.forBoolean(true), NodeView.DEFAULT));
                }
                return true;
            }
        });
    }

    public static boolean isIntrinsicName(GraalHotSpotVMConfig config, String className, String name) {
        for (VMIntrinsicMethod intrinsic : config.getStore().getIntrinsics()) {
            if (!className.equals(intrinsic.declaringClass) || !name.equals(intrinsic.name)) continue;
            return true;
        }
        return false;
    }

    private static void registerAESPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.AESCrypt", replacements);
        r.registerConditional(config.useAESIntrinsics && config.aescryptEncryptBlockStub != 0L, new AESCryptPlugin(CryptMode.ENCRYPT));
        r.registerConditional(config.useAESIntrinsics && config.aescryptDecryptBlockStub != 0L, new AESCryptPlugin(CryptMode.DECRYPT));
        r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.CipherBlockChaining", replacements);
        r.registerConditional(config.useAESIntrinsics && config.cipherBlockChainingEncryptAESCryptStub != 0L, new CipherBlockChainingCryptPlugin(CryptMode.ENCRYPT));
        r.registerConditional(config.useAESIntrinsics && config.cipherBlockChainingDecryptAESCryptStub != 0L, new CipherBlockChainingCryptPlugin(CryptMode.DECRYPT));
        r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.ElectronicCodeBook", replacements);
        r.registerConditional(config.electronicCodeBookEncrypt != 0L, new ElectronicCodeBookCryptPlugin(CryptMode.ENCRYPT));
        r.registerConditional(config.electronicCodeBookDecrypt != 0L, new ElectronicCodeBookCryptPlugin(CryptMode.DECRYPT));
        r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.CounterMode", replacements);
        r.registerConditional(config.useAESCTRIntrinsics(), new CounterModeCryptPlugin());
    }

    private static void registerAdler32Plugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.util.zip.Adler32", replacements);
        r.registerConditional(config.updateBytesAdler32 != 0L, new InvocationPlugin.InlineOnlyInvocationPlugin("updateBytes", new Type[]{Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode adler, ValueNode src, ValueNode off, ValueNode len) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    ValueNode addr = helper.arrayElementPointer(src, JavaKind.Byte, off);
                    ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_ADLER32, adler, addr, len);
                    b.addPush(JavaKind.Int, call);
                }
                return true;
            }
        });
        r.registerConditional(config.updateBytesAdler32 != 0L, new InvocationPlugin.InlineOnlyInvocationPlugin("updateByteBuffer", new Type[]{Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode adler, ValueNode addr, ValueNode off, ValueNode len) {
                ComputeObjectAddressNode buff = b.add(new ComputeObjectAddressNode(addr, off));
                ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_ADLER32, adler, buff, len);
                b.addPush(JavaKind.Int, call);
                return true;
            }
        });
    }

    private static void registerBigIntegerPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)BigInteger.class), replacements);
        r.registerConditional(config.useMultiplyToLenIntrinsic(), new SnippetSubstitutionInvocationPlugin<BigIntegerSnippets.Templates>(BigIntegerSnippets.Templates.class, "implMultiplyToLen", new Type[]{int[].class, Integer.TYPE, int[].class, Integer.TYPE, int[].class}){

            @Override
            public SnippetTemplate.SnippetInfo getSnippet(BigIntegerSnippets.Templates templates) {
                return templates.implMultiplyToLen;
            }
        });
        r.registerConditional(config.useMulAddIntrinsic(), new InvocationPlugin("implMulAdd", new Type[]{int[].class, int[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode out, ValueNode in, ValueNode offset, ValueNode len, ValueNode k) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    ValueNode outNonNull = b.nullCheckedValue(out);
                    ArrayLengthNode outNonNullLength = b.add(new ArrayLengthNode(outNonNull));
                    SubNode newOffset = new SubNode(outNonNullLength, offset);
                    ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.MUL_ADD, helper.arrayStart(outNonNull, JavaKind.Int), helper.arrayStart(in, JavaKind.Int), newOffset, len, k);
                    b.addPush(JavaKind.Int, call);
                }
                return true;
            }
        });
        r.registerConditional(config.useMontgomeryMultiplyIntrinsic(), new InvocationPlugin("implMontgomeryMultiply", new Type[]{int[].class, int[].class, int[].class, Integer.TYPE, Long.TYPE, int[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a, ValueNode bObject, ValueNode n, ValueNode len, ValueNode inv, ValueNode product) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    b.addPush(JavaKind.Object, product);
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.MONTGOMERY_MULTIPLY, helper.arrayStart(a, JavaKind.Int), helper.arrayStart(bObject, JavaKind.Int), helper.arrayStart(n, JavaKind.Int), len, inv, helper.arrayStart(product, JavaKind.Int)));
                }
                return true;
            }
        });
        r.registerConditional(config.useMontgomerySquareIntrinsic(), new InvocationPlugin("implMontgomerySquare", new Type[]{int[].class, int[].class, Integer.TYPE, Long.TYPE, int[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a, ValueNode n, ValueNode len, ValueNode inv, ValueNode product) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    b.addPush(JavaKind.Object, product);
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.MONTGOMERY_SQUARE, helper.arrayStart(a, JavaKind.Int), helper.arrayStart(n, JavaKind.Int), len, inv, helper.arrayStart(product, JavaKind.Int)));
                }
                return true;
            }
        });
        r.registerConditional(config.useSquareToLenIntrinsic(), new InvocationPlugin("implSquareToLen", new Type[]{int[].class, Integer.TYPE, int[].class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode len, ValueNode z, ValueNode zlen) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    b.addPush(JavaKind.Object, z);
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.SQUARE_TO_LEN, helper.arrayStart(x, JavaKind.Int), len, helper.arrayStart(z, JavaKind.Int), zlen));
                }
                return true;
            }
        });
        r.registerConditional(config.bigIntegerLeftShiftWorker != 0L, new InvocationPlugin("shiftLeftImplWorker", new Type[]{int[].class, int[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode newArr, ValueNode oldArr, ValueNode newIdx, ValueNode shiftCount, ValueNode numIter) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.BIGINTEGER_LEFT_SHIFT_WORKER, helper.arrayStart(newArr, JavaKind.Int), helper.arrayStart(oldArr, JavaKind.Int), newIdx, shiftCount, numIter));
                }
                return true;
            }

            @Override
            public boolean isOptional() {
                return JavaVersionUtil.JAVA_SPEC < 14;
            }
        });
        r.registerConditional(config.bigIntegerRightShiftWorker != 0L, new InvocationPlugin("shiftRightImplWorker", new Type[]{int[].class, int[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode newArr, ValueNode oldArr, ValueNode newIdx, ValueNode shiftCount, ValueNode numIter) {
                try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.BIGINTEGER_RIGHT_SHIFT_WORKER, helper.arrayStart(newArr, JavaKind.Int), helper.arrayStart(oldArr, JavaKind.Int), newIdx, shiftCount, numIter));
                }
                return true;
            }

            @Override
            public boolean isOptional() {
                return JavaVersionUtil.JAVA_SPEC < 14;
            }
        });
    }

    private static void registerSHAPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        boolean useMD5 = config.md5ImplCompressMultiBlock != 0L;
        boolean useSha1 = config.useSHA1Intrinsics();
        boolean useSha256 = config.useSHA256Intrinsics();
        boolean useSha512 = config.useSHA512Intrinsics();
        boolean useSha3 = config.sha3ImplCompressMultiBlock != 0L;
        boolean implCompressMultiBlock0Enabled = HotSpotGraphBuilderPlugins.isIntrinsicName(config, "sun/security/provider/DigestBase", "implCompressMultiBlock0") && (useMD5 || useSha1 || useSha256 || useSha512 || useSha3);
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "sun.security.provider.DigestBase", replacements);
        r.registerConditional(implCompressMultiBlock0Enabled, new SnippetSubstitutionInvocationPlugin<DigestBaseSnippets.Templates>(DigestBaseSnippets.Templates.class, "implCompressMultiBlock0", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE}){

            @Override
            protected Object[] getConstantArguments(ResolvedJavaMethod targetMethod) {
                ResolvedJavaType declaringClass = targetMethod.getDeclaringClass();
                return new Object[]{declaringClass, HotSpotReplacementsUtil.getType(declaringClass, "Lsun/security/provider/MD5;"), HotSpotReplacementsUtil.getType(declaringClass, "Lsun/security/provider/SHA;"), HotSpotReplacementsUtil.getType(declaringClass, "Lsun/security/provider/SHA2;"), HotSpotReplacementsUtil.getType(declaringClass, "Lsun/security/provider/SHA5;"), HotSpotReplacementsUtil.getType(declaringClass, "Lsun/security/provider/SHA3;")};
            }

            @Override
            public SnippetTemplate.SnippetInfo getSnippet(DigestBaseSnippets.Templates templates) {
                return templates.implCompressMultiBlock0;
            }
        });
        InvocationPlugins.Registration rSha1 = new InvocationPlugins.Registration(plugins, "sun.security.provider.SHA", replacements);
        rSha1.registerConditional(useSha1, new DigestInvocationPlugin(HotSpotBackend.SHA_IMPL_COMPRESS));
        InvocationPlugins.Registration rSha256 = new InvocationPlugins.Registration(plugins, "sun.security.provider.SHA2", replacements);
        rSha256.registerConditional(useSha256, new DigestInvocationPlugin(HotSpotBackend.SHA2_IMPL_COMPRESS));
        InvocationPlugins.Registration rSha512 = new InvocationPlugins.Registration(plugins, "sun.security.provider.SHA5", replacements);
        rSha512.registerConditional(useSha512, new DigestInvocationPlugin(HotSpotBackend.SHA5_IMPL_COMPRESS));
        InvocationPlugins.Registration rSha3 = new InvocationPlugins.Registration(plugins, "sun.security.provider.SHA3", replacements);
        rSha3.registerConditional(config.sha3ImplCompress != 0L, new DigestInvocationPlugin(HotSpotBackend.SHA5_IMPL_COMPRESS));
    }

    private static void registerMD5Plugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "sun.security.provider.MD5", replacements);
        r.registerConditional(config.md5ImplCompress != 0L, new DigestInvocationPlugin(HotSpotBackend.MD5_IMPL_COMPRESS));
    }

    private static void registerGHASHPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, final MetaAccessProvider metaAccess, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.GHASH", replacements);
        r.registerConditional(config.useGHASHIntrinsics(), new InvocationPlugin("processBlocks", new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, long[].class, long[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode data, ValueNode inOffset, ValueNode blocks, ValueNode state, ValueNode hashSubkey) {
                int longArrayBaseOffset = metaAccess.getArrayBaseOffset(JavaKind.Long);
                int byteArrayBaseOffset = metaAccess.getArrayBaseOffset(JavaKind.Byte);
                ValueNode dataOffset = AddNode.create(ConstantNode.forInt(byteArrayBaseOffset), inOffset, NodeView.DEFAULT);
                ComputeObjectAddressNode dataAddress = b.add(new ComputeObjectAddressNode(data, dataOffset));
                ComputeObjectAddressNode stateAddress = b.add(new ComputeObjectAddressNode(state, ConstantNode.forInt(longArrayBaseOffset)));
                ComputeObjectAddressNode hashSubkeyAddress = b.add(new ComputeObjectAddressNode(hashSubkey, ConstantNode.forInt(longArrayBaseOffset)));
                b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.GHASH_PROCESS_BLOCKS, stateAddress, hashSubkeyAddress, dataAddress, blocks));
                return true;
            }
        });
    }

    private static void registerBase64Plugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, final MetaAccessProvider metaAccess, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.util.Base64$Encoder", replacements);
        r.registerConditional(config.base64EncodeBlock != 0L, new InvocationPlugin("encodeBlock", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Boolean.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode sp, ValueNode sl, ValueNode dst, ValueNode dp, ValueNode isURL) {
                int byteArrayBaseOffset = metaAccess.getArrayBaseOffset(JavaKind.Byte);
                ComputeObjectAddressNode srcAddress = b.add(new ComputeObjectAddressNode(src, ConstantNode.forInt(byteArrayBaseOffset)));
                ComputeObjectAddressNode dstAddress = b.add(new ComputeObjectAddressNode(dst, ConstantNode.forInt(byteArrayBaseOffset)));
                b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.BASE64_ENCODE_BLOCK, srcAddress, sp, sl, dstAddress, dp, isURL));
                return true;
            }
        });
        r = new InvocationPlugins.Registration(plugins, "java.util.Base64$Decoder", replacements);
        r.registerConditional(config.base64DecodeBlock != 0L, new InvocationPlugin("decodeBlock", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Boolean.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode sp, ValueNode sl, ValueNode dst, ValueNode dp, ValueNode isURL) {
                int byteArrayBaseOffset = metaAccess.getArrayBaseOffset(JavaKind.Byte);
                ComputeObjectAddressNode srcAddress = b.add(new ComputeObjectAddressNode(src, ConstantNode.forInt(byteArrayBaseOffset)));
                ComputeObjectAddressNode dstAddress = b.add(new ComputeObjectAddressNode(dst, ConstantNode.forInt(byteArrayBaseOffset)));
                ForeignCallNode call = b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.BASE64_DECODE_BLOCK, srcAddress, sp, sl, dstAddress, dp, isURL));
                b.addPush(JavaKind.Int, call);
                return true;
            }
        });
    }

    private static void registerCRC32Plugins(InvocationPlugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)CRC32.class), replacements);
        r.registerConditional(config.useCRC32Intrinsics() && config.crcTableAddress != 0L, new InvocationPlugin("update", new Type[]{Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode arg) {
                ConstantNode crcTableRawAddress = ConstantNode.forLong(config.crcTableAddress);
                XorNode c = new XorNode(crc, ConstantNode.forInt(-1));
                AndNode index = new AndNode(new XorNode(arg, c), ConstantNode.forInt(255));
                LeftShiftNode offset = new LeftShiftNode(index, ConstantNode.forInt(2));
                OffsetAddressNode address = new OffsetAddressNode(crcTableRawAddress, new SignExtendNode(offset, 32, 64));
                ValueNode result = b.add(new JavaReadNode(JavaKind.Int, (AddressNode)address, HotSpotBackend.CRC_TABLE_LOCATION, OnHeapMemoryAccess.BarrierType.NONE, false));
                result = new XorNode(result, new UnsignedRightShiftNode(c, ConstantNode.forInt(8)));
                b.addPush(JavaKind.Int, new XorNode(result, ConstantNode.forInt(-1)));
                return true;
            }
        });
        r.registerConditional(config.useCRC32Intrinsics(), new InvocationPlugin("updateBytes0", new Type[]{Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode buf, ValueNode off, ValueNode len) {
                int byteArrayBaseOffset = b.getMetaAccess().getArrayBaseOffset(JavaKind.Byte);
                ComputeObjectAddressNode bufAddr = b.add(new ComputeObjectAddressNode(buf, new AddNode(ConstantNode.forInt(byteArrayBaseOffset), off)));
                b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32, crc, bufAddr, len));
                return true;
            }
        });
        r.registerConditional(config.useCRC32Intrinsics(), new InvocationPlugin("updateByteBuffer0", new Type[]{Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode addr, ValueNode off, ValueNode len) {
                AddNode bufAddr = b.add(new AddNode(addr, new SignExtendNode(off, 32, 64)));
                b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32, crc, bufAddr, len));
                return true;
            }
        });
    }

    private static void registerCRC32CPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.util.zip.CRC32C", replacements);
        r.registerConditional(config.useCRC32CIntrinsics(), new InvocationPlugin("updateBytes", new Type[]{Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode buf, ValueNode off, ValueNode end) {
                int byteArrayBaseOffset = b.getMetaAccess().getArrayBaseOffset(JavaKind.Byte);
                ComputeObjectAddressNode bufAddr = b.add(new ComputeObjectAddressNode(buf, new AddNode(ConstantNode.forInt(byteArrayBaseOffset), off)));
                b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32C, crc, bufAddr, new SubNode(end, off)));
                return true;
            }
        });
        r.registerConditional(config.useCRC32CIntrinsics(), new InvocationPlugin("updateDirectByteBuffer", new Type[]{Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode addr, ValueNode off, ValueNode end) {
                AddNode bufAddr = b.add(new AddNode(addr, new SignExtendNode(off, 32, 64)));
                b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32C, crc, bufAddr, new SubNode(end, off)));
                return true;
            }
        });
    }

    private static void registerArraysSupportPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.util.ArraysSupport", replacements);
        r.registerConditional(config.useVectorizedMismatchIntrinsic(), new InvocationPlugin("vectorizedMismatch", new Type[]{Object.class, Long.TYPE, Object.class, Long.TYPE, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a, ValueNode aOffset, ValueNode bObject, ValueNode bOffset, ValueNode length, ValueNode log2ArrayIndexScale) {
                ComputeObjectAddressNode aAddr = b.add(new ComputeObjectAddressNode(a, aOffset));
                ComputeObjectAddressNode bAddr = b.add(new ComputeObjectAddressNode(bObject, bOffset));
                b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.VECTORIZED_MISMATCH, aAddr, bAddr, length, log2ArrayIndexScale));
                return true;
            }
        });
    }

    private static void registerReferencePlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Reference.class), replacements);
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("refersTo0", new Type[]{InvocationPlugin.Receiver.class, Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode o) {
                ConstantNode offset = b.add(ConstantNode.forLong(HotSpotReplacementsUtil.referentOffset(b.getMetaAccess())));
                AddressNode address = b.add(new OffsetAddressNode(receiver.get(), offset));
                FieldLocationIdentity locationIdentity = new FieldLocationIdentity(HotSpotReplacementsUtil.referentField(b.getMetaAccess()));
                JavaReadNode read = b.add(new JavaReadNode(StampFactory.object(), JavaKind.Object, address, locationIdentity, OnHeapMemoryAccess.BarrierType.WEAK_FIELD, true));
                LogicNode objectEquals = b.add(ObjectEqualsNode.create(b.getConstantReflection(), b.getMetaAccess(), b.getOptions(), read, o, NodeView.DEFAULT));
                b.addPush(JavaKind.Boolean, ConditionalNode.create(objectEquals, b.add(ConstantNode.forBoolean(true)), b.add(ConstantNode.forBoolean(false)), NodeView.DEFAULT));
                return true;
            }

            @Override
            public boolean isOptional() {
                return JavaVersionUtil.JAVA_SPEC < 16;
            }
        });
        r = new InvocationPlugins.Registration(plugins, (Type)((Object)PhantomReference.class), replacements);
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("refersTo0", new Type[]{InvocationPlugin.Receiver.class, Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode o) {
                ConstantNode offset = b.add(ConstantNode.forLong(HotSpotReplacementsUtil.referentOffset(b.getMetaAccess())));
                AddressNode address = b.add(new OffsetAddressNode(receiver.get(), offset));
                FieldLocationIdentity locationIdentity = new FieldLocationIdentity(HotSpotReplacementsUtil.referentField(b.getMetaAccess()));
                JavaReadNode read = b.add(new JavaReadNode(StampFactory.object(), JavaKind.Object, address, locationIdentity, OnHeapMemoryAccess.BarrierType.PHANTOM_FIELD, true));
                LogicNode objectEquals = b.add(ObjectEqualsNode.create(b.getConstantReflection(), b.getMetaAccess(), b.getOptions(), read, o, NodeView.DEFAULT));
                b.addPush(JavaKind.Boolean, ConditionalNode.create(objectEquals, b.add(ConstantNode.forBoolean(true)), b.add(ConstantNode.forBoolean(false)), NodeView.DEFAULT));
                return true;
            }

            @Override
            public boolean isOptional() {
                return JavaVersionUtil.JAVA_SPEC < 16;
            }
        });
    }

    private static void registerInstrumentationImplPlugins(InvocationPlugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "sun.instrument.InstrumentationImpl", replacements);
        r.register(new InvocationPlugin.InlineOnlyInvocationPlugin("getObjectSize0", new Type[]{InvocationPlugin.Receiver.class, Long.TYPE, Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode nativeAgent, ValueNode objectToSize) {
                try (HotSpotInvocationPluginHelper helper = new HotSpotInvocationPluginHelper(b, targetMethod, config);){
                    ValueNode objectNonNull = b.nullCheckedValue(objectToSize);
                    StructuredGraph graph = b.getGraph();
                    LoadHubNode hub = b.add(new LoadHubNode(b.getStampProvider(), objectNonNull));
                    ValueNode layoutHelper = helper.klassLayoutHelper(hub);
                    LogicNode isArray = b.add(ObjectIsArrayNode.create(objectNonNull));
                    ArrayLengthNode arrayLengthNode = graph.add(new ArrayLengthNode(objectNonNull));
                    EndNode arrayBranch = graph.add(new EndNode());
                    arrayLengthNode.setNext(arrayBranch);
                    int objectAlignmentMask = config.objectAlignment - 1;
                    ValueNode arrayHeaderSize = b.add(AndNode.create(new UnsignedRightShiftNode(layoutHelper, ConstantNode.forInt(config.layoutHelperHeaderSizeShift)), ConstantNode.forInt(config.layoutHelperHeaderSizeMask), NodeView.DEFAULT));
                    ValueNode arraySize = b.add(AddNode.create(arrayHeaderSize, LeftShiftNode.create(arrayLengthNode, layoutHelper, NodeView.DEFAULT), NodeView.DEFAULT));
                    ValueNode arraySizeMasked = b.add(AndNode.create(AddNode.create(arraySize, ConstantNode.forInt(objectAlignmentMask), NodeView.DEFAULT), ConstantNode.forInt(~objectAlignmentMask), NodeView.DEFAULT));
                    EndNode instanceBranch = graph.add(new EndNode());
                    ValueNode instanceSize = b.add(AndNode.create(layoutHelper, ConstantNode.forInt(-8), NodeView.DEFAULT));
                    b.add(new IfNode(isArray, arrayLengthNode, instanceBranch, ProfileData.BranchProbabilityData.unknown()));
                    MergeNode merge = b.add(new MergeNode());
                    merge.addForwardEnd(arrayBranch);
                    merge.addForwardEnd(instanceBranch);
                    b.addPush(JavaKind.Long, SignExtendNode.create(new ValuePhiNode(StampFactory.positiveInt(), merge, new ValueNode[]{arraySizeMasked, instanceSize}), 64, NodeView.DEFAULT));
                }
                return true;
            }
        });
    }

    static class DigestInvocationPlugin
    extends InvocationPlugin {
        private final ForeignCallDescriptor descriptor;

        DigestInvocationPlugin(ForeignCallDescriptor descriptor) {
            super("implCompress0", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE});
            this.descriptor = descriptor;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode buf, ValueNode ofs) {
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                PiNode realReceiver = b.add(new PiNode(receiver.get(), targetMethod.getDeclaringClass(), false, true));
                ResolvedJavaField stateField = helper.getField(targetMethod.getDeclaringClass(), "state");
                ValueNode state = helper.loadField(realReceiver, stateField);
                ValueNode bufAddr = helper.arrayElementPointer(buf, JavaKind.Byte, ofs);
                ValueNode stateAddr = helper.arrayStart(state, stateField.getType().getComponentType().getJavaKind());
                b.add(new ForeignCallNode(this.descriptor, bufAddr, stateAddr));
            }
            return true;
        }
    }

    public static class CounterModeCryptPlugin
    extends AESCryptPluginBase {
        CounterModeCryptPlugin() {
            super(HotSpotBackend.COUNTERMODE_IMPL_CRYPT, "implCrypt", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE});
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode in, ValueNode inOffset, ValueNode len, ValueNode out, ValueNode outOffset) {
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                ResolvedJavaType klass = targetMethod.getDeclaringClass();
                ValueNode nonNullReceiver = receiver.get();
                ValueNode inAddr = helper.arrayElementPointer(in, JavaKind.Byte, inOffset);
                ValueNode outAddr = helper.arrayElementPointer(out, JavaKind.Byte, outOffset);
                ValueNode embeddedCipher = this.readEmbeddedCipher(b, helper, klass, nonNullReceiver);
                ValueNode kAddr = this.readAESCryptKArrayStart(b, helper, klass, embeddedCipher);
                ValueNode counterAddr = this.readFieldArrayStart(b, helper, klass, "counter", nonNullReceiver, JavaKind.Byte);
                ValueNode encryptedCounterAddr = this.readFieldArrayStart(b, helper, klass, "encryptedCounter", nonNullReceiver, JavaKind.Byte);
                ComputeObjectAddressNode usedPtr = b.add(new ComputeObjectAddressNode(nonNullReceiver, helper.asWord(helper.getFieldOffset(targetMethod.getDeclaringClass(), "used"))));
                ForeignCallNode call = b.add(new ForeignCallNode((ForeignCallDescriptor)this.descriptor, inAddr, outAddr, kAddr, counterAddr, len, encryptedCounterAddr, usedPtr));
                helper.emitFinalReturn(JavaKind.Int, call);
            }
            return true;
        }
    }

    public static class ElectronicCodeBookCryptPlugin
    extends AESCryptPluginBase {
        ElectronicCodeBookCryptPlugin(CryptMode mode) {
            super(mode.isEncrypt() ? HotSpotBackend.ELECTRONIC_CODEBOOK_ENCRYPT_AESCRYPT : HotSpotBackend.ELECTRONIC_CODEBOOK_DECRYPT_AESCRYPT, mode.isEncrypt() ? "implECBEncrypt" : "implECBDecrypt", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE});
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode in, ValueNode inOffset, ValueNode len, ValueNode out, ValueNode outOffset) {
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                ResolvedJavaType klass = targetMethod.getDeclaringClass();
                ValueNode nonNullReceiver = receiver.get();
                ValueNode inAddr = helper.arrayElementPointer(in, JavaKind.Byte, inOffset);
                ValueNode outAddr = helper.arrayElementPointer(out, JavaKind.Byte, outOffset);
                ValueNode embeddedCipher = this.readEmbeddedCipher(b, helper, klass, nonNullReceiver);
                ValueNode kAddr = this.readAESCryptKArrayStart(b, helper, klass, embeddedCipher);
                ForeignCallNode call = b.add(new ForeignCallNode((ForeignCallDescriptor)this.descriptor, inAddr, outAddr, kAddr, len));
                helper.emitFinalReturn(JavaKind.Int, call);
            }
            return true;
        }
    }

    public static class CipherBlockChainingCryptPlugin
    extends AESCryptPluginBase {
        CipherBlockChainingCryptPlugin(CryptMode mode) {
            super(mode.isEncrypt() ? HotSpotBackend.CIPHER_BLOCK_CHAINING_ENCRYPT_AESCRYPT : HotSpotBackend.CIPHER_BLOCK_CHAINING_DECRYPT_AESCRYPT, mode.isEncrypt() ? "implEncrypt" : "implDecrypt", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE});
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode in, ValueNode inOffset, ValueNode inLength, ValueNode out, ValueNode outOffset) {
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                ResolvedJavaType klass = targetMethod.getDeclaringClass();
                ValueNode nonNullReceiver = receiver.get();
                ValueNode inAddr = helper.arrayElementPointer(in, JavaKind.Byte, inOffset);
                ValueNode outAddr = helper.arrayElementPointer(out, JavaKind.Byte, outOffset);
                ValueNode embeddedCipher = this.readEmbeddedCipher(b, helper, klass, nonNullReceiver);
                ValueNode kAddr = this.readAESCryptKArrayStart(b, helper, klass, embeddedCipher);
                ValueNode rAddr = this.readFieldArrayStart(b, helper, klass, "r", nonNullReceiver, JavaKind.Byte);
                ForeignCallNode call = b.add(new ForeignCallNode((ForeignCallDescriptor)this.descriptor, inAddr, outAddr, kAddr, rAddr, inLength));
                helper.emitFinalReturn(JavaKind.Int, call);
            }
            return true;
        }
    }

    public static class AESCryptPlugin
    extends AESCryptPluginBase {
        AESCryptPlugin(CryptMode mode) {
            super(mode.isEncrypt() ? HotSpotBackend.AESCRYPT_ENCRYPTBLOCK : HotSpotBackend.AESCRYPT_DECRYPTBLOCK, mode.isEncrypt() ? "implEncryptBlock" : "implDecryptBlock", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, byte[].class, Integer.TYPE});
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode in, ValueNode inOffset, ValueNode out, ValueNode outOffset) {
            try (InvocationPluginHelper helper = new InvocationPluginHelper(b, targetMethod);){
                ResolvedJavaType klass = targetMethod.getDeclaringClass();
                ValueNode nonNullReceiver = receiver.get();
                ValueNode nonNullIn = b.nullCheckedValue(in);
                ValueNode nonNullOut = b.nullCheckedValue(out);
                ConstantNode zero = ConstantNode.forInt(0);
                helper.intrinsicRangeCheck(inOffset, Condition.LT, zero);
                ValueNode inLength = helper.length(nonNullIn);
                helper.intrinsicRangeCheck(helper.sub(inLength, ConstantNode.forInt(16)), Condition.LT, inOffset);
                helper.intrinsicRangeCheck(outOffset, Condition.LT, zero);
                ValueNode outLength = helper.length(nonNullOut);
                helper.intrinsicRangeCheck(helper.sub(outLength, ConstantNode.forInt(16)), Condition.LT, outOffset);
                ValueNode inAddr = helper.arrayElementPointer(nonNullIn, JavaKind.Byte, inOffset);
                ValueNode outAddr = helper.arrayElementPointer(nonNullOut, JavaKind.Byte, outOffset);
                ValueNode kAddr = this.readAESCryptKArrayStart(b, helper, klass, nonNullReceiver);
                b.add(new ForeignCallNode((ForeignCallDescriptor)this.descriptor, inAddr, outAddr, kAddr));
            }
            return true;
        }
    }

    static abstract class AESCryptPluginBase
    extends InvocationPlugin {
        static final int AES_BLOCK_SIZE_IN_BYTES = 16;
        protected final HotSpotForeignCallDescriptor descriptor;

        AESCryptPluginBase(HotSpotForeignCallDescriptor descriptor, String name, Type ... argumentTypes) {
            super(name, argumentTypes);
            this.descriptor = descriptor;
        }

        private static ResolvedJavaType getType(ResolvedJavaType context, String typeName) {
            try {
                UnresolvedJavaType unresolved = UnresolvedJavaType.create((String)typeName);
                return unresolved.resolve(context);
            }
            catch (LinkageError e) {
                throw new GraalError(e);
            }
        }

        private static ResolvedJavaType aesCryptType(ResolvedJavaType context) {
            return AESCryptPluginBase.getType(context, "Lcom/sun/crypto/provider/AESCrypt;");
        }

        ValueNode readEmbeddedCipher(GraphBuilderContext b, InvocationPluginHelper helper, ResolvedJavaType context, ValueNode receiver) {
            ResolvedJavaField embeddedCipherField = helper.getField(AESCryptPluginBase.getType(context, "Lcom/sun/crypto/provider/FeedbackCipher;"), "embeddedCipher");
            ValueNode embeddedCipher = b.nullCheckedValue(helper.loadField(receiver, embeddedCipherField));
            LogicNode typeCheck = InstanceOfNode.create(TypeReference.create(b.getAssumptions(), AESCryptPluginBase.aesCryptType(context)), embeddedCipher);
            helper.doFallbackIfNot(typeCheck, 0.25);
            return embeddedCipher;
        }

        ValueNode readFieldArrayStart(GraphBuilderContext b, InvocationPluginHelper helper, ResolvedJavaType klass, String filed, ValueNode receiver, JavaKind arrayKind) {
            ResolvedJavaField field = helper.getField(klass, filed);
            ValueNode array = b.nullCheckedValue(helper.loadField(receiver, field));
            return helper.arrayStart(array, arrayKind);
        }

        ValueNode readAESCryptKArrayStart(GraphBuilderContext b, InvocationPluginHelper helper, ResolvedJavaType context, ValueNode receiver) {
            return this.readFieldArrayStart(b, helper, AESCryptPluginBase.aesCryptType(context), "K", receiver, JavaKind.Int);
        }
    }

    static enum CryptMode {
        ENCRYPT,
        DECRYPT;


        boolean isEncrypt() {
            return this == ENCRYPT;
        }
    }
}

