/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.util.EnumMap;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallSignature;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.HotSpotHostBackend;
import org.graalvm.compiler.hotspot.meta.DefaultHotSpotLoweringProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.replacements.AssertionSnippets;
import org.graalvm.compiler.hotspot.replacements.HotSpotAllocationSnippets;
import org.graalvm.compiler.hotspot.replacements.HotSpotG1WriteBarrierSnippets;
import org.graalvm.compiler.hotspot.replacements.Log;
import org.graalvm.compiler.hotspot.replacements.MonitorSnippets;
import org.graalvm.compiler.hotspot.stubs.ArrayStoreExceptionStub;
import org.graalvm.compiler.hotspot.stubs.ClassCastExceptionStub;
import org.graalvm.compiler.hotspot.stubs.CreateExceptionStub;
import org.graalvm.compiler.hotspot.stubs.DivisionByZeroExceptionStub;
import org.graalvm.compiler.hotspot.stubs.ExceptionHandlerStub;
import org.graalvm.compiler.hotspot.stubs.IllegalArgumentExceptionArgumentIsNotAnArrayStub;
import org.graalvm.compiler.hotspot.stubs.IntegerExactOverflowExceptionStub;
import org.graalvm.compiler.hotspot.stubs.LongExactOverflowExceptionStub;
import org.graalvm.compiler.hotspot.stubs.NegativeArraySizeExceptionStub;
import org.graalvm.compiler.hotspot.stubs.NullPointerExceptionStub;
import org.graalvm.compiler.hotspot.stubs.OutOfBoundsExceptionStub;
import org.graalvm.compiler.hotspot.stubs.Stub;
import org.graalvm.compiler.hotspot.stubs.StubUtil;
import org.graalvm.compiler.hotspot.stubs.UnwindExceptionToCallerStub;
import org.graalvm.compiler.hotspot.stubs.VerifyOopStub;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.java.ForeignCallDescriptors;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyForeignCalls;
import org.graalvm.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.word.LocationIdentity;

public abstract class HotSpotHostForeignCallsProvider
extends HotSpotForeignCallsProviderImpl
implements ArrayCopyForeignCalls {
    public static final HotSpotForeignCallDescriptor JAVA_TIME_MILLIS = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, NO_LOCATIONS, "javaTimeMillis", Long.TYPE, new Class[0]);
    public static final HotSpotForeignCallDescriptor JAVA_TIME_NANOS = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, NO_LOCATIONS, "javaTimeNanos", Long.TYPE, new Class[0]);
    public static final HotSpotForeignCallDescriptor NOTIFY = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "object_notify", Boolean.TYPE, Object.class);
    public static final HotSpotForeignCallDescriptor NOTIFY_ALL = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "object_notifyAll", Boolean.TYPE, Object.class);
    public static final HotSpotForeignCallDescriptor INVOKE_STATIC_METHOD_ONE_ARG = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, NO_LOCATIONS, "JVMCIRuntime::invoke_static_method_one_arg", Long.TYPE, Word.class, Word.class, Long.TYPE);
    public static final ForeignCallSignature UNSAFE_ARRAYCOPY = new ForeignCallSignature("unsafe_arraycopy", Void.TYPE, Word.class, Word.class, Word.class);
    public static final ForeignCallSignature GENERIC_ARRAYCOPY = new ForeignCallSignature("generic_arraycopy", Integer.TYPE, Word.class, Integer.TYPE, Word.class, Integer.TYPE, Integer.TYPE);
    private static final EnumMap<JavaKind, ForeignCallDescriptor>[][][] primitiveArraycopyDescriptors = new EnumMap[2][2][2];
    private static final ForeignCallDescriptor[][][][] objectArraycopyDescriptors = new ForeignCallDescriptor[2][2][2][2];
    private static final ForeignCallDescriptor[] checkcastArraycopyDescriptors = new ForeignCallDescriptor[2];

    public HotSpotHostForeignCallsProvider(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalRuntimeProvider runtime, MetaAccessProvider metaAccess, CodeCacheProvider codeCache, WordTypes wordTypes) {
        super(jvmciRuntime, runtime, metaAccess, codeCache, wordTypes);
    }

    protected static void link(Stub stub) {
        stub.getLinkage().setCompiledStub(stub);
    }

    public ForeignCallDescriptor lookupCheckcastArraycopyDescriptor(boolean uninit) {
        return checkcastArraycopyDescriptors[uninit ? 1 : 0];
    }

    @Override
    public ForeignCallDescriptor lookupArraycopyDescriptor(JavaKind kind, boolean aligned, boolean disjoint, boolean uninit, LocationIdentity killedLocation) {
        boolean killAny = killedLocation.isAny();
        boolean killInit = killedLocation.isInit();
        if (kind.isObject()) {
            assert (!killInit) : "unsupported";
            assert (killAny || killedLocation.equals(NamedLocationIdentity.getArrayLocation(kind)));
            return objectArraycopyDescriptors[aligned ? 1 : 0][disjoint ? 1 : 0][uninit ? 1 : 0][killAny ? 1 : 0];
        }
        assert (kind.isPrimitive());
        assert (!killAny) : "unsupported";
        assert (killInit || killedLocation.equals(NamedLocationIdentity.getArrayLocation(kind)));
        return primitiveArraycopyDescriptors[aligned ? 1 : 0][disjoint ? 1 : 0][killInit ? 1 : 0].get(kind);
    }

    private void registerStubCallFunctions(OptionValues options, HotSpotProviders providers, GraalHotSpotVMConfig config) {
        if (config.invokeJavaMethodAddress == 0L || Services.IS_IN_NATIVE_IMAGE) {
            return;
        }
        ResolvedJavaMethod booleanReturnsBoolean = SnippetTemplate.AbstractTemplates.findMethod(providers.getMetaAccess(), TestForeignCalls.class, "booleanReturnsBoolean");
        this.invokeJavaMethodStub(options, providers, TestForeignCalls.BOOLEAN_RETURNS_BOOLEAN, config.invokeJavaMethodAddress, booleanReturnsBoolean);
        ResolvedJavaMethod byteReturnsByte = SnippetTemplate.AbstractTemplates.findMethod(providers.getMetaAccess(), TestForeignCalls.class, "byteReturnsByte");
        this.invokeJavaMethodStub(options, providers, TestForeignCalls.BYTE_RETURNS_BYTE, config.invokeJavaMethodAddress, byteReturnsByte);
        ResolvedJavaMethod shortReturnsShort = SnippetTemplate.AbstractTemplates.findMethod(providers.getMetaAccess(), TestForeignCalls.class, "shortReturnsShort");
        this.invokeJavaMethodStub(options, providers, TestForeignCalls.SHORT_RETURNS_SHORT, config.invokeJavaMethodAddress, shortReturnsShort);
        ResolvedJavaMethod charReturnsChar = SnippetTemplate.AbstractTemplates.findMethod(providers.getMetaAccess(), TestForeignCalls.class, "charReturnsChar");
        this.invokeJavaMethodStub(options, providers, TestForeignCalls.CHAR_RETURNS_CHAR, config.invokeJavaMethodAddress, charReturnsChar);
        ResolvedJavaMethod intReturnsInt = SnippetTemplate.AbstractTemplates.findMethod(providers.getMetaAccess(), TestForeignCalls.class, "intReturnsInt");
        this.invokeJavaMethodStub(options, providers, TestForeignCalls.INT_RETURNS_INT, config.invokeJavaMethodAddress, intReturnsInt);
        ResolvedJavaMethod longReturnsLong = SnippetTemplate.AbstractTemplates.findMethod(providers.getMetaAccess(), TestForeignCalls.class, "longReturnsLong");
        this.invokeJavaMethodStub(options, providers, TestForeignCalls.LONG_RETURNS_LONG, config.invokeJavaMethodAddress, longReturnsLong);
        ResolvedJavaMethod objectReturnsObject = SnippetTemplate.AbstractTemplates.findMethod(providers.getMetaAccess(), TestForeignCalls.class, "objectReturnsObject");
        this.invokeJavaMethodStub(options, providers, TestForeignCalls.OBJECT_RETURNS_OBJECT, config.invokeJavaMethodAddress, objectReturnsObject);
    }

    private void registerArraycopyDescriptor(EconomicMap<Long, ForeignCallDescriptor> descMap, JavaKind kind, boolean aligned, boolean disjoint, boolean uninit, LocationIdentity killedLocation, long routine) {
        boolean killAny = killedLocation.isAny();
        boolean killInit = killedLocation.isInit();
        ForeignCallDescriptor desc = (ForeignCallDescriptor)descMap.get((Object)routine);
        if (desc == null) {
            desc = this.buildDescriptor(kind, aligned, disjoint, uninit, killedLocation, routine);
            descMap.put((Object)routine, (Object)desc);
        }
        if (kind.isObject()) {
            HotSpotHostForeignCallsProvider.objectArraycopyDescriptors[aligned ? 1 : 0][disjoint ? 1 : 0][uninit ? 1 : 0][killAny ? 1 : 0] = desc;
        } else {
            primitiveArraycopyDescriptors[aligned ? 1 : 0][disjoint ? 1 : 0][killInit ? 1 : 0].put(kind, desc);
        }
    }

    private ForeignCallDescriptor buildDescriptor(JavaKind kind, boolean aligned, boolean disjoint, boolean uninit, LocationIdentity killedLocation, long routine) {
        assert (!uninit || kind == JavaKind.Object);
        boolean killAny = killedLocation.isAny();
        boolean killInit = killedLocation.isInit();
        String name = kind + (aligned ? "Aligned" : "") + (disjoint ? "Disjoint" : "") + (uninit ? "Uninit" : "") + "Arraycopy" + (killInit ? "KillInit" : (killAny ? "KillAny" : ""));
        HotSpotForeignCallDescriptor desc = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, killedLocation, name, Void.TYPE, Word.class, Word.class, Word.class);
        this.registerForeignCall(desc, routine, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
        return desc;
    }

    private void registerCheckcastArraycopyDescriptor(boolean uninit, long routine) {
        String name = "Object" + (uninit ? "Uninit" : "") + "CheckcastArraycopy";
        LocationIdentity killed = NamedLocationIdentity.any();
        HotSpotForeignCallDescriptor desc = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, killed, name, Integer.TYPE, Word.class, Word.class, Word.class, Word.class, Word.class);
        this.registerForeignCall(desc, routine, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
        HotSpotHostForeignCallsProvider.checkcastArraycopyDescriptors[uninit ? 1 : 0] = desc;
    }

    private void registerArrayCopy(JavaKind kind, long routine, long alignedRoutine, long disjointRoutine, long alignedDisjointRoutine) {
        this.registerArrayCopy(kind, routine, alignedRoutine, disjointRoutine, alignedDisjointRoutine, false);
    }

    private void registerArrayCopy(JavaKind kind, long routine, long alignedRoutine, long disjointRoutine, long alignedDisjointRoutine, boolean uninit) {
        EconomicMap descMap = EconomicMap.create();
        LocationIdentity arrayLocation = NamedLocationIdentity.getArrayLocation(kind);
        this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)descMap, kind, false, false, uninit, arrayLocation, routine);
        this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)descMap, kind, true, false, uninit, arrayLocation, alignedRoutine);
        this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)descMap, kind, false, true, uninit, arrayLocation, disjointRoutine);
        this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)descMap, kind, true, true, uninit, arrayLocation, alignedDisjointRoutine);
        if (kind.isPrimitive()) {
            assert (!uninit);
            EconomicMap killInitDescMap = EconomicMap.create();
            this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)killInitDescMap, kind, false, false, uninit, LocationIdentity.init(), routine);
            this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)killInitDescMap, kind, true, false, uninit, LocationIdentity.init(), alignedRoutine);
            this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)killInitDescMap, kind, false, true, uninit, LocationIdentity.init(), disjointRoutine);
            this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)killInitDescMap, kind, true, true, uninit, LocationIdentity.init(), alignedDisjointRoutine);
        } else {
            assert (kind.isObject());
            EconomicMap killAnyDescMap = EconomicMap.create();
            this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)killAnyDescMap, kind, false, false, uninit, LocationIdentity.any(), routine);
            this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)killAnyDescMap, kind, true, false, uninit, LocationIdentity.any(), alignedRoutine);
            this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)killAnyDescMap, kind, false, true, uninit, LocationIdentity.any(), disjointRoutine);
            this.registerArraycopyDescriptor((EconomicMap<Long, ForeignCallDescriptor>)killAnyDescMap, kind, true, true, uninit, LocationIdentity.any(), alignedDisjointRoutine);
        }
    }

    public void initialize(HotSpotProviders providers, OptionValues options) {
        GraalHotSpotVMConfig c;
        block36: {
            c = this.runtime.getVMConfig();
            this.registerForeignCall(HotSpotHostBackend.DEOPT_BLOB_UNPACK, c.deoptBlobUnpack, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            if (c.deoptBlobUnpackWithExceptionInTLS != 0L) {
                this.registerForeignCall(HotSpotHostBackend.DEOPT_BLOB_UNPACK_WITH_EXCEPTION_IN_TLS, c.deoptBlobUnpackWithExceptionInTLS, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            this.registerForeignCall(HotSpotHostBackend.DEOPT_BLOB_UNCOMMON_TRAP, c.deoptBlobUncommonTrap, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            this.registerForeignCall(HotSpotBackend.IC_MISS_HANDLER, c.inlineCacheMissStub, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            if (c.enableStackReservedZoneAddress != 0L) {
                assert (c.throwDelayedStackOverflowErrorEntry != 0L) : "both must exist";
                this.registerForeignCall(HotSpotHostBackend.ENABLE_STACK_RESERVED_ZONE, c.enableStackReservedZoneAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
                this.registerForeignCall(HotSpotHostBackend.THROW_DELAYED_STACKOVERFLOW_ERROR, c.throwDelayedStackOverflowErrorEntry, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            this.registerForeignCall(JAVA_TIME_MILLIS, c.javaTimeMillisAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            this.registerForeignCall(JAVA_TIME_NANOS, c.javaTimeNanosAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            this.registerMathStubs(c, providers, options);
            this.registerForeignCall(this.createDescriptor(Backend.ARITHMETIC_FREM, HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, NO_LOCATIONS), c.fremAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            this.registerForeignCall(this.createDescriptor(Backend.ARITHMETIC_DREM, HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, NO_LOCATIONS), c.dremAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            this.registerForeignCall(LOAD_AND_CLEAR_EXCEPTION, c.loadAndClearExceptionAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            this.registerForeignCall(ExceptionHandlerStub.EXCEPTION_HANDLER_FOR_PC, c.exceptionHandlerForPcAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            this.registerForeignCall(UnwindExceptionToCallerStub.EXCEPTION_HANDLER_FOR_RETURN_ADDRESS, c.exceptionHandlerForReturnAddressAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            CreateExceptionStub.registerForeignCalls(c, this);
            this.registerForeignCall(StubUtil.VM_MESSAGE_C, c.vmMessageAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            this.registerForeignCall(AssertionSnippets.ASSERTION_VM_MESSAGE_C, c.vmMessageAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            this.linkForeignCall(options, providers, HotSpotBackend.NEW_INSTANCE, c.newInstanceAddress, true);
            this.linkForeignCall(options, providers, HotSpotBackend.NEW_ARRAY, c.newArrayAddress, true);
            this.linkForeignCall(options, providers, HotSpotBackend.NEW_MULTI_ARRAY, c.newMultiArrayAddress, true);
            this.linkForeignCall(options, providers, HotSpotAllocationSnippets.DYNAMIC_NEW_INSTANCE, c.dynamicNewInstanceAddress, true);
            if (c.areNullAllocationStubsAvailable()) {
                this.linkForeignCall(options, providers, HotSpotBackend.NEW_INSTANCE_OR_NULL, c.newInstanceOrNullAddress, true);
                this.linkForeignCall(options, providers, HotSpotBackend.NEW_ARRAY_OR_NULL, c.newArrayOrNullAddress, true);
                this.linkForeignCall(options, providers, HotSpotBackend.NEW_MULTI_ARRAY_OR_NULL, c.newMultiArrayOrNullAddress, true);
                this.linkForeignCall(options, providers, HotSpotAllocationSnippets.DYNAMIC_NEW_INSTANCE_OR_NULL, c.dynamicNewInstanceOrNullAddress, true);
            }
            HotSpotHostForeignCallsProvider.link(new ExceptionHandlerStub(options, providers, (HotSpotForeignCallLinkage)this.foreignCalls.get((Object)HotSpotBackend.EXCEPTION_HANDLER.getSignature())));
            HotSpotHostForeignCallsProvider.link(new UnwindExceptionToCallerStub(options, providers, this.registerStubCall(HotSpotBackend.UNWIND_EXCEPTION_TO_CALLER, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS)));
            HotSpotHostForeignCallsProvider.link(new VerifyOopStub(options, providers, this.registerStubCall(VERIFY_OOP, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS)));
            EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallSignature> exceptionRuntimeCalls = DefaultHotSpotLoweringProvider.RuntimeCalls.runtimeCalls;
            HotSpotHostForeignCallsProvider.link(new ArrayStoreExceptionStub(options, providers, this.registerStubCall(exceptionRuntimeCalls.get((Object)BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE), HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, LocationIdentity.any())));
            HotSpotHostForeignCallsProvider.link(new ClassCastExceptionStub(options, providers, this.registerStubCall(exceptionRuntimeCalls.get((Object)BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST), HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, LocationIdentity.any())));
            HotSpotHostForeignCallsProvider.link(new NullPointerExceptionStub(options, providers, this.registerStubCall(exceptionRuntimeCalls.get((Object)BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER), HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, LocationIdentity.any())));
            HotSpotHostForeignCallsProvider.link(new OutOfBoundsExceptionStub(options, providers, this.registerStubCall(exceptionRuntimeCalls.get((Object)BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS), HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, LocationIdentity.any())));
            HotSpotHostForeignCallsProvider.link(new NegativeArraySizeExceptionStub(options, providers, this.registerStubCall(exceptionRuntimeCalls.get((Object)BytecodeExceptionNode.BytecodeExceptionKind.NEGATIVE_ARRAY_SIZE), HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, LocationIdentity.any())));
            HotSpotHostForeignCallsProvider.link(new DivisionByZeroExceptionStub(options, providers, this.registerStubCall(exceptionRuntimeCalls.get((Object)BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO), HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, LocationIdentity.any())));
            HotSpotHostForeignCallsProvider.link(new IntegerExactOverflowExceptionStub(options, providers, this.registerStubCall(exceptionRuntimeCalls.get((Object)BytecodeExceptionNode.BytecodeExceptionKind.INTEGER_EXACT_OVERFLOW), HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, LocationIdentity.any())));
            HotSpotHostForeignCallsProvider.link(new LongExactOverflowExceptionStub(options, providers, this.registerStubCall(exceptionRuntimeCalls.get((Object)BytecodeExceptionNode.BytecodeExceptionKind.LONG_EXACT_OVERFLOW), HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, LocationIdentity.any())));
            HotSpotHostForeignCallsProvider.link(new IllegalArgumentExceptionArgumentIsNotAnArrayStub(options, providers, this.registerStubCall(exceptionRuntimeCalls.get((Object)BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_ARGUMENT_IS_NOT_AN_ARRAY), HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, LocationIdentity.any())));
            this.linkForeignCall(options, providers, IDENTITY_HASHCODE, c.identityHashCodeAddress, true);
            this.linkForeignCall(options, providers, this.createDescriptor(ForeignCallDescriptors.REGISTER_FINALIZER, HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any()), c.registerFinalizerAddress, true);
            this.linkForeignCall(options, providers, MonitorSnippets.MONITORENTER, c.monitorenterAddress, true);
            this.linkForeignCall(options, providers, MonitorSnippets.MONITOREXIT, c.monitorexitAddress, true);
            this.linkForeignCall(options, providers, NOTIFY, c.notifyAddress, true);
            this.linkForeignCall(options, providers, NOTIFY_ALL, c.notifyAllAddress, true);
            this.linkForeignCall(options, providers, Log.LOG_PRINTF, c.logPrintfAddress, true);
            this.linkForeignCall(options, providers, Log.LOG_OBJECT, c.logObjectAddress, true);
            this.linkForeignCall(options, providers, Log.LOG_PRIMITIVE, c.logPrimitiveAddress, true);
            this.linkForeignCall(options, providers, HotSpotBackend.VM_ERROR, c.vmErrorAddress, true);
            this.linkForeignCall(options, providers, OSR_MIGRATION_END, c.osrMigrationEndAddress, false);
            this.linkForeignCall(options, providers, HotSpotG1WriteBarrierSnippets.G1WBPRECALL, c.writeBarrierPreAddress, true);
            this.linkForeignCall(options, providers, HotSpotG1WriteBarrierSnippets.G1WBPOSTCALL, c.writeBarrierPostAddress, true);
            this.linkForeignCall(options, providers, HotSpotG1WriteBarrierSnippets.VALIDATE_OBJECT, c.validateObject, true);
            this.linkForeignCall(options, providers, TEST_DEOPTIMIZE_CALL_INT, c.testDeoptimizeCallInt, true);
            this.registerArrayCopy(JavaKind.Byte, c.jbyteArraycopy, c.jbyteAlignedArraycopy, c.jbyteDisjointArraycopy, c.jbyteAlignedDisjointArraycopy);
            this.registerArrayCopy(JavaKind.Boolean, c.jbyteArraycopy, c.jbyteAlignedArraycopy, c.jbyteDisjointArraycopy, c.jbyteAlignedDisjointArraycopy);
            this.registerArrayCopy(JavaKind.Char, c.jshortArraycopy, c.jshortAlignedArraycopy, c.jshortDisjointArraycopy, c.jshortAlignedDisjointArraycopy);
            this.registerArrayCopy(JavaKind.Short, c.jshortArraycopy, c.jshortAlignedArraycopy, c.jshortDisjointArraycopy, c.jshortAlignedDisjointArraycopy);
            this.registerArrayCopy(JavaKind.Int, c.jintArraycopy, c.jintAlignedArraycopy, c.jintDisjointArraycopy, c.jintAlignedDisjointArraycopy);
            this.registerArrayCopy(JavaKind.Float, c.jintArraycopy, c.jintAlignedArraycopy, c.jintDisjointArraycopy, c.jintAlignedDisjointArraycopy);
            this.registerArrayCopy(JavaKind.Long, c.jlongArraycopy, c.jlongAlignedArraycopy, c.jlongDisjointArraycopy, c.jlongAlignedDisjointArraycopy);
            this.registerArrayCopy(JavaKind.Double, c.jlongArraycopy, c.jlongAlignedArraycopy, c.jlongDisjointArraycopy, c.jlongAlignedDisjointArraycopy);
            this.registerArrayCopy(JavaKind.Object, c.oopArraycopy, c.oopAlignedArraycopy, c.oopDisjointArraycopy, c.oopAlignedDisjointArraycopy);
            this.registerArrayCopy(JavaKind.Object, c.oopArraycopyUninit, c.oopAlignedArraycopyUninit, c.oopDisjointArraycopyUninit, c.oopAlignedDisjointArraycopyUninit, true);
            this.registerCheckcastArraycopyDescriptor(true, c.checkcastArraycopyUninit);
            this.registerCheckcastArraycopyDescriptor(false, c.checkcastArraycopy);
            this.registerForeignCall(this.createDescriptor(GENERIC_ARRAYCOPY, HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.any()), c.genericArraycopy, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            this.registerForeignCall(this.createDescriptor(UNSAFE_ARRAYCOPY, HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, NamedLocationIdentity.any()), c.unsafeArraycopy, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            if (c.useMultiplyToLenIntrinsic()) {
                this.registerForeignCall(HotSpotBackend.MULTIPLY_TO_LEN, c.multiplyToLen, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.md5ImplCompress != 0L) {
                this.registerForeignCall(HotSpotBackend.MD5_IMPL_COMPRESS, c.md5ImplCompress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.md5ImplCompressMultiBlock != 0L) {
                this.registerForeignCall(HotSpotBackend.MD5_IMPL_COMPRESS_MB, c.md5ImplCompressMultiBlock, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.useSHA1Intrinsics()) {
                this.registerForeignCall(HotSpotBackend.SHA_IMPL_COMPRESS, c.sha1ImplCompress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
                this.registerForeignCall(HotSpotBackend.SHA_IMPL_COMPRESS_MB, c.sha1ImplCompressMultiBlock, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.useSHA256Intrinsics()) {
                this.registerForeignCall(HotSpotBackend.SHA2_IMPL_COMPRESS, c.sha256ImplCompress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
                this.registerForeignCall(HotSpotBackend.SHA2_IMPL_COMPRESS_MB, c.sha256ImplCompressMultiBlock, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.useSHA512Intrinsics()) {
                this.registerForeignCall(HotSpotBackend.SHA5_IMPL_COMPRESS, c.sha512ImplCompress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
                this.registerForeignCall(HotSpotBackend.SHA5_IMPL_COMPRESS_MB, c.sha512ImplCompressMultiBlock, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.sha3ImplCompress != 0L) {
                this.registerForeignCall(HotSpotBackend.SHA3_IMPL_COMPRESS, c.sha3ImplCompress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.sha3ImplCompressMultiBlock != 0L) {
                this.registerForeignCall(HotSpotBackend.SHA3_IMPL_COMPRESS_MB, c.sha3ImplCompressMultiBlock, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.useGHASHIntrinsics()) {
                this.registerForeignCall(HotSpotBackend.GHASH_PROCESS_BLOCKS, c.ghashProcessBlocks, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.base64EncodeBlock != 0L) {
                this.registerForeignCall(HotSpotBackend.BASE64_ENCODE_BLOCK, c.base64EncodeBlock, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.base64DecodeBlock != 0L) {
                this.registerForeignCall(HotSpotBackend.BASE64_DECODE_BLOCK, c.base64DecodeBlock, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.useMulAddIntrinsic()) {
                this.registerForeignCall(HotSpotBackend.MUL_ADD, c.mulAdd, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.useMontgomeryMultiplyIntrinsic()) {
                this.registerForeignCall(HotSpotBackend.MONTGOMERY_MULTIPLY, c.montgomeryMultiply, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.useMontgomerySquareIntrinsic()) {
                this.registerForeignCall(HotSpotBackend.MONTGOMERY_SQUARE, c.montgomerySquare, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.useSquareToLenIntrinsic()) {
                this.registerForeignCall(HotSpotBackend.SQUARE_TO_LEN, c.squareToLen, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.useCRC32Intrinsics) {
                this.registerForeignCall(HotSpotBackend.UPDATE_BYTES_CRC32, c.updateBytesCRC32Stub, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.useCRC32CIntrinsics) {
                this.registerForeignCall(HotSpotBackend.UPDATE_BYTES_CRC32C, c.updateBytesCRC32C, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.updateBytesAdler32 != 0L) {
                this.registerForeignCall(HotSpotBackend.UPDATE_BYTES_ADLER32, c.updateBytesAdler32, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.bigIntegerLeftShiftWorker != 0L) {
                this.registerForeignCall(HotSpotBackend.BIGINTEGER_LEFT_SHIFT_WORKER, c.bigIntegerLeftShiftWorker, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.bigIntegerRightShiftWorker != 0L) {
                this.registerForeignCall(HotSpotBackend.BIGINTEGER_RIGHT_SHIFT_WORKER, c.bigIntegerRightShiftWorker, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.electronicCodeBookEncrypt != 0L) {
                this.registerForeignCall(HotSpotBackend.ELECTRONIC_CODEBOOK_ENCRYPT_AESCRYPT, c.electronicCodeBookEncrypt, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.electronicCodeBookDecrypt != 0L) {
                this.registerForeignCall(HotSpotBackend.ELECTRONIC_CODEBOOK_DECRYPT_AESCRYPT, c.electronicCodeBookDecrypt, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
            }
            if (c.useAESIntrinsics) {
                block35: {
                    try {
                        this.registerForeignCall(HotSpotBackend.AESCRYPT_ENCRYPTBLOCK, c.aescryptEncryptBlockStub, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
                        this.registerForeignCall(HotSpotBackend.AESCRYPT_DECRYPTBLOCK, c.aescryptDecryptBlockStub, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
                    }
                    catch (GraalError e) {
                        if (e.getCause() instanceof ClassNotFoundException) break block35;
                        throw e;
                    }
                }
                try {
                    this.registerForeignCall(HotSpotBackend.CIPHER_BLOCK_CHAINING_ENCRYPT_AESCRYPT, c.cipherBlockChainingEncryptAESCryptStub, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
                    this.registerForeignCall(HotSpotBackend.CIPHER_BLOCK_CHAINING_DECRYPT_AESCRYPT, c.cipherBlockChainingDecryptAESCryptStub, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
                }
                catch (GraalError e) {
                    if (e.getCause() instanceof ClassNotFoundException) break block36;
                    throw e;
                }
            }
        }
        if (c.useAESCTRIntrinsics) {
            assert (c.counterModeAESCrypt != 0L);
            this.registerForeignCall(HotSpotBackend.COUNTERMODE_IMPL_CRYPT, c.counterModeAESCrypt, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
        }
        if (c.useVectorizedMismatchIntrinsic) {
            assert (c.vectorizedMismatch != 0L);
            this.registerForeignCall(HotSpotBackend.VECTORIZED_MISMATCH, c.vectorizedMismatch, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
        }
        this.registerStubCallFunctions(options, providers, this.runtime.getVMConfig());
    }

    protected void registerMathStubs(GraalHotSpotVMConfig hotSpotVMConfig, HotSpotProviders providers, OptionValues options) {
        this.registerForeignCall(this.createDescriptor(UnaryMathIntrinsicNode.UnaryOperation.SIN.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, NO_LOCATIONS), hotSpotVMConfig.arithmeticSinAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
        this.registerForeignCall(this.createDescriptor(UnaryMathIntrinsicNode.UnaryOperation.COS.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, NO_LOCATIONS), hotSpotVMConfig.arithmeticCosAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
        this.registerForeignCall(this.createDescriptor(UnaryMathIntrinsicNode.UnaryOperation.TAN.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, NO_LOCATIONS), hotSpotVMConfig.arithmeticTanAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
        this.registerForeignCall(this.createDescriptor(UnaryMathIntrinsicNode.UnaryOperation.EXP.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, NO_LOCATIONS), hotSpotVMConfig.arithmeticExpAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
        this.registerForeignCall(this.createDescriptor(UnaryMathIntrinsicNode.UnaryOperation.LOG.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, NO_LOCATIONS), hotSpotVMConfig.arithmeticLogAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
        this.registerForeignCall(this.createDescriptor(UnaryMathIntrinsicNode.UnaryOperation.LOG10.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, NO_LOCATIONS), hotSpotVMConfig.arithmeticLog10Address, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
        this.registerForeignCall(this.createDescriptor(BinaryMathIntrinsicNode.BinaryOperation.POW.foreignCallSignature, HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, NO_LOCATIONS), hotSpotVMConfig.arithmeticPowAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
    }

    static {
        for (int i = 0; i < primitiveArraycopyDescriptors.length; ++i) {
            for (int j = 0; j < primitiveArraycopyDescriptors[i].length; ++j) {
                for (int k = 0; k < primitiveArraycopyDescriptors[i][j].length; ++k) {
                    HotSpotHostForeignCallsProvider.primitiveArraycopyDescriptors[i][j][k] = new EnumMap(JavaKind.class);
                }
            }
        }
    }

    public static class TestForeignCalls {
        public static final HotSpotForeignCallDescriptor BOOLEAN_RETURNS_BOOLEAN = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "boolean returns boolean", Boolean.TYPE, Boolean.TYPE);
        public static final HotSpotForeignCallDescriptor BYTE_RETURNS_BYTE = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "byte returns byte", Byte.TYPE, Byte.TYPE);
        public static final HotSpotForeignCallDescriptor SHORT_RETURNS_SHORT = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "short returns short", Short.TYPE, Short.TYPE);
        public static final HotSpotForeignCallDescriptor CHAR_RETURNS_CHAR = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "char returns char", Character.TYPE, Character.TYPE);
        public static final HotSpotForeignCallDescriptor INT_RETURNS_INT = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "int returns int", Integer.TYPE, Integer.TYPE);
        public static final HotSpotForeignCallDescriptor LONG_RETURNS_LONG = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "long returns long", Long.TYPE, Long.TYPE);
        public static final HotSpotForeignCallDescriptor FLOAT_RETURNS_FLOAT = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "float returns float", Float.TYPE, Float.TYPE);
        public static final HotSpotForeignCallDescriptor DOUBLE_RETURNS_DOUBLE = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "double returns double", Double.TYPE, Double.TYPE);
        public static final HotSpotForeignCallDescriptor OBJECT_RETURNS_OBJECT = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "object returns object", Object.class, Object.class);

        static boolean booleanReturnsBoolean(boolean arg) {
            return arg;
        }

        static byte byteReturnsByte(byte arg) {
            return arg;
        }

        static short shortReturnsShort(short arg) {
            return arg;
        }

        static char charReturnsChar(char arg) {
            return arg;
        }

        static int intReturnsInt(int arg) {
            return arg;
        }

        static long longReturnsLong(long arg) {
            return arg;
        }

        static Object objectReturnsObject(Object arg) {
            return arg;
        }
    }
}

