/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.meta.UnimplementedGraalIntrinsics;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.replacements.nodes.MacroInvokable;

final class HotSpotInvocationPlugins
extends InvocationPlugins {
    private final HotSpotGraalRuntimeProvider graalRuntime;
    private final GraalHotSpotVMConfig config;
    private final UnimplementedGraalIntrinsics unimplementedIntrinsics;
    private Map<String, Integer> missingIntrinsicMetrics;
    private final List<Predicate<ResolvedJavaType>> intrinsificationPredicates = new ArrayList<Predicate<ResolvedJavaType>>();

    HotSpotInvocationPlugins(HotSpotGraalRuntimeProvider graalRuntime, GraalHotSpotVMConfig config, CompilerConfiguration compilerConfiguration, TargetDescription target, OptionValues options) {
        this.graalRuntime = graalRuntime;
        this.config = config;
        this.unimplementedIntrinsics = Options.WarnMissingIntrinsic.getValue(options) != false ? new UnimplementedGraalIntrinsics(config, target.arch) : null;
        this.missingIntrinsicMetrics = null;
        this.registerIntrinsificationPredicate(HotSpotJVMCIRuntime.runtime().getIntrinsificationTrustPredicate(new Class[]{compilerConfiguration.getClass()}));
    }

    @Override
    protected void register(Type declaringClass, InvocationPlugin plugin, boolean allowOverwrite) {
        if (!this.config.usePopCountInstruction && "bitCount".equals(plugin.name)) {
            GraalError.guarantee(declaringClass.equals(Integer.class) || declaringClass.equals(Long.class), declaringClass.getTypeName());
            return;
        }
        if (!this.config.useUnalignedAccesses && plugin.name.endsWith("Unaligned") && declaringClass.getTypeName().equals("jdk.internal.misc.Unsafe")) {
            return;
        }
        super.register(declaringClass, plugin, allowOverwrite);
    }

    @Override
    public void checkNewNodes(GraphBuilderContext b, InvocationPlugin plugin, NodeIterable<Node> newNodes) {
        for (Node node : newNodes) {
            if (!(node instanceof MacroInvokable)) continue;
            GraalError.guarantee(plugin.inlineOnly(), "plugin that creates a %s (%s) must return true for inlineOnly(): %s", (Object)MacroInvokable.class.getSimpleName(), (Object)node, (Object)plugin);
        }
        super.checkNewNodes(b, plugin, newNodes);
    }

    @Override
    public void registerIntrinsificationPredicate(Predicate<ResolvedJavaType> predicate) {
        this.intrinsificationPredicates.add(predicate);
    }

    @Override
    public boolean canBeIntrinsified(ResolvedJavaType declaringClass) {
        boolean ok = false;
        for (Predicate<ResolvedJavaType> p : this.intrinsificationPredicates) {
            ok |= p.test(declaringClass);
        }
        if (!ok) {
            if (this.graalRuntime.isBootstrapping()) {
                throw GraalError.shouldNotReachHere("Class declaring a method for which a Graal intrinsic is available should be trusted for intrinsification: " + declaringClass.toJavaName());
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyNoPlugin(ResolvedJavaMethod targetMethod, OptionValues options) {
        String method;
        if (Options.WarnMissingIntrinsic.getValue(options).booleanValue() && this.unimplementedIntrinsics.isMissing(method = String.format("%s.%s%s", targetMethod.getDeclaringClass().toJavaName().replace('.', '/'), targetMethod.getName(), targetMethod.getSignature().toMethodDescriptor()))) {
            int currentCount;
            UnimplementedGraalIntrinsics unimplementedGraalIntrinsics = this.unimplementedIntrinsics;
            synchronized (unimplementedGraalIntrinsics) {
                if (this.missingIntrinsicMetrics == null) {
                    this.missingIntrinsicMetrics = new HashMap<String, Integer>();
                    try {
                        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                            if (this.missingIntrinsicMetrics.size() > 0) {
                                TTY.println("[Warning] Missing intrinsics found: %d", this.missingIntrinsicMetrics.size());
                                this.missingIntrinsicMetrics.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue, Comparator.reverseOrder())).forEach(entry -> TTY.println("        - %d occurrences during parsing: %s", entry.getValue(), entry.getKey()));
                            }
                        }));
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                currentCount = this.missingIntrinsicMetrics.compute(method, (key, cnt) -> cnt == null ? 1 : Math.addExact(cnt, 1));
            }
            if (currentCount == 1) {
                TTY.println("[Warning] Missing intrinsic %s found during parsing.", method);
            }
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> WarnMissingIntrinsic = new OptionKey<Boolean>(false);
    }
}

