/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.phases;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.loop.phases.LoopTransformations;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.EntryMarkerNode;
import org.graalvm.compiler.nodes.EntryProxyNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.extended.OSRLocalNode;
import org.graalvm.compiler.nodes.extended.OSRLockNode;
import org.graalvm.compiler.nodes.extended.OSRMonitorEnterNode;
import org.graalvm.compiler.nodes.extended.OSRStartNode;
import org.graalvm.compiler.nodes.java.AccessMonitorNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.MonitorEnterNode;
import org.graalvm.compiler.nodes.java.MonitorExitNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopsData;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;
import org.graalvm.compiler.serviceprovider.SpeculationReasonGroup;

public class OnStackReplacementPhase
extends BasePhase<CoreProviders> {
    private static final CounterKey OsrWithLocksCount = DebugContext.counter("OSRWithLocks");
    private static final SpeculationReasonGroup OSR_LOCAL_SPECULATIONS = new SpeculationReasonGroup("OSRLocal", Integer.TYPE, Stamp.class, Integer.TYPE);

    private static boolean supportOSRWithLocks(OptionValues options) {
        return Options.SupportOSRWithLocks.getValue(options);
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders providers) {
        OSRStartNode osrStart;
        EntryMarkerNode osr;
        DebugContext debug = graph.getDebug();
        if (graph.getEntryBCI() == -1) {
            assert (graph.getNodes(EntryMarkerNode.TYPE).isEmpty());
            return;
        }
        debug.dump(4, (Object)graph, "OnStackReplacement initial at bci %d", graph.getEntryBCI());
        int maxIterations = -1;
        int iterations = 0;
        EntryMarkerNode originalOSRNode = OnStackReplacementPhase.getEntryMarker(graph);
        LoopBeginNode originalOSRLoop = OnStackReplacementPhase.osrLoop(originalOSRNode, providers);
        boolean currentOSRWithLocks = OnStackReplacementPhase.osrWithLocks(originalOSRNode);
        if (originalOSRLoop == null) {
            throw new PermanentBailoutException("OSR compilation without OSR entry loop.");
        }
        if (!OnStackReplacementPhase.supportOSRWithLocks(graph.getOptions()) && currentOSRWithLocks) {
            throw new PermanentBailoutException("OSR with locks disabled.");
        }
        while (true) {
            osr = OnStackReplacementPhase.getEntryMarker(graph);
            LoopsData loops = providers.getLoopsDataProvider().getLoopsData(graph);
            Loop<Block> l = loops.getCFG().getNodeToBlock().get(osr).getLoop();
            if (l == null) break;
            ++iterations;
            if (maxIterations == -1) {
                maxIterations = l.getDepth();
            } else if (iterations > maxIterations) {
                throw GraalError.shouldNotReachHere();
            }
            while (l.getParent() != null) {
                l = l.getParent();
            }
            LoopEx loop = loops.loop(l);
            loop.loopBegin().markOsrLoop();
            LoopTransformations.peel(loop);
            osr.prepareDelete();
            GraphUtil.removeFixedWithUnusedInputs(osr);
            debug.dump(4, graph, "OnStackReplacement loop peeling result");
        }
        StartNode start = graph.start();
        FrameState osrState = osr.stateAfter();
        try (DebugCloseable context = osr.withNodeSourcePosition();){
            osr.setStateAfter(null);
            osrStart = graph.add(new OSRStartNode());
            FixedNode next = osr.next();
            osr.setNext(null);
            osrStart.setNext(next);
            graph.setStart(osrStart);
            osrStart.setStateAfter(osrState);
            debug.dump(4, graph, "OnStackReplacement after setting OSR start");
            int localsSize = osrState.localsSize();
            int locksSize = osrState.locksSize();
            for (int i = 0; i < localsSize + locksSize; ++i) {
                ValueNode value = i >= localsSize ? osrState.lockAt(i - localsSize) : osrState.localAt(i);
                if (value instanceof EntryProxyNode) {
                    EntryProxyNode proxy = (EntryProxyNode)value;
                    Stamp narrowedStamp = proxy.value().stamp(NodeView.DEFAULT);
                    Stamp unrestrictedStamp = proxy.stamp(NodeView.DEFAULT).unrestricted();
                    ValueNode osrLocal = i >= localsSize ? (ValueNode)graph.addOrUnique(new OSRLockNode(i - localsSize, unrestrictedStamp)) : (ValueNode)graph.addOrUnique(new OSRLocalNode(i, unrestrictedStamp));
                    SpeculationLog.SpeculationReason reason = OSR_LOCAL_SPECULATIONS.createSpeculationReason(osrState.bci, narrowedStamp, i);
                    if (graph.getSpeculationLog().maySpeculate(reason) && osrLocal instanceof OSRLocalNode && value.getStackKind().equals((Object)JavaKind.Object) && !narrowedStamp.isUnrestricted()) {
                        LogicNode check = graph.addOrUniqueWithInputs(InstanceOfNode.createHelper((ObjectStamp)narrowedStamp, osrLocal, null, null));
                        SpeculationLog.Speculation constant = graph.getSpeculationLog().speculate(reason);
                        FixedGuardNode guard = graph.add(new FixedGuardNode(check, DeoptimizationReason.OptimizedTypeCheckViolated, DeoptimizationAction.InvalidateRecompile, constant, false));
                        graph.addAfterFixed(osrStart, guard);
                        proxy.replaceAtMatchingUsages(osrLocal, n -> n == osrState);
                        osrLocal = graph.addOrUnique(new PiNode(osrLocal, narrowedStamp, guard));
                    }
                    proxy.replaceAndDelete(osrLocal);
                    continue;
                }
                assert (value == null || value instanceof OSRLocalNode);
            }
            osr.replaceAtUsages((Node)osrStart, InputType.Guard);
            osr.replaceAtUsages((Node)osrStart, InputType.Anchor);
        }
        debug.dump(4, graph, "OnStackReplacement after replacing entry proxies");
        GraphUtil.killCFG(start);
        debug.dump(4, graph, "OnStackReplacement result");
        new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Required).apply(graph);
        if (currentOSRWithLocks) {
            OsrWithLocksCount.increment(debug);
            context = osrStart.withNodeSourcePosition();
            try {
                for (int i = osrState.monitorIdCount() - 1; i >= 0; --i) {
                    MonitorIdNode id = osrState.monitorIdAt(i);
                    ValueNode lockedObject = osrState.lockAt(i);
                    OSRMonitorEnterNode osrMonitorEnter = graph.add(new OSRMonitorEnterNode(lockedObject, id));
                    osrMonitorEnter.setStateAfter(osrStart.stateAfter());
                    for (Node usage : id.usages()) {
                        if (!(usage instanceof AccessMonitorNode)) continue;
                        AccessMonitorNode access = (AccessMonitorNode)usage;
                        access.setObject(lockedObject);
                    }
                    FixedNode oldNext = osrStart.next();
                    oldNext.replaceAtPredecessor(null);
                    osrMonitorEnter.setNext(oldNext);
                    osrStart.setNext(osrMonitorEnter);
                }
            }
            finally {
                if (context != null) {
                    context.close();
                }
            }
            debug.dump(4, graph, "After inserting OSR monitor enters");
            for (MonitorExitNode exit : graph.getNodes(MonitorExitNode.TYPE)) {
                MonitorIdNode id = exit.getMonitorId();
                if (id.usages().filter(MonitorEnterNode.class).count() == 1) continue;
                throw new PermanentBailoutException("Unbalanced monitor enter-exit in OSR compilation with locks. Object is locked before the loop but released inside the loop.");
            }
        }
        debug.dump(4, graph, "OnStackReplacement result");
        new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Required).apply(graph);
        assert (graph.getNodes(ParameterNode.TYPE).count() == 0) : "OSR Compilation contains references to parameters.";
    }

    private static EntryMarkerNode getEntryMarker(StructuredGraph graph) {
        NodeIterable<EntryMarkerNode> osrNodes = graph.getNodes(EntryMarkerNode.TYPE);
        EntryMarkerNode osr = osrNodes.first();
        if (osr == null) {
            throw new GraalError("No OnStackReplacementNode generated");
        }
        if (osrNodes.count() > 1) {
            throw new GraalError("Multiple OnStackReplacementNodes generated");
        }
        if (osr.stateAfter().stackSize() != 0) {
            throw new PermanentBailoutException("OSR with stack entries not supported: %s", osr.stateAfter().toString(Verbosity.Debugger));
        }
        return osr;
    }

    private static LoopBeginNode osrLoop(EntryMarkerNode osr, CoreProviders providers) {
        LoopsData loops = providers.getLoopsDataProvider().getLoopsData(osr.graph());
        Loop<Block> l = loops.getCFG().getNodeToBlock().get(osr).getLoop();
        if (l == null) {
            return null;
        }
        return (LoopBeginNode)l.getHeader().getBeginNode();
    }

    private static boolean osrWithLocks(EntryMarkerNode osr) {
        return osr.stateAfter().locksSize() != 0;
    }

    @Override
    public float codeSizeIncrease() {
        return 5.0f;
    }

    public static class Options {
        public static final OptionKey<Boolean> DeoptAfterOSR = new OptionKey<Boolean>(true);
        public static final OptionKey<Boolean> SupportOSRWithLocks = new OptionKey<Boolean>(true);
    }
}

