/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.meta.Constant;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.nodes.StubForeignCallNode;
import org.graalvm.compiler.hotspot.nodes.StubStartNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.nodes.AssertionNode;
import org.graalvm.compiler.replacements.nodes.CStringConstant;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;

public class AssertionSnippets
implements Snippets {
    public static final HotSpotForeignCallDescriptor ASSERTION_VM_MESSAGE_C = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "assertionVmMessageC", Void.TYPE, Boolean.TYPE, Word.class, Long.TYPE, Long.TYPE, Long.TYPE);

    @Snippet
    public static void assertion(boolean condition, @Snippet.ConstantParameter Word message, long l1, long l2) {
        if (GraalDirectives.injectBranchProbability(1.0E-4, !condition)) {
            AssertionSnippets.vmMessageC(ASSERTION_VM_MESSAGE_C, true, message, l1, l2, 0L);
        }
    }

    @Snippet
    public static void stubAssertion(boolean condition, @Snippet.ConstantParameter Word message, long l1, long l2) {
        if (GraalDirectives.injectBranchProbability(1.0E-4, !condition)) {
            AssertionSnippets.vmMessageStub(ASSERTION_VM_MESSAGE_C, true, message, l1, l2, 0L);
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    static native void vmMessageC(@Node.ConstantNodeParameter ForeignCallDescriptor var0, boolean var1, Word var2, long var3, long var5, long var7);

    @Node.NodeIntrinsic(value=StubForeignCallNode.class)
    static native void vmMessageStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, boolean var1, Word var2, long var3, long var5, long var7);

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo assertion = this.snippet(AssertionSnippets.class, "assertion", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo stubAssertion = this.snippet(AssertionSnippets.class, "stubAssertion", new LocationIdentity[0]);

        public Templates(OptionValues options, HotSpotProviders providers) {
            super(options, providers);
        }

        public void lower(AssertionNode assertionNode, LoweringTool tool) {
            StructuredGraph graph = assertionNode.graph();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(graph.start() instanceof StubStartNode ? this.stubAssertion : this.assertion, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("condition", assertionNode.condition());
            args.addConst("message", graph.unique(new ConstantNode((Constant)new CStringConstant("failed runtime assertion in snippet/stub: " + assertionNode.message() + " (" + graph.method() + ")"), StampFactory.pointer())));
            args.add("l1", assertionNode.getL1());
            args.add("l2", assertionNode.getL2());
            this.template(assertionNode, args).instantiate(this.providers.getMetaAccess(), assertionNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

