/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public class BigIntegerSnippets
implements Snippets {
    @Snippet
    public static int[] implMultiplyToLen(int[] x, int xlen, int[] y, int ylen, int[] zIn) {
        int zLen;
        int[] zResult = zIn;
        if (zResult == null || zResult.length < xlen + ylen) {
            zLen = xlen + ylen;
            zResult = new int[xlen + ylen];
        } else {
            zLen = zIn.length;
        }
        HotSpotBackend.multiplyToLenStub(HotSpotReplacementsUtil.arrayStart(x), xlen, HotSpotReplacementsUtil.arrayStart(y), ylen, HotSpotReplacementsUtil.arrayStart(zResult), zLen);
        return zResult;
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        public final SnippetTemplate.SnippetInfo implMultiplyToLen = this.snippet(BigIntegerSnippets.class, "implMultiplyToLen", new LocationIdentity[0]);

        public Templates(OptionValues options, Providers providers) {
            super(options, providers);
        }
    }
}

