/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Lowerable;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
@Node.NodeIntrinsicFactory
public final class KlassLayoutHelperNode
extends FloatingNode
implements Canonicalizable,
Lowerable {
    public static final NodeClass<KlassLayoutHelperNode> TYPE = NodeClass.create(KlassLayoutHelperNode.class);
    @Node.Input
    protected ValueNode klass;
    protected final GraalHotSpotVMConfig config;

    public KlassLayoutHelperNode(@Node.InjectedNodeParameter GraalHotSpotVMConfig config, ValueNode klass) {
        super((NodeClass<? extends FloatingNode>)TYPE, StampFactory.forKind(JavaKind.Int));
        this.config = config;
        this.klass = klass;
    }

    public static ValueNode create(GraalHotSpotVMConfig config, ValueNode klass, ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess) {
        Stamp stamp = StampFactory.forKind(JavaKind.Int);
        return KlassLayoutHelperNode.canonical(null, config, klass, stamp, constantReflection, metaAccess);
    }

    public static boolean intrinsify(GraphBuilderContext b, @Node.InjectedNodeParameter GraalHotSpotVMConfig config, ValueNode klass) {
        ValueNode valueNode = KlassLayoutHelperNode.create(config, klass, b.getConstantReflection(), b.getMetaAccess());
        b.push(JavaKind.Int, b.append(valueNode));
        return true;
    }

    @Override
    public boolean inferStamp() {
        ObjectStamp objectStamp;
        ResolvedJavaType type;
        LoadHubNode hub;
        Stamp hubStamp;
        if (this.klass instanceof LoadHubNode && (hubStamp = (hub = (LoadHubNode)this.klass).getValue().stamp(NodeView.DEFAULT)) instanceof ObjectStamp && (type = (objectStamp = (ObjectStamp)hubStamp).type()) != null && !type.isJavaLangObject()) {
            if (!type.isArray() && !type.isInterface()) {
                return this.updateStamp(StampFactory.forInteger(JavaKind.Int, (long)this.config.klassLayoutHelperNeutralValue, Integer.MAX_VALUE));
            }
            if (type.isArray()) {
                return this.updateStamp(StampFactory.forInteger(JavaKind.Int, Integer.MIN_VALUE, (long)(this.config.klassLayoutHelperNeutralValue - 1)));
            }
        }
        return false;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        return KlassLayoutHelperNode.canonical(this, this.config, this.klass, this.stamp(NodeView.DEFAULT), tool.getConstantReflection(), tool.getMetaAccess());
    }

    private static ValueNode canonical(KlassLayoutHelperNode klassLayoutHelperNode, GraalHotSpotVMConfig config, ValueNode klass, Stamp stamp, ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess) {
        ObjectStamp ostamp;
        HotSpotResolvedObjectType type;
        LoadHubNode hub;
        Stamp hubStamp;
        KlassLayoutHelperNode self = klassLayoutHelperNode;
        if (klass.isConstant() && !klass.asConstant().isDefaultForKind()) {
            Constant constant = stamp.readConstant(constantReflection.getMemoryAccessProvider(), klass.asConstant(), config.klassLayoutHelperOffset);
            return ConstantNode.forConstant(stamp, constant, metaAccess);
        }
        if (klass instanceof LoadHubNode && (hubStamp = (hub = (LoadHubNode)klass).getValue().stamp(NodeView.DEFAULT)) instanceof ObjectStamp && (type = (HotSpotResolvedObjectType)(ostamp = (ObjectStamp)hubStamp).type()) != null && type.isArray() && !type.getComponentType().isPrimitive()) {
            Constant constant = stamp.readConstant(constantReflection.getMemoryAccessProvider(), type.klass(), config.klassLayoutHelperOffset);
            return ConstantNode.forConstant(stamp, constant, metaAccess);
        }
        if (self == null) {
            self = new KlassLayoutHelperNode(config, klass);
        }
        return self;
    }

    public ValueNode getHub() {
        return this.klass;
    }
}

