/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import java.util.function.Consumer;
import java.util.function.Function;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.SwitchStrategy;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.aarch64.AArch64BlockEndOp;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.aarch64.AArch64Move;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AArch64ControlFlow {
    private static void emitBranchOrFarBranch(CompilationResultBuilder crb, AArch64MacroAssembler masm, LIRInstruction instr, int immSize, Label target, Consumer<Label> originalBranch, Consumer<Label> negatedBranch) {
        boolean isFarBranch;
        if (target.isBound()) {
            isFarBranch = !NumUtil.isSignedNbit(immSize, masm.getPCRelativeOffset(target));
        } else {
            int maxLIRDistance = 1 << immSize - 4;
            boolean bl = isFarBranch = !crb.labelWithinLIRRange(instr, target, maxLIRDistance);
        }
        if (!isFarBranch) {
            originalBranch.accept(target);
        } else {
            Label skipJump = new Label();
            negatedBranch.accept(skipJump);
            masm.jmp(target);
            masm.bind(skipJump);
        }
    }

    @Opcode(value="CMOV")
    public static class ASIMDCondMoveOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<ASIMDCondMoveOp> TYPE = LIRInstructionClass.create(ASIMDCondMoveOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        AllocatableValue condition;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        AllocatableValue trueVal;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        AllocatableValue falseVal;

        public ASIMDCondMoveOp(AllocatableValue result, AllocatableValue condition, AllocatableValue trueVal, AllocatableValue falseVal) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            PlatformKind conditionKind = condition.getPlatformKind();
            PlatformKind trueKind = trueVal.getPlatformKind();
            PlatformKind falseKind = falseVal.getPlatformKind();
            assert (conditionKind.getSizeInBytes() == trueKind.getSizeInBytes() && conditionKind.getVectorLength() == trueKind.getVectorLength()) : condition + " " + trueVal;
            assert (trueKind == falseKind) : trueVal + " " + falseVal;
            this.result = result;
            this.condition = condition;
            this.trueVal = trueVal;
            this.falseVal = falseVal;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ASIMDSize size = AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.result.getPlatformKind());
            masm.neon.moveVV(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.condition));
            masm.neon.bslVVV(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.trueVal), ValueUtil.asRegister((Value)this.falseVal));
        }
    }

    public static final class HashTableSwitchOp
    extends AArch64BlockEndOp {
        public static final LIRInstructionClass<HashTableSwitchOp> TYPE = LIRInstructionClass.create(HashTableSwitchOp.class);
        private final JavaConstant[] keys;
        private final LabelRef defaultTarget;
        private final LabelRef[] targets;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue originalValue;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue hash;

        public HashTableSwitchOp(JavaConstant[] keys, LabelRef defaultTarget, LabelRef[] targets, AllocatableValue originalValue, AllocatableValue hash) {
            super((LIRInstructionClass<? extends AArch64BlockEndOp>)TYPE);
            this.keys = keys;
            this.defaultTarget = defaultTarget;
            this.targets = targets;
            this.originalValue = originalValue;
            this.hash = hash;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            try (AArch64MacroAssembler.ScratchRegister scratch1 = masm.getScratchRegister();
                 AArch64MacroAssembler.ScratchRegister scratch2 = masm.getScratchRegister();){
                Register jumpTableBase = scratch1.getRegister();
                Register jumpTableEntry = scratch2.getRegister();
                Label jumpTable = new Label();
                masm.adr(jumpTableBase, jumpTable);
                CompilationResult.JumpTable.EntryFormat format = this.defaultTarget == null ? CompilationResult.JumpTable.EntryFormat.OFFSET_ONLY : CompilationResult.JumpTable.EntryFormat.VALUE_AND_OFFSET;
                int memAccessSize = format.size * 8;
                AArch64Address jumpTableEntryAddr = AArch64Address.createExtendedRegisterOffsetAddress(memAccessSize, jumpTableBase, ValueUtil.asRegister((Value)this.hash), true, AArch64Assembler.ExtendType.UXTW);
                masm.ldrs(64, memAccessSize, jumpTableEntry, jumpTableEntryAddr);
                if (format == CompilationResult.JumpTable.EntryFormat.OFFSET_ONLY) {
                    masm.add(64, jumpTableEntry, jumpTableBase, jumpTableEntry);
                    masm.jmp(jumpTableEntry);
                } else {
                    assert (format == CompilationResult.JumpTable.EntryFormat.VALUE_AND_OFFSET);
                    masm.cmp(32, jumpTableEntry, ValueUtil.asRegister((Value)this.originalValue));
                    masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, this.defaultTarget.label());
                    masm.add(64, jumpTableBase, jumpTableBase, jumpTableEntry, AArch64Assembler.ShiftType.ASR, 32);
                    masm.jmp(jumpTableBase);
                }
                masm.align(format.size);
                masm.bind(jumpTable);
                for (int i = 0; i < this.targets.length; ++i) {
                    if (format == CompilationResult.JumpTable.EntryFormat.VALUE_AND_OFFSET) {
                        masm.emitInt(this.keys[i].asInt());
                    }
                    masm.emitJumpTableOffset(jumpTable, this.targets[i].label());
                }
                CompilationResult.JumpTable jt = new CompilationResult.JumpTable(jumpTable.position(), 0, this.keys.length - 1, format);
                crb.compilationResult.addAnnotation(jt);
            }
        }
    }

    public static final class RangeTableSwitchOp
    extends AArch64BlockEndOp {
        public static final LIRInstructionClass<RangeTableSwitchOp> TYPE = LIRInstructionClass.create(RangeTableSwitchOp.class);
        private final int lowKey;
        private final LabelRef defaultTarget;
        private final LabelRef[] targets;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue index;

        public RangeTableSwitchOp(int lowKey, LabelRef defaultTarget, LabelRef[] targets, AllocatableValue index) {
            super((LIRInstructionClass<? extends AArch64BlockEndOp>)TYPE);
            this.lowKey = lowKey;
            assert (defaultTarget != null);
            this.defaultTarget = defaultTarget;
            this.targets = targets;
            this.index = index;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            try (AArch64MacroAssembler.ScratchRegister sc1 = masm.getScratchRegister();
                 AArch64MacroAssembler.ScratchRegister sc2 = masm.getScratchRegister();){
                Register scratch1 = sc1.getRegister();
                Register scratch2 = sc2.getRegister();
                int highKey = this.lowKey + this.targets.length - 1;
                masm.sub(32, scratch2, ValueUtil.asRegister((Value)this.index), this.lowKey);
                int keyDiff = highKey - this.lowKey;
                if (AArch64MacroAssembler.isComparisonImmediate(keyDiff)) {
                    masm.compare(32, scratch2, keyDiff);
                } else {
                    masm.mov(scratch1, keyDiff);
                    masm.cmp(32, scratch2, scratch1);
                }
                masm.branchConditionally(AArch64Assembler.ConditionFlag.HI, this.defaultTarget.label());
                Label jumpTable = new Label();
                masm.adr(scratch1, jumpTable);
                AArch64Address jumpTableEntryAddr = AArch64Address.createExtendedRegisterOffsetAddress(32, scratch1, scratch2, true, AArch64Assembler.ExtendType.UXTW);
                masm.ldrs(64, 32, scratch2, jumpTableEntryAddr);
                masm.add(64, scratch1, scratch1, scratch2);
                masm.jmp(scratch1);
                masm.bind(jumpTable);
                for (LabelRef target : this.targets) {
                    masm.emitJumpTableOffset(jumpTable, target.label());
                }
                CompilationResult.JumpTable jt = new CompilationResult.JumpTable(jumpTable.position(), this.lowKey, highKey, CompilationResult.JumpTable.EntryFormat.OFFSET_ONLY);
                crb.compilationResult.addAnnotation(jt);
            }
        }
    }

    public static class StrategySwitchOp
    extends AArch64BlockEndOp {
        public static final LIRInstructionClass<StrategySwitchOp> TYPE = LIRInstructionClass.create(StrategySwitchOp.class);
        private final Constant[] keyConstants;
        protected final SwitchStrategy strategy;
        private final Function<Condition, AArch64Assembler.ConditionFlag> converter;
        private final LabelRef[] keyTargets;
        private final LabelRef defaultTarget;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue key;

        public StrategySwitchOp(SwitchStrategy strategy, LabelRef[] keyTargets, LabelRef defaultTarget, AllocatableValue key, Function<Condition, AArch64Assembler.ConditionFlag> converter) {
            this(TYPE, strategy, keyTargets, defaultTarget, key, converter);
        }

        protected StrategySwitchOp(LIRInstructionClass<? extends StrategySwitchOp> c, SwitchStrategy strategy, LabelRef[] keyTargets, LabelRef defaultTarget, AllocatableValue key, Function<Condition, AArch64Assembler.ConditionFlag> converter) {
            super((LIRInstructionClass<? extends AArch64BlockEndOp>)c);
            this.strategy = strategy;
            this.converter = converter;
            this.keyConstants = strategy.getKeyConstants();
            this.keyTargets = keyTargets;
            this.defaultTarget = defaultTarget;
            this.key = key;
            assert (this.keyConstants.length == keyTargets.length);
            assert (this.keyConstants.length == strategy.keyProbabilities.length);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            this.strategy.run(new SwitchClosure(ValueUtil.asRegister((Value)this.key), crb, masm));
        }

        private static void emitCompareHelper(CompilationResultBuilder crb, AArch64MacroAssembler masm, int cmpSize, Value key, JavaConstant jc) {
            assert (cmpSize == key.getPlatformKind().getSizeInBytes() * 8);
            long imm = jc.asLong();
            if (AArch64MacroAssembler.isComparisonImmediate(imm)) {
                masm.compare(cmpSize, ValueUtil.asRegister((Value)key), NumUtil.safeToInt(imm));
            } else {
                try (AArch64MacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
                    Register scratchReg = scratch.getRegister();
                    AArch64Move.const2reg((AArch64Kind)key.getPlatformKind(), crb, masm, scratchReg, jc);
                    masm.cmp(cmpSize, ValueUtil.asRegister((Value)key), scratchReg);
                }
            }
        }

        public class SwitchClosure
        extends SwitchStrategy.BaseSwitchClosure {
            protected final Register keyRegister;
            protected final CompilationResultBuilder crb;
            protected final AArch64MacroAssembler masm;

            protected SwitchClosure(Register keyRegister, CompilationResultBuilder crb, AArch64MacroAssembler masm) {
                super(crb, masm, StrategySwitchOp.this.keyTargets, StrategySwitchOp.this.defaultTarget);
                this.keyRegister = keyRegister;
                this.crb = crb;
                this.masm = masm;
            }

            protected void emitComparison(Constant c) {
                JavaConstant jc = (JavaConstant)c;
                switch (jc.getJavaKind()) {
                    case Int: {
                        long lc = jc.asLong();
                        assert (NumUtil.isInt(lc));
                        StrategySwitchOp.emitCompareHelper(this.crb, this.masm, 32, (Value)StrategySwitchOp.this.key, jc);
                        break;
                    }
                    case Long: {
                        StrategySwitchOp.emitCompareHelper(this.crb, this.masm, 64, (Value)StrategySwitchOp.this.key, jc);
                        break;
                    }
                    case Object: {
                        StrategySwitchOp.emitCompareHelper(this.crb, this.masm, 64, (Value)StrategySwitchOp.this.key, jc);
                        break;
                    }
                    default: {
                        throw new GraalError("switch only supported for int, long and object");
                    }
                }
            }

            @Override
            protected void conditionalJump(int index, Condition condition, Label target) {
                this.emitComparison(StrategySwitchOp.this.keyConstants[index]);
                this.masm.branchConditionally(StrategySwitchOp.this.converter.apply(condition), target);
            }
        }
    }

    public static class CondSetOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<CondSetOp> TYPE = LIRInstructionClass.create(CondSetOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        private final AArch64Assembler.ConditionFlag condition;

        public CondSetOp(Variable result, AArch64Assembler.ConditionFlag condition) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.result = result;
            this.condition = condition;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int size = this.result.getPlatformKind().getSizeInBytes() * 8;
            masm.cset(size, ValueUtil.asRegister((Value)this.result), this.condition);
        }
    }

    @Opcode(value="CMOVE")
    public static class CondMoveOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<CondMoveOp> TYPE = LIRInstructionClass.create(CondMoveOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue trueValue;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue falseValue;
        private final AArch64Assembler.ConditionFlag condition;

        public CondMoveOp(Variable result, AArch64Assembler.ConditionFlag condition, AllocatableValue trueValue, AllocatableValue falseValue) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            assert (trueValue.getPlatformKind() == falseValue.getPlatformKind() && trueValue.getPlatformKind() == result.getPlatformKind());
            this.result = result;
            this.condition = condition;
            this.trueValue = trueValue;
            this.falseValue = falseValue;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64Kind kind = (AArch64Kind)this.trueValue.getPlatformKind();
            int size = kind.getSizeInBytes() * 8;
            if (kind.isInteger()) {
                masm.csel(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.trueValue), ValueUtil.asRegister((Value)this.falseValue), this.condition);
            } else {
                masm.fcsel(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.trueValue), ValueUtil.asRegister((Value)this.falseValue), this.condition);
            }
        }
    }

    public static class BitTestAndBranchOp
    extends AbstractBranchOp
    implements StandardOp.BranchOp {
        public static final LIRInstructionClass<BitTestAndBranchOp> TYPE = LIRInstructionClass.create(BitTestAndBranchOp.class);
        @LIRInstruction.Use
        protected AllocatableValue value;
        private final int index;

        public BitTestAndBranchOp(LabelRef trueDestination, LabelRef falseDestination, AllocatableValue value, double trueDestinationProbability, int index) {
            super(TYPE, trueDestination, falseDestination, trueDestinationProbability);
            this.value = value;
            this.index = index;
        }

        @Override
        protected void emitBranch(CompilationResultBuilder crb, AArch64MacroAssembler masm, LabelRef target, boolean negate) {
            Consumer<Label> negatedBranch;
            Consumer<Label> originalBranch;
            Consumer<Label> tbzBranch = l -> masm.tbz(ValueUtil.asRegister((Value)this.value), this.index, (Label)l);
            Consumer<Label> tbnzBranch = l -> masm.tbnz(ValueUtil.asRegister((Value)this.value), this.index, (Label)l);
            if (negate) {
                originalBranch = tbnzBranch;
                negatedBranch = tbzBranch;
            } else {
                originalBranch = tbzBranch;
                negatedBranch = tbnzBranch;
            }
            AArch64ControlFlow.emitBranchOrFarBranch(crb, masm, this, 16, target.label(), originalBranch, negatedBranch);
        }
    }

    public static class CompareBranchZeroOp
    extends AbstractBranchOp
    implements StandardOp.BranchOp {
        public static final LIRInstructionClass<CompareBranchZeroOp> TYPE = LIRInstructionClass.create(CompareBranchZeroOp.class);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        private AllocatableValue value;

        public CompareBranchZeroOp(AllocatableValue value, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
            super(TYPE, trueDestination, falseDestination, trueDestinationProbability);
            this.value = value;
        }

        @Override
        protected void emitBranch(CompilationResultBuilder crb, AArch64MacroAssembler masm, LabelRef target, boolean negate) {
            Consumer<Label> negatedBranch;
            Consumer<Label> originalBranch;
            AArch64Kind kind = (AArch64Kind)this.value.getPlatformKind();
            assert (kind.isInteger());
            int size = kind.getSizeInBytes() * 8;
            Consumer<Label> cbzBranch = l -> masm.cbz(size, ValueUtil.asRegister((Value)this.value), (Label)l);
            Consumer<Label> cbnzBranch = l -> masm.cbnz(size, ValueUtil.asRegister((Value)this.value), (Label)l);
            if (negate) {
                originalBranch = cbnzBranch;
                negatedBranch = cbzBranch;
            } else {
                originalBranch = cbzBranch;
                negatedBranch = cbnzBranch;
            }
            AArch64ControlFlow.emitBranchOrFarBranch(crb, masm, this, 21, target.label(), originalBranch, negatedBranch);
        }
    }

    public static class BranchOp
    extends AbstractBranchOp
    implements StandardOp.BranchOp {
        public static final LIRInstructionClass<BranchOp> TYPE = LIRInstructionClass.create(BranchOp.class);
        private final AArch64Assembler.ConditionFlag condition;

        public BranchOp(AArch64Assembler.ConditionFlag condition, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
            super(TYPE, trueDestination, falseDestination, trueDestinationProbability);
            this.condition = condition;
        }

        @Override
        protected void emitBranch(CompilationResultBuilder crb, AArch64MacroAssembler masm, LabelRef target, boolean negate) {
            AArch64Assembler.ConditionFlag finalCond = negate ? this.condition.negate() : this.condition;
            masm.branchConditionally(finalCond, target.label());
        }
    }

    public static abstract class AbstractBranchOp
    extends AArch64BlockEndOp
    implements StandardOp.BranchOp {
        private final LabelRef trueDestination;
        private final LabelRef falseDestination;
        private final double trueDestinationProbability;

        private AbstractBranchOp(LIRInstructionClass<? extends AbstractBranchOp> c, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
            super((LIRInstructionClass<? extends AArch64BlockEndOp>)c);
            this.trueDestination = trueDestination;
            this.falseDestination = falseDestination;
            this.trueDestinationProbability = trueDestinationProbability;
        }

        protected abstract void emitBranch(CompilationResultBuilder var1, AArch64MacroAssembler var2, LabelRef var3, boolean var4);

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            if (crb.isSuccessorEdge(this.trueDestination)) {
                this.emitBranch(crb, masm, this.falseDestination, true);
            } else if (crb.isSuccessorEdge(this.falseDestination)) {
                this.emitBranch(crb, masm, this.trueDestination, false);
            } else if (this.trueDestinationProbability < 0.5) {
                this.emitBranch(crb, masm, this.falseDestination, true);
                masm.jmp(this.trueDestination.label());
            } else {
                this.emitBranch(crb, masm, this.trueDestination, false);
                masm.jmp(this.falseDestination.label());
            }
        }
    }

    public static final class ReturnOp
    extends AArch64BlockEndOp {
        public static final LIRInstructionClass<ReturnOp> TYPE = LIRInstructionClass.create(ReturnOp.class);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        protected Value x;

        public ReturnOp(Value x) {
            super((LIRInstructionClass<? extends AArch64BlockEndOp>)TYPE);
            this.x = x;
        }

        @Override
        protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            crb.frameContext.leave(crb);
            masm.ret(AArch64.lr);
            crb.frameContext.returned(crb);
        }
    }
}

