/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64ComplexVectorOp;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@Opcode(value="ARRAY_COMPARE_TO")
public final class AMD64ArrayCompareToOp
extends AMD64ComplexVectorOp {
    public static final LIRInstructionClass<AMD64ArrayCompareToOp> TYPE = LIRInstructionClass.create(AMD64ArrayCompareToOp.class);
    private final JavaKind kind1;
    private final JavaKind kind2;
    private final int array1BaseOffset;
    private final int array2BaseOffset;
    private final int useAVX3Threshold;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value resultValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value array1Value;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value array2Value;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected Value length1Value;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected Value length2Value;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value length1ValueTemp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value length2ValueTemp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value temp1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value temp2;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value vectorTemp1;

    public AMD64ArrayCompareToOp(LIRGeneratorTool tool, int useAVX3Threshold, JavaKind kind1, JavaKind kind2, int array1BaseOffset, int array2BaseOffset, Value result, Value array1, Value array2, Value length1, Value length2) {
        super(TYPE, tool, AVXKind.AVXSize.ZMM);
        assert (CodeUtil.isPowerOf2((int)useAVX3Threshold)) : "AVX3Threshold must be power of 2";
        this.useAVX3Threshold = useAVX3Threshold;
        this.kind1 = kind1;
        this.kind2 = kind2;
        this.array1BaseOffset = array1BaseOffset;
        this.array2BaseOffset = array2BaseOffset;
        this.resultValue = result;
        this.array1Value = array1;
        this.array2Value = array2;
        this.length1Value = length1;
        this.length2Value = length2;
        this.length1ValueTemp = length1;
        this.length2ValueTemp = length2;
        this.temp1 = tool.newVariable(LIRKind.unknownReference(tool.target().arch.getWordKind()));
        this.temp2 = tool.newVariable(LIRKind.unknownReference(tool.target().arch.getWordKind()));
        this.vectorTemp1 = AMD64ArrayCompareToOp.supports(tool.target(), AMD64.CPUFeature.SSE4_2) ? tool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DOUBLE)) : Value.ILLEGAL;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        int stride;
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register str1 = ValueUtil.asRegister((Value)this.temp1);
        Register str2 = ValueUtil.asRegister((Value)this.temp2);
        masm.leaq(str1, new AMD64Address(ValueUtil.asRegister((Value)this.array1Value), this.array1BaseOffset));
        masm.leaq(str2, new AMD64Address(ValueUtil.asRegister((Value)this.array2Value), this.array2BaseOffset));
        Register cnt1 = ValueUtil.asRegister((Value)this.length1Value);
        Register cnt2 = ValueUtil.asRegister((Value)this.length2Value);
        Label labelLengthDiff = new Label();
        Label labelPop = new Label();
        Label labelDone = new Label();
        Label labelWhileHead = new Label();
        Label labelCompareWideVectorsLoopFailed = new Label();
        int adrStride = -1;
        int adrStride1 = -1;
        int adrStride2 = -1;
        int stride2x2 = 64;
        AMD64Address.Scale scale = null;
        AMD64Address.Scale scale1 = null;
        AMD64Address.Scale scale2 = null;
        if (this.kind1 != JavaKind.Byte || this.kind2 != JavaKind.Byte) {
            stride2x2 = 32;
        }
        if (this.kind1 != this.kind2) {
            masm.shrl(cnt2, 1);
        }
        masm.movl(result, cnt1);
        masm.subl(cnt1, cnt2);
        masm.push(cnt1);
        masm.cmovl(AMD64Assembler.ConditionFlag.LessEqual, cnt2, result);
        masm.testlAndJcc(cnt2, cnt2, AMD64Assembler.ConditionFlag.Zero, labelLengthDiff, false);
        if (this.kind1 == JavaKind.Byte && this.kind2 == JavaKind.Byte) {
            masm.movzbl(result, new AMD64Address(str1, 0));
            masm.movzbl(cnt1, new AMD64Address(str2, 0));
        } else if (this.kind1 == JavaKind.Char && this.kind2 == JavaKind.Char) {
            masm.movzwl(result, new AMD64Address(str1, 0));
            masm.movzwl(cnt1, new AMD64Address(str2, 0));
        } else {
            masm.movzbl(result, new AMD64Address(str1, 0));
            masm.movzwl(cnt1, new AMD64Address(str2, 0));
        }
        masm.sublAndJcc(result, cnt1, AMD64Assembler.ConditionFlag.NotZero, labelPop, false);
        if (this.kind1 == JavaKind.Char && this.kind2 == JavaKind.Char) {
            masm.shrl(cnt2, 1);
        }
        masm.cmplAndJcc(cnt2, 1, AMD64Assembler.ConditionFlag.Equal, labelLengthDiff, false);
        if (this.kind1 == this.kind2) {
            masm.cmpqAndJcc(str1, str2, AMD64Assembler.ConditionFlag.Equal, labelLengthDiff, false);
            if (this.kind1 == JavaKind.Byte && this.kind2 == JavaKind.Byte) {
                scale = AMD64Address.Scale.Times1;
                stride = 16;
            } else {
                scale = AMD64Address.Scale.Times2;
                stride = 8;
            }
        } else {
            scale1 = AMD64Address.Scale.Times1;
            scale2 = AMD64Address.Scale.Times2;
            stride = 8;
        }
        if (this.supportsAVX2AndYMM() && masm.supports(AMD64.CPUFeature.SSE4_2)) {
            Register vec1 = ValueUtil.asRegister((Value)this.vectorTemp1, (PlatformKind)AMD64Kind.DOUBLE);
            Label labelCompareWideVectors = new Label();
            Label labelVectorNotEqual = new Label();
            Label labelCompareWideTail = new Label();
            Label labelCompareSmallStr = new Label();
            Label labelCompareWideVectorsLoop = new Label();
            Label labelCompare16Chars = new Label();
            Label labelCompareIndexChar = new Label();
            Label labelCompareWideVectorsLoopAVX2 = new Label();
            Label labelCompareTailLong = new Label();
            Label labelCompareWideVectorsLoopAVX3 = new Label();
            int pcmpmask = 25;
            if (this.kind1 == JavaKind.Byte && this.kind2 == JavaKind.Byte) {
                pcmpmask &= 0xFFFFFFFE;
            }
            int stride2 = this.kind1 == JavaKind.Byte && this.kind2 == JavaKind.Byte ? 32 : 16;
            if (this.kind1 == this.kind2) {
                adrStride = stride << scale.log2;
            } else {
                adrStride1 = 8;
                adrStride2 = 16;
            }
            assert (result.equals((Object)AMD64.rax) && cnt2.equals((Object)AMD64.rdx) && cnt1.equals((Object)AMD64.rcx)) : "pcmpestri";
            masm.movl(result, cnt2);
            masm.andlAndJcc(cnt2, ~(stride2 - 1), AMD64Assembler.ConditionFlag.Zero, labelCompareTailLong, false);
            masm.bind(labelCompare16Chars);
            if (this.kind1 == this.kind2) {
                masm.movdqu(vec1, new AMD64Address(str1, 0));
            } else {
                masm.pmovzxbw(vec1, new AMD64Address(str1, 0));
            }
            masm.pcmpestri(vec1, new AMD64Address(str2, 0), pcmpmask);
            masm.jccb(AMD64Assembler.ConditionFlag.Below, labelCompareIndexChar);
            if (this.kind1 == this.kind2) {
                masm.movdqu(vec1, new AMD64Address(str1, adrStride));
                masm.pcmpestri(vec1, new AMD64Address(str2, adrStride), pcmpmask);
            } else {
                masm.pmovzxbw(vec1, new AMD64Address(str1, adrStride1));
                masm.pcmpestri(vec1, new AMD64Address(str2, adrStride2), pcmpmask);
            }
            masm.jccb(AMD64Assembler.ConditionFlag.AboveEqual, labelCompareWideVectors);
            masm.addl(cnt1, stride);
            masm.bind(labelCompareIndexChar);
            this.loadNextElements(masm, result, cnt2, str1, str2, scale, scale1, scale2, cnt1);
            masm.subl(result, cnt2);
            masm.jmp(labelPop);
            masm.bind(labelCompareWideVectors);
            if (this.kind1 == this.kind2) {
                masm.leaq(str1, new AMD64Address(str1, result, scale));
                masm.leaq(str2, new AMD64Address(str2, result, scale));
            } else {
                masm.leaq(str1, new AMD64Address(str1, result, scale1));
                masm.leaq(str2, new AMD64Address(str2, result, scale2));
            }
            masm.subl(result, stride2);
            masm.sublAndJcc(cnt2, stride2, AMD64Assembler.ConditionFlag.Zero, labelCompareWideTail, false);
            masm.negq(result);
            masm.bind(labelCompareWideVectorsLoop);
            if (this.useAVX3Threshold == 0 && this.supportsAVX512VLBWAndZMM()) {
                masm.cmplAndJcc(cnt2, stride2x2, AMD64Assembler.ConditionFlag.Below, labelCompareWideVectorsLoopAVX2, true);
                masm.testlAndJcc(cnt2, stride2x2 - 1, AMD64Assembler.ConditionFlag.NotZero, labelCompareWideVectorsLoopAVX2, true);
                masm.bind(labelCompareWideVectorsLoopAVX3);
                if (this.kind1 == this.kind2) {
                    masm.evmovdqu64(vec1, new AMD64Address(str1, result, scale));
                    masm.evpcmpeqb(AMD64.k7, vec1, new AMD64Address(str2, result, scale));
                } else {
                    masm.evpmovzxbw(vec1, new AMD64Address(str1, result, scale1));
                    masm.evpcmpeqb(AMD64.k7, vec1, new AMD64Address(str2, result, scale2));
                }
                masm.kortestq(AMD64.k7, AMD64.k7);
                masm.jcc(AMD64Assembler.ConditionFlag.AboveEqual, labelCompareWideVectorsLoopFailed);
                masm.addq(result, stride2x2);
                masm.sublAndJcc(cnt2, stride2x2, AMD64Assembler.ConditionFlag.NotZero, labelCompareWideVectorsLoopAVX3, true);
                masm.vpxor(vec1, vec1, vec1);
                masm.jmpb(labelCompareWideTail);
            }
            masm.bind(labelCompareWideVectorsLoopAVX2);
            if (this.kind1 == this.kind2) {
                masm.vmovdqu(vec1, new AMD64Address(str1, result, scale));
                masm.vpxor(vec1, vec1, new AMD64Address(str2, result, scale));
            } else {
                masm.vpmovzxbw(vec1, new AMD64Address(str1, result, scale1));
                masm.vpxor(vec1, vec1, new AMD64Address(str2, result, scale2));
            }
            masm.vptest(vec1, vec1);
            masm.jcc(AMD64Assembler.ConditionFlag.NotZero, labelVectorNotEqual);
            masm.addq(result, stride2);
            masm.sublAndJcc(cnt2, stride2, AMD64Assembler.ConditionFlag.NotZero, labelCompareWideVectorsLoop, false);
            masm.vpxor(vec1, vec1, vec1);
            masm.bind(labelCompareWideTail);
            masm.testqAndJcc(result, result, AMD64Assembler.ConditionFlag.Zero, labelLengthDiff, false);
            masm.movl(result, stride2);
            masm.movl(cnt2, result);
            masm.negq(result);
            masm.jmp(labelCompareWideVectorsLoopAVX2);
            masm.bind(labelVectorNotEqual);
            masm.vpxor(vec1, vec1, vec1);
            if (this.kind1 == this.kind2) {
                masm.leaq(str1, new AMD64Address(str1, result, scale));
                masm.leaq(str2, new AMD64Address(str2, result, scale));
            } else {
                masm.leaq(str1, new AMD64Address(str1, result, scale1));
                masm.leaq(str2, new AMD64Address(str2, result, scale2));
            }
            masm.jmp(labelCompare16Chars);
            masm.bind(labelCompareTailLong);
            masm.movl(cnt2, result);
            masm.cmplAndJcc(cnt2, stride, AMD64Assembler.ConditionFlag.Less, labelCompareSmallStr, false);
            if (this.kind1 == this.kind2) {
                masm.movdqu(vec1, new AMD64Address(str1, 0));
            } else {
                masm.pmovzxbw(vec1, new AMD64Address(str1, 0));
            }
            masm.pcmpestri(vec1, new AMD64Address(str2, 0), pcmpmask);
            masm.jcc(AMD64Assembler.ConditionFlag.Below, labelCompareIndexChar);
            masm.subqAndJcc(cnt2, stride, AMD64Assembler.ConditionFlag.Zero, labelLengthDiff, false);
            if (this.kind1 == this.kind2) {
                masm.leaq(str1, new AMD64Address(str1, result, scale));
                masm.leaq(str2, new AMD64Address(str2, result, scale));
            } else {
                masm.leaq(str1, new AMD64Address(str1, result, scale1));
                masm.leaq(str2, new AMD64Address(str2, result, scale2));
            }
            masm.negq(cnt2);
            masm.jmpb(labelWhileHead);
            masm.bind(labelCompareSmallStr);
        } else if (masm.supports(AMD64.CPUFeature.SSE4_2)) {
            Register vec1 = ValueUtil.asRegister((Value)this.vectorTemp1, (PlatformKind)AMD64Kind.DOUBLE);
            Label labelCompareWideVectors = new Label();
            Label labelVectorNotEqual = new Label();
            Label labelCompareTail = new Label();
            int pcmpmask = 25;
            masm.movl(result, cnt2);
            if (this.kind1 == JavaKind.Byte && this.kind2 == JavaKind.Byte) {
                pcmpmask &= 0xFFFFFFFE;
            }
            masm.andlAndJcc(cnt2, ~(stride - 1), AMD64Assembler.ConditionFlag.Zero, labelCompareTail, false);
            if (this.kind1 == this.kind2) {
                masm.leaq(str1, new AMD64Address(str1, result, scale));
                masm.leaq(str2, new AMD64Address(str2, result, scale));
            } else {
                masm.leaq(str1, new AMD64Address(str1, result, scale1));
                masm.leaq(str2, new AMD64Address(str2, result, scale2));
            }
            masm.negq(result);
            assert (result.equals((Object)AMD64.rax) && cnt2.equals((Object)AMD64.rdx) && cnt1.equals((Object)AMD64.rcx)) : "pcmpestri";
            masm.bind(labelCompareWideVectors);
            if (this.kind1 == this.kind2) {
                masm.movdqu(vec1, new AMD64Address(str1, result, scale));
                masm.pcmpestri(vec1, new AMD64Address(str2, result, scale), pcmpmask);
            } else {
                masm.pmovzxbw(vec1, new AMD64Address(str1, result, scale1));
                masm.pcmpestri(vec1, new AMD64Address(str2, result, scale2), pcmpmask);
            }
            masm.jccb(AMD64Assembler.ConditionFlag.Below, labelVectorNotEqual);
            masm.addq(result, stride);
            masm.subqAndJcc(cnt2, stride, AMD64Assembler.ConditionFlag.NotZero, labelCompareWideVectors, true);
            masm.testqAndJcc(result, result, AMD64Assembler.ConditionFlag.Zero, labelLengthDiff, false);
            masm.movl(cnt2, stride);
            masm.movl(result, stride);
            masm.negq(result);
            if (this.kind1 == this.kind2) {
                masm.movdqu(vec1, new AMD64Address(str1, result, scale));
                masm.pcmpestri(vec1, new AMD64Address(str2, result, scale), pcmpmask);
            } else {
                masm.pmovzxbw(vec1, new AMD64Address(str1, result, scale1));
                masm.pcmpestri(vec1, new AMD64Address(str2, result, scale2), pcmpmask);
            }
            masm.jccb(AMD64Assembler.ConditionFlag.AboveEqual, labelLengthDiff);
            masm.bind(labelVectorNotEqual);
            masm.addq(cnt1, result);
            this.loadNextElements(masm, result, cnt2, str1, str2, scale, scale1, scale2, cnt1);
            masm.subl(result, cnt2);
            masm.jmpb(labelPop);
            masm.bind(labelCompareTail);
            masm.movl(cnt2, result);
        }
        if (this.kind1 == this.kind2) {
            masm.leaq(str1, new AMD64Address(str1, cnt2, scale));
            masm.leaq(str2, new AMD64Address(str2, cnt2, scale));
        } else {
            masm.leaq(str1, new AMD64Address(str1, cnt2, scale1));
            masm.leaq(str2, new AMD64Address(str2, cnt2, scale2));
        }
        masm.decrementl(cnt2);
        masm.negq(cnt2);
        masm.bind(labelWhileHead);
        this.loadNextElements(masm, result, cnt1, str1, str2, scale, scale1, scale2, cnt2);
        masm.sublAndJcc(result, cnt1, AMD64Assembler.ConditionFlag.NotZero, labelPop, true);
        masm.incqAndJcc(cnt2, AMD64Assembler.ConditionFlag.NotZero, labelWhileHead, true);
        masm.bind(labelLengthDiff);
        masm.pop(result);
        if (this.kind1 == JavaKind.Char && this.kind2 == JavaKind.Char) {
            masm.sarl(result, 1);
        }
        masm.jmpb(labelDone);
        if (this.supportsAVX512VLBWAndZMM()) {
            masm.bind(labelCompareWideVectorsLoopFailed);
            masm.kmovq(cnt1, AMD64.k7);
            masm.notq(cnt1);
            masm.bsfq(cnt2, cnt1);
            if (this.kind1 != JavaKind.Byte || this.kind2 != JavaKind.Byte) {
                masm.sarl(cnt2, 1);
            }
            masm.addq(result, cnt2);
            if (this.kind1 == JavaKind.Byte && this.kind2 == JavaKind.Byte) {
                masm.movzbl(cnt1, new AMD64Address(str2, result, AMD64Address.Scale.Times1));
                masm.movzbl(result, new AMD64Address(str1, result, AMD64Address.Scale.Times1));
            } else if (this.kind1 == JavaKind.Char && this.kind2 == JavaKind.Char) {
                masm.movzwl(cnt1, new AMD64Address(str2, result, scale));
                masm.movzwl(result, new AMD64Address(str1, result, scale));
            } else {
                masm.movzwl(cnt1, new AMD64Address(str2, result, scale2));
                masm.movzbl(result, new AMD64Address(str1, result, scale1));
            }
            masm.subl(result, cnt1);
            masm.jmpb(labelPop);
        }
        masm.bind(labelPop);
        masm.pop(cnt1);
        masm.bind(labelDone);
        if (this.kind1 == JavaKind.Char && this.kind2 == JavaKind.Byte) {
            masm.negl(result);
        }
    }

    private void loadNextElements(AMD64MacroAssembler masm, Register elem1, Register elem2, Register str1, Register str2, AMD64Address.Scale scale, AMD64Address.Scale scale1, AMD64Address.Scale scale2, Register index) {
        if (this.kind1 == JavaKind.Byte && this.kind2 == JavaKind.Byte) {
            masm.movzbl(elem1, new AMD64Address(str1, index, scale, 0));
            masm.movzbl(elem2, new AMD64Address(str2, index, scale, 0));
        } else if (this.kind1 == JavaKind.Char && this.kind2 == JavaKind.Char) {
            masm.movzwl(elem1, new AMD64Address(str1, index, scale, 0));
            masm.movzwl(elem2, new AMD64Address(str2, index, scale, 0));
        } else {
            masm.movzbl(elem1, new AMD64Address(str1, index, scale1, 0));
            masm.movzwl(elem2, new AMD64Address(str2, index, scale2, 0));
        }
    }
}

