/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

public abstract class AMD64ComplexVectorOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64ComplexVectorOp> TYPE = LIRInstructionClass.create(AMD64ComplexVectorOp.class);
    protected final AVXKind.AVXSize vectorSize;
    protected final TargetDescription targetDescription;

    public AMD64ComplexVectorOp(LIRInstructionClass<? extends AMD64ComplexVectorOp> c, LIRGeneratorTool tool, AVXKind.AVXSize maxUsedVectorSize) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)c);
        this.targetDescription = tool.target();
        AVXKind.AVXSize maxSupportedVectorSize = (AVXKind.AVXSize)tool.getMaxVectorSize();
        assert (AMD64ComplexVectorOp.isXMMOrGreater(maxUsedVectorSize) && AMD64ComplexVectorOp.isXMMOrGreater(maxSupportedVectorSize));
        this.vectorSize = maxUsedVectorSize.fitsWithin(maxSupportedVectorSize) ? maxUsedVectorSize : maxSupportedVectorSize;
    }

    private static boolean isXMMOrGreater(AVXKind.AVXSize size) {
        return size == AVXKind.AVXSize.XMM || size == AVXKind.AVXSize.YMM || size == AVXKind.AVXSize.ZMM;
    }

    protected AMD64Kind getVectorKind(JavaKind valueKind) {
        switch (this.vectorSize) {
            case XMM: {
                switch (valueKind) {
                    case Byte: {
                        return AMD64Kind.V128_BYTE;
                    }
                    case Char: {
                        return AMD64Kind.V128_WORD;
                    }
                    case Int: {
                        return AMD64Kind.V128_DWORD;
                    }
                    case Long: {
                        return AMD64Kind.V128_QWORD;
                    }
                    case Float: {
                        return AMD64Kind.V128_SINGLE;
                    }
                    case Double: {
                        return AMD64Kind.V128_DOUBLE;
                    }
                }
                throw GraalError.shouldNotReachHere("Unsupported base value kind.");
            }
            case YMM: {
                switch (valueKind) {
                    case Byte: {
                        return AMD64Kind.V256_BYTE;
                    }
                    case Char: {
                        return AMD64Kind.V256_WORD;
                    }
                    case Int: {
                        return AMD64Kind.V256_DWORD;
                    }
                    case Long: {
                        return AMD64Kind.V256_QWORD;
                    }
                    case Float: {
                        return AMD64Kind.V256_SINGLE;
                    }
                    case Double: {
                        return AMD64Kind.V256_DOUBLE;
                    }
                }
                throw GraalError.shouldNotReachHere("Unsupported base value kind.");
            }
            case ZMM: {
                switch (valueKind) {
                    case Byte: {
                        return AMD64Kind.V512_BYTE;
                    }
                    case Char: {
                        return AMD64Kind.V512_WORD;
                    }
                    case Int: {
                        return AMD64Kind.V512_DWORD;
                    }
                    case Long: {
                        return AMD64Kind.V512_QWORD;
                    }
                    case Float: {
                        return AMD64Kind.V512_SINGLE;
                    }
                    case Double: {
                        return AMD64Kind.V512_DOUBLE;
                    }
                }
                throw GraalError.shouldNotReachHere("Unsupported base value kind.");
            }
        }
        throw GraalError.shouldNotReachHere("Unsupported vector size.");
    }

    public static boolean supports(TargetDescription target, AMD64.CPUFeature cpuFeature) {
        return ((AMD64)target.arch).getFeatures().contains(cpuFeature);
    }

    public static boolean supportsAVX512VLBW(TargetDescription target) {
        return AMD64ComplexVectorOp.supports(target, AMD64.CPUFeature.AVX512VL) && AMD64ComplexVectorOp.supports(target, AMD64.CPUFeature.AVX512BW);
    }

    protected boolean supportsAVX2AndYMM() {
        return AVXKind.AVXSize.YMM.fitsWithin(this.vectorSize) && AMD64ComplexVectorOp.supports(this.targetDescription, AMD64.CPUFeature.AVX2);
    }

    protected boolean supportsAVX512VLBWAndZMM() {
        return AVXKind.AVXSize.ZMM.fitsWithin(this.vectorSize) && AMD64ComplexVectorOp.supportsAVX512VLBW(this.targetDescription);
    }

    protected boolean supportsBMI2() {
        return AMD64ComplexVectorOp.supports(this.targetDescription, AMD64.CPUFeature.BMI2);
    }

    @Override
    public boolean needsClearUpperVectorRegisters() {
        return true;
    }
}

