/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64ComplexVectorOp;
import org.graalvm.compiler.lir.amd64.AMD64Move;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@Opcode(value="AMD64_HAS_NEGATIVES")
public final class AMD64HasNegativesOp
extends AMD64ComplexVectorOp {
    public static final LIRInstructionClass<AMD64HasNegativesOp> TYPE = LIRInstructionClass.create(AMD64HasNegativesOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    private Value resultValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value originArrayValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.CONST})
    private Value originLengthValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value arrayValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value lenValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value tmpValue1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value vecValue1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value vecValue2;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value maskValue1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value maskValue2;

    public AMD64HasNegativesOp(LIRGeneratorTool tool, Value result, Value array, Value length) {
        super(TYPE, tool, AMD64HasNegativesOp.supportsAVX512VLBW(tool.target()) && AMD64HasNegativesOp.supports(tool.target(), AMD64.CPUFeature.BMI2) ? AVXKind.AVXSize.ZMM : AVXKind.AVXSize.YMM);
        this.resultValue = result;
        this.originArrayValue = array;
        this.originLengthValue = length;
        this.arrayValue = tool.newVariable(array.getValueKind());
        this.lenValue = tool.newVariable(length.getValueKind());
        this.tmpValue1 = tool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
        LIRKind lirKind = LIRKind.value((PlatformKind)this.getVectorKind(JavaKind.Byte));
        this.vecValue1 = tool.newVariable(lirKind);
        this.vecValue2 = tool.newVariable(lirKind);
        if (AVXKind.AVXSize.ZMM.fitsWithin(this.vectorSize)) {
            this.maskValue1 = tool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.MASK64));
            this.maskValue2 = tool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.MASK64));
        } else {
            this.maskValue1 = Value.ILLEGAL;
            this.maskValue2 = Value.ILLEGAL;
        }
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Label labelTrue = new Label();
        Label labelFalse = new Label();
        Label labelDone = new Label();
        Label labelCompareChar = new Label();
        Label labelCompareVectors = new Label();
        Label labelCompareByte = new Label();
        AMD64Move.move(crb, masm, this.arrayValue, this.originArrayValue);
        AMD64Move.move(crb, masm, this.lenValue, this.originLengthValue);
        Register ary1 = ValueUtil.asRegister((Value)this.arrayValue);
        Register len = ValueUtil.asRegister((Value)this.lenValue);
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register tmp1 = ValueUtil.asRegister((Value)this.tmpValue1);
        Register vec1 = ValueUtil.asRegister((Value)this.vecValue1);
        Register vec2 = ValueUtil.asRegister((Value)this.vecValue2);
        masm.testlAndJcc(len, len, AMD64Assembler.ConditionFlag.Zero, labelFalse, false);
        if (this.supportsAVX512VLBWAndZMM() && AMD64HasNegativesOp.supports(crb.target, AMD64.CPUFeature.BMI2)) {
            Label labelTest64Loop = new Label();
            Label labelTestTail = new Label();
            Register tmp3Aliased = len;
            Register mask1 = ValueUtil.asRegister((Value)this.maskValue1);
            Register mask2 = ValueUtil.asRegister((Value)this.maskValue2);
            masm.movl(tmp1, len);
            masm.emit(AMD64Assembler.VexRVMOp.VPXOR, vec2, vec2, vec2, AVXKind.AVXSize.ZMM);
            masm.andl(tmp1, 63);
            masm.andlAndJcc(len, -64, AMD64Assembler.ConditionFlag.Zero, labelTestTail, true);
            masm.leaq(ary1, new AMD64Address(ary1, len, AMD64Address.Scale.Times1));
            masm.negq(len);
            masm.bind(labelTest64Loop);
            masm.evpcmpgtb(mask1, vec2, new AMD64Address(ary1, len, AMD64Address.Scale.Times1));
            masm.kortestq(mask1, mask1);
            masm.jcc(AMD64Assembler.ConditionFlag.NotZero, labelTrue);
            masm.addqAndJcc(len, 64, AMD64Assembler.ConditionFlag.NotZero, labelTest64Loop, true);
            masm.bind(labelTestTail);
            masm.testlAndJcc(tmp1, -1, AMD64Assembler.ConditionFlag.Zero, labelFalse, false);
            masm.movq(tmp3Aliased, -1L);
            masm.emit(AMD64Assembler.VexGeneralPurposeRMVOp.SHLX, tmp3Aliased, tmp3Aliased, tmp1, AVXKind.AVXSize.QWORD);
            masm.notq(tmp3Aliased);
            masm.kmovq(mask2, tmp3Aliased);
            masm.evpcmpgtb(mask1, mask2, vec2, new AMD64Address(ary1, 0));
            masm.ktestq(mask1, mask2);
            masm.jcc(AMD64Assembler.ConditionFlag.NotZero, labelTrue);
            masm.jmp(labelFalse);
        } else {
            masm.movl(result, len);
            if (this.supportsAVX2AndYMM()) {
                Label labelCompareWideVectors = new Label();
                Label labelCompareTail = new Label();
                masm.andl(result, 31);
                masm.andlAndJcc(len, -32, AMD64Assembler.ConditionFlag.Zero, labelCompareTail, true);
                masm.leaq(ary1, new AMD64Address(ary1, len, AMD64Address.Scale.Times1));
                masm.negq(len);
                masm.movl(tmp1, -2139062144);
                masm.movdl(vec2, tmp1);
                masm.emit(AMD64Assembler.VexRMOp.VPBROADCASTD, vec2, vec2, AVXKind.AVXSize.YMM);
                masm.bind(labelCompareWideVectors);
                masm.vmovdqu(vec1, new AMD64Address(ary1, len, AMD64Address.Scale.Times1));
                masm.vptest(vec1, vec2);
                masm.jcc(AMD64Assembler.ConditionFlag.NotZero, labelTrue);
                masm.addqAndJcc(len, 32, AMD64Assembler.ConditionFlag.NotZero, labelCompareWideVectors, false);
                masm.testlAndJcc(result, result, AMD64Assembler.ConditionFlag.Zero, labelFalse, false);
                masm.vmovdqu(vec1, new AMD64Address(ary1, result, AMD64Address.Scale.Times1, -32));
                masm.vptest(vec1, vec2);
                masm.jccb(AMD64Assembler.ConditionFlag.NotZero, labelTrue);
                masm.jmp(labelFalse);
                masm.bind(labelCompareTail);
                masm.movl(len, result);
            } else if (masm.supports(AMD64.CPUFeature.SSE4_2)) {
                Label labelCompareWideVectors = new Label();
                Label labelCompareTail = new Label();
                masm.andl(result, 15);
                masm.andlAndJcc(len, -16, AMD64Assembler.ConditionFlag.Zero, labelCompareTail, false);
                masm.leaq(ary1, new AMD64Address(ary1, len, AMD64Address.Scale.Times1));
                masm.negq(len);
                masm.movl(tmp1, -2139062144);
                masm.movdl(vec2, tmp1);
                masm.pshufd(vec2, vec2, 0);
                masm.bind(labelCompareWideVectors);
                masm.movdqu(vec1, new AMD64Address(ary1, len, AMD64Address.Scale.Times1));
                masm.ptest(vec1, vec2);
                masm.jcc(AMD64Assembler.ConditionFlag.NotZero, labelTrue);
                masm.addqAndJcc(len, 16, AMD64Assembler.ConditionFlag.NotZero, labelCompareWideVectors, false);
                masm.testlAndJcc(result, result, AMD64Assembler.ConditionFlag.Zero, labelFalse, false);
                masm.movdqu(vec1, new AMD64Address(ary1, result, AMD64Address.Scale.Times1, -16));
                masm.ptest(vec1, vec2);
                masm.jccb(AMD64Assembler.ConditionFlag.NotZero, labelTrue);
                masm.jmp(labelFalse);
                masm.bind(labelCompareTail);
                masm.movl(len, result);
            }
        }
        masm.andlAndJcc(len, -4, AMD64Assembler.ConditionFlag.Zero, labelCompareChar, true);
        masm.leaq(ary1, new AMD64Address(ary1, len, AMD64Address.Scale.Times1));
        masm.negq(len);
        masm.bind(labelCompareVectors);
        masm.movl(tmp1, new AMD64Address(ary1, len, AMD64Address.Scale.Times1));
        masm.andlAndJcc(tmp1, -2139062144, AMD64Assembler.ConditionFlag.NotZero, labelTrue, true);
        masm.addqAndJcc(len, 4, AMD64Assembler.ConditionFlag.NotZero, labelCompareVectors, false);
        masm.bind(labelCompareChar);
        masm.testlAndJcc(result, 2, AMD64Assembler.ConditionFlag.Zero, labelCompareByte, true);
        masm.movzwl(tmp1, new AMD64Address(ary1, 0));
        masm.andlAndJcc(tmp1, 32896, AMD64Assembler.ConditionFlag.NotZero, labelTrue, true);
        masm.subq(result, 2);
        masm.leaq(ary1, new AMD64Address(ary1, 2));
        masm.bind(labelCompareByte);
        masm.testlAndJcc(result, 1, AMD64Assembler.ConditionFlag.Zero, labelFalse, true);
        masm.movzbl(tmp1, new AMD64Address(ary1, 0));
        masm.andlAndJcc(tmp1, 128, AMD64Assembler.ConditionFlag.NotEqual, labelTrue, true);
        masm.jmpb(labelFalse);
        masm.bind(labelTrue);
        masm.movl(result, 1);
        masm.jmpb(labelDone);
        masm.bind(labelFalse);
        masm.xorl(result, result);
        masm.bind(labelDone);
    }
}

