/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.StubPort;
import org.graalvm.compiler.lir.amd64.AMD64HotSpotHelper;
import org.graalvm.compiler.lir.amd64.AMD64MathIntrinsicUnaryOp;
import org.graalvm.compiler.lir.asm.ArrayDataPointerConstant;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@StubPort(path="src/hotspot/cpu/x86/macroAssembler_x86_tan.cpp", lineStart=0, lineEnd=1059, commit="e58c12e61828485bfffbc9d1b865302b93a94158", sha1="1f1f3a6d2437b250c0d5b13e596d9ed5a14c869e")
public final class AMD64MathTanOp
extends AMD64MathIntrinsicUnaryOp {
    public static final LIRInstructionClass<AMD64MathTanOp> TYPE = LIRInstructionClass.create(AMD64MathTanOp.class);
    private ArrayDataPointerConstant onehalf = AMD64HotSpotHelper.pointerConstant(16, new int[]{0, 1071644672, 0, 1071644672});
    private ArrayDataPointerConstant mul16 = AMD64HotSpotHelper.pointerConstant(16, new int[]{0, 0x40300000, 0, 0x3FF00000});
    private ArrayDataPointerConstant signMask = AMD64HotSpotHelper.pointerConstant(16, new int[]{0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE});
    private ArrayDataPointerConstant pi32Inv = AMD64HotSpotHelper.pointerConstant(16, new int[]{1841940611, 1071931184, 1841940611, 1076125488});
    private ArrayDataPointerConstant p1 = AMD64HotSpotHelper.pointerConstant(16, new int[]{0x54444000, 1069097467, 0x54440000, 1069097467});
    private ArrayDataPointerConstant p2 = AMD64HotSpotHelper.pointerConstant(16, new int[]{1734819840, -1120737351, 0x4C4C0000, 1028033571});
    private ArrayDataPointerConstant p3 = AMD64HotSpotHelper.pointerConstant(16, new int[]{923219018, 984130272, 57701189, 988383790});
    private ArrayDataPointerConstant ctable = AMD64HotSpotHelper.pointerConstant(16, new int[]{0, 0, 0, 0, -2010377990, 1066820852, 0, 0, 0, 0, 0, 0, 1441186365, 1065494243, 0x55555555, 1070945621, 0, 0, 0, 0, 236289504, 1064135997, 0x11111111, 1069617425, 0, 0, 0, 0, 1160476131, 1062722102, 463583772, 1068212666, 0, 0, 0, 0, 0, 0x3FF00000, 0, 0, 0, 0, 0, 0, 1313038235, 1066745731, 0, 0, 1013878342, 1067152618, 0, 0, -631540463, 1065725283, -601683045, 1069118808, 650852232, 1065882376, 1996245381, 1071000265, 2008746170, 1064664197, -1239124703, 1068578846, 1495406348, 1064652437, -2025437139, 1069711235, 285563696, 1063576465, 1046897440, 1067705865, 233429731, 1063453151, 522045958, 1068476590, -1940181598, 1069102779, 1317599141, 1012432133, 0, 0x3FF00000, -1466737191, 1065606626, 0, 0, 0, 0, 1512545955, 1068119047, 0, 0, 1127048698, 1067909459, 0, 0, -1994766846, 1067254767, -701717000, 1070233561, -1285601752, 1066902117, 1127373050, 1071173457, -1248863991, 1066371299, 24583402, 1069723988, -212455538, 1065914199, -1071077597, 1070020367, 548927984, 1065415756, 558065897, 1068949418, 680073315, 1064940726, 388873200, 1068944270, -531287720, 1070167541, 1497360404, 1009710547, 0, 0x3FF00000, 64931152, 1067729411, 0, 0, 0, 0, -1827384514, 1069256389, 0, 0, 162150096, 1068946420, 0, 0, -592173059, 1068579152, -663048005, 1070936926, -838145883, 1068217218, 2031366438, 1071495745, 1596664020, 1067799281, 1509038701, 1070601643, 583171477, 1067510148, -509622614, 1070618476, -1892931248, 1067075736, -1061948884, 1069913186, 411280568, 1066710556, 1065584192, 1069747896, 895247324, 1070819848, 500078909, -1133678515, 0, 0x3FF00000, 729983843, 1068994194, 0, 0, 0, 0, 1458794562, 1070398550, 0, 0, -1437189807, 1070137637, 0, 0, 1024359517, 1069876531, -1678927058, 1071582937, 1609024636, 1069675088, -1765726747, 1071836633, 1510128600, 1069440113, -2043270112, 1071253687, 1262761453, 1069142850, 1263091857, 1071190461, -1251583810, 1068885191, -1818034826, 1070842002, -634972268, 1068669200, 855891755, 1070696894, -1711476942, 1071284857, -1232333721, 1014008623, 0, 0x3FF00000, -1744026825, 1069938201, 0, 0, 0, 0, -872159999, 1071640847, 0, 0, 1151658053, 1071494715, 0, 0, 929607071, 1071346340, 1037049034, 1072037305, -1508038639, 1071215282, 1447406859, 1072265209, -804015189, 1071090851, -1089734380, 1071968658, 1297344304, 1070977120, 1066110976, 1071946035, -491245816, 1070871082, 1496754229, 1071807201, -1312416613, 1070773243, -280525307, 1071736222, 419968236, 1071717047, -843700758, -1131522485, 0, 0x3FF00000, -1334700061, 1070745841, 0, 0, 0, 0, 724322768, 1072881308, 0, 0, 643153048, 1072905816, 0, 0, -9887838, 1072928558, -382442563, 1072622983, 118362272, 1072952754, -187199324, 1072827408, -1605464413, 1072976922, 946523347, 1072772766, 573204189, 1073001761, 581531518, 1072826391, 1386236526, 1073026959, -576061391, 1072832823, 1145558140, 1073052673, 513572637, 1072861969, 716700048, 1071997368, 547126769, 1015523525, 0, 0x3FF00000, 1097907398, 1071420120, 0, 0, 0, 0, -945074854, 1074290212, 0, 0, -381769891, 1074501181, 0, 0, -1800932774, 1074739170, 1264738763, 1073084804, 1520293906, 1074899632, 1958936600, 1073411493, 2133649635, 1075052171, -24226566, 1073574708, 1728930189, 1075224844, 1303998552, 1073799186, 618611933, 1075420255, 1769828046, 1073938542, -2094429310, 1075641421, 433361110, 1074105369, 719595600, 1072317184, 294527206, -1132827208, 0, 0x40000000, -483179080, -1076566746, 0, 0, 0, 0, 0x65965966, 1075943001, 0, 0, -2010377990, 1076258036, 0, 0, -2083703005, 1076659010, 0, 0x40000000, 1441186365, 1077028579, 0x55555555, 0x40055555, 876943673, 1077353622, -1431655765, 0x400AAAAA, 236289504, 1077767485, 0x11111111, 0x40111111, -1489493985, 1078115278, 95443718, 1075163227, 1160476131, 1078450742, 463583772, 1075552698, 0, 0x3FF00000, 0, 0, 0, 0x40000000, 0, 0, 0, 0, 0, 0, 1330165971, -1087116551, 0, 0, 217536623, 1059109098, 0, 0, -802846447, -1089815821, 602185705, -1079289204, 760422958, 1056312597, 555127889, 1067545266, -1155183172, -1092496459, -604423282, -1081817125, 95707915, 1053635428, -291852889, 1064581412, 2034926231, -1095256135, -535431273, -1084407307, -468039082, 1050893819, -457006511, 1061790379, 1526325248, -1076999730, -1938540775, 1025423456, 0, 0, 457728975, 1071088276, 0, 0x3FF00000, 0, -8, 1398462608, -1087663328, 0, 0, 26205983, 1058461213, 0, 0, 56226238, -1090438684, -1540260755, -1079607785, -2107167473, 1055634437, 790323742, 1067402587, 1372385848, -1093315817, -197674580, -1082110994, -946756939, 1052830099, -1852170830, 1064337602, 862608142, -1096136542, 170296152, -1084906429, -539395868, 1049933343, -680101288, 1061361670, 719978496, -1077298200, 1998842465, -1120263319, 0, 0, -545810689, 1071048258, 0, 0x3FF00000, 0, -8, -1174468658, -1088217992, 0, 0, -1521389182, 1058009312, 0, 0, 2030783676, -1091149423, -2071312698, -1079895360, -1318832646, 1054987244, 706390066, 1067217386, -36529681, -1094066918, 1066252975, -1082576029, 815777514, 1051989462, -1092221839, 1064010682, -1801410921, -1096962543, 1046243251, -1085288325, -1701888450, 1049017717, -1531005020, 1060970161, 701480960, -1077589554, -1089105064, -1120306381, 0, 0, -2027950484, 1071015664, 0, 0x3FF00000, 0, -8, 2107155798, -1088800424, 0, 0, -1651975167, 1057424578, 0, 0, 1936992811, -1091762870, 1485063559, -1080284653, 1432914553, 1054319398, -298585642, 1067075828, -1461938040, -1094743751, -1428900424, -1082984634, -1862078559, 1051234178, -625202737, 1063748136, -1836470344, -1097796522, 1948234989, -1085869149, -1451268509, 1048163519, -896925889, 1060559728, -1465737216, -1077875181, 1034046433, -1120695393, 0, 0, 298675305, 1070989821, 0, 0x3FF00000, 0, -8, 437603223, -1089377535, 0, 0, 759330352, 1057048511, 0, 0, -1187503928, -1092459308, -1150502120, -1080775796, -2004005486, 1053841035, 1618153340, 1066971547, -458097903, -1095567024, 584032116, -1083498035, 1245704358, 1050626462, -47479858, 1063561943, 1669034927, -1098692484, -450733798, -1086340974, -1588008772, 1047411374, -437768198, 1060281647, -701063168, -1078376577, -1027419460, -1122803975, 0, 0, -218255069, 1070970214, 0, 0x3FF00000, 0, -8, -1004876956, -1090173811, 0, 0, -609206929, 1056668370, 0, 0, -1639803347, -1093292379, 628750575, -1081400424, 680140505, 1053299777, -1340502587, 1066900026, 803201619, -1096450861, 1466315631, -1084130134, 1611220163, 1049972438, -1528780040, 1063437894, 1804579484, -1099635805, -598998007, -1087112878, -1677728923, 1046675948, -1199137212, 1060095334, -505397248, -1078932382, 23826559, -1122919236, 0, 0, -424027910, 1070956467, 0, 0x3FF00000, 0, -8, 1571758758, -1091294761, 0, 0, 113026373, 1056416381, 0, 0, 1913766298, -1094443970, -1787898562, -1082465292, -294318478, 1053003803, -1848359947, 1066858259, 912662124, -1097634295, 1349489537, -1085201688, -881994689, 1049641401, 1721283327, 1063366855, 1466691883, -1100850550, -442439204, -1088206435, 285443293, 1046158380, 1758739894, 1059895449, 1858781184, -1079983084, -847391348, 1024675855, 0, 0, -2052929285, 1070948320, 0, 0x3FF00000, 0, -8, 0, 0, 0, 0, 737611454, 1056336527, 0, 0, 0, 0, 0, 0, -700176769, 1052911621, 381774871, 1066844524, 0, 0, 0, 0, -991915678, 1049456050, -1140779673, 1063343722, 0, 0, 0, 0, 528061788, 1045944910, -1825247477, 1059831159, 0, 0, 0, 0, 0, 0, 0x55555555, 1070945621, 0, 0x3FF00000, 0, -8, 1571758758, 1056188887, 0, 0, 113026373, 1056416381, 0, 0, 1913766298, 1053039678, -1787898562, 1065018356, -294318478, 1053003803, -1848359947, 1066858259, 912662124, 1049849353, 1349489537, 1062281960, -881994689, 1049641401, 1721283327, 1063366855, 1466691883, 1046633098, -442439204, 1059277213, 285443293, 1046158380, 1758739894, 1059895449, 1858781184, 1067500564, -847391348, -1122807793, 0, 0, -2052929285, 1070948320, 0, 0x3FF00000, 0, -8, -1004876956, 1057309837, 0, 0, -609206929, 1056668370, 0, 0, -1639803347, 1054191269, 628750575, 1066083224, 680140505, 1053299777, -1340502587, 1066900026, 803201619, 1051032787, 1466315631, 1063353514, 1611220163, 1049972438, -1528780040, 1063437894, 1804579484, 1047847843, -598998007, 1060370770, -1677728923, 1046675948, -1199137212, 1060095334, -505397248, 1068551266, 23826559, 1024564412, 0, 0, -424027910, 1070956467, 0, 0x3FF00000, 0, -8, 437603223, 1058106113, 0, 0, 759330352, 1057048511, 0, 0, -1187503928, 1055024340, -1150502120, 1066707852, -2004005486, 1053841035, 1618153340, 1066971547, -458097903, 1051916624, 584032116, 1063985613, 1245704358, 1050626462, -47479858, 1063561943, 1669034927, 1048791164, -450733798, 1061142674, -1588008772, 1047411374, -437768198, 1060281647, -701063168, 1069107071, -1027419460, 1024679673, 0, 0, -218255069, 1070970214, 0, 0x3FF00000, 0, -8, 2107155798, 1058683224, 0, 0, -1651975167, 1057424578, 0, 0, 1936992811, 1055720778, 1485063559, 1067198995, 1432914553, 1054319398, -298585642, 1067075828, -1461938040, 1052739897, -1428900424, 1064499014, -1862078559, 1051234178, -625202737, 1063748136, -1836470344, 1049687126, 1948234989, 1061614499, -1451268509, 1048163519, -896925889, 1060559728, -1465737216, 1069608467, 1034046433, 1026788255, 0, 0, 298675305, 1070989821, 0, 0x3FF00000, 0, -8, -1174468658, 1059265656, 0, 0, -1521389182, 1058009312, 0, 0, 2030783676, 1056334225, -2071312698, 1067588288, -1318832646, 1054987244, 706390066, 1067217386, -36529681, 1053416730, 1066252975, 1064907619, 815777514, 1051989462, -1092221839, 1064010682, -1801410921, 1050521105, 1046243251, 1062195323, -1701888450, 1049017717, -1531005020, 1060970161, 701480960, 1069894094, -1089105064, 1027177267, 0, 0, -2027950484, 1071015664, 0, 0x3FF00000, 0, -8, 1398462608, 1059820320, 0, 0, 26205983, 1058461213, 0, 0, 56226238, 1057044964, -1540260755, 1067875863, -2107167473, 1055634437, 790323742, 1067402587, 1372385848, 1054167831, -197674580, 1065372654, -946756939, 1052830099, -1852170830, 1064337602, 862608142, 1051347106, 170296152, 1062577219, -539395868, 1049933343, -680101288, 1061361670, 719978496, 1070185448, 1998842465, 1027220329, 0, 0, -545810689, 1071048258, 0, 0x3FF00000, 0, -8, 1330165971, 1060367097, 0, 0, 217536623, 1059109098, 0, 0, -802846447, 1057667827, 602185705, 1068194444, 760422958, 1056312597, 555127889, 1067545266, -1155183172, 1054987189, -604423282, 1065666523, 95707915, 1053635428, -291852889, 1064581412, 2034926231, 1052227513, -535431273, 1063076341, -468039082, 1050893819, -457006511, 1061790379, 1526325248, 1070483918, -1938540775, -1122060192, 0, 0, 457728975, 1071088276, 0, 0x3FF00000, 0, -8, 0x65965966, -1071540647, 0, 0, -2010377990, 1076258036, 0, 0, -2083703005, -1070824638, 0, -1073741824, 1441186365, 1077028579, 0x55555555, 0x40055555, 876943673, -1070130026, -1431655765, -1073042774, 236289504, 1077767485, 0x11111111, 0x40111111, -1489493985, -1069368370, 95443718, -1072320421, 1160476131, 1078450742, 463583772, 1075552698, 0, -1074790400, 0, 0, 0, 0x40000000, 0, 0, 0, 0, 0, 0, -945074854, -1073193436, 0, 0, -381769891, 1074501181, 0, 0, -1800932774, -1072744478, 1264738763, -1074398844, 1520293906, 1074899632, 1958936600, 1073411493, 2133649635, -1072431477, -24226566, -1073908940, 1728930189, 1075224844, 1303998552, 1073799186, 618611933, -1072063393, 1769828046, -1073545106, -2094429310, 1075641421, 433361110, 1074105369, 719595600, -1075166464, 294527206, 1014656440, 0, 0x40000000, -483179080, -1076566746, 0, 0, 0, 0, 724322768, -1074602340, 0, 0, 643153048, 1072905816, 0, 0, -9887838, -1074555090, -382442563, -1074860665, 118362272, 1072952754, -187199324, 1072827408, -1605464413, -1074506726, 946523347, -1074710882, 573204189, 1073001761, 581531518, 1072826391, 1386236526, -1074456689, -576061391, -1074650825, 1145558140, 1073052673, 513572637, 1072861969, 716700048, -1075486280, 547126769, -1131960123, 0, 0x3FF00000, 1097907398, 1071420120, 0, 0, 0, 0, -872159999, -1075842801, 0, 0, 1151658053, 1071494715, 0, 0, 929607071, -1076137308, 1037049034, -1075446343, -1508038639, 1071215282, 1447406859, 1072265209, -804015189, -1076392797, -1089734380, -1075514990, 1297344304, 1070977120, 1066110976, 1071946035, -491245816, -1076612566, 1496754229, -1075676447, -1312416613, 1070773243, -280525307, 1071736222, 419968236, -1075766601, -843700758, 1015961163, 0, 0x3FF00000, -1334700061, 1070745841, 0, 0, 0, 0, 1458794562, -1077085098, 0, 0, -1437189807, 1070137637, 0, 0, 1024359517, -1077607117, -1678927058, -1075900711, 1609024636, 1069675088, -1765726747, 1071836633, 1510128600, -1078043535, -2043270112, -1076229961, 1262761453, 1069142850, 1263091857, 1071190461, -1251583810, -1078598457, -1818034826, -1076641646, -634972268, 1068669200, 855891755, 1070696894, -1711476942, -1076198791, -1232333721, -1133475025, 0, 0x3FF00000, -1744026825, 1069938201, 0, 0, 0, 0, -1827384514, -1078227259, 0, 0, 162150096, 1068946420, 0, 0, -592173059, -1078904496, -663048005, -1076546722, -838145883, 1068217218, 2031366438, 1071495745, 1596664020, -1079684367, 1509038701, -1076882005, 583171477, 1067510148, -509622614, 1070618476, -1892931248, -1080407912, -1061948884, -1077570462, 411280568, 1066710556, 1065584192, 1069747896, 895247324, -1076663800, 500078909, 1013805133, 0, 0x3FF00000, 729983843, 1068994194, 0, 0, 0, 0, 1512545955, -1079364601, 0, 0, 1127048698, 1067909459, 0, 0, -1994766846, -1080228881, -701717000, -1077250087, -1285601752, 1066902117, 1127373050, 1071173457, -1248863991, -1081112349, 24583402, -1077759660, -212455538, 1065914199, -1071077597, 1070020367, 548927984, -1082067892, 558065897, -1078534230, 680073315, 1064940726, 388873200, 1068944270, -531287720, -1077316107, 1497360404, -1137773101, 0, 0x3FF00000, 64931152, 1067729411, 0, 0, 0, 0, 1313038235, -1080737917, 0, 0, 1013878342, 1067152618, 0, 0, -631540463, -1081758365, -601683045, -1078364840, 650852232, 1065882376, 1996245381, 1071000265, 2008746170, -1082819451, -1239124703, -1078904802, 1495406348, 1064652437, -2025437139, 1069711235, 285563696, -1083907183, 1046897440, -1079777783, 233429731, 1063453151, 522045958, 1068476590, -1940181598, -1078380869, 1317599141, -1135051515, 0, 0x3FF00000, -1466737191, 1065606626, 0, 0, 0, 0});
    private ArrayDataPointerConstant mask35 = AMD64HotSpotHelper.pointerConstant(16, new int[]{-262144, -1, 0, 0});
    private ArrayDataPointerConstant q11 = AMD64HotSpotHelper.pointerConstant(16, new int[]{-1191293577, 1065509018});
    private ArrayDataPointerConstant q9 = AMD64HotSpotHelper.pointerConstant(16, new int[]{-1081836989, 1066820768});
    private ArrayDataPointerConstant q7 = AMD64HotSpotHelper.pointerConstant(16, new int[]{1388628139, 1068212666});
    private ArrayDataPointerConstant q5 = AMD64HotSpotHelper.pointerConstant(16, new int[]{285812550, 1069617425});
    private ArrayDataPointerConstant q3 = AMD64HotSpotHelper.pointerConstant(16, new int[]{1431655954, 1070945621});
    private ArrayDataPointerConstant piInvTable = AMD64HotSpotHelper.pointerConstant(16, new int[]{0, 0, -1560706194, 1313084713, -64530479, -181084736, -614296167, 1011060801, -28220501, -558119583, -1222349254, 1112396512, 105459434, 164729372, -31593700, -1322670274, -394119691, 784024708, -375623642, -1268810175, 965858873, -2091697676, -1669046389, -1107744709, 536385535, -570058737, -282127989, 1510632735, 1832287951, 667617719, 1330003814, -1637881299, 1965537991, -337251973, 1023883767, -1974299926, 1811636145, 529358088, 1443049542, -59020373, -254821343});
    private ArrayDataPointerConstant pi4 = AMD64HotSpotHelper.pointerConstant(8, new int[]{0, 1072243195});
    private ArrayDataPointerConstant pi48 = AMD64HotSpotHelper.pointerConstant(8, new int[]{1175561766, 1048908043});
    private ArrayDataPointerConstant qq2 = AMD64HotSpotHelper.pointerConstant(8, new int[]{1734816687, 1026746297});
    private ArrayDataPointerConstant one = AMD64HotSpotHelper.pointerConstant(8, new int[]{0, 0x3FF00000});
    private ArrayDataPointerConstant twoPow55 = AMD64HotSpotHelper.pointerConstant(8, new int[]{0, 1130364928});
    private ArrayDataPointerConstant twoPowM55 = AMD64HotSpotHelper.pointerConstant(4, new int[]{0, 1015021568});
    private ArrayDataPointerConstant negZero = AMD64HotSpotHelper.pointerConstant(4, new int[]{0, Integer.MIN_VALUE});

    public AMD64MathTanOp() {
        super(TYPE, AMD64.rax, AMD64.rcx, AMD64.rdx, AMD64.rbx, AMD64.rsi, AMD64.rdi, AMD64.r8, AMD64.r9, AMD64.r10, AMD64.r11, AMD64.xmm1, AMD64.xmm2, AMD64.xmm3, AMD64.xmm4, AMD64.xmm5, AMD64.xmm6, AMD64.xmm7);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Label block0 = new Label();
        Label block1 = new Label();
        Label block2 = new Label();
        Label block3 = new Label();
        Label block4 = new Label();
        Label block5 = new Label();
        Label block6 = new Label();
        Label block7 = new Label();
        Label block8 = new Label();
        Label block9 = new Label();
        Label block10 = new Label();
        Label block11 = new Label();
        Label block12 = new Label();
        Label block13 = new Label();
        Label block14 = new Label();
        masm.push(AMD64.rbx);
        masm.subq(AMD64.rsp, 16);
        masm.movsd(new AMD64Address(AMD64.rsp, 8), AMD64.xmm0);
        masm.pextrw(AMD64.rax, AMD64.xmm0, 3);
        masm.andl(AMD64.rax, Short.MAX_VALUE);
        masm.subl(AMD64.rax, 16314);
        masm.cmplAndJcc(AMD64.rax, 270, AMD64Assembler.ConditionFlag.Above, block0, false);
        masm.movdqu(AMD64.xmm5, AMD64HotSpotHelper.recordExternalAddress(crb, this.onehalf));
        masm.movdqu(AMD64.xmm6, AMD64HotSpotHelper.recordExternalAddress(crb, this.mul16));
        masm.unpcklpd(AMD64.xmm0, AMD64.xmm0);
        masm.movdqu(AMD64.xmm4, AMD64HotSpotHelper.recordExternalAddress(crb, this.signMask));
        masm.andpd(AMD64.xmm4, AMD64.xmm0);
        masm.movdqu(AMD64.xmm1, AMD64HotSpotHelper.recordExternalAddress(crb, this.pi32Inv));
        masm.mulpd(AMD64.xmm1, AMD64.xmm0);
        masm.por(AMD64.xmm5, AMD64.xmm4);
        masm.addpd(AMD64.xmm1, AMD64.xmm5);
        masm.movdqu(AMD64.xmm7, AMD64.xmm1);
        masm.unpckhpd(AMD64.xmm7, AMD64.xmm7);
        masm.cvttsd2sil(AMD64.rdx, AMD64.xmm7);
        masm.cvttpd2dq(AMD64.xmm1, AMD64.xmm1);
        masm.cvtdq2pd(AMD64.xmm1, AMD64.xmm1);
        masm.mulpd(AMD64.xmm1, AMD64.xmm6);
        masm.movdqu(AMD64.xmm3, AMD64HotSpotHelper.recordExternalAddress(crb, this.p1));
        masm.movq(AMD64.xmm5, AMD64HotSpotHelper.recordExternalAddress(crb, this.qq2));
        masm.addq(AMD64.rdx, 469248);
        masm.movdqu(AMD64.xmm4, AMD64HotSpotHelper.recordExternalAddress(crb, this.p2));
        masm.mulpd(AMD64.xmm3, AMD64.xmm1);
        masm.andq(AMD64.rdx, 31);
        masm.mulsd(AMD64.xmm5, AMD64.xmm1);
        masm.movq(AMD64.rcx, AMD64.rdx);
        masm.mulpd(AMD64.xmm4, AMD64.xmm1);
        masm.shlq(AMD64.rcx, 1);
        masm.subpd(AMD64.xmm0, AMD64.xmm3);
        masm.mulpd(AMD64.xmm1, AMD64HotSpotHelper.recordExternalAddress(crb, this.p3));
        masm.addq(AMD64.rdx, AMD64.rcx);
        masm.shlq(AMD64.rcx, 2);
        masm.addq(AMD64.rdx, AMD64.rcx);
        masm.addsd(AMD64.xmm5, AMD64.xmm0);
        masm.movdqu(AMD64.xmm2, AMD64.xmm0);
        masm.subpd(AMD64.xmm0, AMD64.xmm4);
        masm.movq(AMD64.xmm6, AMD64HotSpotHelper.recordExternalAddress(crb, this.one));
        masm.shlq(AMD64.rdx, 4);
        masm.leaq(AMD64.rax, AMD64HotSpotHelper.recordExternalAddress(crb, this.ctable));
        masm.andpd(AMD64.xmm5, AMD64HotSpotHelper.recordExternalAddress(crb, this.mask35));
        masm.movdqu(AMD64.xmm3, AMD64.xmm0);
        masm.addq(AMD64.rax, AMD64.rdx);
        masm.subpd(AMD64.xmm2, AMD64.xmm0);
        masm.unpckhpd(AMD64.xmm0, AMD64.xmm0);
        masm.divsd(AMD64.xmm6, AMD64.xmm5);
        masm.subpd(AMD64.xmm2, AMD64.xmm4);
        masm.movdqu(AMD64.xmm7, new AMD64Address(AMD64.rax, 16));
        masm.subsd(AMD64.xmm3, AMD64.xmm5);
        masm.mulpd(AMD64.xmm7, AMD64.xmm0);
        masm.subpd(AMD64.xmm2, AMD64.xmm1);
        masm.movdqu(AMD64.xmm1, new AMD64Address(AMD64.rax, 48));
        masm.mulpd(AMD64.xmm1, AMD64.xmm0);
        masm.movdqu(AMD64.xmm4, new AMD64Address(AMD64.rax, 96));
        masm.mulpd(AMD64.xmm4, AMD64.xmm0);
        masm.addsd(AMD64.xmm2, AMD64.xmm3);
        masm.movdqu(AMD64.xmm3, AMD64.xmm0);
        masm.mulpd(AMD64.xmm0, AMD64.xmm0);
        masm.addpd(AMD64.xmm7, new AMD64Address(AMD64.rax, 0));
        masm.addpd(AMD64.xmm1, new AMD64Address(AMD64.rax, 32));
        masm.mulpd(AMD64.xmm1, AMD64.xmm0);
        masm.addpd(AMD64.xmm4, new AMD64Address(AMD64.rax, 80));
        masm.addpd(AMD64.xmm7, AMD64.xmm1);
        masm.movdqu(AMD64.xmm1, new AMD64Address(AMD64.rax, 112));
        masm.mulpd(AMD64.xmm1, AMD64.xmm0);
        masm.mulpd(AMD64.xmm0, AMD64.xmm0);
        masm.addpd(AMD64.xmm4, AMD64.xmm1);
        masm.movdqu(AMD64.xmm1, new AMD64Address(AMD64.rax, 64));
        masm.mulpd(AMD64.xmm1, AMD64.xmm0);
        masm.addpd(AMD64.xmm7, AMD64.xmm1);
        masm.movdqu(AMD64.xmm1, AMD64.xmm3);
        masm.mulpd(AMD64.xmm3, AMD64.xmm0);
        masm.mulsd(AMD64.xmm0, AMD64.xmm0);
        masm.mulpd(AMD64.xmm1, new AMD64Address(AMD64.rax, 144));
        masm.mulpd(AMD64.xmm4, AMD64.xmm3);
        masm.movdqu(AMD64.xmm3, AMD64.xmm1);
        masm.addpd(AMD64.xmm7, AMD64.xmm4);
        masm.movdqu(AMD64.xmm4, AMD64.xmm1);
        masm.mulsd(AMD64.xmm0, AMD64.xmm7);
        masm.unpckhpd(AMD64.xmm7, AMD64.xmm7);
        masm.addsd(AMD64.xmm0, AMD64.xmm7);
        masm.unpckhpd(AMD64.xmm1, AMD64.xmm1);
        masm.addsd(AMD64.xmm3, AMD64.xmm1);
        masm.subsd(AMD64.xmm4, AMD64.xmm3);
        masm.addsd(AMD64.xmm1, AMD64.xmm4);
        masm.movdqu(AMD64.xmm4, AMD64.xmm2);
        masm.movq(AMD64.xmm7, new AMD64Address(AMD64.rax, 144));
        masm.unpckhpd(AMD64.xmm2, AMD64.xmm2);
        masm.addsd(AMD64.xmm7, new AMD64Address(AMD64.rax, 152));
        masm.mulsd(AMD64.xmm7, AMD64.xmm2);
        masm.addsd(AMD64.xmm7, new AMD64Address(AMD64.rax, 136));
        masm.addsd(AMD64.xmm7, AMD64.xmm1);
        masm.addsd(AMD64.xmm0, AMD64.xmm7);
        masm.movq(AMD64.xmm7, AMD64HotSpotHelper.recordExternalAddress(crb, this.one));
        masm.mulsd(AMD64.xmm4, AMD64.xmm6);
        masm.movq(AMD64.xmm2, new AMD64Address(AMD64.rax, 168));
        masm.andpd(AMD64.xmm2, AMD64.xmm6);
        masm.mulsd(AMD64.xmm5, AMD64.xmm2);
        masm.mulsd(AMD64.xmm6, new AMD64Address(AMD64.rax, 160));
        masm.subsd(AMD64.xmm7, AMD64.xmm5);
        masm.subsd(AMD64.xmm2, new AMD64Address(AMD64.rax, 128));
        masm.subsd(AMD64.xmm7, AMD64.xmm4);
        masm.mulsd(AMD64.xmm7, AMD64.xmm6);
        masm.movdqu(AMD64.xmm4, AMD64.xmm3);
        masm.subsd(AMD64.xmm3, AMD64.xmm2);
        masm.addsd(AMD64.xmm2, AMD64.xmm3);
        masm.subsd(AMD64.xmm4, AMD64.xmm2);
        masm.addsd(AMD64.xmm0, AMD64.xmm4);
        masm.subsd(AMD64.xmm0, AMD64.xmm7);
        masm.addsd(AMD64.xmm0, AMD64.xmm3);
        masm.jmp(block14);
        masm.bind(block0);
        masm.jcc(AMD64Assembler.ConditionFlag.Greater, block1);
        masm.pextrw(AMD64.rax, AMD64.xmm0, 3);
        masm.movl(AMD64.rdx, AMD64.rax);
        masm.andlAndJcc(AMD64.rax, 32752, AMD64Assembler.ConditionFlag.Equal, block2, false);
        masm.andl(AMD64.rdx, Short.MAX_VALUE);
        masm.cmplAndJcc(AMD64.rdx, 15904, AMD64Assembler.ConditionFlag.Below, block3, false);
        masm.movdqu(AMD64.xmm2, AMD64.xmm0);
        masm.movdqu(AMD64.xmm3, AMD64.xmm0);
        masm.movq(AMD64.xmm1, AMD64HotSpotHelper.recordExternalAddress(crb, this.q11));
        masm.mulsd(AMD64.xmm2, AMD64.xmm0);
        masm.mulsd(AMD64.xmm3, AMD64.xmm2);
        masm.mulsd(AMD64.xmm1, AMD64.xmm2);
        masm.addsd(AMD64.xmm1, AMD64HotSpotHelper.recordExternalAddress(crb, this.q9));
        masm.mulsd(AMD64.xmm1, AMD64.xmm2);
        masm.addsd(AMD64.xmm1, AMD64HotSpotHelper.recordExternalAddress(crb, this.q7));
        masm.mulsd(AMD64.xmm1, AMD64.xmm2);
        masm.addsd(AMD64.xmm1, AMD64HotSpotHelper.recordExternalAddress(crb, this.q5));
        masm.mulsd(AMD64.xmm1, AMD64.xmm2);
        masm.addsd(AMD64.xmm1, AMD64HotSpotHelper.recordExternalAddress(crb, this.q3));
        masm.mulsd(AMD64.xmm1, AMD64.xmm3);
        masm.addsd(AMD64.xmm0, AMD64.xmm1);
        masm.jmp(block14);
        masm.bind(block3);
        masm.movq(AMD64.xmm3, AMD64HotSpotHelper.recordExternalAddress(crb, this.twoPow55));
        masm.mulsd(AMD64.xmm3, AMD64.xmm0);
        masm.addsd(AMD64.xmm0, AMD64.xmm3);
        masm.mulsd(AMD64.xmm0, AMD64HotSpotHelper.recordExternalAddress(crb, this.twoPowM55));
        masm.jmp(block14);
        masm.bind(block2);
        masm.movdqu(AMD64.xmm1, AMD64.xmm0);
        masm.mulsd(AMD64.xmm1, AMD64.xmm1);
        masm.jmp(block14);
        masm.bind(block1);
        masm.pextrw(AMD64.rax, AMD64.xmm0, 3);
        masm.andl(AMD64.rax, 32752);
        masm.cmplAndJcc(AMD64.rax, 32752, AMD64Assembler.ConditionFlag.Equal, block4, false);
        masm.pextrw(AMD64.rcx, AMD64.xmm0, 3);
        masm.andl(AMD64.rcx, 32752);
        masm.subl(AMD64.rcx, 16224);
        masm.shrl(AMD64.rcx, 7);
        masm.andl(AMD64.rcx, 65532);
        masm.leaq(AMD64.r11, AMD64HotSpotHelper.recordExternalAddress(crb, this.piInvTable));
        masm.addq(AMD64.rcx, AMD64.r11);
        masm.movdq(AMD64.rax, AMD64.xmm0);
        masm.movl(AMD64.r10, new AMD64Address(AMD64.rcx, 20));
        masm.movl(AMD64.r8, new AMD64Address(AMD64.rcx, 24));
        masm.movl(AMD64.rdx, AMD64.rax);
        masm.shrq(AMD64.rax, 21);
        masm.orl(AMD64.rax, Integer.MIN_VALUE);
        masm.shrl(AMD64.rax, 11);
        masm.movl(AMD64.r9, AMD64.r10);
        masm.imulq(AMD64.r10, AMD64.rdx);
        masm.imulq(AMD64.r9, AMD64.rax);
        masm.imulq(AMD64.r8, AMD64.rax);
        masm.movl(AMD64.rsi, new AMD64Address(AMD64.rcx, 16));
        masm.movl(AMD64.rdi, new AMD64Address(AMD64.rcx, 12));
        masm.movl(AMD64.r11, AMD64.r10);
        masm.shrq(AMD64.r10, 32);
        masm.addq(AMD64.r9, AMD64.r10);
        masm.addq(AMD64.r11, AMD64.r8);
        masm.movl(AMD64.r8, AMD64.r11);
        masm.shrq(AMD64.r11, 32);
        masm.addq(AMD64.r9, AMD64.r11);
        masm.movl(AMD64.r10, AMD64.rsi);
        masm.imulq(AMD64.rsi, AMD64.rdx);
        masm.imulq(AMD64.r10, AMD64.rax);
        masm.movl(AMD64.r11, AMD64.rdi);
        masm.imulq(AMD64.rdi, AMD64.rdx);
        masm.movl(AMD64.rbx, AMD64.rsi);
        masm.shrq(AMD64.rsi, 32);
        masm.addq(AMD64.r9, AMD64.rbx);
        masm.movl(AMD64.rbx, AMD64.r9);
        masm.shrq(AMD64.r9, 32);
        masm.addq(AMD64.r10, AMD64.rsi);
        masm.addq(AMD64.r10, AMD64.r9);
        masm.shlq(AMD64.rbx, 32);
        masm.orq(AMD64.r8, AMD64.rbx);
        masm.imulq(AMD64.r11, AMD64.rax);
        masm.movl(AMD64.r9, new AMD64Address(AMD64.rcx, 8));
        masm.movl(AMD64.rsi, new AMD64Address(AMD64.rcx, 4));
        masm.movl(AMD64.rbx, AMD64.rdi);
        masm.shrq(AMD64.rdi, 32);
        masm.addq(AMD64.r10, AMD64.rbx);
        masm.movl(AMD64.rbx, AMD64.r10);
        masm.shrq(AMD64.r10, 32);
        masm.addq(AMD64.r11, AMD64.rdi);
        masm.addq(AMD64.r11, AMD64.r10);
        masm.movq(AMD64.rdi, AMD64.r9);
        masm.imulq(AMD64.r9, AMD64.rdx);
        masm.imulq(AMD64.rdi, AMD64.rax);
        masm.movl(AMD64.r10, AMD64.r9);
        masm.shrq(AMD64.r9, 32);
        masm.addq(AMD64.r11, AMD64.r10);
        masm.movl(AMD64.r10, AMD64.r11);
        masm.shrq(AMD64.r11, 32);
        masm.addq(AMD64.rdi, AMD64.r9);
        masm.addq(AMD64.rdi, AMD64.r11);
        masm.movq(AMD64.r9, AMD64.rsi);
        masm.imulq(AMD64.rsi, AMD64.rdx);
        masm.imulq(AMD64.r9, AMD64.rax);
        masm.shlq(AMD64.r10, 32);
        masm.orq(AMD64.r10, AMD64.rbx);
        masm.movl(AMD64.rax, new AMD64Address(AMD64.rcx, 0));
        masm.movl(AMD64.r11, AMD64.rsi);
        masm.shrq(AMD64.rsi, 32);
        masm.addq(AMD64.rdi, AMD64.r11);
        masm.movl(AMD64.r11, AMD64.rdi);
        masm.shrq(AMD64.rdi, 32);
        masm.addq(AMD64.r9, AMD64.rsi);
        masm.addq(AMD64.r9, AMD64.rdi);
        masm.imulq(AMD64.rdx, AMD64.rax);
        masm.pextrw(AMD64.rbx, AMD64.xmm0, 3);
        masm.leaq(AMD64.rdi, AMD64HotSpotHelper.recordExternalAddress(crb, this.piInvTable));
        masm.subq(AMD64.rcx, AMD64.rdi);
        masm.addl(AMD64.rcx, AMD64.rcx);
        masm.addl(AMD64.rcx, AMD64.rcx);
        masm.addl(AMD64.rcx, AMD64.rcx);
        masm.addl(AMD64.rcx, 19);
        masm.movl(AMD64.rsi, 32768);
        masm.andl(AMD64.rsi, AMD64.rbx);
        masm.shrl(AMD64.rbx, 4);
        masm.andl(AMD64.rbx, 2047);
        masm.subl(AMD64.rbx, 1023);
        masm.subl(AMD64.rcx, AMD64.rbx);
        masm.addq(AMD64.r9, AMD64.rdx);
        masm.movl(AMD64.rdx, AMD64.rcx);
        masm.addl(AMD64.rdx, 32);
        masm.cmplAndJcc(AMD64.rcx, 0, AMD64Assembler.ConditionFlag.Less, block5, false);
        masm.negl(AMD64.rcx);
        masm.addl(AMD64.rcx, 29);
        masm.shll(AMD64.r9);
        masm.movl(AMD64.rdi, AMD64.r9);
        masm.andl(AMD64.r9, 0x3FFFFFFF);
        masm.testlAndJcc(AMD64.r9, 0x20000000, AMD64Assembler.ConditionFlag.NotEqual, block6, false);
        masm.shrl(AMD64.r9);
        masm.movl(AMD64.rbx, 0);
        masm.shlq(AMD64.r9, 32);
        masm.orq(AMD64.r9, AMD64.r11);
        masm.bind(block7);
        masm.bind(block8);
        masm.cmpqAndJcc(AMD64.r9, 0, AMD64Assembler.ConditionFlag.Equal, block9, false);
        masm.bind(block10);
        masm.bsrq(AMD64.r11, AMD64.r9);
        masm.movl(AMD64.rcx, 29);
        masm.sublAndJcc(AMD64.rcx, AMD64.r11, AMD64Assembler.ConditionFlag.LessEqual, block11, false);
        masm.shlq(AMD64.r9);
        masm.movq(AMD64.rax, AMD64.r10);
        masm.shlq(AMD64.r10);
        masm.addl(AMD64.rdx, AMD64.rcx);
        masm.negl(AMD64.rcx);
        masm.addl(AMD64.rcx, 64);
        masm.shrq(AMD64.rax);
        masm.shrq(AMD64.r8);
        masm.orq(AMD64.r9, AMD64.rax);
        masm.orq(AMD64.r10, AMD64.r8);
        masm.bind(block12);
        masm.cvtsi2sdq(AMD64.xmm0, AMD64.r9);
        masm.shrq(AMD64.r10, 1);
        masm.cvtsi2sdq(AMD64.xmm3, AMD64.r10);
        masm.xorpd(AMD64.xmm4, AMD64.xmm4);
        masm.shll(AMD64.rdx, 4);
        masm.negl(AMD64.rdx);
        masm.addl(AMD64.rdx, 16368);
        masm.orl(AMD64.rdx, AMD64.rsi);
        masm.xorl(AMD64.rdx, AMD64.rbx);
        masm.pinsrw(AMD64.xmm4, AMD64.rdx, 3);
        masm.movq(AMD64.xmm2, AMD64HotSpotHelper.recordExternalAddress(crb, this.pi4));
        masm.movq(AMD64.xmm7, AMD64HotSpotHelper.recordExternalAddress(crb, this.pi48));
        masm.xorpd(AMD64.xmm5, AMD64.xmm5);
        masm.subl(AMD64.rdx, 1008);
        masm.pinsrw(AMD64.xmm5, AMD64.rdx, 3);
        masm.mulsd(AMD64.xmm0, AMD64.xmm4);
        masm.shll(AMD64.rsi, 16);
        masm.sarl(AMD64.rsi, 31);
        masm.mulsd(AMD64.xmm3, AMD64.xmm5);
        masm.movdqu(AMD64.xmm1, AMD64.xmm0);
        masm.mulsd(AMD64.xmm0, AMD64.xmm2);
        masm.shrl(AMD64.rdi, 30);
        masm.addsd(AMD64.xmm1, AMD64.xmm3);
        masm.mulsd(AMD64.xmm3, AMD64.xmm2);
        masm.addl(AMD64.rdi, AMD64.rsi);
        masm.xorl(AMD64.rdi, AMD64.rsi);
        masm.mulsd(AMD64.xmm7, AMD64.xmm1);
        masm.movl(AMD64.rax, AMD64.rdi);
        masm.addsd(AMD64.xmm7, AMD64.xmm3);
        masm.movdqu(AMD64.xmm2, AMD64.xmm0);
        masm.addsd(AMD64.xmm0, AMD64.xmm7);
        masm.subsd(AMD64.xmm2, AMD64.xmm0);
        masm.addsd(AMD64.xmm7, AMD64.xmm2);
        masm.movdqu(AMD64.xmm1, AMD64HotSpotHelper.recordExternalAddress(crb, this.pi32Inv));
        if (masm.supports(AMD64.CPUFeature.SSE3)) {
            masm.movddup(AMD64.xmm0, AMD64.xmm0);
        } else {
            masm.movlhps(AMD64.xmm0, AMD64.xmm0);
        }
        masm.movdqu(AMD64.xmm4, AMD64HotSpotHelper.recordExternalAddress(crb, this.signMask));
        masm.andpd(AMD64.xmm4, AMD64.xmm0);
        masm.mulpd(AMD64.xmm1, AMD64.xmm0);
        if (masm.supports(AMD64.CPUFeature.SSE3)) {
            masm.movddup(AMD64.xmm7, AMD64.xmm7);
        } else {
            masm.movlhps(AMD64.xmm7, AMD64.xmm7);
        }
        masm.movdqu(AMD64.xmm5, AMD64HotSpotHelper.recordExternalAddress(crb, this.onehalf));
        masm.movdqu(AMD64.xmm6, AMD64HotSpotHelper.recordExternalAddress(crb, this.mul16));
        masm.por(AMD64.xmm5, AMD64.xmm4);
        masm.addpd(AMD64.xmm1, AMD64.xmm5);
        masm.movdqu(AMD64.xmm5, AMD64.xmm1);
        masm.unpckhpd(AMD64.xmm5, AMD64.xmm5);
        masm.cvttsd2sil(AMD64.rdx, AMD64.xmm5);
        masm.cvttpd2dq(AMD64.xmm1, AMD64.xmm1);
        masm.cvtdq2pd(AMD64.xmm1, AMD64.xmm1);
        masm.mulpd(AMD64.xmm1, AMD64.xmm6);
        masm.movdqu(AMD64.xmm3, AMD64HotSpotHelper.recordExternalAddress(crb, this.p1));
        masm.movq(AMD64.xmm5, AMD64HotSpotHelper.recordExternalAddress(crb, this.qq2));
        masm.shll(AMD64.rax, 4);
        masm.addl(AMD64.rdx, 469248);
        masm.movdqu(AMD64.xmm4, AMD64HotSpotHelper.recordExternalAddress(crb, this.p2));
        masm.mulpd(AMD64.xmm3, AMD64.xmm1);
        masm.addl(AMD64.rdx, AMD64.rax);
        masm.andl(AMD64.rdx, 31);
        masm.mulsd(AMD64.xmm5, AMD64.xmm1);
        masm.movl(AMD64.rcx, AMD64.rdx);
        masm.mulpd(AMD64.xmm4, AMD64.xmm1);
        masm.shll(AMD64.rcx, 1);
        masm.subpd(AMD64.xmm0, AMD64.xmm3);
        masm.mulpd(AMD64.xmm1, AMD64HotSpotHelper.recordExternalAddress(crb, this.p3));
        masm.addl(AMD64.rdx, AMD64.rcx);
        masm.shll(AMD64.rcx, 2);
        masm.addl(AMD64.rdx, AMD64.rcx);
        masm.addsd(AMD64.xmm5, AMD64.xmm0);
        masm.movdqu(AMD64.xmm2, AMD64.xmm0);
        masm.subpd(AMD64.xmm0, AMD64.xmm4);
        masm.movq(AMD64.xmm6, AMD64HotSpotHelper.recordExternalAddress(crb, this.one));
        masm.shll(AMD64.rdx, 4);
        masm.leaq(AMD64.rax, AMD64HotSpotHelper.recordExternalAddress(crb, this.ctable));
        masm.andpd(AMD64.xmm5, AMD64HotSpotHelper.recordExternalAddress(crb, this.mask35));
        masm.movdqu(AMD64.xmm3, AMD64.xmm0);
        masm.addq(AMD64.rax, AMD64.rdx);
        masm.subpd(AMD64.xmm2, AMD64.xmm0);
        masm.unpckhpd(AMD64.xmm0, AMD64.xmm0);
        masm.divsd(AMD64.xmm6, AMD64.xmm5);
        masm.subpd(AMD64.xmm2, AMD64.xmm4);
        masm.subsd(AMD64.xmm3, AMD64.xmm5);
        masm.subpd(AMD64.xmm2, AMD64.xmm1);
        masm.movdqu(AMD64.xmm1, new AMD64Address(AMD64.rax, 48));
        masm.addpd(AMD64.xmm2, AMD64.xmm7);
        masm.movdqu(AMD64.xmm7, new AMD64Address(AMD64.rax, 16));
        masm.mulpd(AMD64.xmm7, AMD64.xmm0);
        masm.movdqu(AMD64.xmm4, new AMD64Address(AMD64.rax, 96));
        masm.mulpd(AMD64.xmm1, AMD64.xmm0);
        masm.mulpd(AMD64.xmm4, AMD64.xmm0);
        masm.addsd(AMD64.xmm2, AMD64.xmm3);
        masm.movdqu(AMD64.xmm3, AMD64.xmm0);
        masm.mulpd(AMD64.xmm0, AMD64.xmm0);
        masm.addpd(AMD64.xmm7, new AMD64Address(AMD64.rax, 0));
        masm.addpd(AMD64.xmm1, new AMD64Address(AMD64.rax, 32));
        masm.mulpd(AMD64.xmm1, AMD64.xmm0);
        masm.addpd(AMD64.xmm4, new AMD64Address(AMD64.rax, 80));
        masm.addpd(AMD64.xmm7, AMD64.xmm1);
        masm.movdqu(AMD64.xmm1, new AMD64Address(AMD64.rax, 112));
        masm.mulpd(AMD64.xmm1, AMD64.xmm0);
        masm.mulpd(AMD64.xmm0, AMD64.xmm0);
        masm.addpd(AMD64.xmm4, AMD64.xmm1);
        masm.movdqu(AMD64.xmm1, new AMD64Address(AMD64.rax, 64));
        masm.mulpd(AMD64.xmm1, AMD64.xmm0);
        masm.addpd(AMD64.xmm7, AMD64.xmm1);
        masm.movdqu(AMD64.xmm1, AMD64.xmm3);
        masm.mulpd(AMD64.xmm3, AMD64.xmm0);
        masm.mulsd(AMD64.xmm0, AMD64.xmm0);
        masm.mulpd(AMD64.xmm1, new AMD64Address(AMD64.rax, 144));
        masm.mulpd(AMD64.xmm4, AMD64.xmm3);
        masm.movdqu(AMD64.xmm3, AMD64.xmm1);
        masm.addpd(AMD64.xmm7, AMD64.xmm4);
        masm.movdqu(AMD64.xmm4, AMD64.xmm1);
        masm.mulsd(AMD64.xmm0, AMD64.xmm7);
        masm.unpckhpd(AMD64.xmm7, AMD64.xmm7);
        masm.addsd(AMD64.xmm0, AMD64.xmm7);
        masm.unpckhpd(AMD64.xmm1, AMD64.xmm1);
        masm.addsd(AMD64.xmm3, AMD64.xmm1);
        masm.subsd(AMD64.xmm4, AMD64.xmm3);
        masm.addsd(AMD64.xmm1, AMD64.xmm4);
        masm.movdqu(AMD64.xmm4, AMD64.xmm2);
        masm.movq(AMD64.xmm7, new AMD64Address(AMD64.rax, 144));
        masm.unpckhpd(AMD64.xmm2, AMD64.xmm2);
        masm.addsd(AMD64.xmm7, new AMD64Address(AMD64.rax, 152));
        masm.mulsd(AMD64.xmm7, AMD64.xmm2);
        masm.addsd(AMD64.xmm7, new AMD64Address(AMD64.rax, 136));
        masm.addsd(AMD64.xmm7, AMD64.xmm1);
        masm.addsd(AMD64.xmm0, AMD64.xmm7);
        masm.movq(AMD64.xmm7, AMD64HotSpotHelper.recordExternalAddress(crb, this.one));
        masm.mulsd(AMD64.xmm4, AMD64.xmm6);
        masm.movq(AMD64.xmm2, new AMD64Address(AMD64.rax, 168));
        masm.andpd(AMD64.xmm2, AMD64.xmm6);
        masm.mulsd(AMD64.xmm5, AMD64.xmm2);
        masm.mulsd(AMD64.xmm6, new AMD64Address(AMD64.rax, 160));
        masm.subsd(AMD64.xmm7, AMD64.xmm5);
        masm.subsd(AMD64.xmm2, new AMD64Address(AMD64.rax, 128));
        masm.subsd(AMD64.xmm7, AMD64.xmm4);
        masm.mulsd(AMD64.xmm7, AMD64.xmm6);
        masm.movdqu(AMD64.xmm4, AMD64.xmm3);
        masm.subsd(AMD64.xmm3, AMD64.xmm2);
        masm.addsd(AMD64.xmm2, AMD64.xmm3);
        masm.subsd(AMD64.xmm4, AMD64.xmm2);
        masm.addsd(AMD64.xmm0, AMD64.xmm4);
        masm.subsd(AMD64.xmm0, AMD64.xmm7);
        masm.addsd(AMD64.xmm0, AMD64.xmm3);
        masm.jmp(block14);
        masm.bind(block9);
        masm.addl(AMD64.rdx, 64);
        masm.movq(AMD64.r9, AMD64.r10);
        masm.movq(AMD64.r10, AMD64.r8);
        masm.movl(AMD64.r8, 0);
        masm.cmpqAndJcc(AMD64.r9, 0, AMD64Assembler.ConditionFlag.NotEqual, block10, false);
        masm.addl(AMD64.rdx, 64);
        masm.movq(AMD64.r9, AMD64.r10);
        masm.movq(AMD64.r10, AMD64.r8);
        masm.cmpqAndJcc(AMD64.r9, 0, AMD64Assembler.ConditionFlag.NotEqual, block10, false);
        masm.jmp(block12);
        masm.bind(block11);
        masm.jcc(AMD64Assembler.ConditionFlag.Equal, block12);
        masm.negl(AMD64.rcx);
        masm.shrq(AMD64.r10);
        masm.movq(AMD64.rax, AMD64.r9);
        masm.shrq(AMD64.r9);
        masm.subl(AMD64.rdx, AMD64.rcx);
        masm.negl(AMD64.rcx);
        masm.addl(AMD64.rcx, 64);
        masm.shlq(AMD64.rax);
        masm.orq(AMD64.r10, AMD64.rax);
        masm.jmp(block12);
        masm.bind(block5);
        masm.notl(AMD64.rcx);
        masm.shlq(AMD64.r9, 32);
        masm.orq(AMD64.r9, AMD64.r11);
        masm.shlq(AMD64.r9);
        masm.movq(AMD64.rdi, AMD64.r9);
        masm.testlAndJcc(AMD64.r9, Integer.MIN_VALUE, AMD64Assembler.ConditionFlag.NotEqual, block13, false);
        masm.shrl(AMD64.r9);
        masm.movl(AMD64.rbx, 0);
        masm.shrq(AMD64.rdi, 2);
        masm.jmp(block8);
        masm.bind(block6);
        masm.shrl(AMD64.r9);
        masm.movl(AMD64.rbx, 0x40000000);
        masm.shrl(AMD64.rbx);
        masm.shlq(AMD64.r9, 32);
        masm.orq(AMD64.r9, AMD64.r11);
        masm.shlq(AMD64.rbx, 32);
        masm.addl(AMD64.rdi, 0x40000000);
        masm.movl(AMD64.rcx, 0);
        masm.movl(AMD64.r11, 0);
        masm.subq(AMD64.rcx, AMD64.r8);
        masm.sbbq(AMD64.r11, AMD64.r10);
        masm.sbbq(AMD64.rbx, AMD64.r9);
        masm.movq(AMD64.r8, AMD64.rcx);
        masm.movq(AMD64.r10, AMD64.r11);
        masm.movq(AMD64.r9, AMD64.rbx);
        masm.movl(AMD64.rbx, 32768);
        masm.jmp(block7);
        masm.bind(block13);
        masm.shrl(AMD64.r9);
        masm.movq(AMD64.rbx, 0x100000000L);
        masm.shrq(AMD64.rbx);
        masm.movl(AMD64.rcx, 0);
        masm.movl(AMD64.r11, 0);
        masm.subq(AMD64.rcx, AMD64.r8);
        masm.sbbq(AMD64.r11, AMD64.r10);
        masm.sbbq(AMD64.rbx, AMD64.r9);
        masm.movq(AMD64.r8, AMD64.rcx);
        masm.movq(AMD64.r10, AMD64.r11);
        masm.movq(AMD64.r9, AMD64.rbx);
        masm.movl(AMD64.rbx, 32768);
        masm.shrq(AMD64.rdi, 2);
        masm.addl(AMD64.rdi, 0x40000000);
        masm.jmp(block8);
        masm.bind(block4);
        masm.movq(AMD64.xmm0, new AMD64Address(AMD64.rsp, 8));
        masm.mulsd(AMD64.xmm0, AMD64HotSpotHelper.recordExternalAddress(crb, this.negZero));
        masm.movq(new AMD64Address(AMD64.rsp, 0), AMD64.xmm0);
        masm.bind(block14);
        masm.addq(AMD64.rsp, 16);
        masm.pop(AMD64.rbx);
    }
}

