/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop.phases;

import java.util.Comparator;
import java.util.List;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.loop.phases.LoopPhase;
import org.graalvm.compiler.loop.phases.LoopTransformations;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopPolicies;
import org.graalvm.compiler.nodes.loop.LoopsData;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;

public class LoopFullUnrollPhase
extends LoopPhase<LoopPolicies> {
    private static final CounterKey FULLY_UNROLLED_LOOPS = DebugContext.counter("FullUnrolls");
    public static final Comparator<LoopEx> LOOP_COMPARATOR;

    public LoopFullUnrollPhase(CanonicalizerPhase canonicalizer, LoopPolicies policies) {
        super(policies, canonicalizer);
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        if (GraalOptions.FullUnroll.getValue(graph.getOptions()).booleanValue()) {
            DebugContext debug = graph.getDebug();
            if (graph.hasLoops()) {
                boolean peeled;
                int applications = 0;
                do {
                    peeled = false;
                    LoopsData dataCounted = context.getLoopsDataProvider().getLoopsData(graph);
                    dataCounted.detectCountedLoops();
                    List<LoopEx> countedLoops = dataCounted.countedLoops();
                    countedLoops.sort(LOOP_COMPARATOR);
                    for (LoopEx loop : countedLoops) {
                        if (!this.getPolicies().shouldFullUnroll(loop)) continue;
                        debug.log("FullUnroll %s", loop);
                        LoopTransformations.fullUnroll(loop, context, this.canonicalizer);
                        FULLY_UNROLLED_LOOPS.increment(debug);
                        debug.dump(4, (Object)graph, "FullUnroll %s", loop);
                        peeled = true;
                        break;
                    }
                    dataCounted.deleteUnusedNodes();
                } while (peeled && ++applications < Options.FullUnrollMaxApplication.getValue(graph.getOptions()));
            }
        }
    }

    @Override
    public boolean checkContract() {
        return false;
    }

    static {
        ToDoubleFunction<LoopEx> loopFreq = e -> e.loop().getHeader().getFirstPredecessor().getRelativeFrequency();
        ToIntFunction<LoopEx> loopDepth = e -> e.loop().getDepth();
        LOOP_COMPARATOR = Comparator.comparingDouble(loopFreq).thenComparingInt(loopDepth).reversed();
    }

    public static class Options {
        public static final OptionKey<Integer> FullUnrollMaxApplication = new OptionKey<Integer>(60);
    }
}

