/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.debug.ControlFlowAnchored;
import org.graalvm.compiler.nodes.spi.Lowerable;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class ComputeObjectAddressNode
extends FixedWithNextNode
implements Lowerable,
ControlFlowAnchored {
    public static final NodeClass<ComputeObjectAddressNode> TYPE = NodeClass.create(ComputeObjectAddressNode.class);
    @Node.Input
    ValueNode object;
    @Node.Input
    ValueNode offset;

    public ComputeObjectAddressNode(ValueNode obj, ValueNode offset) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(JavaKind.Long));
        this.object = obj;
        this.offset = SignExtendNode.create(offset, 64, NodeView.DEFAULT);
    }

    @Node.NodeIntrinsic
    public static native long get(Object var0, long var1);

    public ValueNode getObject() {
        return this.object;
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    public void setOffset(ValueNode offset) {
        this.updateUsages(this.offset, offset);
        this.offset = offset;
    }
}

