/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.Position;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.BinaryOpLogicNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNegationNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AbstractNormalizeCompareNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.ConvertNode;
import org.graalvm.compiler.nodes.calc.FloatEqualsNode;
import org.graalvm.compiler.nodes.calc.FloatLessThanNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.calc.PointerEqualsNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.memory.OrderedReadNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;

@NodeInfo(cycles=NodeCycles.CYCLES_1)
public abstract class CompareNode
extends BinaryOpLogicNode
implements Canonicalizable.Binary<ValueNode> {
    public static final NodeClass<CompareNode> TYPE = NodeClass.create(CompareNode.class);
    protected final CanonicalCondition condition;
    protected final boolean unorderedIsTrue;

    protected CompareNode(NodeClass<? extends CompareNode> c, CanonicalCondition condition, boolean unorderedIsTrue, ValueNode x, ValueNode y) {
        super(c, x, y);
        this.condition = condition;
        this.unorderedIsTrue = unorderedIsTrue;
    }

    public final CanonicalCondition condition() {
        return this.condition;
    }

    public final boolean unorderedIsTrue() {
        return this.unorderedIsTrue;
    }

    public static LogicNode tryConstantFold(CanonicalCondition condition, ValueNode forX, ValueNode forY, ConstantReflectionProvider constantReflection, boolean unorderedIsTrue) {
        if (forX.isConstant() && forY.isConstant() && (constantReflection != null || forX.asConstant() instanceof PrimitiveConstant)) {
            return LogicConstantNode.forBoolean(condition.foldCondition(forX.asConstant(), forY.asConstant(), constantReflection, unorderedIsTrue));
        }
        return null;
    }

    public static LogicNode tryConstantFoldPrimitive(CanonicalCondition condition, ValueNode forX, ValueNode forY, boolean unorderedIsTrue, NodeView view) {
        if (forX.asConstant() instanceof PrimitiveConstant && forY.asConstant() instanceof PrimitiveConstant) {
            return LogicConstantNode.forBoolean(condition.foldCondition((PrimitiveConstant)forX.asConstant(), (PrimitiveConstant)forY.asConstant(), unorderedIsTrue));
        }
        return null;
    }

    public boolean isIdentityComparison() {
        return this.condition == CanonicalCondition.EQ;
    }

    public static LogicNode createCompareNode(StructuredGraph graph, CanonicalCondition condition, ValueNode x, ValueNode y, ConstantReflectionProvider constantReflection, NodeView view) {
        LogicNode result = CompareNode.createCompareNode(condition, x, y, constantReflection, view);
        return result.graph() == null ? graph.addOrUniqueWithInputs(result) : result;
    }

    public static LogicNode createCompareNode(CanonicalCondition condition, ValueNode x, ValueNode y, ConstantReflectionProvider constantReflection, NodeView view) {
        LogicNode comparison;
        assert (x.getStackKind() == y.getStackKind());
        assert (!x.getStackKind().isNumericFloat());
        if (condition == CanonicalCondition.EQ) {
            if (x.stamp(view) instanceof AbstractObjectStamp) {
                comparison = ObjectEqualsNode.create(x, y, constantReflection, view);
            } else if (x.stamp(view) instanceof AbstractPointerStamp) {
                comparison = PointerEqualsNode.create(x, y, view);
            } else {
                assert (x.getStackKind().isNumericInteger());
                comparison = IntegerEqualsNode.create(x, y, view);
            }
        } else if (condition == CanonicalCondition.LT) {
            assert (x.getStackKind().isNumericInteger());
            comparison = IntegerLessThanNode.create(x, y, view);
        } else {
            assert (condition == CanonicalCondition.BT);
            assert (x.getStackKind().isNumericInteger());
            comparison = IntegerBelowNode.create(x, y, view);
        }
        return comparison;
    }

    public static LogicNode createCompareNode(StructuredGraph graph, ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, CanonicalCondition condition, ValueNode x, ValueNode y, NodeView view) {
        LogicNode result = CompareNode.createCompareNode(constantReflection, metaAccess, options, smallestCompareWidth, condition, x, y, view);
        return result.graph() == null ? graph.addOrUniqueWithInputs(result) : result;
    }

    public static LogicNode createAnyCompareNode(Condition condition, ValueNode x, ValueNode y, ConstantReflectionProvider constantReflection) {
        ValueNode xx = x;
        ValueNode yy = y;
        Condition canonicalCondition = condition;
        if (canonicalCondition.canonicalMirror()) {
            xx = y;
            yy = x;
            canonicalCondition = condition.mirror();
        }
        boolean negate = false;
        if (canonicalCondition.canonicalNegate()) {
            negate = true;
            canonicalCondition = canonicalCondition.negate();
        }
        CanonicalCondition canon = null;
        switch (canonicalCondition) {
            case EQ: {
                canon = CanonicalCondition.EQ;
                break;
            }
            case LT: {
                canon = CanonicalCondition.LT;
                break;
            }
            case BT: {
                canon = CanonicalCondition.BT;
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        LogicNode logic = CompareNode.createCompareNode(canon, xx, yy, constantReflection, NodeView.DEFAULT);
        if (negate) {
            return LogicNegationNode.create(logic);
        }
        return logic;
    }

    public boolean implies(LogicNode otherLogicNode, boolean thisNegated) {
        boolean otherNegated = false;
        LogicNode otherLogic = otherLogicNode;
        while (otherLogic instanceof LogicNegationNode) {
            otherLogic = ((LogicNegationNode)otherLogic).getValue();
            otherNegated = !otherNegated;
        }
        if (otherLogic instanceof CompareNode) {
            CompareNode otherCompare = (CompareNode)otherLogic;
            return this.implies(otherCompare, otherNegated, thisNegated);
        }
        return false;
    }

    public boolean implies(CompareNode otherCompare, boolean otherNegated, boolean thisNegated) {
        CanonicalCondition otherCondition = otherCompare.condition();
        ValueNode otherX = otherCompare.getX();
        ValueNode otherY = otherCompare.getY();
        if (this.condition() == otherCondition && CompareNode.sameValue(this.getX(), otherX) && CompareNode.sameValue(this.getY(), otherY) && thisNegated == otherNegated) {
            return true;
        }
        if (CompareNode.sameValue(this.getX(), otherX) && CompareNode.sameValue(this.getY(), otherY) || CompareNode.sameValue(this.getX(), otherY) && CompareNode.sameValue(this.getY(), otherX)) {
            if (this.condition() == CanonicalCondition.EQ && (otherCondition == CanonicalCondition.LT || otherCondition == CanonicalCondition.BT) && !thisNegated && otherNegated) {
                return true;
            }
            if (otherCondition == CanonicalCondition.EQ && (this.condition() == CanonicalCondition.LT || this.condition() == CanonicalCondition.BT) && thisNegated && !otherNegated) {
                return true;
            }
        }
        if (this.condition() == otherCondition && CompareNode.sameValue(this.getX(), otherY) && CompareNode.sameValue(this.getY(), otherX) && (this.condition() == CanonicalCondition.LT || this.condition() == CanonicalCondition.BT) && this.getY().stamp(NodeView.DEFAULT) instanceof IntegerStamp && !thisNegated && otherNegated) {
            return true;
        }
        if (CompareNode.sameValue(this.getX(), otherX) && this.getY().isJavaConstant() && otherY.isJavaConstant() && this.getY().stamp(NodeView.DEFAULT) instanceof IntegerStamp && otherY.stamp(NodeView.DEFAULT) instanceof IntegerStamp) {
            long thisYLong = this.getY().asJavaConstant().asLong();
            long otherYLong = otherY.asJavaConstant().asLong();
            if (this.condition() == CanonicalCondition.EQ && !thisNegated) {
                if (otherCondition == CanonicalCondition.EQ) {
                    if (thisYLong != otherYLong && otherNegated) {
                        return true;
                    }
                } else if (otherCondition == CanonicalCondition.LT) {
                    if (!otherNegated && thisYLong < otherYLong) {
                        return true;
                    }
                    if (otherNegated && otherYLong < thisYLong) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean sameValue(ValueNode v1, ValueNode v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1.isConstant() && v2.isConstant()) {
            return v1.asConstant().equals(v2.asConstant());
        }
        return GraphUtil.skipPi(v1) == GraphUtil.skipPi(v2);
    }

    public static LogicNode createCompareNode(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, CanonicalCondition condition, ValueNode x, ValueNode y, NodeView view) {
        LogicNode comparison;
        assert (x.getStackKind() == y.getStackKind());
        assert (!x.getStackKind().isNumericFloat());
        if (condition == CanonicalCondition.EQ) {
            if (x.stamp(view) instanceof AbstractObjectStamp) {
                assert (smallestCompareWidth == null);
                comparison = ObjectEqualsNode.create(constantReflection, metaAccess, options, x, y, view);
            } else if (x.stamp(view) instanceof AbstractPointerStamp) {
                comparison = PointerEqualsNode.create(x, y, view);
            } else {
                assert (x.getStackKind().isNumericInteger());
                comparison = IntegerEqualsNode.create(constantReflection, metaAccess, options, smallestCompareWidth, x, y, view);
            }
        } else if (condition == CanonicalCondition.LT) {
            assert (x.getStackKind().isNumericInteger());
            comparison = IntegerLessThanNode.create(constantReflection, metaAccess, options, smallestCompareWidth, x, y, view);
        } else {
            assert (condition == CanonicalCondition.BT);
            assert (x.getStackKind().isNumericInteger());
            comparison = IntegerBelowNode.create(constantReflection, metaAccess, options, smallestCompareWidth, x, y, view);
        }
        return comparison;
    }

    public static LogicNode createFloatCompareNode(StructuredGraph graph, CanonicalCondition condition, ValueNode x, ValueNode y, boolean unorderedIsTrue, NodeView view) {
        LogicNode result = CompareNode.createFloatCompareNode(condition, x, y, unorderedIsTrue, view);
        return result.graph() == null ? graph.addOrUniqueWithInputs(result) : result;
    }

    public static LogicNode createFloatCompareNode(CanonicalCondition condition, ValueNode x, ValueNode y, boolean unorderedIsTrue, NodeView view) {
        LogicNode comparison;
        assert (x.getStackKind() == y.getStackKind());
        assert (x.getStackKind().isNumericFloat());
        if (condition == CanonicalCondition.EQ) {
            comparison = FloatEqualsNode.create(x, y, view);
        } else {
            assert (condition == CanonicalCondition.LT);
            comparison = FloatLessThanNode.create(x, y, unorderedIsTrue, view);
        }
        return comparison;
    }

    public static abstract class CompareOp {
        public LogicNode canonical(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, CanonicalCondition condition, boolean unorderedIsTrue, ValueNode forX, ValueNode forY, NodeView view) {
            LogicNode constantCondition = CompareNode.tryConstantFold(condition, forX, forY, constantReflection, unorderedIsTrue);
            if (constantCondition != null) {
                return constantCondition;
            }
            if (forX.isConstant()) {
                LogicNode result = this.canonicalizeSymmetricConstant(constantReflection, metaAccess, options, smallestCompareWidth, condition, forX.asConstant(), forY, true, unorderedIsTrue, view);
                if (result != null) {
                    return result;
                }
            } else if (forY.isConstant()) {
                LogicNode result = this.canonicalizeSymmetricConstant(constantReflection, metaAccess, options, smallestCompareWidth, condition, forY.asConstant(), forX, false, unorderedIsTrue, view);
                if (result != null) {
                    return result;
                }
            } else if (forX instanceof ConvertNode && forY instanceof ConvertNode) {
                ConvertNode convertX = (ConvertNode)((Object)forX);
                ConvertNode convertY = (ConvertNode)((Object)forY);
                if (convertX.preservesOrder(condition) && convertY.preservesOrder(condition) && convertX.getValue().stamp(view).isCompatible(convertY.getValue().stamp(view))) {
                    boolean supported = CompareOp.isConstantConversionSupported(convertX, view, smallestCompareWidth);
                    if (supported && convertX.getValue().stamp(view) instanceof IntegerStamp) {
                        boolean bl = supported = convertX.getClass() == convertY.getClass();
                    }
                    if (supported) {
                        ValueNode xValue = convertX.getValue();
                        ValueNode yValue = convertY.getValue();
                        if (forX instanceof ZeroExtendNode || forX instanceof SignExtendNode) {
                            int introducedUsages = 0;
                            int eliminatedNodes = 0;
                            if (convertX.asNode().hasExactlyOneUsage()) {
                                ++eliminatedNodes;
                            } else if (xValue.hasExactlyOneUsage()) {
                                ++introducedUsages;
                            }
                            if (convertY.asNode().hasExactlyOneUsage()) {
                                ++eliminatedNodes;
                            } else if (yValue.hasExactlyOneUsage()) {
                                ++introducedUsages;
                            }
                            if (introducedUsages > eliminatedNodes) {
                                return null;
                            }
                        }
                        return this.duplicateModified(convertX.getValue(), convertY.getValue(), unorderedIsTrue, view);
                    }
                }
            }
            return null;
        }

        protected LogicNode canonicalizeSymmetricConstant(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, CanonicalCondition condition, Constant constant, ValueNode nonConstant, boolean mirrored, boolean unorderedIsTrue, NodeView view) {
            if (nonConstant instanceof ConditionalNode) {
                Condition realCondition = condition.asCondition();
                if (mirrored) {
                    realCondition = realCondition.mirror();
                }
                return CompareOp.optimizeConditional(constant, (ConditionalNode)nonConstant, constantReflection, realCondition, unorderedIsTrue);
            }
            if (nonConstant instanceof AbstractNormalizeCompareNode) {
                return this.optimizeNormalizeCompare(constantReflection, metaAccess, options, smallestCompareWidth, constant, (AbstractNormalizeCompareNode)nonConstant, mirrored, view);
            }
            if (nonConstant instanceof ConvertNode) {
                ConstantNode newConstant;
                boolean multiUsage;
                ConvertNode convert = (ConvertNode)((Object)nonConstant);
                boolean bl = multiUsage = convert.asNode().hasMoreThanOneUsage() && convert.getValue().hasExactlyOneUsage();
                if (!multiUsage && convert.asNode().hasMoreThanOneUsage() && convert.getValue() instanceof OrderedReadNode) {
                    OrderedReadNode read = (OrderedReadNode)convert.getValue();
                    int nonMemoryEdges = 0;
                    for (Node u : read.usages()) {
                        for (Position pos : u.inputPositions()) {
                            if (pos.get(u) != read || pos.getInputType() == InputType.Memory) continue;
                            ++nonMemoryEdges;
                        }
                    }
                    boolean bl2 = multiUsage = nonMemoryEdges == 1;
                }
                if (convert instanceof IntegerConvertNode && multiUsage) {
                    return null;
                }
                if (convert instanceof NarrowNode) {
                    NarrowNode narrowNode = (NarrowNode)convert;
                    if (narrowNode.getInputBits() > 32 && !constant.isDefaultForKind()) {
                        return null;
                    }
                    Stamp convertInputStamp = narrowNode.getValue().stamp(NodeView.DEFAULT);
                    if (convertInputStamp.isUnrestricted()) {
                        return null;
                    }
                    if (convertInputStamp instanceof IntegerStamp) {
                        IntegerStamp intConvertInputStamp = (IntegerStamp)convertInputStamp;
                        IntegerStamp intConvertStamp = (IntegerStamp)narrowNode.stamp(NodeView.DEFAULT);
                        if (condition.isUnsigned() ? intConvertInputStamp.unsignedLowerBound() < intConvertStamp.unsignedLowerBound() || intConvertInputStamp.unsignedUpperBound() > intConvertStamp.unsignedUpperBound() : intConvertInputStamp.lowerBound() < intConvertStamp.lowerBound() || intConvertInputStamp.upperBound() > intConvertStamp.upperBound()) {
                            return null;
                        }
                    } else if (convertInputStamp instanceof FloatStamp) {
                        FloatStamp floatConvertInputStamp = (FloatStamp)convertInputStamp;
                        FloatStamp floatConvertStamp = (FloatStamp)narrowNode.stamp(NodeView.DEFAULT);
                        GraalError.guarantee(!condition.isUnsigned(), "An unsigned floating point comparison makes no sense");
                        if (floatConvertInputStamp.lowerBound() < floatConvertStamp.lowerBound() || floatConvertInputStamp.upperBound() > floatConvertStamp.upperBound()) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                if (CompareOp.isConstantConversionSupported(convert, view, smallestCompareWidth) && (newConstant = CompareOp.canonicalConvertConstant(constantReflection, metaAccess, condition, convert, constant, view)) != null) {
                    if (mirrored) {
                        return this.duplicateModified(newConstant, convert.getValue(), unorderedIsTrue, view);
                    }
                    return this.duplicateModified(convert.getValue(), newConstant, unorderedIsTrue, view);
                }
            }
            return null;
        }

        private static boolean isConstantConversionSupported(ConvertNode convert, NodeView view, Integer smallestCompareWidth) {
            boolean supported;
            Stamp stamp = convert.getValue().stamp(view);
            boolean bl = supported = stamp instanceof PrimitiveStamp || stamp.isPointerStamp();
            if (supported && stamp instanceof IntegerStamp) {
                IntegerStamp intStamp = (IntegerStamp)convert.getValue().stamp(view);
                supported = smallestCompareWidth != null && intStamp.getBits() >= smallestCompareWidth;
            }
            return supported;
        }

        private static ConstantNode canonicalConvertConstant(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, CanonicalCondition condition, ConvertNode convert, Constant constant, NodeView view) {
            Constant reverseConverted;
            if (convert.preservesOrder(condition, constant, constantReflection) && (reverseConverted = convert.reverse(constant, constantReflection)) != null && convert.convert(reverseConverted, constantReflection).equals(constant)) {
                return ConstantNode.forConstant(convert.getValue().stamp(view), reverseConverted, metaAccess);
            }
            return null;
        }

        protected LogicNode optimizeNormalizeCompare(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, Constant constant, AbstractNormalizeCompareNode normalizeNode, boolean mirrored, NodeView view) {
            throw new PermanentBailoutException("NormalizeCompareNode connected to %s (%s %s %s)", this, constant, normalizeNode, mirrored);
        }

        private static LogicNode optimizeConditional(Constant constant, ConditionalNode conditionalNode, ConstantReflectionProvider constantReflection, Condition cond, boolean unorderedIsTrue) {
            Constant trueConstant = conditionalNode.trueValue().asConstant();
            Constant falseConstant = conditionalNode.falseValue().asConstant();
            if (falseConstant != null && trueConstant != null && constantReflection != null) {
                boolean falseResult;
                boolean trueResult = cond.foldCondition(trueConstant, constant, constantReflection, unorderedIsTrue);
                if (trueResult == (falseResult = cond.foldCondition(falseConstant, constant, constantReflection, unorderedIsTrue))) {
                    return LogicConstantNode.forBoolean(trueResult);
                }
                if (trueResult) {
                    assert (!falseResult);
                    return conditionalNode.condition();
                }
                assert (falseResult);
                return LogicNegationNode.create(conditionalNode.condition());
            }
            return null;
        }

        protected abstract LogicNode duplicateModified(ValueNode var1, ValueNode var2, boolean var3, NodeView var4);
    }
}

