/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNegationNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AbstractNormalizeCompareNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.FloatEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerLowerThanNode;
import org.graalvm.compiler.nodes.calc.IntegerTestNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.ShiftNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.calc.XorNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;

@NodeInfo(shortName="==")
public final class IntegerEqualsNode
extends CompareNode
implements Canonicalizable.BinaryCommutative<ValueNode> {
    public static final NodeClass<IntegerEqualsNode> TYPE = NodeClass.create(IntegerEqualsNode.class);
    private static final IntegerEqualsOp OP = new IntegerEqualsOp();

    public IntegerEqualsNode(ValueNode x, ValueNode y) {
        super(TYPE, CanonicalCondition.EQ, false, x, y);
        assert (!x.getStackKind().isNumericFloat() && x.getStackKind() != JavaKind.Object);
        assert (!y.getStackKind().isNumericFloat() && y.getStackKind() != JavaKind.Object);
    }

    public static LogicNode create(ValueNode x, ValueNode y, NodeView view) {
        LogicNode result = CompareNode.tryConstantFoldPrimitive(CanonicalCondition.EQ, x, y, false, view);
        if (result != null) {
            return result;
        }
        if (x instanceof ConditionalNode) {
            ConditionalNode conditionalNode = (ConditionalNode)x;
            if (conditionalNode.trueValue() == y) {
                return conditionalNode.condition();
            }
            if (conditionalNode.falseValue() == y) {
                return LogicNegationNode.create(conditionalNode.condition());
            }
        } else if (y instanceof ConditionalNode) {
            ConditionalNode conditionalNode = (ConditionalNode)y;
            if (conditionalNode.trueValue() == x) {
                return conditionalNode.condition();
            }
            if (conditionalNode.falseValue() == x) {
                return LogicNegationNode.create(conditionalNode.condition());
            }
        }
        return new IntegerEqualsNode(x, y).maybeCommuteInputs();
    }

    public static LogicNode create(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, ValueNode x, ValueNode y, NodeView view) {
        LogicNode value = OP.canonical(constantReflection, metaAccess, options, smallestCompareWidth, CanonicalCondition.EQ, false, x, y, view);
        if (value != null) {
            return value;
        }
        return IntegerEqualsNode.create(x, y, view);
    }

    @Override
    public Node canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        LogicNode value = OP.canonical(tool.getConstantReflection(), tool.getMetaAccess(), tool.getOptions(), tool.smallestCompareWidth(), CanonicalCondition.EQ, false, forX, forY, view);
        if (value != null) {
            return value;
        }
        return this;
    }

    @Override
    public Stamp getSucceedingStampForX(boolean negated, Stamp xStamp, Stamp yStamp) {
        if (!negated) {
            return xStamp.join(yStamp);
        }
        return null;
    }

    @Override
    public Stamp getSucceedingStampForY(boolean negated, Stamp xStamp, Stamp yStamp) {
        if (!negated) {
            return xStamp.join(yStamp);
        }
        return null;
    }

    @Override
    public TriState tryFold(Stamp xStampGeneric, Stamp yStampGeneric) {
        if (xStampGeneric instanceof IntegerStamp && yStampGeneric instanceof IntegerStamp) {
            IntegerStamp xStamp = (IntegerStamp)xStampGeneric;
            IntegerStamp yStamp = (IntegerStamp)yStampGeneric;
            if (xStamp.alwaysDistinct(yStamp)) {
                return TriState.FALSE;
            }
            if (xStamp.neverDistinct(yStamp)) {
                return TriState.TRUE;
            }
        }
        return TriState.UNKNOWN;
    }

    @Override
    public TriState implies(boolean thisNegated, LogicNode other) {
        if (!thisNegated && other instanceof IntegerLowerThanNode) {
            ValueNode otherX = ((IntegerLowerThanNode)other).getX();
            ValueNode otherY = ((IntegerLowerThanNode)other).getY();
            if (this.getX() == otherX && this.getY() == otherY || this.getX() == otherY && this.getY() == otherX) {
                return TriState.FALSE;
            }
        }
        return super.implies(thisNegated, other);
    }

    public static class IntegerEqualsOp
    extends CompareNode.CompareOp {
        @Override
        protected LogicNode optimizeNormalizeCompare(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, Constant constant, AbstractNormalizeCompareNode normalizeNode, boolean mirrored, NodeView view) {
            PrimitiveConstant primitive = (PrimitiveConstant)constant;
            long cst = primitive.asLong();
            if (cst == 0L) {
                return normalizeNode.createEqualComparison(constantReflection, metaAccess, options, smallestCompareWidth, view);
            }
            if (cst == 1L) {
                return normalizeNode.createLowerComparison(true, constantReflection, metaAccess, options, smallestCompareWidth, view);
            }
            if (cst == -1L) {
                return normalizeNode.createLowerComparison(false, constantReflection, metaAccess, options, smallestCompareWidth, view);
            }
            return LogicConstantNode.contradiction();
        }

        @Override
        protected CompareNode duplicateModified(ValueNode newX, ValueNode newY, boolean unorderedIsTrue, NodeView view) {
            if (newX.stamp(view) instanceof FloatStamp && newY.stamp(view) instanceof FloatStamp) {
                return new FloatEqualsNode(newX, newY);
            }
            if (newX.stamp(view) instanceof IntegerStamp && newY.stamp(view) instanceof IntegerStamp) {
                return new IntegerEqualsNode(newX, newY);
            }
            if (newX.stamp(view) instanceof AbstractPointerStamp && newY.stamp(view) instanceof AbstractPointerStamp) {
                return new IntegerEqualsNode(newX, newY);
            }
            throw GraalError.shouldNotReachHere();
        }

        @Override
        public LogicNode canonical(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, CanonicalCondition condition, boolean unorderedIsTrue, ValueNode forX, ValueNode forY, NodeView view) {
            SubNode subNode;
            AddNode addNode;
            ValueNode v2;
            ValueNode v1;
            if (GraphUtil.unproxify(forX) == GraphUtil.unproxify(forY)) {
                return LogicConstantNode.tautology();
            }
            if (forX.stamp(view).alwaysDistinct(forY.stamp(view))) {
                return LogicConstantNode.contradiction();
            }
            if (forX instanceof AddNode && forY instanceof AddNode) {
                AddNode addX = (AddNode)forX;
                AddNode addY = (AddNode)forY;
                v1 = null;
                v2 = null;
                if (addX.getX() == addY.getX()) {
                    v1 = addX.getY();
                    v2 = addY.getY();
                } else if (addX.getX() == addY.getY()) {
                    v1 = addX.getY();
                    v2 = addY.getX();
                } else if (addX.getY() == addY.getX()) {
                    v1 = addX.getX();
                    v2 = addY.getY();
                } else if (addX.getY() == addY.getY()) {
                    v1 = addX.getX();
                    v2 = addY.getX();
                }
                if (v1 != null) {
                    assert (v2 != null);
                    return IntegerEqualsNode.create(v1, v2, view);
                }
            }
            if (forX instanceof SubNode && forY instanceof SubNode) {
                SubNode subX = (SubNode)forX;
                SubNode subY = (SubNode)forY;
                v1 = null;
                v2 = null;
                if (subX.getX() == subY.getX()) {
                    v1 = subX.getY();
                    v2 = subY.getY();
                } else if (subX.getY() == subY.getY()) {
                    v1 = subX.getX();
                    v2 = subY.getX();
                }
                if (v1 != null) {
                    assert (v2 != null);
                    return IntegerEqualsNode.create(v1, v2, view);
                }
            }
            if (forX instanceof AddNode) {
                addNode = (AddNode)forX;
                if (addNode.getX() == forY) {
                    return IntegerEqualsNode.create(addNode.getY(), ConstantNode.forIntegerStamp(view.stamp(addNode), 0L), view);
                }
                if (addNode.getY() == forY) {
                    return IntegerEqualsNode.create(addNode.getX(), ConstantNode.forIntegerStamp(view.stamp(addNode), 0L), view);
                }
            }
            if (forY instanceof AddNode) {
                addNode = (AddNode)forY;
                if (addNode.getX() == forX) {
                    return IntegerEqualsNode.create(addNode.getY(), ConstantNode.forIntegerStamp(view.stamp(addNode), 0L), view);
                }
                if (addNode.getY() == forX) {
                    return IntegerEqualsNode.create(addNode.getX(), ConstantNode.forIntegerStamp(view.stamp(addNode), 0L), view);
                }
            }
            if (forX instanceof SubNode && (subNode = (SubNode)forX).getX() == forY) {
                return IntegerEqualsNode.create(subNode.getY(), ConstantNode.forIntegerStamp(view.stamp(subNode), 0L), view);
            }
            if (forY instanceof SubNode && forX == (subNode = (SubNode)forY).getX()) {
                return IntegerEqualsNode.create(subNode.getY(), ConstantNode.forIntegerStamp(view.stamp(subNode), 0L), view);
            }
            return super.canonical(constantReflection, metaAccess, options, smallestCompareWidth, condition, unorderedIsTrue, forX, forY, view);
        }

        @Override
        protected LogicNode canonicalizeSymmetricConstant(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, CanonicalCondition condition, Constant constant, ValueNode nonConstant, boolean mirrored, boolean unorderedIsTrue, NodeView view) {
            if (constant instanceof PrimitiveConstant) {
                XorNode xorNode;
                AddNode addNode;
                PrimitiveConstant primitiveConstant = (PrimitiveConstant)constant;
                IntegerStamp nonConstantStamp = (IntegerStamp)nonConstant.stamp(view);
                if (primitiveConstant.asLong() == 1L && nonConstantStamp.upperBound() == 1L && nonConstantStamp.lowerBound() == 0L || primitiveConstant.asLong() == -1L && nonConstantStamp.upperBound() == 0L && nonConstantStamp.lowerBound() == -1L) {
                    return LogicNegationNode.create(IntegerEqualsNode.create(constantReflection, metaAccess, options, smallestCompareWidth, nonConstant, ConstantNode.forIntegerStamp(nonConstantStamp, 0L), view));
                }
                if (primitiveConstant.asLong() == 0L) {
                    if (nonConstant instanceof AndNode) {
                        AndNode andNode = (AndNode)nonConstant;
                        return new IntegerTestNode(andNode.getX(), andNode.getY());
                    }
                    if (nonConstant instanceof SubNode) {
                        SubNode subNode = (SubNode)nonConstant;
                        return IntegerEqualsNode.create(constantReflection, metaAccess, options, smallestCompareWidth, subNode.getX(), subNode.getY(), view);
                    }
                    if (nonConstant instanceof ShiftNode && nonConstant.stamp(view) instanceof IntegerStamp) {
                        ShiftNode shift;
                        if (nonConstant instanceof LeftShiftNode) {
                            shift = (LeftShiftNode)nonConstant;
                            if (shift.getY().isConstant()) {
                                int mask = shift.getShiftAmountMask();
                                int amount = shift.getY().asJavaConstant().asInt() & mask;
                                if (shift.getX().getStackKind() == JavaKind.Int) {
                                    return new IntegerTestNode(shift.getX(), ConstantNode.forInt(-1 >>> amount));
                                }
                                assert (shift.getX().getStackKind() == JavaKind.Long);
                                return new IntegerTestNode(shift.getX(), ConstantNode.forLong(-1L >>> amount));
                            }
                        } else if (nonConstant instanceof RightShiftNode) {
                            shift = (RightShiftNode)nonConstant;
                            if (shift.getY().isConstant() && ((IntegerStamp)shift.getX().stamp(view)).isPositive()) {
                                int mask = shift.getShiftAmountMask();
                                int amount = shift.getY().asJavaConstant().asInt() & mask;
                                if (shift.getX().getStackKind() == JavaKind.Int) {
                                    return new IntegerTestNode(shift.getX(), ConstantNode.forInt(-1 << amount));
                                }
                                assert (shift.getX().getStackKind() == JavaKind.Long);
                                return new IntegerTestNode(shift.getX(), ConstantNode.forLong(-1L << amount));
                            }
                        } else if (nonConstant instanceof UnsignedRightShiftNode && (shift = (UnsignedRightShiftNode)nonConstant).getY().isConstant()) {
                            int mask = shift.getShiftAmountMask();
                            int amount = shift.getY().asJavaConstant().asInt() & mask;
                            if (shift.getX().getStackKind() == JavaKind.Int) {
                                return new IntegerTestNode(shift.getX(), ConstantNode.forInt(-1 << amount));
                            }
                            assert (shift.getX().getStackKind() == JavaKind.Long);
                            return new IntegerTestNode(shift.getX(), ConstantNode.forLong(-1L << amount));
                        }
                    }
                }
                if (nonConstant instanceof AddNode && (addNode = (AddNode)nonConstant).getY().isJavaConstant()) {
                    return new IntegerEqualsNode(addNode.getX(), ConstantNode.forIntegerStamp(nonConstantStamp, primitiveConstant.asLong() - addNode.getY().asJavaConstant().asLong()));
                }
                if (nonConstant instanceof AndNode) {
                    AndNode andNode = (AndNode)nonConstant;
                    if (Long.bitCount(((PrimitiveConstant)constant).asLong()) == 1 && andNode.getY().isConstant() && andNode.getY().asJavaConstant().equals(constant)) {
                        return new LogicNegationNode(new IntegerTestNode(andNode.getX(), andNode.getY()));
                    }
                }
                if (nonConstant instanceof XorNode && nonConstant.stamp(view) instanceof IntegerStamp && (xorNode = (XorNode)nonConstant).getY().isJavaConstant() && xorNode.getY().asJavaConstant().asLong() == 1L && ((IntegerStamp)xorNode.getX().stamp(view)).upMask() == 1L) {
                    return new IntegerEqualsNode(xorNode.getX(), ConstantNode.forIntegerStamp(xorNode.getX().stamp(view), primitiveConstant.asLong() ^ 1L));
                }
            }
            return super.canonicalizeSymmetricConstant(constantReflection, metaAccess, options, smallestCompareWidth, condition, constant, nonConstant, mirrored, unorderedIsTrue, view);
        }
    }
}

