/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_32, size=NodeSize.SIZE_32)
public final class RoundFloatToIntegerNode
extends UnaryNode
implements ArithmeticLIRLowerable {
    public static final NodeClass<RoundFloatToIntegerNode> TYPE = NodeClass.create(RoundFloatToIntegerNode.class);

    public RoundFloatToIntegerNode(ValueNode value) {
        super(TYPE, RoundFloatToIntegerNode.roundStamp((FloatStamp)value.stamp(NodeView.DEFAULT)), value);
    }

    private static IntegerStamp roundStamp(FloatStamp stamp) {
        double min = stamp.lowerBound();
        double max = stamp.upperBound();
        if (stamp.getBits() == 32) {
            long lowerBound = Math.round((float)min);
            long upperBound = Math.round((float)max);
            IntegerStamp newStamp = StampFactory.forInteger(32, lowerBound, upperBound);
            if (stamp.canBeNaN()) {
                return (IntegerStamp)newStamp.meet(StampFactory.forInteger(32, 0L, 0L));
            }
            return newStamp;
        }
        assert (stamp.getBits() == 64);
        long lowerBound = Math.round(min);
        long upperBound = Math.round(max);
        IntegerStamp newStamp = StampFactory.forInteger(64, lowerBound, upperBound);
        if (stamp.canBeNaN()) {
            return (IntegerStamp)newStamp.meet(StampFactory.forInteger(64, 0L, 0L));
        }
        return newStamp;
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        assert (newStamp.isCompatible(this.getValue().stamp(NodeView.DEFAULT)));
        return RoundFloatToIntegerNode.roundStamp((FloatStamp)newStamp);
    }

    private static ValueNode tryFold(ValueNode input) {
        if (input.isConstant()) {
            JavaConstant c = input.asJavaConstant();
            if (c.getJavaKind() == JavaKind.Double) {
                return ConstantNode.forLong(Math.round(c.asDouble()));
            }
            if (c.getJavaKind() == JavaKind.Float) {
                return ConstantNode.forInt(Math.round(c.asFloat()));
            }
        }
        return null;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        ValueNode folded = RoundFloatToIntegerNode.tryFold(forValue);
        return folded != null ? folded : this;
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        builder.setResult(this, gen.emitRoundFloatToInteger(builder.operand(this.getValue())));
    }
}

