/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.code.CodeUtil;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.IntegerDivRemNode;
import org.graalvm.compiler.nodes.calc.NegateNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.SignedFloatingIntegerDivNode;
import org.graalvm.compiler.nodes.calc.SignedRemNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(shortName="/")
public class SignedDivNode
extends IntegerDivRemNode
implements LIRLowerable {
    public static final NodeClass<SignedDivNode> TYPE = NodeClass.create(SignedDivNode.class);

    public SignedDivNode(ValueNode x, ValueNode y, GuardingNode zeroCheck) {
        this(TYPE, x, y, zeroCheck);
    }

    protected SignedDivNode(NodeClass<? extends SignedDivNode> c, ValueNode x, ValueNode y, GuardingNode zeroCheck) {
        super(c, IntegerStamp.OPS.getDiv().foldStamp(x.stamp(NodeView.DEFAULT), y.stamp(NodeView.DEFAULT)), IntegerDivRemNode.Op.DIV, IntegerDivRemNode.Type.SIGNED, x, y, zeroCheck);
    }

    public static ValueNode create(ValueNode x, ValueNode y, GuardingNode zeroCheck, NodeView view) {
        return SignedDivNode.canonical(null, x, y, zeroCheck, view);
    }

    @Override
    public boolean inferStamp() {
        return this.updateStamp(IntegerStamp.OPS.getDiv().foldStamp(this.getX().stamp(NodeView.DEFAULT), this.getY().stamp(NodeView.DEFAULT)));
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        return SignedDivNode.canonical(this, forX, forY, this.getZeroGuard(), view, this.canDeoptimize() ? tool.divisionOverflowIsJVMSCompliant() : true);
    }

    protected SignedDivNode createWithInputs(ValueNode forX, ValueNode forY, GuardingNode forZeroCheck, FrameState forStateBefore) {
        SignedDivNode sd = new SignedDivNode(forX, forY, forZeroCheck);
        sd.stateBefore = forStateBefore;
        return sd;
    }

    public static ValueNode canonical(SignedDivNode self, ValueNode forX, ValueNode forY, GuardingNode zeroCheck, NodeView view) {
        return SignedDivNode.canonical(self, forX, forY, zeroCheck, view, self == null ? false : !self.canDeoptimize());
    }

    public static ValueNode canonical(SignedDivNode self, ValueNode forX, ValueNode forY, GuardingNode zeroCheck, NodeView view, boolean divisionOverflowIsJVMSCompliant) {
        IntegerStamp yStamp;
        SubNode integerSubNode;
        long c;
        ValueNode v;
        Stamp stamp;
        Stamp predictedStamp = IntegerStamp.OPS.getDiv().foldStamp(forX.stamp(NodeView.DEFAULT), forY.stamp(NodeView.DEFAULT));
        Stamp stamp2 = stamp = self != null ? self.stamp(view) : predictedStamp;
        if (forX.isConstant() && forY.isConstant()) {
            long y = forY.asJavaConstant().asLong();
            if (y == 0L) {
                return self != null ? self : new SignedDivNode(forX, forY, zeroCheck);
            }
            return ConstantNode.forIntegerStamp(stamp, forX.asJavaConstant().asLong() / y);
        }
        if (forY.isConstant() && (v = SignedDivNode.canonical(forX, c = forY.asJavaConstant().asLong(), view)) != null) {
            return v;
        }
        if (forX instanceof SubNode && (integerSubNode = (SubNode)forX).getY() instanceof SignedRemNode) {
            SignedRemNode integerRemNode = (SignedRemNode)integerSubNode.getY();
            if (integerSubNode.stamp(view).isCompatible(stamp) && integerRemNode.stamp(view).isCompatible(stamp) && integerSubNode.getX() == integerRemNode.getX() && forY == integerRemNode.getY()) {
                if (self != null) {
                    return self.createWithInputs(integerSubNode.getX(), forY, zeroCheck, self.stateBefore);
                }
                return new SignedDivNode(integerSubNode.getX(), forY, zeroCheck);
            }
        }
        if (self != null && self.canFloat() && GraalOptions.FloatingDivNodes.getValue(self.getOptions()).booleanValue() && self.graph().isBeforeStage(StructuredGraph.StageFlag.VALUE_PROXY_REMOVAL) && !(yStamp = (IntegerStamp)forY.stamp(view)).contains(0L) && SignedDivNode.divisionIsJVMSCompliant(forX, forY, divisionOverflowIsJVMSCompliant)) {
            return SignedFloatingIntegerDivNode.create(forX, forY, view, zeroCheck, divisionOverflowIsJVMSCompliant);
        }
        if (self != null && self.next() instanceof SignedDivNode) {
            NodeClass<? extends Node> nodeClass = self.getNodeClass();
            if (self.next().getClass() == self.getClass() && nodeClass.equalInputs(self, self.next()) && self.valueEquals(self.next())) {
                return self.next();
            }
        }
        return self != null ? self : new SignedDivNode(forX, forY, zeroCheck);
    }

    @Override
    public boolean canFloat() {
        return true;
    }

    public static boolean divisionIsJVMSCompliant(ValueNode dividend, ValueNode divisor, boolean platformIsCompliant) {
        if (platformIsCompliant) {
            return true;
        }
        IntegerStamp dividendStamp = (IntegerStamp)dividend.stamp(NodeView.DEFAULT);
        IntegerStamp divisorStamp = (IntegerStamp)divisor.stamp(NodeView.DEFAULT);
        assert (dividendStamp.getBits() == divisorStamp.getBits());
        long minValue = NumUtil.minValue(dividendStamp.getBits());
        return !dividendStamp.contains(minValue) || !divisorStamp.contains(-1L);
    }

    public static ValueNode canonical(ValueNode forX, long c, NodeView view) {
        if (c == 1L) {
            return forX;
        }
        if (c == -1L) {
            return NegateNode.create(forX, view);
        }
        long abs = Math.abs(c);
        if (CodeUtil.isPowerOf2((long)abs) && forX.stamp(view) instanceof IntegerStamp) {
            IntegerStamp stampX = (IntegerStamp)forX.stamp(view);
            ValueNode dividend = forX;
            int log2 = CodeUtil.log2((long)abs);
            if (stampX.canBeNegative() && (stampX.upMask() & abs - 1L) != 0L) {
                int bits = PrimitiveStamp.getBits(forX.stamp(view));
                RightShiftNode sign = new RightShiftNode(forX, ConstantNode.forInt(bits - 1));
                UnsignedRightShiftNode round = new UnsignedRightShiftNode(sign, ConstantNode.forInt(bits - log2));
                dividend = BinaryArithmeticNode.add(dividend, round, view);
            }
            RightShiftNode shift = new RightShiftNode(dividend, ConstantNode.forInt(log2));
            if (c < 0L) {
                return NegateNode.create(shift, view);
            }
            return shift;
        }
        return null;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.setResult(this, gen.getLIRGeneratorTool().getArithmetic().emitDiv(gen.operand(this.getX()), gen.operand(this.getY()), gen.state(this)));
    }
}

