/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.IntegerDivRemNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.NegateNode;
import org.graalvm.compiler.nodes.calc.SignedDivNode;
import org.graalvm.compiler.nodes.calc.SignedFloatingIntegerRemNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(shortName="%")
public class SignedRemNode
extends IntegerDivRemNode
implements LIRLowerable {
    public static final NodeClass<SignedRemNode> TYPE = NodeClass.create(SignedRemNode.class);

    public SignedRemNode(ValueNode x, ValueNode y, GuardingNode zeroCheck) {
        this(TYPE, x, y, zeroCheck);
    }

    protected SignedRemNode(NodeClass<? extends SignedRemNode> c, ValueNode x, ValueNode y, GuardingNode zeroCheck) {
        super(c, IntegerStamp.OPS.getRem().foldStamp(x.stamp(NodeView.DEFAULT), y.stamp(NodeView.DEFAULT)), IntegerDivRemNode.Op.REM, IntegerDivRemNode.Type.SIGNED, x, y, zeroCheck);
    }

    public static ValueNode create(ValueNode x, ValueNode y, GuardingNode zeroCheck, NodeView view) {
        Stamp stamp = IntegerStamp.OPS.getRem().foldStamp(x.stamp(view), y.stamp(view));
        return SignedRemNode.canonical(null, x, y, zeroCheck, stamp, view, null);
    }

    @Override
    public boolean inferStamp() {
        return this.updateStamp(IntegerStamp.OPS.getRem().foldStamp(this.getX().stamp(NodeView.DEFAULT), this.getY().stamp(NodeView.DEFAULT)));
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        return SignedRemNode.canonical(this, forX, forY, this.getZeroGuard(), this.stamp(view), view, tool, this.canDeoptimize() ? tool.divisionOverflowIsJVMSCompliant() : true);
    }

    protected SignedRemNode createWithInputs(ValueNode forX, ValueNode forY, GuardingNode forZeroCheck) {
        return new SignedRemNode(forX, forY, forZeroCheck);
    }

    private static ValueNode canonical(SignedRemNode self, ValueNode forX, ValueNode forY, GuardingNode zeroCheck, Stamp stamp, NodeView view, CanonicalizerTool tool) {
        return SignedRemNode.canonical(self, forX, forY, zeroCheck, stamp, view, tool, self == null ? false : !self.canDeoptimize());
    }

    private static ValueNode canonical(SignedRemNode self, ValueNode forX, ValueNode forY, GuardingNode zeroCheck, Stamp stamp, NodeView view, CanonicalizerTool tool, boolean divisionOverflowIsJVMSCompliant) {
        IntegerStamp yStamp;
        if (forX.isConstant() && forY.isConstant()) {
            long y = forY.asJavaConstant().asLong();
            if (y == 0L) {
                return self != null ? self : new SignedRemNode(forX, forY, zeroCheck);
            }
            return ConstantNode.forIntegerStamp(stamp, forX.asJavaConstant().asLong() % y);
        }
        if (forY.isConstant() && forX.stamp(view) instanceof IntegerStamp && forY.stamp(view) instanceof IntegerStamp) {
            long constY = forY.asJavaConstant().asLong();
            IntegerStamp yStamp2 = (IntegerStamp)forY.stamp(view);
            if (constY < 0L && constY != CodeUtil.minValue((int)yStamp2.getBits())) {
                Stamp newStamp = IntegerStamp.OPS.getRem().foldStamp(forX.stamp(view), forY.stamp(view));
                return SignedRemNode.canonical(self, forX, ConstantNode.forIntegerStamp(yStamp2, -constY), zeroCheck, newStamp, view, tool);
            }
            ValueNode v = SignedRemNode.canonical(self, yStamp2, forX, forY, view, tool);
            if (v != null) {
                return v;
            }
        }
        if (self != null && self.hasNoUsages() && self.next() instanceof SignedDivNode) {
            SignedDivNode div = (SignedDivNode)self.next();
            if (div.x == self.x && div.y == self.y && div.getZeroGuard() == self.getZeroGuard() && div.stateBefore() == self.stateBefore()) {
                return null;
            }
        }
        if (tool != null && self.canFloat() && GraalOptions.FloatingDivNodes.getValue(tool.getOptions()).booleanValue() && self.graph().isBeforeStage(StructuredGraph.StageFlag.VALUE_PROXY_REMOVAL) && !(yStamp = (IntegerStamp)forY.stamp(view)).contains(0L) && SignedDivNode.divisionIsJVMSCompliant(forX, forY, divisionOverflowIsJVMSCompliant)) {
            return SignedFloatingIntegerRemNode.create(forX, forY, view, zeroCheck, divisionOverflowIsJVMSCompliant);
        }
        if (self != null && self.x == forX && self.y == forY) {
            return self;
        }
        if (self != null) {
            return self.createWithInputs(forX, forY, zeroCheck);
        }
        return new SignedRemNode(forX, forY, zeroCheck);
    }

    @Override
    public boolean canFloat() {
        return true;
    }

    public static ValueNode canonical(ValueNode self, Stamp stamp, ValueNode forX, ValueNode forY, NodeView view, CanonicalizerTool tool) {
        long constY = forY.asJavaConstant().asLong();
        IntegerStamp xStamp = (IntegerStamp)forX.stamp(view);
        IntegerStamp yStamp = (IntegerStamp)forY.stamp(view);
        if (constY == 1L) {
            return ConstantNode.forIntegerStamp(stamp, 0L);
        }
        if (CodeUtil.isPowerOf2((long)constY) && tool != null && tool.allUsagesAvailable()) {
            if (SignedRemNode.allUsagesCompareAgainstZero(self)) {
                return new AndNode(forX, ConstantNode.forIntegerStamp(yStamp, constY - 1L));
            }
            if (xStamp.isPositive()) {
                return new AndNode(forX, ConstantNode.forIntegerStamp(stamp, constY - 1L));
            }
            if (xStamp.isNegative()) {
                return new NegateNode(new AndNode(new NegateNode(forX), ConstantNode.forIntegerStamp(stamp, constY - 1L)));
            }
        }
        return null;
    }

    private static boolean allUsagesCompareAgainstZero(ValueNode self) {
        if (self == null) {
            return false;
        }
        for (Node usage : self.usages()) {
            if (usage instanceof IntegerEqualsNode) {
                ConstantNode constantNode;
                Constant constant;
                IntegerEqualsNode equalsNode = (IntegerEqualsNode)usage;
                ValueNode node = equalsNode.getY();
                if (node == self) {
                    node = equalsNode.getX();
                }
                if (node instanceof ConstantNode && (constant = (constantNode = (ConstantNode)node).asConstant()) instanceof PrimitiveConstant && ((PrimitiveConstant)constant).asLong() == 0L) continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.setResult(this, gen.getLIRGeneratorTool().getArithmetic().emitRem(gen.operand(this.getX()), gen.operand(this.getY()), gen.state(this)));
    }
}

