/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.debug;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.AbstractMemoryCheckpoint;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED, allowedUsageTypes={InputType.Memory})
public class SideEffectNode
extends AbstractMemoryCheckpoint
implements LIRLowerable,
SingleMemoryKill {
    public static final NodeClass<SideEffectNode> TYPE = NodeClass.create(SideEffectNode.class);
    @Node.OptionalInput
    ValueNode value;

    public SideEffectNode() {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)TYPE, StampFactory.forVoid());
    }

    public SideEffectNode(ValueNode value) {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)TYPE, value.stamp(NodeView.DEFAULT));
        this.value = value;
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        if (this.value != null) {
            generator.setResult(this, generator.operand(this.value));
        }
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }
}

