/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="OrderedJavaRead#{p#location/s}", allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public class JavaOrderedReadNode
extends JavaReadNode
implements SingleMemoryKill {
    public static final NodeClass<JavaOrderedReadNode> TYPE = NodeClass.create(JavaOrderedReadNode.class);
    private final MemoryOrderMode memoryOrder;

    public JavaOrderedReadNode(JavaKind readKind, AddressNode address, LocationIdentity location, OnHeapMemoryAccess.BarrierType barrierType, MemoryOrderMode memoryOrder, boolean compressible) {
        this(StampFactory.forKind(readKind), readKind, address, location, barrierType, memoryOrder, compressible);
    }

    public JavaOrderedReadNode(Stamp stamp, JavaKind readKind, AddressNode address, LocationIdentity location, OnHeapMemoryAccess.BarrierType barrierType, MemoryOrderMode memoryOrder, boolean compressible) {
        super(TYPE, stamp, readKind, address, location, barrierType, compressible);
        assert (MemoryOrderMode.ordersMemoryAccesses(memoryOrder));
        this.memoryOrder = memoryOrder;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        if (this.ordersMemoryAccesses()) {
            return LocationIdentity.any();
        }
        return MemoryKill.NO_LOCATION;
    }

    @Override
    public MemoryOrderMode getMemoryOrder() {
        return this.memoryOrder;
    }
}

