/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.graphbuilderconf;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderPlugin;

public abstract class InvocationPlugin
implements GraphBuilderPlugin {
    public final String name;
    final Type[] argumentTypes;
    public final boolean isStatic;
    public final String argumentsDescriptor;
    InvocationPlugin next;

    public InvocationPlugin(String name, Type ... argumentTypes) {
        int i;
        this.name = name;
        this.argumentTypes = argumentTypes;
        this.isStatic = argumentTypes.length == 0 || argumentTypes[0] != Receiver.class;
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        int n = i = this.isStatic ? 0 : 1;
        while (i < argumentTypes.length) {
            buf.append(MetaUtil.toInternalName((String)argumentTypes[i].getTypeName()));
            ++i;
        }
        buf.append(')');
        this.argumentsDescriptor = buf.toString();
    }

    public boolean inlineOnly() {
        return false;
    }

    public boolean isDecorator() {
        return false;
    }

    public boolean isOptional() {
        return false;
    }

    public boolean canBeDisabled() {
        return true;
    }

    public void rewriteReceiverType(Type receiverType) {
        GraalError.guarantee(!this.isStatic, "Cannot rewrite receiver type for a static method.");
        this.argumentTypes[0] = receiverType;
    }

    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver) {
        return this.defaultHandler(b, targetMethod, receiver, new ValueNode[0]);
    }

    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg) {
        return this.defaultHandler(b, targetMethod, receiver, arg);
    }

    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg1, ValueNode arg2) {
        return this.defaultHandler(b, targetMethod, receiver, arg1, arg2);
    }

    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3) {
        return this.defaultHandler(b, targetMethod, receiver, arg1, arg2, arg3);
    }

    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3, ValueNode arg4) {
        return this.defaultHandler(b, targetMethod, receiver, arg1, arg2, arg3, arg4);
    }

    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3, ValueNode arg4, ValueNode arg5) {
        return this.defaultHandler(b, targetMethod, receiver, arg1, arg2, arg3, arg4, arg5);
    }

    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3, ValueNode arg4, ValueNode arg5, ValueNode arg6) {
        return this.defaultHandler(b, targetMethod, receiver, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3, ValueNode arg4, ValueNode arg5, ValueNode arg6, ValueNode arg7) {
        return this.defaultHandler(b, targetMethod, receiver, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3, ValueNode arg4, ValueNode arg5, ValueNode arg6, ValueNode arg7, ValueNode arg8) {
        return this.defaultHandler(b, targetMethod, receiver, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }

    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3, ValueNode arg4, ValueNode arg5, ValueNode arg6, ValueNode arg7, ValueNode arg8, ValueNode arg9) {
        return this.defaultHandler(b, targetMethod, receiver, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }

    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3, ValueNode arg4, ValueNode arg5, ValueNode arg6, ValueNode arg7, ValueNode arg8, ValueNode arg9, ValueNode arg10) {
        return this.defaultHandler(b, targetMethod, receiver, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }

    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3, ValueNode arg4, ValueNode arg5, ValueNode arg6, ValueNode arg7, ValueNode arg8, ValueNode arg9, ValueNode arg10, ValueNode arg11) {
        return this.defaultHandler(b, targetMethod, receiver, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
    }

    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3, ValueNode arg4, ValueNode arg5, ValueNode arg6, ValueNode arg7, ValueNode arg8, ValueNode arg9, ValueNode arg10, ValueNode arg11, ValueNode arg12) {
        return this.defaultHandler(b, targetMethod, receiver, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
    }

    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode arg1, ValueNode arg2, ValueNode arg3, ValueNode arg4, ValueNode arg5, ValueNode arg6, ValueNode arg7, ValueNode arg8, ValueNode arg9, ValueNode arg10, ValueNode arg11, ValueNode arg12, ValueNode arg13) {
        return this.defaultHandler(b, targetMethod, receiver, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13);
    }

    public boolean execute(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode[] argsIncludingReceiver) {
        int n = argsIncludingReceiver.length;
        ValueNode[] a = argsIncludingReceiver;
        if (receiver != null) {
            assert (!targetMethod.isStatic());
            assert (n > 0);
            if (n == 1) {
                return this.apply(b, targetMethod, receiver);
            }
            if (n == 2) {
                return this.apply(b, targetMethod, receiver, a[1]);
            }
            if (n == 3) {
                return this.apply(b, targetMethod, receiver, a[1], a[2]);
            }
            if (n == 4) {
                return this.apply(b, targetMethod, receiver, a[1], a[2], a[3]);
            }
            if (n == 5) {
                return this.apply(b, targetMethod, receiver, a[1], a[2], a[3], a[4]);
            }
            if (n == 6) {
                return this.apply(b, targetMethod, receiver, a[1], a[2], a[3], a[4], a[5]);
            }
            if (n == 7) {
                return this.apply(b, targetMethod, receiver, a[1], a[2], a[3], a[4], a[5], a[6]);
            }
            if (n == 8) {
                return this.apply(b, targetMethod, receiver, a[1], a[2], a[3], a[4], a[5], a[6], a[7]);
            }
            if (n == 9) {
                return this.apply(b, targetMethod, receiver, a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8]);
            }
            if (n == 10) {
                return this.apply(b, targetMethod, receiver, a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9]);
            }
            if (n == 11) {
                return this.apply(b, targetMethod, receiver, a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9], a[10]);
            }
            if (n == 12) {
                return this.apply(b, targetMethod, receiver, a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9], a[10], a[11]);
            }
            if (n == 13) {
                return this.apply(b, targetMethod, receiver, a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9], a[10], a[11], a[12]);
            }
            return this.defaultHandler(b, targetMethod, receiver, a);
        }
        assert (targetMethod.isStatic());
        if (n == 0) {
            return this.apply(b, targetMethod, null);
        }
        if (n == 1) {
            return this.apply(b, targetMethod, null, a[0]);
        }
        if (n == 2) {
            return this.apply(b, targetMethod, null, a[0], a[1]);
        }
        if (n == 3) {
            return this.apply(b, targetMethod, null, a[0], a[1], a[2]);
        }
        if (n == 4) {
            return this.apply(b, targetMethod, null, a[0], a[1], a[2], a[3]);
        }
        if (n == 5) {
            return this.apply(b, targetMethod, null, a[0], a[1], a[2], a[3], a[4]);
        }
        if (n == 6) {
            return this.apply(b, targetMethod, null, a[0], a[1], a[2], a[3], a[4], a[5]);
        }
        if (n == 7) {
            return this.apply(b, targetMethod, null, a[0], a[1], a[2], a[3], a[4], a[5], a[6]);
        }
        if (n == 8) {
            return this.apply(b, targetMethod, null, a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7]);
        }
        if (n == 9) {
            return this.apply(b, targetMethod, null, a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8]);
        }
        if (n == 10) {
            return this.apply(b, targetMethod, null, a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9]);
        }
        if (n == 11) {
            return this.apply(b, targetMethod, null, a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9], a[10]);
        }
        if (n == 12) {
            return this.apply(b, targetMethod, null, a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9], a[10], a[11]);
        }
        if (n == 13) {
            return this.apply(b, targetMethod, null, a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9], a[10], a[11], a[12]);
        }
        return this.defaultHandler(b, targetMethod, receiver, a);
    }

    public boolean defaultHandler(GraphBuilderContext b, ResolvedJavaMethod targetMethod, Receiver receiver, ValueNode ... args) {
        throw new GraalError("Invocation plugin for %s does not handle invocations with %d arguments", targetMethod.format("%H.%n(%p)"), args.length);
    }

    public String getSourceLocation() {
        Class<?> c = this.getClass();
        for (Method m : c.getDeclaredMethods()) {
            if (!m.getName().equals("apply") && !m.getName().equals("defaultHandler")) continue;
            return String.format("%s.%s()", m.getClass().getName(), m.getName());
        }
        if (Services.IS_IN_NATIVE_IMAGE) {
            return String.format("%s.%s()", c.getName(), "apply");
        }
        throw new GraalError("could not find method named \"apply\" or \"defaultHandler\" in " + c.getName());
    }

    public int getArgumentsSize() {
        return this.argumentTypes.length - (this.isStatic ? 0 : 1);
    }

    public String getMethodNameWithArgumentsDescriptor() {
        return this.name + this.argumentsDescriptor;
    }

    public boolean match(InvocationPlugin other) {
        return this.isStatic == other.isStatic && this.name.equals(other.name) && this.argumentsDescriptor.equals(other.argumentsDescriptor);
    }

    public boolean match(ResolvedJavaMethod method) {
        return this.isStatic == method.isStatic() && this.name.equals(method.getName()) && method.getSignature().toMethodDescriptor().startsWith(this.argumentsDescriptor);
    }

    public boolean match(Method method) {
        if (this.isStatic == Modifier.isStatic(method.getModifiers()) && this.name.equals(method.getName())) {
            int offset;
            Class<?>[] parameterTypes = method.getParameterTypes();
            int n = offset = this.isStatic ? 0 : 1;
            if (parameterTypes.length == this.argumentTypes.length - offset) {
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (parameterTypes[i] == this.argumentTypes[i + offset]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean match(Constructor<?> c) {
        Class<?>[] parameterTypes;
        if (!this.isStatic && "<init>".equals(this.name) && (parameterTypes = c.getParameterTypes()).length == this.argumentTypes.length - 1) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (parameterTypes[i] == this.argumentTypes[i + 1]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static abstract class RequiredInlineOnlyInvocationPlugin
    extends RequiredInvocationPlugin {
        public RequiredInlineOnlyInvocationPlugin(String name, Type ... argumentTypes) {
            super(name, argumentTypes);
        }

        @Override
        public final boolean inlineOnly() {
            return true;
        }
    }

    public static abstract class RequiredInvocationPlugin
    extends InvocationPlugin {
        public RequiredInvocationPlugin(String name, Type ... argumentTypes) {
            super(name, argumentTypes);
        }

        @Override
        public final boolean canBeDisabled() {
            return false;
        }
    }

    public static abstract class OptionalInvocationPlugin
    extends InvocationPlugin {
        public OptionalInvocationPlugin(String name, Type ... argumentTypes) {
            super(name, argumentTypes);
        }

        @Override
        public final boolean isOptional() {
            return true;
        }
    }

    public static abstract class InlineOnlyInvocationPlugin
    extends InvocationPlugin {
        public InlineOnlyInvocationPlugin(String name, Type ... argumentTypes) {
            super(name, argumentTypes);
        }

        @Override
        public final boolean inlineOnly() {
            return true;
        }
    }

    public static interface Receiver {
        default public ValueNode get() {
            return this.get(true);
        }

        public ValueNode get(boolean var1);

        default public boolean isConstant() {
            return false;
        }
    }
}

