/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.graphbuilderconf;

import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.Pair;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.MethodFilter;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.ForeignCallPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;

public class InvocationPlugins {
    private final UnmodifiableEconomicMap<ResolvedJavaMethod, InvocationPlugin> resolvedRegistrations;
    private final EconomicMap<String, ClassPlugins> registrations;
    private volatile List<Runnable> deferredRegistrations;
    private boolean processingDeferredRegistrations;
    private volatile LateClassPlugins lateRegistrations;
    private volatile EconomicMap<String, List<InvocationPlugin>> testExtensions;
    protected final InvocationPlugins parent;
    private MethodFilter disabledIntrinsicsFilter;
    private volatile boolean isDisabledIntrinsicsFilterInitialized;
    private boolean logDisabledIntrinsics;

    public void defer(Runnable deferrable) {
        assert (this.deferredRegistrations != null) : "registration is closed";
        this.deferredRegistrations.add(deferrable);
    }

    void put(Type declaringClass, InvocationPlugin plugin, boolean allowOverwrite) {
        assert (this.resolvedRegistrations == null) : "registration is closed";
        String internalName = MetaUtil.toInternalName((String)declaringClass.getTypeName());
        assert (plugin.isStatic || plugin.argumentTypes[0] == declaringClass);
        assert (this.deferredRegistrations != null) : "initial registration is closed - use " + LateRegistration.class.getName() + " for late registrations";
        ClassPlugins classPlugins = (ClassPlugins)this.registrations.get((Object)internalName);
        if (classPlugins == null) {
            classPlugins = new ClassPlugins();
            this.registrations.put((Object)internalName, (Object)classPlugins);
        }
        classPlugins.register(plugin, allowOverwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InvocationPlugin get(ResolvedJavaMethod method) {
        if (this.resolvedRegistrations != null) {
            return (InvocationPlugin)this.resolvedRegistrations.get((Object)method);
        }
        if (!method.isBridge()) {
            LateClassPlugins lcp;
            ResolvedJavaType declaringClass = method.getDeclaringClass();
            this.flushDeferrables();
            String internalName = declaringClass.getName();
            ClassPlugins classPlugins = (ClassPlugins)this.registrations.get((Object)internalName);
            InvocationPlugin res = null;
            if (classPlugins != null) {
                res = classPlugins.get(method);
            }
            if (res == null && (lcp = this.findLateClassPlugins(internalName)) != null) {
                res = lcp.get(method);
            }
            if (res != null && (res.isDecorator() || res instanceof GeneratedInvocationPlugin || this.canBeIntrinsified(declaringClass))) {
                return res;
            }
            if (this.testExtensions != null) {
                InvocationPlugins invocationPlugins = this;
                synchronized (invocationPlugins) {
                    List testInvocationPlugins;
                    if (this.testExtensions != null && (testInvocationPlugins = (List)this.testExtensions.get((Object)internalName)) != null) {
                        for (InvocationPlugin testInvocationPlugin : testInvocationPlugins) {
                            if (!testInvocationPlugin.match(method)) continue;
                            return testInvocationPlugin;
                        }
                    }
                }
            }
        }
        return null;
    }

    public boolean canBeIntrinsified(ResolvedJavaType declaringClass) {
        return true;
    }

    public void registerIntrinsificationPredicate(Predicate<ResolvedJavaType> predicate) {
    }

    LateClassPlugins findLateClassPlugins(String internalClassName) {
        LateClassPlugins lcp = this.lateRegistrations;
        while (lcp != null) {
            if (lcp.className.equals(internalClassName)) {
                return lcp;
            }
            lcp = lcp.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushDeferrables() {
        if (this.deferredRegistrations != null) {
            InvocationPlugins invocationPlugins = this;
            synchronized (invocationPlugins) {
                if (this.deferredRegistrations != null) {
                    if (this.processingDeferredRegistrations) {
                        throw new GraalError("recursively performing deferred registration");
                    }
                    try {
                        this.processingDeferredRegistrations = true;
                        for (Runnable deferrable : this.deferredRegistrations) {
                            deferrable.run();
                        }
                        this.deferredRegistrations = null;
                    }
                    catch (InvocationPluginRegistrationError t) {
                        throw t;
                    }
                    catch (Throwable t) {
                        this.deferredRegistrations.clear();
                        Runnable rethrow = new Runnable(){

                            @Override
                            public void run() {
                                throw new InvocationPluginRegistrationError(t);
                            }
                        };
                        this.deferredRegistrations.add(rethrow);
                        rethrow.run();
                    }
                    finally {
                        this.processingDeferredRegistrations = false;
                    }
                }
            }
        }
    }

    private static int findInvocationPlugin(List<InvocationPlugin> list, InvocationPlugin key) {
        for (int i = 0; i < list.size(); ++i) {
            InvocationPlugin invocationPlugin = list.get(i);
            if (!invocationPlugin.match(key)) continue;
            return i;
        }
        return -1;
    }

    private static List<InvocationPlugin> getOrCreate(EconomicMap<String, List<InvocationPlugin>> res, String key) {
        ArrayList invocationPlugins = (ArrayList)res.get((Object)key);
        if (invocationPlugins == null) {
            invocationPlugins = new ArrayList();
            res.put((Object)key, invocationPlugins);
        }
        return invocationPlugins;
    }

    public synchronized void addTestPlugins(InvocationPlugins other, List<Pair<String, InvocationPlugin>> ignored) {
        assert (this.resolvedRegistrations == null) : "registration is closed";
        EconomicMap<String, List<InvocationPlugin>> otherInvocationPlugins = other.getInvocationPlugins(true, false);
        if (otherInvocationPlugins.isEmpty()) {
            return;
        }
        if (this.testExtensions == null) {
            this.testExtensions = EconomicMap.create();
        }
        MapCursor c = otherInvocationPlugins.getEntries();
        while (c.advance()) {
            String declaringClass = (String)c.getKey();
            List<InvocationPlugin> testInvocationPlugins = InvocationPlugins.getOrCreate(this.testExtensions, declaringClass);
            for (InvocationPlugin otherInvocationPlugin : (List)c.getValue()) {
                int index = InvocationPlugins.findInvocationPlugin(testInvocationPlugins, otherInvocationPlugin);
                if (index != -1) {
                    if (ignored == null) continue;
                    ignored.add((Pair<String, InvocationPlugin>)Pair.create((Object)declaringClass, (Object)otherInvocationPlugin));
                    continue;
                }
                testInvocationPlugins.add(otherInvocationPlugin);
            }
        }
    }

    public synchronized void removeTestPlugins(InvocationPlugins other) {
        assert (this.resolvedRegistrations == null) : "registration is closed";
        if (this.testExtensions != null) {
            MapCursor c = other.getInvocationPlugins(false).getEntries();
            while (c.advance()) {
                String declaringClass = (String)c.getKey();
                List testInvocationPlugins = (List)this.testExtensions.get((Object)declaringClass);
                if (testInvocationPlugins == null) continue;
                for (InvocationPlugin otherInvocationPlugin : (List)c.getValue()) {
                    int index = InvocationPlugins.findInvocationPlugin(testInvocationPlugins, otherInvocationPlugin);
                    if (index == -1) continue;
                    testInvocationPlugins.remove(index);
                }
                if (!testInvocationPlugins.isEmpty()) continue;
                this.testExtensions.removeKey((Object)declaringClass);
            }
            if (this.testExtensions.isEmpty()) {
                this.testExtensions = null;
            }
        }
    }

    synchronized void registerLate(Type declaringType, List<InvocationPlugin> invocationPlugins) {
        String internalName = MetaUtil.toInternalName((String)declaringType.getTypeName());
        assert (this.findLateClassPlugins(internalName) == null) : "Cannot have more than one late registration of invocation plugins for " + internalName;
        LateClassPlugins lateClassPlugins = new LateClassPlugins(this.lateRegistrations, internalName);
        for (InvocationPlugin plugin : invocationPlugins) {
            lateClassPlugins.register(plugin);
        }
        this.lateRegistrations = lateClassPlugins;
    }

    @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="string literal object identity used as sentinel")
    private synchronized boolean closeLateRegistrations() {
        if (this.lateRegistrations == null || this.lateRegistrations.className != "-----") {
            this.lateRegistrations = new LateClassPlugins(this.lateRegistrations, "-----");
        }
        return true;
    }

    public void closeRegistration() {
        assert (this.closeLateRegistrations());
        this.flushDeferrables();
    }

    public boolean isEmpty() {
        if (this.parent != null && !this.parent.isEmpty()) {
            return false;
        }
        UnmodifiableEconomicMap<ResolvedJavaMethod, InvocationPlugin> resolvedRegs = this.resolvedRegistrations;
        if (resolvedRegs != null && !resolvedRegs.isEmpty()) {
            return false;
        }
        List<Runnable> deferred = this.deferredRegistrations;
        if (deferred != null && !deferred.isEmpty()) {
            return false;
        }
        LateClassPlugins late = this.lateRegistrations;
        while (late != null) {
            if (!late.invocationPlugins.isEmpty()) {
                return false;
            }
            late = late.next;
        }
        return this.registrations.size() == 0;
    }

    public InvocationPlugins() {
        this(null, null);
    }

    public InvocationPlugins(Map<ResolvedJavaMethod, InvocationPlugin> resolvedPlugins, InvocationPlugins parent) {
        this.parent = parent;
        if (resolvedPlugins == null) {
            this.resolvedRegistrations = null;
            this.deferredRegistrations = new ArrayList<Runnable>();
            this.registrations = EconomicMap.create();
        } else {
            EconomicMap map = EconomicMap.create((int)resolvedPlugins.size());
            for (Map.Entry<ResolvedJavaMethod, InvocationPlugin> entry : resolvedPlugins.entrySet()) {
                map.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            this.resolvedRegistrations = map;
            this.deferredRegistrations = null;
            this.registrations = null;
        }
    }

    protected void register(Type declaringClass, InvocationPlugin plugin, boolean allowOverwrite) {
        if (!plugin.isStatic) {
            plugin.rewriteReceiverType(declaringClass);
        }
        this.put(declaringClass, plugin, allowOverwrite);
        assert (Services.IS_IN_NATIVE_IMAGE || Checks.check(this, declaringClass, plugin));
        assert (Services.IS_IN_NATIVE_IMAGE || Checks.checkResolvable(declaringClass, plugin));
    }

    public final void register(Type declaringClass, InvocationPlugin plugin) {
        this.register(declaringClass, plugin, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocationPlugin lookupInvocation(ResolvedJavaMethod method, boolean allowDecorators, OptionValues options) {
        InvocationPlugin plugin;
        if (!this.isDisabledIntrinsicsFilterInitialized) {
            InvocationPlugins invocationPlugins = this;
            synchronized (invocationPlugins) {
                String filterValue;
                if (!this.isDisabledIntrinsicsFilterInitialized && (filterValue = Options.DisableIntrinsics.getValue(options)) != null) {
                    String[] values = filterValue.split(":");
                    if (values.length > 1 && "verbose".equals(values[1])) {
                        this.logDisabledIntrinsics = true;
                    }
                    this.disabledIntrinsicsFilter = MethodFilter.parse(values[0]);
                }
                this.isDisabledIntrinsicsFilterInitialized = true;
            }
        }
        if (this.parent != null && (plugin = this.parent.lookupInvocation(method, allowDecorators, options)) != null) {
            return plugin;
        }
        InvocationPlugin invocationPlugin = this.get(method);
        if (invocationPlugin != null && (allowDecorators || !invocationPlugin.isDecorator())) {
            if (this.disabledIntrinsicsFilter != null && this.disabledIntrinsicsFilter.matches((JavaMethod)method)) {
                if (invocationPlugin.canBeDisabled()) {
                    if (this.logDisabledIntrinsics) {
                        TTY.println("[Warning] Intrinsic for %s is disabled.", method.format("%H.%n(%p)"));
                    }
                    return null;
                }
                if (this.logDisabledIntrinsics) {
                    TTY.println("[Warning] Intrinsic for %s cannot be disabled.", method.format("%H.%n(%p)"));
                }
            }
            return invocationPlugin;
        }
        return null;
    }

    public InvocationPlugin lookupInvocation(ResolvedJavaMethod method, OptionValues options) {
        return this.lookupInvocation(method, false, options);
    }

    public EconomicMap<String, List<InvocationPlugin>> getInvocationPlugins(boolean includeParents) {
        return this.getInvocationPlugins(includeParents, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EconomicMap<String, List<InvocationPlugin>> getInvocationPlugins(boolean includeParents, boolean flushDeferrables) {
        EconomicMap res = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        if (this.parent != null && includeParents) {
            res.putAll(this.parent.getInvocationPlugins(true, flushDeferrables));
        }
        if (this.resolvedRegistrations != null) {
            UnmodifiableMapCursor cursor = this.resolvedRegistrations.getEntries();
            while (cursor.advance()) {
                ResolvedJavaMethod method = (ResolvedJavaMethod)cursor.getKey();
                InvocationPlugin plugin = (InvocationPlugin)cursor.getValue();
                String type = method.getDeclaringClass().getName();
                List<InvocationPlugin> pluginsPerClass = InvocationPlugins.getOrCreate((EconomicMap<String, List<InvocationPlugin>>)res, type);
                pluginsPerClass.add(plugin);
            }
        } else {
            List<InvocationPlugin> pluginsPerClass;
            if (flushDeferrables) {
                this.flushDeferrables();
            }
            MapCursor classes = this.registrations.getEntries();
            while (classes.advance()) {
                String type = (String)classes.getKey();
                ClassPlugins cp = (ClassPlugins)classes.getValue();
                pluginsPerClass = InvocationPlugins.getOrCreate((EconomicMap<String, List<InvocationPlugin>>)res, type);
                cp.collectInvocationPluginsTo(pluginsPerClass);
            }
            LateClassPlugins lcp = this.lateRegistrations;
            while (lcp != null) {
                String type = lcp.className;
                pluginsPerClass = InvocationPlugins.getOrCreate((EconomicMap<String, List<InvocationPlugin>>)res, type);
                lcp.collectInvocationPluginsTo(pluginsPerClass);
                lcp = lcp.next;
            }
            if (this.testExtensions != null) {
                InvocationPlugins invocationPlugins = this;
                synchronized (invocationPlugins) {
                    if (this.testExtensions != null) {
                        MapCursor c = this.testExtensions.getEntries();
                        while (c.advance()) {
                            String type = (String)c.getKey();
                            List<InvocationPlugin> pluginsPerClass2 = InvocationPlugins.getOrCreate((EconomicMap<String, List<InvocationPlugin>>)res, type);
                            pluginsPerClass2.addAll((Collection)c.getValue());
                        }
                    }
                }
            }
        }
        return res;
    }

    public InvocationPlugins getParent() {
        return this.parent;
    }

    public String toString() {
        MapCursor entries = this.getInvocationPlugins(false, false).getEntries();
        ArrayList<CallSite> all = new ArrayList<CallSite>();
        while (entries.advance()) {
            String c = MetaUtil.internalNameToJava((String)((String)entries.getKey()), (boolean)true, (boolean)false);
            for (InvocationPlugin invocationPlugin : (List)entries.getValue()) {
                all.add((CallSite)((Object)(c + "." + invocationPlugin.getMethodNameWithArgumentsDescriptor())));
            }
        }
        Collections.sort(all);
        StringBuilder buf = new StringBuilder();
        String nl = String.format("%n", new Object[0]);
        for (String string : all) {
            if (buf.length() != 0) {
                buf.append(nl);
            }
            buf.append(string);
        }
        if (this.parent != null) {
            if (buf.length() != 0) {
                buf.append(nl);
            }
            buf.append("// parent").append(nl).append(this.parent);
        }
        return buf.toString();
    }

    public void checkNewNodes(GraphBuilderContext b, InvocationPlugin plugin, NodeIterable<Node> newNodes) {
        if (this.parent != null) {
            this.parent.checkNewNodes(b, plugin, newNodes);
        }
    }

    public static Class<?> resolveClass(String className, boolean optional) {
        try {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            return Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException e) {
            if (optional) {
                return null;
            }
            throw new GraalError("Could not resolve type " + className);
        }
    }

    public static Class<?> resolveType(Type type, boolean optional) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof OptionalLazySymbol) {
            return ((OptionalLazySymbol)type).resolve();
        }
        if (Services.IS_IN_NATIVE_IMAGE) {
            throw new GraalError("Unresolved type in native image image:" + type.getTypeName());
        }
        return InvocationPlugins.resolveClass(type.getTypeName(), optional);
    }

    public static Method resolveMethod(Class<?> declaringClass, InvocationPlugin plugin) {
        if ("<init>".equals(plugin.name)) {
            return null;
        }
        Method[] methods = declaringClass.getDeclaredMethods();
        Method match = null;
        for (Method m : methods) {
            if (!plugin.match(m)) continue;
            if (match == null) {
                match = m;
                continue;
            }
            if (match.getReturnType().isAssignableFrom(m.getReturnType())) {
                match = m;
                continue;
            }
            if (m.getReturnType().isAssignableFrom(match.getReturnType())) continue;
            throw new NoSuchMethodError(String.format("Found 2 methods with same name and parameter types but unrelated return types:%n %s%n %s", match, m));
        }
        return match;
    }

    public static ResolvedJavaMethod resolveJavaMethod(ResolvedJavaType declaringClass, InvocationPlugin plugin) {
        ResolvedJavaMethod[] methods = declaringClass.getDeclaredMethods();
        if (plugin.name.equals("<init>")) {
            for (ResolvedJavaMethod m : methods) {
                if (!m.getName().equals("<init>") || !m.getSignature().toMethodDescriptor().startsWith(plugin.argumentsDescriptor)) continue;
                return m;
            }
            return null;
        }
        ResolvedJavaMethod match = null;
        for (int i = 0; i < methods.length; ++i) {
            ResolvedJavaType mReturnType;
            ResolvedJavaMethod m = methods[i];
            if (!plugin.match(m)) continue;
            if (match == null) {
                match = m;
                continue;
            }
            ResolvedJavaType matchReturnType = (ResolvedJavaType)match.getSignature().getReturnType(declaringClass);
            if (matchReturnType.isAssignableFrom(mReturnType = (ResolvedJavaType)m.getSignature().getReturnType(declaringClass))) {
                match = m;
                continue;
            }
            if (mReturnType.isAssignableFrom(matchReturnType)) continue;
            throw new NoSuchMethodError(String.format("Found 2 methods with same name and parameter types but unrelated return types:%n %s%n %s", match, m));
        }
        return match;
    }

    public static Constructor<?> resolveConstructor(Class<?> declaringClass, InvocationPlugin plugin) {
        Constructor<?>[] constructors;
        if (!"<init>".equals(plugin.name)) {
            return null;
        }
        for (Constructor<?> c : constructors = declaringClass.getDeclaredConstructors()) {
            if (!plugin.match(c)) continue;
            return c;
        }
        return null;
    }

    public void notifyNoPlugin(ResolvedJavaMethod targetMethod, OptionValues options) {
    }

    private static class Checks {
        private static final int MAX_ARITY = 13;
        static final Class<?>[][] SIGS;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Checks() {
        }

        static boolean containsPlugin(InvocationPlugins p, Type declaringType, InvocationPlugin plugin) {
            String internalName = MetaUtil.toInternalName((String)declaringType.getTypeName());
            ClassPlugins classPlugins = (ClassPlugins)p.registrations.get((Object)internalName);
            return classPlugins != null && classPlugins.lookup(plugin) != null;
        }

        public static boolean check(InvocationPlugins plugins, Type declaringType, InvocationPlugin plugin) {
            InvocationPlugins p = plugins.parent;
            while (p != null) {
                if (!$assertionsDisabled && Checks.containsPlugin(p, declaringType, plugin)) {
                    throw new AssertionError((Object)("a plugin is already registered for " + plugin.getMethodNameWithArgumentsDescriptor()));
                }
                p = p.parent;
            }
            if (plugin instanceof ForeignCallPlugin || plugin instanceof GeneratedInvocationPlugin) {
                return true;
            }
            int arguments = plugin.getArgumentsSize();
            if (!$assertionsDisabled && arguments >= SIGS.length) {
                throw new AssertionError((Object)String.format("need to extend %s to support method with %d arguments: %s", InvocationPlugin.class.getSimpleName(), arguments, plugin.getMethodNameWithArgumentsDescriptor()));
            }
            for (Class<?> klass = plugin.getClass(); klass != InvocationPlugin.class; klass = klass.getSuperclass()) {
                for (Method m : klass.getDeclaredMethods()) {
                    Object[] parameterTypes;
                    if (m.getName().equals("defaultHandler") || m.getName().equals("execute")) {
                        return true;
                    }
                    if (!m.getName().equals("apply") || !Arrays.equals(SIGS[arguments], parameterTypes = m.getParameterTypes())) continue;
                    return true;
                }
            }
            throw new AssertionError((Object)String.format("graph builder plugin for %s not found", plugin.getMethodNameWithArgumentsDescriptor()));
        }

        static boolean checkResolvable(Type declaringType, InvocationPlugin plugin) {
            if (declaringType instanceof ResolvedJavaSymbol) {
                return Checks.checkResolvable(((ResolvedJavaSymbol)declaringType).getResolved(), plugin);
            }
            Class<?> declaringClass = InvocationPlugins.resolveType(declaringType, plugin.isOptional());
            if (declaringClass == null) {
                return true;
            }
            if ("<init>".equals(plugin.name)) {
                if (InvocationPlugins.resolveConstructor(declaringClass, plugin) == null && !plugin.isOptional()) {
                    throw new AssertionError((Object)String.format("Constructor not found: %s%s", declaringClass.getName(), plugin.argumentsDescriptor));
                }
            } else if (InvocationPlugins.resolveMethod(declaringClass, plugin) == null && !plugin.isOptional()) {
                throw new NoSuchMethodError(String.format("%s.%s", declaringClass.getName(), plugin.getMethodNameWithArgumentsDescriptor()));
            }
            return true;
        }

        private static boolean checkResolvable(ResolvedJavaType declaringType, InvocationPlugin plugin) {
            if (InvocationPlugins.resolveJavaMethod(declaringType, plugin) == null && !plugin.isOptional()) {
                throw new AssertionError((Object)String.format("Method not found: %s.%s", declaringType.toJavaName(), plugin.getMethodNameWithArgumentsDescriptor()));
            }
            return true;
        }

        static {
            boolean bl = $assertionsDisabled = !InvocationPlugins.class.desiredAssertionStatus();
            if (!Assertions.assertionsEnabled() && !Services.IS_BUILDING_NATIVE_IMAGE) {
                throw new GraalError("%s must only be used in assertions", Checks.class.getName());
            }
            ArrayList<Class<?>[]> sigs = new ArrayList<Class<?>[]>(13);
            if (!Services.IS_IN_NATIVE_IMAGE) {
                for (Method method : InvocationPlugin.class.getDeclaredMethods()) {
                    if (Modifier.isStatic(method.getModifiers()) || !method.getName().equals("apply")) continue;
                    Class<?>[] sig = method.getParameterTypes();
                    if (!$assertionsDisabled && sig[0] != GraphBuilderContext.class) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && sig[1] != ResolvedJavaMethod.class) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && sig[2] != InvocationPlugin.Receiver.class) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !Arrays.asList(sig).subList(3, sig.length).stream().allMatch(c -> c == ValueNode.class)) {
                        throw new AssertionError();
                    }
                    while (sigs.size() < sig.length - 2) {
                        sigs.add(null);
                    }
                    sigs.set(sig.length - 3, sig);
                }
                if (!$assertionsDisabled && sigs.indexOf(null) != -1) {
                    throw new AssertionError((Object)String.format("need to add an apply() method to %s that takes %d %s arguments ", InvocationPlugin.class.getName(), sigs.indexOf(null), ValueNode.class.getSimpleName()));
                }
            }
            SIGS = (Class[][])sigs.toArray((T[])new Class[sigs.size()][]);
        }
    }

    static class InvocationPluginRegistrationError
    extends GraalError {
        InvocationPluginRegistrationError(Throwable cause) {
            super(cause);
        }
    }

    static class LateClassPlugins
    extends ClassPlugins {
        static final String CLOSED_LATE_CLASS_PLUGIN = "-----";
        private final String className;
        private final LateClassPlugins next;

        LateClassPlugins(LateClassPlugins next, String className) {
            assert (next == null || next.className != CLOSED_LATE_CLASS_PLUGIN) : "Late registration of invocation plugins is closed";
            this.next = next;
            this.className = className;
        }
    }

    static class ClassPlugins {
        final EconomicMap<String, InvocationPlugin> invocationPlugins = EconomicMap.create((Equivalence)Equivalence.DEFAULT);

        ClassPlugins() {
        }

        InvocationPlugin get(ResolvedJavaMethod method) {
            assert (!method.isBridge());
            InvocationPlugin plugin = (InvocationPlugin)this.invocationPlugins.get((Object)method.getName());
            while (plugin != null) {
                if (plugin.match(method)) {
                    return plugin;
                }
                plugin = plugin.next;
            }
            return null;
        }

        public void register(InvocationPlugin plugin, boolean allowOverwrite) {
            if (allowOverwrite) {
                if (this.lookup(plugin) != null) {
                    this.register(plugin);
                    return;
                }
            } else assert (this.lookup(plugin) == null) : "a value is already registered for " + plugin.getMethodNameWithArgumentsDescriptor();
            this.register(plugin);
        }

        InvocationPlugin lookup(InvocationPlugin plugin) {
            InvocationPlugin registeredPlugin = (InvocationPlugin)this.invocationPlugins.get((Object)plugin.name);
            while (registeredPlugin != null) {
                if (registeredPlugin.match(plugin)) {
                    return registeredPlugin;
                }
                registeredPlugin = registeredPlugin.next;
            }
            return null;
        }

        void register(InvocationPlugin plugin) {
            InvocationPlugin head = (InvocationPlugin)this.invocationPlugins.get((Object)plugin.name);
            assert (plugin.next == null);
            plugin.next = head;
            this.invocationPlugins.put((Object)plugin.name, (Object)plugin);
        }

        void collectInvocationPluginsTo(List<InvocationPlugin> collection) {
            MapCursor plugins = this.invocationPlugins.getEntries();
            while (plugins.advance()) {
                InvocationPlugin plugin = (InvocationPlugin)plugins.getValue();
                while (plugin != null) {
                    collection.add(plugin);
                    plugin = plugin.next;
                }
            }
        }
    }

    public static class LateRegistration
    implements AutoCloseable {
        private InvocationPlugins plugins;
        private final List<InvocationPlugin> invocationPlugins = new ArrayList<InvocationPlugin>();
        private final Type declaringType;

        public LateRegistration(InvocationPlugins plugins, Type declaringType) {
            this.plugins = plugins;
            this.declaringType = declaringType;
        }

        public void register(InvocationPlugin plugin) {
            assert (this.plugins != null) : String.format("Late registrations of invocation plugins for %s is already closed", this.declaringType);
            if (!plugin.isStatic) {
                plugin.rewriteReceiverType(this.declaringType);
            }
            this.invocationPlugins.add(plugin);
            assert (Services.IS_IN_NATIVE_IMAGE || Checks.check(this.plugins, this.declaringType, plugin));
            assert (Services.IS_IN_NATIVE_IMAGE || Checks.checkResolvable(this.declaringType, plugin));
        }

        @Override
        public void close() {
            assert (this.plugins != null) : String.format("Late registrations of invocation plugins for %s is already closed", this.declaringType);
            this.plugins.registerLate(this.declaringType, this.invocationPlugins);
            this.plugins = null;
        }
    }

    public static class Registration {
        private final InvocationPlugins plugins;
        private final Type declaringType;
        private final Replacements replacements;
        private boolean allowOverwrite;

        public Class<?> getReceiverType() {
            return InvocationPlugin.Receiver.class;
        }

        public Type getDeclaringType() {
            return this.declaringType;
        }

        public Registration(InvocationPlugins plugins, Type declaringType) {
            this.plugins = plugins;
            this.declaringType = declaringType;
            this.replacements = null;
        }

        public Registration(InvocationPlugins plugins, Type declaringType, Replacements replacements) {
            this.plugins = plugins;
            this.declaringType = declaringType;
            this.replacements = replacements;
        }

        public Registration(InvocationPlugins plugins, String declaringClassName) {
            this.plugins = plugins;
            this.declaringType = new OptionalLazySymbol(declaringClassName);
            this.replacements = null;
        }

        public Registration(InvocationPlugins plugins, String declaringClassName, Replacements replacements) {
            this.plugins = plugins;
            this.declaringType = new OptionalLazySymbol(declaringClassName);
            this.replacements = replacements;
        }

        public Registration setAllowOverwrite(boolean allowOverwrite) {
            this.allowOverwrite = allowOverwrite;
            return this;
        }

        public void register(InvocationPlugin plugin) {
            this.plugins.register(this.declaringType, plugin, this.allowOverwrite);
        }

        public void registerConditional(boolean isEnabled, InvocationPlugin plugin) {
            this.replacements.registerConditionalPlugin(plugin);
            if (isEnabled) {
                this.plugins.register(this.declaringType, plugin, this.allowOverwrite);
            }
        }
    }

    static class OptionalLazySymbol
    implements Type {
        private static final Class<?> MASK_NULL = OptionalLazySymbol.class;
        private final String name;
        private Class<?> resolved;

        OptionalLazySymbol(String name) {
            this.name = name;
            if (Services.IS_BUILDING_NATIVE_IMAGE) {
                this.resolve();
            }
        }

        @Override
        public String getTypeName() {
            return this.name;
        }

        public Class<?> resolve() {
            if (!Services.IS_IN_NATIVE_IMAGE && this.resolved == null) {
                Class<?> resolvedOrNull = InvocationPlugins.resolveClass(this.name, true);
                this.resolved = resolvedOrNull == null ? MASK_NULL : resolvedOrNull;
            }
            return this.resolved == MASK_NULL ? null : this.resolved;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ResolvedJavaSymbol
    implements Type {
        private final ResolvedJavaType resolved;

        public ResolvedJavaSymbol(ResolvedJavaType type) {
            this.resolved = type;
        }

        public ResolvedJavaType getResolved() {
            return this.resolved;
        }

        public String toString() {
            return this.resolved.toJavaName();
        }
    }

    public static class InvocationPluginReceiver
    implements InvocationPlugin.Receiver {
        private final GraphBuilderContext parser;
        private ValueNode[] args;
        private ValueNode value;

        public InvocationPluginReceiver(GraphBuilderContext parser) {
            this.parser = parser;
        }

        @Override
        public ValueNode get(boolean performNullCheck) {
            assert (this.args != null) : "Cannot get the receiver of a static method";
            if (!performNullCheck) {
                return this.args[0];
            }
            if (this.value == null) {
                this.value = this.parser.nullCheckedValue(this.args[0]);
                if (this.value != this.args[0]) {
                    this.args[0] = this.value;
                }
            }
            return this.value;
        }

        @Override
        public boolean isConstant() {
            return this.args[0].isConstant();
        }

        public InvocationPluginReceiver init(ResolvedJavaMethod targetMethod, ValueNode[] newArgs) {
            if (!targetMethod.isStatic()) {
                this.args = newArgs;
                this.value = null;
                return this;
            }
            return null;
        }
    }

    public static class Options {
        public static final OptionKey<String> DisableIntrinsics = new OptionKey<Object>(null);
    }
}

