/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.loop;

import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.core.common.util.UnsignedLong;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.debug.ControlFlowAnchorNode;
import org.graalvm.compiler.nodes.extended.ForeignCall;
import org.graalvm.compiler.nodes.loop.CountedLoopInfo;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopPolicies;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;

public class DefaultLoopPolicies
implements LoopPolicies {
    @Override
    public boolean shouldPeel(LoopEx loop, ControlFlowGraph cfg, CoreProviders providers, int peelingIteration) {
        StructuredGraph graph;
        OptionValues options;
        if (peelingIteration > 0) {
            return false;
        }
        LoopBeginNode loopBegin = loop.loopBegin();
        double entryProbability = cfg.blockFor(loopBegin.forwardEnd()).getRelativeFrequency();
        if (entryProbability < (double)GraalOptions.MinimumPeelFrequency.getValue(options = (graph = cfg.graph).getOptions()).floatValue()) {
            return false;
        }
        if (loop.parent() != null && loop.size() > loop.parent().size() >> 1) {
            return false;
        }
        if (loop.loop().getChildren().size() > 0) {
            return false;
        }
        return loop.size() + graph.getNodeCount() <= GraalOptions.MaximumDesiredSize.getValue(options);
    }

    public FullUnrollability canFullUnroll(LoopEx loop) {
        if (!(loop.isCounted() && loop.counted().isConstantMaxTripCount() && loop.counted().counterNeverOverflows())) {
            return FullUnrollability.NOT_COUNTED;
        }
        if (!loop.canDuplicateLoop()) {
            return FullUnrollability.MUST_NOT_DUPLICATE;
        }
        OptionValues options = loop.entryPoint().getOptions();
        CountedLoopInfo counted = loop.counted();
        UnsignedLong maxTrips = counted.constantMaxTripCount();
        if (maxTrips.equals(0L)) {
            return FullUnrollability.SHOULD_FULL_UNROLL;
        }
        if (maxTrips.isGreaterThan(Options.FullUnrollMaxIterations.getValue(options).intValue())) {
            return FullUnrollability.TOO_MANY_ITERATIONS;
        }
        int globalMax = GraalOptions.MaximumDesiredSize.getValue(options) - loop.loopBegin().graph().getNodeCount();
        if (globalMax <= 0) {
            return FullUnrollability.TOO_LARGE;
        }
        int maxNodes = counted.isExactTripCount() ? Options.ExactFullUnrollMaxNodes.getValue(options) : Options.FullUnrollMaxNodes.getValue(options);
        for (Node usage : counted.getLimitCheckedIV().valueNode().usages()) {
            CompareNode compare;
            if (!(usage instanceof CompareNode) || !(compare = (CompareNode)usage).getY().isConstant()) continue;
            maxNodes += Options.FullUnrollConstantCompareBoost.getValue(options).intValue();
        }
        maxNodes = Math.min(maxNodes, globalMax);
        int size = loop.inside().nodes().count();
        size -= 2;
        GraalError.guarantee((size -= loop.loopBegin().loopEnds().count()) >= 0, "Wrong size");
        if (maxTrips.minus(1L).times(size).isLessOrEqualTo(maxNodes)) {
            return FullUnrollability.SHOULD_FULL_UNROLL;
        }
        return FullUnrollability.TOO_LARGE;
    }

    @Override
    public boolean shouldFullUnroll(LoopEx loop) {
        return this.canFullUnroll(loop) == FullUnrollability.SHOULD_FULL_UNROLL;
    }

    @Override
    public boolean shouldPartiallyUnroll(LoopEx loop, CoreProviders providers) {
        LoopBeginNode loopBegin = loop.loopBegin();
        if (!loop.isCounted()) {
            loopBegin.getDebug().log(3, "shouldPartiallyUnroll %s isn't counted", (Object)loopBegin);
            return false;
        }
        OptionValues options = loop.entryPoint().getOptions();
        int maxNodes = Options.ExactPartialUnrollMaxNodes.getValue(options);
        maxNodes = Math.min(maxNodes, Math.max(0, GraalOptions.MaximumDesiredSize.getValue(options) - loop.loopBegin().graph().getNodeCount()));
        int size = Math.max(1, loop.size() - 1 - loop.loopBegin().phis().count());
        int unrollFactor = loopBegin.getUnrollFactor();
        if (unrollFactor == 1) {
            double loopFrequency = loop.localLoopFrequency();
            if (loopBegin.isSimpleLoop() && loopFrequency < 5.0) {
                loopBegin.getDebug().log(3, "shouldPartiallyUnroll %s frequency too low %s ", (Object)loopBegin, (Object)loopFrequency);
                return false;
            }
            loopBegin.setLoopOrigFrequency(loopFrequency);
        }
        int maxUnroll = Options.UnrollMaxIterations.getValue(options);
        size += size;
        if (maxUnroll == 1 && loopBegin.isSimpleLoop() || size <= maxNodes && unrollFactor < maxUnroll) {
            if ((int)loopBegin.loopOrigFrequency() < unrollFactor * 2) {
                return false;
            }
            for (Node node : loop.inside().nodes()) {
                if (node instanceof ControlFlowAnchorNode) {
                    return false;
                }
                if (!(node instanceof Invoke) && !(node instanceof ForeignCall)) continue;
                return false;
            }
            return true;
        }
        loopBegin.getDebug().log(3, "shouldPartiallyUnroll %s unrolled loop is too large %s ", (Object)loopBegin, size);
        return false;
    }

    @Override
    public boolean shouldTryUnswitch(LoopEx loop) {
        LoopBeginNode loopBegin = loop.loopBegin();
        double loopFrequency = loop.localLoopFrequency();
        if (loopFrequency <= 1.0) {
            return false;
        }
        OptionValues options = loop.entryPoint().getOptions();
        return loopBegin.unswitches() < GraalOptions.LoopMaxUnswitch.getValue(options);
    }

    private static int approxCodeSizeChange(LoopEx loop, List<ControlSplitNode> controlSplits) {
        StructuredGraph graph = loop.loopBegin().graph();
        NodeBitMap branchNodes = graph.createNodeBitMap();
        for (ControlSplitNode controlSplit : controlSplits) {
            for (Node successor : controlSplit.successors()) {
                AbstractBeginNode branch = (AbstractBeginNode)successor;
                loop.nodesInLoopBranch(branchNodes, branch);
            }
        }
        int inBranchTotal = branchNodes.count();
        int loopTotal = loop.size();
        int diff = loopTotal - inBranchTotal;
        ControlSplitNode firstSplit = controlSplits.get(0);
        int copies = firstSplit.successors().count() - 1;
        return diff *= copies;
    }

    private static double splitLocalLoopFrequency(LoopEx loop, List<ControlSplitNode> controlSplits) {
        int loopDepth = loop.loop().getDepth();
        double loopLocalFrequency = loop.localLoopFrequency();
        ControlFlowGraph cfg = loop.loopsData().getCFG();
        double loopRelativeFrequency = cfg.blockFor(loop.loopBegin()).getRelativeFrequency();
        double freq = 0.0;
        for (ControlSplitNode node : controlSplits) {
            Block b = cfg.blockFor(node);
            double f = b.getRelativeFrequency();
            Loop<Block> l = b.getLoop();
            while (l.getDepth() > loopDepth) {
                f /= loop.loopsData().loop(l).localLoopFrequency();
                l = l.getParent();
            }
            freq += f;
        }
        return freq / loopRelativeFrequency * loopLocalFrequency;
    }

    private static int loopMaxCodeSizeChange(LoopEx loop) {
        StructuredGraph graph = loop.loopBegin().graph();
        double loopFrequency = loop.localLoopFrequency();
        OptionValues options = loop.loopBegin().getOptions();
        int maxDiff = Options.LoopUnswitchTrivial.getValue(options) + (int)(Options.LoopUnswitchFrequencyBoost.getValue(options) * (loopFrequency - 1.0));
        maxDiff = Math.min(maxDiff, Options.LoopUnswitchMaxIncrease.getValue(options));
        int remainingGraphSpace = GraalOptions.MaximumDesiredSize.getValue(options) - graph.getNodeCount();
        return Math.min(maxDiff, remainingGraphSpace);
    }

    @Override
    public LoopPolicies.UnswitchingDecision shouldUnswitch(LoopEx loop, EconomicMap<ValueNode, List<ControlSplitNode>> controlSplits) {
        if (loop.loopBegin().unswitches() >= GraalOptions.LoopMaxUnswitch.getValue(loop.loopBegin().graph().getOptions())) {
            return LoopPolicies.UnswitchingDecision.NO;
        }
        if (!loop.canDuplicateLoop()) {
            return LoopPolicies.UnswitchingDecision.NO;
        }
        DebugContext debug = loop.loopBegin().getDebug();
        OptionValues options = debug.getOptions();
        double localLoopFrequency = loop.localLoopFrequency();
        int loopSize = loop.size();
        int loopMaxCodeSizeChange = DefaultLoopPolicies.loopMaxCodeSizeChange(loop);
        List bestSplit = null;
        double bestSplitFrequency = 0.0;
        int bestCodeSizeChange = 0;
        double bestFactor = 0.0;
        for (List split : controlSplits.getValues()) {
            int approxCodeSizeChange;
            boolean isTrusted = true;
            for (ControlSplitNode node : split) {
                isTrusted = isTrusted && ProfileData.ProfileSource.isTrusted(node.getProfileData().getProfileSource());
            }
            if (!isTrusted) {
                debug.log("control split %s discarded because unknown profile data", split);
            }
            if ((approxCodeSizeChange = DefaultLoopPolicies.approxCodeSizeChange(loop, split)) > loopMaxCodeSizeChange) {
                debug.log("control split %s discarded because the code size difference is too big, loop size=%d, loop f=%.2f, max diff=%d, diff=%d, relative code size diff=%d%%", split, (Object)loopSize, (Object)localLoopFrequency, (Object)loopMaxCodeSizeChange, (Object)approxCodeSizeChange, (Object)((int)(100.0 * (double)approxCodeSizeChange / (double)loopSize)));
                continue;
            }
            double splitFrequency = DefaultLoopPolicies.splitLocalLoopFrequency(loop, split);
            if (splitFrequency < Options.LoopUnswitchMinSplitFrequency.getValue(options)) {
                debug.log("control split %s discarded because infrequent, f=%.2f", (Object)split, (Object)splitFrequency);
                continue;
            }
            double factor = Math.pow(((ControlSplitNode)split.get(0)).getSuccessorCount(), ((ControlSplitNode)split.get(0)).getSuccessorCount() * split.size());
            for (ControlSplitNode s : split) {
                for (double p : s.successorProbabilities()) {
                    factor *= p;
                }
            }
            assert (0.0 <= factor && factor <= 1.0) : "factor shold be between 0 and 1, but is : " + factor;
            double cappedFactor = 1.0 - Math.min(Math.max(factor, Options.LoopUnswitchFrequencyMinFactor.getValue(options)), Options.LoopUnswitchFrequencyMaxFactor.getValue(options));
            if (splitFrequency < cappedFactor * localLoopFrequency) {
                debug.log("control split %s not frequenct enough with respect to factor, factor=%.2f, split f=%.2f, loop f=%.2f", split, (Object)cappedFactor, (Object)splitFrequency, (Object)localLoopFrequency);
                continue;
            }
            if (!(splitFrequency > bestSplitFrequency)) continue;
            bestSplitFrequency = splitFrequency;
            bestSplit = split;
            bestCodeSizeChange = approxCodeSizeChange;
            bestFactor = cappedFactor;
        }
        if (bestSplit != null) {
            debug.log("shouldUnswitch(%s, %s) : best=%s, loop size=%d, f=%.2f, max=%d, delta=%d, invariant f=%.2f, factor=%.2f", loop, controlSplits, bestSplit, (Object)loopSize, (Object)localLoopFrequency, (Object)loopMaxCodeSizeChange, (Object)bestCodeSizeChange, (Object)bestSplitFrequency, (Object)bestFactor);
            return LoopPolicies.UnswitchingDecision.yes(bestSplit);
        }
        return LoopPolicies.UnswitchingDecision.NO;
    }

    public static enum FullUnrollability {
        SHOULD_FULL_UNROLL,
        NOT_COUNTED,
        MUST_NOT_DUPLICATE,
        TOO_MANY_ITERATIONS,
        TOO_LARGE;

    }

    public static class Options {
        public static final OptionKey<Integer> LoopUnswitchMaxIncrease = new OptionKey<Integer>(2000);
        public static final OptionKey<Integer> LoopUnswitchTrivial = new OptionKey<Integer>(10);
        public static final OptionKey<Double> LoopUnswitchFrequencyBoost = new OptionKey<Double>(10.0);
        public static final OptionKey<Double> LoopUnswitchFrequencyMinFactor = new OptionKey<Double>(0.05);
        public static final OptionKey<Double> LoopUnswitchFrequencyMaxFactor = new OptionKey<Double>(0.95);
        public static final OptionKey<Double> LoopUnswitchMinSplitFrequency = new OptionKey<Double>(1.0);
        public static final OptionKey<Integer> FullUnrollMaxNodes = new OptionKey<Integer>(400);
        public static final OptionKey<Integer> FullUnrollConstantCompareBoost = new OptionKey<Integer>(15);
        public static final OptionKey<Integer> FullUnrollMaxIterations = new OptionKey<Integer>(600);
        public static final OptionKey<Integer> ExactFullUnrollMaxNodes = new OptionKey<Integer>(800);
        public static final OptionKey<Integer> ExactPartialUnrollMaxNodes = new OptionKey<Integer>(200);
        public static final OptionKey<Integer> UnrollMaxIterations = new OptionKey<Integer>(16);
    }
}

