/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.memory;

import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.memory.FloatingAccessNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="OrderedRead#{p#location/s}", allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public class OrderedReadNode
extends ReadNode {
    public static final NodeClass<OrderedReadNode> TYPE = NodeClass.create(OrderedReadNode.class);
    private final MemoryOrderMode memoryOrder;

    public OrderedReadNode(AddressNode address, Stamp stamp, OnHeapMemoryAccess.BarrierType barrierType, MemoryOrderMode memoryOrder) {
        super((NodeClass<? extends ReadNode>)TYPE, address, LocationIdentity.any(), stamp, (GuardingNode)null, barrierType, false, (FrameState)null);
        assert (MemoryOrderMode.ordersMemoryAccesses(memoryOrder));
        this.memoryOrder = memoryOrder;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        LIRKind readKind = gen.getLIRGeneratorTool().getLIRKind(this.getAccessStamp(NodeView.DEFAULT));
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().getArithmetic().emitOrderedLoad(readKind, gen.operand(this.address), gen.state(this), this.memoryOrder));
    }

    @Override
    public FloatingAccessNode asFloatingNode() {
        throw new RuntimeException();
    }

    @Override
    public boolean canFloat() {
        return false;
    }

    @Override
    public MemoryOrderMode getMemoryOrder() {
        return this.memoryOrder;
    }
}

