/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.memory;

import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.gc.WriteBarrier;
import org.graalvm.compiler.nodes.java.AbstractCompareAndSwapNode;
import org.graalvm.compiler.nodes.memory.AbstractWriteNode;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.OrderedMemoryAccess;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="OrderedWrite#{p#location/s}")
public class OrderedWriteNode
extends WriteNode {
    public static final NodeClass<OrderedWriteNode> TYPE = NodeClass.create(OrderedWriteNode.class);
    private final MemoryOrderMode memoryOrder;

    public OrderedWriteNode(AddressNode address, LocationIdentity location, ValueNode value, OnHeapMemoryAccess.BarrierType barrierType, MemoryOrderMode memoryOrder) {
        super(TYPE, address, location, LocationIdentity.any(), value, barrierType);
        assert (MemoryOrderMode.ordersMemoryAccesses(memoryOrder));
        this.memoryOrder = memoryOrder;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        LIRKind writeKind = gen.getLIRGeneratorTool().getLIRKind(this.value().stamp(NodeView.DEFAULT));
        gen.getLIRGeneratorTool().getArithmetic().emitOrderedStore(writeKind, gen.operand(this.address), gen.operand(this.value()), gen.state(this), this.memoryOrder);
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    @Override
    public MemoryOrderMode getMemoryOrder() {
        return this.memoryOrder;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (tool.trySinkWriteFences() && this.getMemoryOrder() == MemoryOrderMode.VOLATILE && this.hasFollowingVolatileWrite()) {
            OrderedWriteNode writeRelease = this.graph().add(new OrderedWriteNode(this.getAddress(), this.getLocationIdentity(), this.value(), this.getBarrierType(), MemoryOrderMode.RELEASE));
            writeRelease.setLastLocationAccess(writeRelease.getLastLocationAccess());
            this.graph().replaceFixedWithFixed(this, writeRelease);
            tool.addToWorkList(writeRelease);
        }
    }

    private boolean hasFollowingVolatileWrite() {
        FixedWithNextNode cur = this;
        while (true) {
            for (Node usage : cur.usages()) {
                if (usage instanceof MemoryAccess && usage instanceof FixedWithNextNode) continue;
                return false;
            }
            FixedNode nextNode = cur.next();
            while (nextNode instanceof WriteBarrier) {
                nextNode = ((WriteBarrier)nextNode).next();
            }
            if (!(nextNode instanceof OrderedMemoryAccess) || !(nextNode instanceof AbstractWriteNode) && !(nextNode instanceof AbstractCompareAndSwapNode)) break;
            if (((OrderedMemoryAccess)((Object)nextNode)).getMemoryOrder() == MemoryOrderMode.VOLATILE) {
                return true;
            }
            cur = (FixedWithNextNode)nextNode;
        }
        return false;
    }
}

