/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.util;

import java.nio.ByteOrder;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;

public final class ConstantReflectionUtil {
    private ConstantReflectionUtil() {
    }

    public static byte[] loadByteArrayConstant(ConstantReflectionProvider crp, JavaConstant targetArg, int maxLength) {
        int targetArgLength = Integer.min(maxLength, crp.readArrayLength(targetArg));
        byte[] targetByteArray = new byte[targetArgLength];
        for (int i = 0; i < targetArgLength; ++i) {
            targetByteArray[i] = (byte)crp.readArrayElement(targetArg, i).asInt();
        }
        return targetByteArray;
    }

    public static char[] loadCharArrayConstant(ConstantReflectionProvider crp, JavaConstant targetArg, int maxLength) {
        int targetArgLength = Integer.min(maxLength, crp.readArrayLength(targetArg));
        char[] targetCharArray = new char[targetArgLength];
        for (int i = 0; i < targetArgLength; ++i) {
            targetCharArray[i] = (char)crp.readArrayElement(targetArg, i).asInt();
        }
        return targetCharArray;
    }

    public static int[] loadIntArrayConstant(ConstantReflectionProvider crp, JavaConstant targetArg, int maxLength) {
        int targetArgLength = Integer.min(maxLength, crp.readArrayLength(targetArg));
        int[] targetCharArray = new int[targetArgLength];
        for (int i = 0; i < targetArgLength; ++i) {
            targetCharArray[i] = (char)crp.readArrayElement(targetArg, i).asInt();
        }
        return targetCharArray;
    }

    public static int readTypePunned(ConstantReflectionProvider provider, JavaConstant array, JavaKind arrayKind, JavaKind stride, int index) {
        assert (arrayKind == JavaKind.Byte || arrayKind == JavaKind.Char || arrayKind == JavaKind.Int);
        assert (stride == JavaKind.Byte || stride == JavaKind.Char || stride == JavaKind.Int);
        assert (stride.getByteCount() >= arrayKind.getByteCount());
        if (arrayKind == JavaKind.Byte) {
            int i = index * stride.getByteCount();
            if (stride == JavaKind.Byte) {
                return provider.readArrayElement(array, i).asInt() & 0xFF;
            }
            if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
                if (stride == JavaKind.Char) {
                    return provider.readArrayElement(array, i).asInt() & 0xFF | (provider.readArrayElement(array, i + 1).asInt() & 0xFF) << 8;
                }
                return provider.readArrayElement(array, i).asInt() & 0xFF | (provider.readArrayElement(array, i + 1).asInt() & 0xFF) << 8 | (provider.readArrayElement(array, i + 2).asInt() & 0xFF) << 16 | (provider.readArrayElement(array, i + 3).asInt() & 0xFF) << 24;
            }
            if (stride == JavaKind.Char) {
                return provider.readArrayElement(array, i + 1).asInt() & 0xFF | (provider.readArrayElement(array, i).asInt() & 0xFF) << 8;
            }
            return provider.readArrayElement(array, i + 3).asInt() & 0xFF | (provider.readArrayElement(array, i + 2).asInt() & 0xFF) << 8 | (provider.readArrayElement(array, i + 1).asInt() & 0xFF) << 16 | (provider.readArrayElement(array, i).asInt() & 0xFF) << 24;
        }
        if (arrayKind == JavaKind.Char) {
            if (stride == JavaKind.Char) {
                return provider.readArrayElement(array, index).asInt() & 0xFFFF;
            }
            assert (stride == JavaKind.Int);
            int i = index * 2;
            if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
                return provider.readArrayElement(array, i).asInt() & 0xFFFF | (provider.readArrayElement(array, i + 1).asInt() & 0xFFFF) << 16;
            }
            return provider.readArrayElement(array, i + 1).asInt() & 0xFFFF | (provider.readArrayElement(array, i).asInt() & 0xFFFF) << 16;
        }
        assert (stride == JavaKind.Int);
        return provider.readArrayElement(array, index).asInt();
    }

    public static boolean canFoldReads(CanonicalizerTool tool, ValueNode array, ValueNode offset, JavaKind stride, int len, ArrayBaseOffsetProvider arrayBaseOffsetProvider) {
        ResolvedJavaType arrayType;
        if (array.isJavaConstant() && ((ConstantNode)array).getStableDimension() >= 1 && (offset == null || offset.isJavaConstant()) && (arrayType = array.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess())).isArray()) {
            Integer arrayLength = tool.getConstantReflection().readArrayLength(array.asJavaConstant());
            if (offset == null) {
                return arrayLength != null && len <= arrayLength;
            }
            Integer index = ConstantReflectionUtil.startIndex(tool, array, offset.asJavaConstant(), stride, arrayBaseOffsetProvider);
            return arrayLength != null && index != null && index >= 0 && index + len <= arrayLength;
        }
        return false;
    }

    public static Integer startIndex(CanonicalizerTool tool, ValueNode array, JavaConstant offset, JavaKind stride, ArrayBaseOffsetProvider arrayBaseOffsetProvider) {
        JavaKind arrayKind = array.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess()).getComponentType().getJavaKind();
        long elementOffset = offset.asLong() - (long)arrayBaseOffsetProvider.getArrayBaseOffset(tool.getMetaAccess(), array, arrayKind);
        if (elementOffset % (long)stride.getByteCount() != 0L) {
            return null;
        }
        return (int)(elementOffset / (long)stride.getByteCount());
    }

    public static interface ArrayBaseOffsetProvider {
        public int getArrayBaseOffset(MetaAccessProvider var1, ValueNode var2, JavaKind var3);
    }
}

