/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases;

import java.util.EnumSet;
import java.util.Set;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.ProfilingInfo;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.options.OptionValues;

public final class OptimisticOptimizations {
    public static final OptimisticOptimizations ALL = new OptimisticOptimizations(EnumSet.allOf(Optimization.class));
    public static final OptimisticOptimizations NONE = new OptimisticOptimizations(EnumSet.noneOf(Optimization.class));
    private final Set<Optimization> enabledOpts;

    public OptimisticOptimizations(ProfilingInfo info, OptionValues options) {
        this.enabledOpts = EnumSet.noneOf(Optimization.class);
        this.enabledOpts.add(Optimization.UseExceptionProbabilityForOperations);
        this.addOptimization(options, info, DeoptimizationReason.UnreachedCode, Optimization.RemoveNeverExecutedCode);
        this.addOptimization(options, info, DeoptimizationReason.TypeCheckedInliningViolated, Optimization.UseTypeCheckedInlining);
        this.addOptimization(options, info, DeoptimizationReason.OptimizedTypeCheckViolated, Optimization.UseTypeCheckHints);
        this.addOptimization(options, info, DeoptimizationReason.NotCompiledExceptionHandler, Optimization.UseExceptionProbability);
        this.addOptimization(options, info, DeoptimizationReason.LoopLimitCheck, Optimization.UseLoopLimitChecks);
    }

    private void addOptimization(OptionValues options, ProfilingInfo info, DeoptimizationReason deoptReason, Optimization optimization) {
        if (OptimisticOptimizations.checkDeoptimizations(options, info, deoptReason)) {
            this.enabledOpts.add(optimization);
        }
    }

    public OptimisticOptimizations remove(Optimization ... optimizations) {
        EnumSet<Optimization> newOptimizations = EnumSet.copyOf(this.enabledOpts);
        for (Optimization o : optimizations) {
            newOptimizations.remove((Object)o);
        }
        return new OptimisticOptimizations(newOptimizations);
    }

    public OptimisticOptimizations add(Optimization ... optimizations) {
        EnumSet<Optimization> newOptimizations = EnumSet.copyOf(this.enabledOpts);
        for (Optimization o : optimizations) {
            newOptimizations.add(o);
        }
        return new OptimisticOptimizations(newOptimizations);
    }

    private OptimisticOptimizations(Set<Optimization> enabledOpts) {
        this.enabledOpts = enabledOpts;
    }

    public boolean removeNeverExecutedCode(OptionValues options) {
        return GraalOptions.RemoveNeverExecutedCode.getValue(options) != false && this.enabledOpts.contains((Object)Optimization.RemoveNeverExecutedCode);
    }

    public boolean useTypeCheckHints(OptionValues options) {
        return GraalOptions.UseTypeCheckHints.getValue(options) != false && this.enabledOpts.contains((Object)Optimization.UseTypeCheckHints);
    }

    public boolean inlineMonomorphicCalls(OptionValues options) {
        return GraalOptions.InlineMonomorphicCalls.getValue(options) != false && this.enabledOpts.contains((Object)Optimization.UseTypeCheckedInlining);
    }

    public boolean inlinePolymorphicCalls(OptionValues options) {
        return GraalOptions.InlinePolymorphicCalls.getValue(options) != false && this.enabledOpts.contains((Object)Optimization.UseTypeCheckedInlining);
    }

    public boolean inlineMegamorphicCalls(OptionValues options) {
        return GraalOptions.InlineMegamorphicCalls.getValue(options) != false && this.enabledOpts.contains((Object)Optimization.UseTypeCheckedInlining);
    }

    public boolean devirtualizeInvokes(OptionValues options) {
        return GraalOptions.OptDevirtualizeInvokesOptimistically.getValue(options) != false && this.enabledOpts.contains((Object)Optimization.UseTypeCheckedInlining);
    }

    public boolean useExceptionProbability(OptionValues options) {
        return GraalOptions.UseExceptionProbability.getValue(options) != false && this.enabledOpts.contains((Object)Optimization.UseExceptionProbability);
    }

    public boolean useExceptionProbabilityForOperations() {
        return this.enabledOpts.contains((Object)Optimization.UseExceptionProbabilityForOperations);
    }

    public boolean useLoopLimitChecks(OptionValues options) {
        return GraalOptions.UseLoopLimitChecks.getValue(options) != false && this.enabledOpts.contains((Object)Optimization.UseLoopLimitChecks);
    }

    public boolean lessOptimisticThan(OptimisticOptimizations other) {
        for (Optimization opt : Optimization.values()) {
            if (this.enabledOpts.contains((Object)opt) || !other.enabledOpts.contains((Object)opt)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkDeoptimizations(OptionValues options, ProfilingInfo profilingInfo, DeoptimizationReason reason) {
        return profilingInfo == null || profilingInfo.getDeoptimizationCount(reason) < GraalOptions.DeoptsToDisableOptimisticOptimization.getValue(options);
    }

    public String toString() {
        return this.enabledOpts.toString();
    }

    public static enum Optimization {
        RemoveNeverExecutedCode,
        UseTypeCheckedInlining,
        UseTypeCheckHints,
        UseExceptionProbabilityForOperations,
        UseExceptionProbability,
        UseLoopLimitChecks;

    }
}

