/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.meta.TriState;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.NodeStack;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BinaryOpLogicNode;
import org.graalvm.compiler.nodes.ConditionAnchorNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.DeoptimizingGuard;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StaticDeoptimizingNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnaryOpLogicNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.extended.IntegerSwitchNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.extended.ValueAnchorNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.TypeSwitchNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.NodeWithState;
import org.graalvm.compiler.nodes.spi.StampInverter;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.ConditionalEliminationUtil;
import org.graalvm.compiler.phases.schedule.SchedulePhase;

public class ConditionalEliminationPhase
extends BasePhase<CoreProviders> {
    private static final CounterKey counterStampsRegistered = DebugContext.counter("StampsRegistered");
    private static final CounterKey counterIfsKilled = DebugContext.counter("CE_KilledIfs");
    private static final CounterKey counterPhiStampsImproved = DebugContext.counter("CE_ImprovedPhis");
    private final boolean fullSchedule;
    private final boolean moveGuards;

    public ConditionalEliminationPhase(boolean fullSchedule) {
        this(fullSchedule, true);
    }

    public ConditionalEliminationPhase(boolean fullSchedule, boolean moveGuards) {
        this.fullSchedule = fullSchedule;
        this.moveGuards = moveGuards;
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        try (DebugContext.Scope s = graph.getDebug().scope("DominatorConditionalElimination");){
            BlockMap<List<Node>> blockToNodes = null;
            NodeMap<Block> nodeToBlock = null;
            ControlFlowGraph cfg = ControlFlowGraph.compute(graph, true, true, true, true);
            if (this.fullSchedule) {
                if (this.moveGuards && Options.MoveGuardsUpwards.getValue(graph.getOptions()).booleanValue()) {
                    cfg.visitDominatorTree(new MoveGuardsUpwards(), graph.isBeforeStage(StructuredGraph.StageFlag.VALUE_PROXY_REMOVAL));
                }
                try (DebugContext.Scope scheduleScope = graph.getDebug().scope(SchedulePhase.class);){
                    SchedulePhase.run(graph, SchedulePhase.SchedulingStrategy.EARLIEST_WITH_GUARD_ORDER, cfg, context, false);
                }
                catch (Throwable t) {
                    throw graph.getDebug().handle(t);
                }
                StructuredGraph.ScheduleResult r = graph.getLastSchedule();
                blockToNodes = r.getBlockToNodesMap();
                nodeToBlock = r.getNodeToBlockMap();
            } else {
                nodeToBlock = cfg.getNodeToBlock();
                blockToNodes = this.getBlockToNodes(cfg);
            }
            ControlFlowGraph.RecursiveVisitor<?> visitor = this.createVisitor(graph, cfg, blockToNodes, nodeToBlock, context);
            cfg.visitDominatorTree(visitor, graph.isBeforeStage(StructuredGraph.StageFlag.VALUE_PROXY_REMOVAL));
        }
    }

    protected BlockMap<List<Node>> getBlockToNodes(ControlFlowGraph cfg) {
        return null;
    }

    protected ControlFlowGraph.RecursiveVisitor<?> createVisitor(StructuredGraph graph, ControlFlowGraph cfg, BlockMap<List<Node>> blockToNodes, NodeMap<Block> nodeToBlock, CoreProviders context) {
        return new Instance(graph, blockToNodes, nodeToBlock, context);
    }

    @Override
    public float codeSizeIncrease() {
        return 1.5f;
    }

    public static class Instance
    implements ControlFlowGraph.RecursiveVisitor<ConditionalEliminationUtil.Marks> {
        protected final NodeMap<ConditionalEliminationUtil.InfoElement> map;
        protected final BlockMap<List<Node>> blockToNodes;
        protected final NodeMap<Block> nodeToBlock;
        protected final CanonicalizerTool tool;
        protected final NodeStack undoOperations;
        protected final StructuredGraph graph;
        protected final DebugContext debug;
        protected final EconomicMap<MergeNode, EconomicMap<ValuePhiNode, PhiInfoElement>> mergeMaps;
        private final ConditionalEliminationUtil.InfoElementProvider infoElementProvider;
        private final ConditionalEliminationUtil.GuardFolding guardFolding;
        protected final ArrayDeque<ConditionalEliminationUtil.GuardedCondition> conditions;
        private Deque<DeoptimizingGuard> pendingTests;

        public Instance(StructuredGraph graph, BlockMap<List<Node>> blockToNodes, NodeMap<Block> nodeToBlock, CoreProviders context) {
            this.graph = graph;
            this.debug = graph.getDebug();
            this.blockToNodes = blockToNodes;
            this.nodeToBlock = nodeToBlock;
            this.undoOperations = new NodeStack();
            this.map = graph.createNodeMap();
            this.pendingTests = new ArrayDeque<DeoptimizingGuard>();
            this.conditions = new ArrayDeque();
            this.tool = GraphUtil.getDefaultSimplifier(context, false, graph.getAssumptions(), graph.getOptions());
            this.mergeMaps = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
            this.infoElementProvider = new ConditionalEliminationUtil.InfoElementProvider(){

                @Override
                public ConditionalEliminationUtil.InfoElement infoElements(ValueNode value) {
                    return this.getInfoElements(value);
                }
            };
            this.guardFolding = new ConditionalEliminationUtil.GuardFolding(){

                @Override
                public boolean foldGuard(DeoptimizingGuard thisGuard, ValueNode original, Stamp newStamp, ConditionalEliminationUtil.GuardRewirer rewireGuardFunction) {
                    return this.foldPendingTest(thisGuard, original, newStamp, rewireGuardFunction);
                }
            };
        }

        protected void processConditionAnchor(ConditionAnchorNode node) {
            this.tryProveGuardCondition(null, node.condition(), (guard, result, guardedValueStamp, newInput) -> {
                if (result != node.isNegated()) {
                    node.replaceAtUsages(guard.asNode());
                    GraphUtil.unlinkFixedNode(node);
                    GraphUtil.killWithUnusedFloatingInputs(node);
                } else {
                    ValueAnchorNode valueAnchor = node.graph().add(new ValueAnchorNode(null));
                    node.replaceAtUsages(valueAnchor);
                    node.graph().replaceFixedWithFixed(node, valueAnchor);
                }
                return true;
            });
        }

        protected void processGuard(GuardNode node) {
            if (!this.tryProveGuardCondition(node, node.getCondition(), (guard, result, guardedValueStamp, newInput) -> {
                if (result != node.isNegated()) {
                    node.replaceAndDelete(guard.asNode());
                    if (guard instanceof DeoptimizingGuard && !((DeoptimizingGuard)guard).isNegated()) {
                        this.rebuildPiNodes((DeoptimizingGuard)guard);
                    }
                } else {
                    AbstractBeginNode beginNode = (AbstractBeginNode)node.getAnchor();
                    if (!(beginNode.next() instanceof DeoptimizeNode)) {
                        FixedGuardNode deopt = new FixedGuardNode(LogicConstantNode.forBoolean(result, node.graph()), node.getReason(), node.getAction(), node.getSpeculation(), node.isNegated(), node.getNodeSourcePosition());
                        this.graph.addAfterFixed(beginNode, node.graph().add(deopt));
                    }
                }
                return true;
            })) {
                this.registerNewCondition(node.getCondition(), node.isNegated(), node);
            }
        }

        protected void processFixedGuard(FixedGuardNode node) {
            if (!this.tryProveGuardCondition(node, node.condition(), (guard, result, guardedValueStamp, newInput) -> {
                if (result != node.isNegated()) {
                    node.replaceAtUsages(guard.asNode());
                    GraphUtil.unlinkFixedNode(node);
                    GraphUtil.killWithUnusedFloatingInputs(node);
                    this.debug.dump(5, this.graph, "Killed fixed %s guard because of %s", node, guard);
                    if (guard instanceof DeoptimizingGuard && !((DeoptimizingGuard)guard).isNegated()) {
                        this.rebuildPiNodes((DeoptimizingGuard)guard);
                    }
                    this.debug.log("Kill fixed guard %s because of %s", (Object)node, (Object)guard);
                } else {
                    node.setCondition(LogicConstantNode.forBoolean(result, node.graph()), node.isNegated());
                    this.debug.log("Set condition on fixed guard %s to be delted because of %s", (Object)node, (Object)guard);
                    this.debug.dump(5, this.graph, "Killed fixed guard %s because of %s by setting condition instead of direct kill", node, guard);
                }
                return true;
            })) {
                this.registerNewCondition(node.condition(), node.isNegated(), node);
            }
        }

        private void rebuildPiNodes(DeoptimizingGuard guard) {
            LogicNode newCondition = guard.getCondition();
            if (newCondition instanceof InstanceOfNode) {
                InstanceOfNode inst = (InstanceOfNode)newCondition;
                ValueNode originalValue = GraphUtil.skipPi(inst.getValue());
                ValueNode pi = null;
                for (PiNode existing : guard.asNode().usages().filter(PiNode.class).snapshot()) {
                    boolean differentObject;
                    if (!existing.isAlive() || originalValue != GraphUtil.skipPi(existing.object())) continue;
                    boolean strongerStamp = !existing.piStamp().join(inst.getCheckedStamp()).equals(inst.getCheckedStamp());
                    boolean differentCheckedStamp = !existing.piStamp().equals(inst.getCheckedStamp());
                    boolean bl = differentObject = existing.object() != inst.getValue();
                    if (strongerStamp || !differentCheckedStamp && !differentObject) continue;
                    if (pi == null) {
                        pi = this.graph.unique(new PiNode(inst.getValue(), (Stamp)inst.getCheckedStamp(), (ValueNode)((Object)guard)));
                    }
                    if (!pi.stamp(NodeView.DEFAULT).join(existing.stamp(NodeView.DEFAULT)).equals(pi.stamp(NodeView.DEFAULT))) {
                        PiNode alternatePi;
                        if (!differentCheckedStamp || !(alternatePi = this.graph.unique(new PiNode(existing.object(), (Stamp)inst.getCheckedStamp(), (ValueNode)((Object)guard)))).stamp(NodeView.DEFAULT).join(existing.stamp(NodeView.DEFAULT)).equals(alternatePi.stamp(NodeView.DEFAULT))) continue;
                        this.graph.getDebug().dump(5, this.graph, "Rebuild pis: Before replacing %s with alternate %s", existing, alternatePi);
                        existing.replaceAndDelete(alternatePi);
                        this.graph.getDebug().dump(5, this.graph, "Rebuild pis: After replacing %s with alternate %s", existing, alternatePi);
                        continue;
                    }
                    this.graph.getDebug().dump(5, this.graph, "Rebuild pis: Before replacing %s with %s", existing, pi);
                    existing.replaceAndDelete(pi);
                    this.graph.getDebug().dump(5, this.graph, "Rebuild pis: After replacing %s with %s", existing, pi);
                }
            }
        }

        protected void processIf(IfNode node) {
            this.tryProveGuardCondition(null, node.condition(), (guard, result, guardedValueStamp, newInput) -> {
                node.setCondition(LogicConstantNode.forBoolean(result, node.graph()));
                AbstractBeginNode survivingSuccessor = node.getSuccessor(result);
                survivingSuccessor.replaceAtUsages((Node)guard.asNode(), InputType.Guard);
                counterIfsKilled.increment(this.debug);
                return true;
            });
        }

        private void processValueAnchor(ValueAnchorNode node) {
            for (Node usage : node.usages().snapshot()) {
                if (!(usage instanceof PiNode) || ((PiNode)usage).getGuard() != node) continue;
                this.tryImproveAnchoredPi((PiNode)usage);
            }
        }

        private void tryImproveAnchoredPi(PiNode piNode) {
            ConditionalEliminationUtil.InfoElement infoElement = this.infoElementProvider.infoElements(piNode.object());
            while (infoElement != null) {
                Stamp joinedStamp = infoElement.getStamp().join(piNode.piStamp());
                if (joinedStamp.equals(infoElement.getStamp())) {
                    piNode.setGuard(infoElement.getGuard());
                    return;
                }
                infoElement = this.infoElementProvider.nextElement(infoElement);
            }
            this.registerNewStamp(piNode.object(), piNode.piStamp(), piNode.getGuard());
        }

        @Override
        public ConditionalEliminationUtil.Marks enter(Block block) {
            int infoElementsMark = this.undoOperations.size();
            int conditionsMark = this.conditions.size();
            this.debug.log("[Pre Processing block %s]", block);
            this.pendingTests.clear();
            this.processNodes(block);
            return new ConditionalEliminationUtil.Marks(infoElementsMark, conditionsMark);
        }

        protected void processNodes(Block block) {
            if (this.blockToNodes != null) {
                for (Node n : this.blockToNodes.get(block)) {
                    if (!n.isAlive()) continue;
                    this.processNode(n);
                }
            } else {
                this.processBlock(block);
            }
        }

        private void processBlock(Block block) {
            FixedNode n = block.getBeginNode();
            FixedNode endNode = block.getEndNode();
            this.debug.log("[Processing block %s]", block);
            while (n != endNode) {
                if (n.isDeleted() || endNode.isDeleted()) {
                    return;
                }
                FixedNode next = ((FixedWithNextNode)n).next();
                this.processNode(n);
                n = next;
            }
            if (endNode.isAlive()) {
                this.processNode(endNode);
            }
        }

        protected void processNode(Node node) {
            try (DebugCloseable closeable = node.withNodeSourcePosition();){
                if (node instanceof NodeWithState && !(node instanceof GuardingNode)) {
                    this.pendingTests.clear();
                }
                if (node instanceof MergeNode) {
                    this.introducePisForPhis((MergeNode)node);
                }
                if (node instanceof AbstractBeginNode) {
                    if (node instanceof LoopExitNode && this.graph.isBeforeStage(StructuredGraph.StageFlag.VALUE_PROXY_REMOVAL)) {
                        return;
                    }
                    this.processAbstractBegin((AbstractBeginNode)node);
                } else if (node instanceof FixedGuardNode) {
                    this.processFixedGuard((FixedGuardNode)node);
                } else if (node instanceof GuardNode) {
                    this.processGuard((GuardNode)node);
                } else if (node instanceof ConditionAnchorNode) {
                    this.processConditionAnchor((ConditionAnchorNode)node);
                } else if (node instanceof IfNode) {
                    this.processIf((IfNode)node);
                } else if (node instanceof EndNode) {
                    this.processEnd((EndNode)node);
                } else if (node instanceof ValueAnchorNode) {
                    this.processValueAnchor((ValueAnchorNode)node);
                }
            }
        }

        protected void introducePisForPhis(MergeNode merge) {
            EconomicMap mergeMap = (EconomicMap)this.mergeMaps.get((Object)merge);
            if (mergeMap != null) {
                MapCursor entries = mergeMap.getEntries();
                while (entries.advance()) {
                    ValuePhiNode phi = (ValuePhiNode)entries.getKey();
                    assert (phi.isAlive() || phi.isDeleted());
                    if (phi.isDeleted()) continue;
                    PhiInfoElement phiInfoElements = (PhiInfoElement)entries.getValue();
                    Stamp bestPossibleStamp = null;
                    for (int i = 0; i < phi.valueCount(); ++i) {
                        ValueNode valueAt = phi.valueAt(i);
                        Stamp curBestStamp = valueAt.stamp(NodeView.DEFAULT);
                        ConditionalEliminationUtil.InfoElement infoElement = phiInfoElements.get(merge.forwardEndAt(i));
                        if (infoElement != null) {
                            curBestStamp = curBestStamp.join(infoElement.getStamp());
                        }
                        bestPossibleStamp = bestPossibleStamp == null ? curBestStamp : bestPossibleStamp.meet(curBestStamp);
                    }
                    Stamp oldStamp = phi.stamp(NodeView.DEFAULT);
                    if (oldStamp.tryImproveWith(bestPossibleStamp) == null) continue;
                    boolean allow = false;
                    if (bestPossibleStamp instanceof ObjectStamp) {
                        allow = true;
                    } else if (bestPossibleStamp instanceof IntegerStamp) {
                        IntegerStamp integerStamp = (IntegerStamp)bestPossibleStamp;
                        IntegerStamp oldIntegerStamp = (IntegerStamp)oldStamp;
                        if (integerStamp.isPositive() != oldIntegerStamp.isPositive()) {
                            allow = true;
                        } else if (integerStamp.isNegative() != oldIntegerStamp.isNegative()) {
                            allow = true;
                        } else if (integerStamp.isStrictlyPositive() != oldIntegerStamp.isStrictlyPositive()) {
                            allow = true;
                        } else if (integerStamp.isStrictlyNegative() != oldIntegerStamp.isStrictlyNegative()) {
                            allow = true;
                        } else if (integerStamp.asConstant() != null) {
                            allow = true;
                        } else if (oldStamp.isUnrestricted()) {
                            allow = true;
                        }
                    } else {
                        assert (bestPossibleStamp != null);
                        boolean bl = allow = bestPossibleStamp.asConstant() != null;
                    }
                    if (!allow) continue;
                    ValuePhiNode newPhi = this.graph.addWithoutUnique(new ValuePhiNode(bestPossibleStamp, merge));
                    for (int i = 0; i < phi.valueCount(); ++i) {
                        ValueNode valueAt = phi.valueAt(i);
                        if (!bestPossibleStamp.meet(valueAt.stamp(NodeView.DEFAULT)).equals(bestPossibleStamp)) {
                            ConditionalEliminationUtil.InfoElement infoElement = phiInfoElements.get(merge.forwardEndAt(i));
                            assert (infoElement != null);
                            Stamp curBestStamp = infoElement.getStamp();
                            ValueNode input = infoElement.getProxifiedInput();
                            if (input == null) {
                                input = valueAt;
                            }
                            valueAt = this.graph.addOrUnique(PiNode.create(input, curBestStamp, (ValueNode)((Object)infoElement.getGuard())));
                        }
                        newPhi.addInput(valueAt);
                    }
                    counterPhiStampsImproved.increment(this.debug);
                    phi.replaceAtUsagesAndDelete(newPhi);
                }
            }
        }

        protected void processEnd(EndNode end) {
            AbstractMergeNode abstractMerge = end.merge();
            if (abstractMerge instanceof MergeNode) {
                MergeNode merge = (MergeNode)abstractMerge;
                EconomicMap mergeMap = (EconomicMap)this.mergeMaps.get((Object)merge);
                block0: for (ValuePhiNode phi : merge.valuePhis()) {
                    ValueNode valueAt = phi.valueAt(end);
                    ConditionalEliminationUtil.InfoElement infoElement = this.getInfoElements(valueAt);
                    while (infoElement != null) {
                        Stamp newStamp = infoElement.getStamp();
                        if (phi.stamp(NodeView.DEFAULT).tryImproveWith(newStamp) != null) {
                            PhiInfoElement phiInfoElement;
                            if (mergeMap == null) {
                                mergeMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
                                this.mergeMaps.put((Object)merge, (Object)mergeMap);
                            }
                            if ((phiInfoElement = (PhiInfoElement)mergeMap.get((Object)phi)) == null) {
                                phiInfoElement = new PhiInfoElement();
                                mergeMap.put((Object)phi, (Object)phiInfoElement);
                            }
                            phiInfoElement.set(end, infoElement);
                            continue block0;
                        }
                        infoElement = this.nextElement(infoElement);
                    }
                }
            }
        }

        protected void registerNewCondition(LogicNode condition, boolean negated, GuardingNode guard) {
            if (condition instanceof UnaryOpLogicNode) {
                UnaryOpLogicNode unaryLogicNode = (UnaryOpLogicNode)condition;
                ValueNode value = unaryLogicNode.getValue();
                TriState unconditionallyFold = unaryLogicNode.tryFold(value.stamp(NodeView.DEFAULT));
                if (unconditionallyFold.isKnown()) {
                    return;
                }
                if (Instance.maybeMultipleUsages(value)) {
                    Stamp newStamp = unaryLogicNode.getSucceedingStampForValue(negated);
                    this.registerNewStamp(value, newStamp, guard, true);
                }
            } else if (condition instanceof BinaryOpLogicNode) {
                BinaryOpLogicNode binaryOpLogicNode = (BinaryOpLogicNode)condition;
                ValueNode x = binaryOpLogicNode.getX();
                ValueNode y = binaryOpLogicNode.getY();
                TriState unconditionallyFold = binaryOpLogicNode.tryFold(x.stamp(NodeView.DEFAULT), y.stamp(NodeView.DEFAULT));
                if (unconditionallyFold.isKnown()) {
                    return;
                }
                if (!x.isConstant() && Instance.maybeMultipleUsages(x)) {
                    Stamp newStampX = binaryOpLogicNode.getSucceedingStampForX(negated, ConditionalEliminationUtil.getSafeStamp(x), ConditionalEliminationUtil.getOtherSafeStamp(y));
                    this.registerNewStamp(x, newStampX, guard);
                }
                if (!y.isConstant() && Instance.maybeMultipleUsages(y)) {
                    Stamp newStampY = binaryOpLogicNode.getSucceedingStampForY(negated, ConditionalEliminationUtil.getOtherSafeStamp(x), ConditionalEliminationUtil.getSafeStamp(y));
                    this.registerNewStamp(y, newStampY, guard);
                }
                if (condition instanceof IntegerEqualsNode && guard instanceof DeoptimizingGuard && !negated && y.isConstant() && x instanceof AndNode) {
                    AndNode and = (AndNode)x;
                    ValueNode andX = and.getX();
                    if (and.getY() == y && Instance.maybeMultipleUsages(andX)) {
                        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Or> op = ArithmeticOpTable.forStamp(x.stamp(NodeView.DEFAULT)).getOr();
                        IntegerStamp newStampX = (IntegerStamp)op.foldStamp(ConditionalEliminationUtil.getSafeStamp(andX), ConditionalEliminationUtil.getOtherSafeStamp(y));
                        this.registerNewStamp(andX, newStampX, guard);
                    }
                }
            }
            if (guard instanceof DeoptimizingGuard) {
                assert (((DeoptimizingGuard)guard).getCondition() == condition);
                this.pendingTests.push((DeoptimizingGuard)guard);
            }
            this.registerCondition(condition, negated, guard);
        }

        Pair<ConditionalEliminationUtil.InfoElement, Stamp> recursiveFoldStampFromInfo(Node node) {
            return ConditionalEliminationUtil.recursiveFoldStamp(this.infoElementProvider, node);
        }

        protected boolean foldPendingTest(DeoptimizingGuard thisGuard, ValueNode original, Stamp newStamp, ConditionalEliminationUtil.GuardRewirer rewireGuardFunction) {
            for (DeoptimizingGuard pendingGuard : this.pendingTests) {
                LogicNode pendingCondition = pendingGuard.getCondition();
                TriState result = TriState.UNKNOWN;
                if (pendingCondition instanceof UnaryOpLogicNode) {
                    UnaryOpLogicNode unaryLogicNode = (UnaryOpLogicNode)pendingCondition;
                    if (unaryLogicNode.getValue() == original) {
                        result = unaryLogicNode.tryFold(newStamp);
                    }
                } else if (pendingCondition instanceof BinaryOpLogicNode) {
                    AndNode and;
                    BinaryOpLogicNode binaryOpLogicNode = (BinaryOpLogicNode)pendingCondition;
                    ValueNode x = binaryOpLogicNode.getX();
                    ValueNode y = binaryOpLogicNode.getY();
                    if (x == original) {
                        result = binaryOpLogicNode.tryFold(newStamp, ConditionalEliminationUtil.getOtherSafeStamp(y));
                    } else if (y == original) {
                        result = binaryOpLogicNode.tryFold(ConditionalEliminationUtil.getOtherSafeStamp(x), newStamp);
                    } else if (binaryOpLogicNode instanceof IntegerEqualsNode && y.isConstant() && x instanceof AndNode && (and = (AndNode)x).getY() == y && and.getX() == original) {
                        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.And> andOp = ArithmeticOpTable.forStamp(newStamp).getAnd();
                        result = binaryOpLogicNode.tryFold(andOp.foldStamp(newStamp, ConditionalEliminationUtil.getOtherSafeStamp(y)), ConditionalEliminationUtil.getOtherSafeStamp(y));
                    }
                }
                if (!result.isKnown() || !this.canScheduleAbove(thisGuard.getCondition(), pendingGuard.asNode(), original) || !this.foldGuard(thisGuard, pendingGuard, result.toBoolean(), newStamp, rewireGuardFunction)) continue;
                return true;
            }
            return false;
        }

        private boolean canScheduleAbove(Node n, Node target, ValueNode knownToBeAbove) {
            Block targetBlock = this.nodeToBlock.get(target);
            Block testBlock = this.nodeToBlock.get(n);
            if (targetBlock != null && testBlock != null) {
                if (targetBlock == testBlock) {
                    for (Node fixed : this.blockToNodes.get(targetBlock)) {
                        if (fixed == n) {
                            return true;
                        }
                        if (fixed != target) continue;
                        break;
                    }
                } else if (AbstractControlFlowGraph.dominates(testBlock, targetBlock)) {
                    return true;
                }
            }
            ConditionalEliminationUtil.InputFilter v = new ConditionalEliminationUtil.InputFilter(knownToBeAbove);
            n.applyInputs(v);
            return v.ok;
        }

        protected boolean foldGuard(DeoptimizingGuard thisGuard, DeoptimizingGuard otherGuard, boolean outcome, Stamp guardedValueStamp, ConditionalEliminationUtil.GuardRewirer rewireGuardFunction) {
            DeoptimizationAction action = StaticDeoptimizingNode.mergeActions(otherGuard.getAction(), thisGuard.getAction());
            if (action != null && otherGuard.getSpeculation() == thisGuard.getSpeculation()) {
                LogicNode condition = (LogicNode)thisGuard.getCondition().copyWithInputs();
                thisGuard.setAction(action);
                ConditionalEliminationUtil.GuardRewirer rewirer = (guard, result, innerGuardedValueStamp, newInput) -> {
                    boolean mustDeopt = result == otherGuard.isNegated();
                    if (rewireGuardFunction.rewire(guard, mustDeopt == thisGuard.isNegated(), innerGuardedValueStamp, newInput)) {
                        if (!mustDeopt) {
                            this.graph.getDebug().dump(5, this.graph, "Fold guard:thisGuard=%s otherGuard=%s, replacing condition from %s to %s", thisGuard, otherGuard, otherGuard.getCondition(), condition);
                            otherGuard.setCondition(condition, thisGuard.isNegated());
                            otherGuard.setAction(action);
                            otherGuard.setReason(thisGuard.getReason());
                            this.graph.getDebug().dump(5, (Object)this.graph, "After guard folding at %s", otherGuard);
                        }
                        return true;
                    }
                    condition.safeDelete();
                    return false;
                };
                return ConditionalEliminationUtil.rewireGuards(otherGuard, outcome, null, guardedValueStamp, rewirer);
            }
            return false;
        }

        protected boolean tryProveGuardCondition(DeoptimizingGuard thisGuard, LogicNode node, ConditionalEliminationUtil.GuardRewirer rewireGuardFunction) {
            return ConditionalEliminationUtil.tryProveGuardCondition(this.infoElementProvider, this.conditions, this.guardFolding, thisGuard, node, rewireGuardFunction);
        }

        protected void registerCondition(LogicNode condition, boolean negated, GuardingNode guard) {
            if (condition.hasMoreThanOneUsage()) {
                this.registerNewStamp(condition, negated ? StampFactory.contradiction() : StampFactory.tautology(), guard);
            }
            this.conditions.push(new ConditionalEliminationUtil.GuardedCondition(guard, condition, negated));
        }

        protected ConditionalEliminationUtil.InfoElement getInfoElements(ValueNode proxiedValue) {
            if (proxiedValue == null) {
                return null;
            }
            ConditionalEliminationUtil.InfoElement infoElement = this.map.getAndGrow(proxiedValue);
            if (infoElement == null) {
                infoElement = this.map.getAndGrow(GraphUtil.skipPi(proxiedValue));
            }
            return infoElement;
        }

        private ConditionalEliminationUtil.InfoElement nextElement(ConditionalEliminationUtil.InfoElement current) {
            ConditionalEliminationUtil.InfoElement parent = current.getParent();
            if (parent != null) {
                return parent;
            }
            ValueNode proxifiedInput = current.getProxifiedInput();
            if (proxifiedInput instanceof PiNode) {
                PiNode piNode = (PiNode)proxifiedInput;
                return this.getInfoElements(piNode.getOriginalNode());
            }
            return null;
        }

        protected void registerNewStamp(ValueNode maybeProxiedValue, Stamp newStamp, GuardingNode guard) {
            this.registerNewStamp(maybeProxiedValue, newStamp, guard, false);
        }

        protected void registerNewStamp(ValueNode maybeProxiedValue, Stamp newStamp, GuardingNode guard, boolean propagateThroughPis) {
            assert (maybeProxiedValue != null);
            assert (guard != null);
            if (newStamp == null || newStamp.isUnrestricted()) {
                return;
            }
            ValueNode value = maybeProxiedValue;
            Stamp stamp = newStamp;
            while (stamp != null && value != null) {
                ValueNode proxiedValue = null;
                if (value instanceof PiNode) {
                    proxiedValue = value;
                }
                counterStampsRegistered.increment(this.debug);
                this.debug.log("\t Saving stamp for node %s stamp %s guarded by %s", value, (Object)stamp, (Object)guard);
                assert (value instanceof LogicNode || stamp.isCompatible(value.stamp(NodeView.DEFAULT))) : stamp + " vs. " + value.stamp(NodeView.DEFAULT) + " (" + value + ")";
                this.map.setAndGrow(value, new ConditionalEliminationUtil.InfoElement(stamp, guard, proxiedValue, this.map.getAndGrow(value)));
                this.undoOperations.push(value);
                if (propagateThroughPis && value instanceof PiNode) {
                    PiNode piNode = (PiNode)value;
                    value = piNode.getOriginalNode();
                    continue;
                }
                if (!(value instanceof StampInverter)) break;
                StampInverter stampInverter = (StampInverter)((Object)value);
                value = stampInverter.getValue();
                stamp = stampInverter.invertStamp(stamp);
            }
        }

        protected void processAbstractBegin(AbstractBeginNode beginNode) {
            Node predecessor = beginNode.predecessor();
            if (predecessor instanceof IfNode) {
                IfNode ifNode = (IfNode)predecessor;
                boolean negated = ifNode.falseSuccessor() == beginNode;
                LogicNode condition = ifNode.condition();
                this.registerNewCondition(condition, negated, beginNode);
            } else if (predecessor instanceof TypeSwitchNode) {
                TypeSwitchNode typeSwitch = (TypeSwitchNode)predecessor;
                this.processTypeSwitch(beginNode, typeSwitch);
            } else if (predecessor instanceof IntegerSwitchNode) {
                IntegerSwitchNode integerSwitchNode = (IntegerSwitchNode)predecessor;
                this.processIntegerSwitch(beginNode, integerSwitchNode);
            }
        }

        private static boolean maybeMultipleUsages(ValueNode value) {
            if (value.hasMoreThanOneUsage()) {
                return true;
            }
            return value instanceof ProxyNode || value instanceof PiNode || value instanceof StampInverter;
        }

        protected void processIntegerSwitch(AbstractBeginNode beginNode, IntegerSwitchNode integerSwitchNode) {
            Stamp stamp;
            ValueNode value = integerSwitchNode.value();
            if (Instance.maybeMultipleUsages(value) && (stamp = integerSwitchNode.getValueStampForSuccessor(beginNode)) != null) {
                this.registerNewStamp(value, stamp, beginNode);
            }
        }

        protected void processTypeSwitch(AbstractBeginNode beginNode, TypeSwitchNode typeSwitch) {
            Stamp stamp;
            LoadHubNode loadHub;
            ValueNode value;
            ValueNode hub = typeSwitch.value();
            if (hub instanceof LoadHubNode && Instance.maybeMultipleUsages(value = (loadHub = (LoadHubNode)hub).getValue()) && (stamp = typeSwitch.getValueStampForSuccessor(beginNode)) != null) {
                this.registerNewStamp(value, stamp, beginNode);
            }
        }

        @Override
        public void exit(Block b, ConditionalEliminationUtil.Marks marks) {
            int infoElementsMark = marks.infoElementOperations;
            while (this.undoOperations.size() > infoElementsMark) {
                Node node = this.undoOperations.pop();
                if (!node.isAlive()) continue;
                this.map.set(node, this.map.get(node).getParent());
            }
            int conditionsMark = marks.conditions;
            while (this.conditions.size() > conditionsMark) {
                this.conditions.pop();
            }
        }
    }

    private static final class PhiInfoElement {
        private EconomicMap<EndNode, ConditionalEliminationUtil.InfoElement> infoElements;

        private PhiInfoElement() {
        }

        public void set(EndNode end, ConditionalEliminationUtil.InfoElement infoElement) {
            if (this.infoElements == null) {
                this.infoElements = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
            }
            this.infoElements.put((Object)end, (Object)infoElement);
        }

        public ConditionalEliminationUtil.InfoElement get(EndNode end) {
            if (this.infoElements == null) {
                return null;
            }
            return (ConditionalEliminationUtil.InfoElement)this.infoElements.get((Object)end);
        }
    }

    public static class MoveGuardsUpwards
    implements ControlFlowGraph.RecursiveVisitor<Block> {
        Block anchorBlock;

        @Override
        public Block enter(Block b) {
            FixedNode endNode;
            AbstractBeginNode beginNode;
            Block oldAnchorBlock = this.anchorBlock;
            if (b.getDominator() == null || ((Block)b.getDominator()).getPostdominator() != b) {
                this.anchorBlock = b;
            }
            if ((beginNode = b.getBeginNode()) instanceof AbstractMergeNode && this.anchorBlock != b) {
                AbstractMergeNode mergeNode = (AbstractMergeNode)beginNode;
                mergeNode.replaceAtUsages((Node)this.anchorBlock.getBeginNode(), InputType.Anchor, InputType.Guard);
                mergeNode.graph().getDebug().dump(5, mergeNode.graph(), "After moving guard and anchored usages from %s to %s", mergeNode, this.anchorBlock.getBeginNode());
                assert (mergeNode.anchored().isEmpty());
            }
            if ((endNode = b.getEndNode()) instanceof IfNode) {
                IfNode node = (IfNode)endNode;
                AbstractBeginNode trueSuccessor = node.trueSuccessor();
                AbstractBeginNode falseSuccessor = node.falseSuccessor();
                EconomicMap trueGuards = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
                for (GuardNode guard : trueSuccessor.guards()) {
                    LogicNode condition = guard.getCondition();
                    if (!condition.hasMoreThanOneUsage()) continue;
                    trueGuards.put((Object)condition, (Object)guard);
                }
                if (!trueGuards.isEmpty()) {
                    LoopExitNode trueSuccLex = trueSuccessor instanceof LoopExitNode ? (LoopExitNode)trueSuccessor : null;
                    LoopExitNode falseSuccLex = falseSuccessor instanceof LoopExitNode ? (LoopExitNode)falseSuccessor : null;
                    EconomicSet allLoopsAllExits = null;
                    if (trueSuccLex != null) {
                        if (allLoopsAllExits == null) {
                            allLoopsAllExits = EconomicSet.create();
                        }
                        allLoopsAllExits.addAll(trueSuccLex.loopBegin().loopExits());
                        allLoopsAllExits.remove((Object)trueSuccLex);
                    }
                    if (falseSuccLex != null) {
                        if (allLoopsAllExits == null) {
                            allLoopsAllExits = EconomicSet.create();
                        }
                        allLoopsAllExits.addAll(falseSuccLex.loopBegin().loopExits());
                        allLoopsAllExits.remove((Object)falseSuccLex);
                    }
                    if (allLoopsAllExits == null || allLoopsAllExits.isEmpty()) {
                        for (GuardNode guard : falseSuccessor.guards().snapshot()) {
                            GuardNode otherGuard = (GuardNode)trueGuards.get((Object)guard.getCondition());
                            if (otherGuard == null || guard.isNegated() != otherGuard.isNegated()) continue;
                            SpeculationLog.Speculation speculation = otherGuard.getSpeculation();
                            if (speculation == null) {
                                speculation = guard.getSpeculation();
                            } else if (guard.getSpeculation() != null && guard.getSpeculation() != speculation) continue;
                            try (DebugCloseable closeable = guard.withNodeSourcePosition();){
                                StructuredGraph graph = guard.graph();
                                GuardNode newlyCreatedGuard = new GuardNode(guard.getCondition(), this.anchorBlock.getBeginNode(), guard.getReason(), guard.getAction(), guard.isNegated(), speculation, guard.getNoDeoptSuccessorPosition());
                                GuardNode newGuard = node.graph().unique(newlyCreatedGuard);
                                if (otherGuard.isAlive()) {
                                    if (trueSuccessor instanceof LoopExitNode && beginNode.graph().isBeforeStage(StructuredGraph.StageFlag.VALUE_PROXY_REMOVAL)) {
                                        otherGuard.replaceAndDelete(ProxyNode.forGuard(newGuard, (LoopExitNode)trueSuccessor));
                                    } else {
                                        otherGuard.replaceAndDelete(newGuard);
                                    }
                                }
                                if (falseSuccessor instanceof LoopExitNode && beginNode.graph().isBeforeStage(StructuredGraph.StageFlag.VALUE_PROXY_REMOVAL)) {
                                    guard.replaceAndDelete(ProxyNode.forGuard(newGuard, (LoopExitNode)falseSuccessor));
                                } else {
                                    guard.replaceAndDelete(newGuard);
                                }
                                graph.getDebug().dump(5, graph, "After combining %s and %s to new %s in the dominator", guard, otherGuard, newGuard);
                            }
                        }
                    }
                }
            }
            return oldAnchorBlock;
        }

        @Override
        public void exit(Block b, Block value) {
            this.anchorBlock = value;
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> MoveGuardsUpwards = new OptionKey<Boolean>(true);
    }
}

