/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeFlood;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.phases.Phase;

public class DeadCodeEliminationPhase
extends Phase {
    private static final CounterKey counterNodesRemoved = DebugContext.counter("NodesRemoved");
    private final boolean optional;

    public DeadCodeEliminationPhase() {
        this(Optionality.Required);
    }

    public DeadCodeEliminationPhase(Optionality optionality) {
        this.optional = optionality == Optionality.Optional;
    }

    @Override
    public void run(StructuredGraph graph) {
        int totalMarkedCount;
        if (this.optional && Options.ReduceDCE.getValue(graph.getOptions()).booleanValue()) {
            return;
        }
        NodeFlood flood = graph.createNodeFlood();
        int totalNodeCount = graph.getNodeCount();
        flood.add(graph.start());
        DeadCodeEliminationPhase.iterateSuccessorsAndInputs(flood);
        boolean changed = false;
        for (GuardNode guard : graph.getNodes(GuardNode.TYPE)) {
            if (!flood.isMarked(guard.getAnchor().asNode())) continue;
            flood.add(guard);
            changed = true;
        }
        if (changed) {
            DeadCodeEliminationPhase.iterateSuccessorsAndInputs(flood);
        }
        if (totalNodeCount == (totalMarkedCount = flood.getTotalMarkedCount())) {
            return;
        }
        assert (totalNodeCount > totalMarkedCount);
        DeadCodeEliminationPhase.deleteNodes(flood, graph);
    }

    private static void iterateSuccessorsAndInputs(final NodeFlood flood) {
        Node.EdgeVisitor consumer = new Node.EdgeVisitor(){

            @Override
            public Node apply(Node n, Node succOrInput) {
                assert (succOrInput.isAlive()) : "dead successor or input " + succOrInput + " in " + n;
                flood.add(succOrInput);
                return succOrInput;
            }
        };
        for (Node current : flood) {
            if (current instanceof AbstractEndNode) {
                AbstractEndNode end = (AbstractEndNode)current;
                flood.add(end.merge());
                continue;
            }
            current.applySuccessors(consumer);
            current.applyInputs(consumer);
        }
    }

    private static void deleteNodes(final NodeFlood flood, StructuredGraph graph) {
        Node.EdgeVisitor consumer = new Node.EdgeVisitor(){

            @Override
            public Node apply(Node n, Node input) {
                if (input.isAlive() && flood.isMarked(input)) {
                    input.removeUsage(n);
                }
                return input;
            }
        };
        DebugContext debug = graph.getDebug();
        for (Node node : graph.getNodes()) {
            if (flood.isMarked(node)) continue;
            node.markDeleted();
            node.applyInputs(consumer);
            counterNodesRemoved.increment(debug);
        }
    }

    public static enum Optionality {
        Optional,
        Required;

    }

    public static class Options {
        public static final OptionKey<Boolean> ReduceDCE = new OptionKey<Boolean>(true);
    }
}

