/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.extended.OSRMonitorEnterNode;
import org.graalvm.compiler.nodes.java.AccessMonitorNode;
import org.graalvm.compiler.nodes.java.MonitorEnterNode;
import org.graalvm.compiler.nodes.java.MonitorExitNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.spi.ValueProxy;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.Phase;

public class LockEliminationPhase
extends Phase {
    @Override
    protected void run(StructuredGraph graph) {
        ControlFlowGraph cfg = ControlFlowGraph.compute(graph, true, true, true, false);
        for (MonitorExitNode monitorExitNode : graph.getNodes(MonitorExitNode.TYPE)) {
            MonitorIdNode exitId;
            FixedNode next = monitorExitNode.next();
            if (!(next instanceof MonitorEnterNode)) continue;
            assert (!(next instanceof OSRMonitorEnterNode));
            AccessMonitorNode monitorEnterNode = (AccessMonitorNode)next;
            if (!LockEliminationPhase.isCompatibleLock(monitorEnterNode, monitorExitNode, true, cfg)) continue;
            MonitorIdNode enterId = monitorEnterNode.getMonitorId();
            if (enterId != (exitId = monitorExitNode.getMonitorId())) {
                enterId.replaceAndDelete(exitId);
            }
            GraphUtil.removeFixedWithUnusedInputs(monitorEnterNode);
            GraphUtil.removeFixedWithUnusedInputs(monitorExitNode);
        }
    }

    public static boolean isCompatibleLock(AccessMonitorNode a, AccessMonitorNode b, boolean aDominatesB, ControlFlowGraph cfg) {
        ValueNode objectB;
        ValueNode objectA = GraphUtil.unproxify(a.object());
        if (objectA == (objectB = GraphUtil.unproxify(b.object())) && a.getMonitorId().getLockDepth() == b.getMonitorId().getLockDepth() && a.getMonitorId().isMultipleEntry() == b.getMonitorId().isMultipleEntry()) {
            Block lowestBlockA = LockEliminationPhase.lowestGuardedInputBlock(b, cfg);
            Block lowestBlockB = null;
            if (lowestBlockA != null) {
                lowestBlockB = LockEliminationPhase.lowestGuardedInputBlock(b, cfg);
            }
            if (lowestBlockA == null || lowestBlockB == null) {
                return true;
            }
            if (aDominatesB) {
                return AbstractControlFlowGraph.dominates(lowestBlockA, lowestBlockB);
            }
            return AbstractControlFlowGraph.dominates(lowestBlockB, lowestBlockA);
        }
        return false;
    }

    public static Block lowestGuardedInputBlock(AccessMonitorNode monitorNode, ControlFlowGraph cfg) {
        return LockEliminationPhase.lowestGuardedInputBlock(LockEliminationPhase.unproxifyHighestGuard(monitorNode.object()), LockEliminationPhase.unproxifyHighestGuard(monitorNode.getObjectData()), cfg);
    }

    public static Block lowestGuardedInputBlock(GuardingNode g1, GuardingNode g2, ControlFlowGraph cfg) {
        Block b1 = LockEliminationPhase.getGuardingBlock(g1, cfg);
        Block b2 = LockEliminationPhase.getGuardingBlock(g2, cfg);
        if (b1 == null) {
            return b2;
        }
        if (b2 == null) {
            return b1;
        }
        if (AbstractControlFlowGraph.dominates(b1, b2)) {
            return b2;
        }
        return b1;
    }

    public static Block getGuardingBlock(GuardingNode g1, ControlFlowGraph cfg) {
        Block b1 = null;
        if (g1 != null) {
            AnchoringNode a;
            if (g1 instanceof FixedNode) {
                b1 = cfg.blockFor((Node)((Object)g1));
            } else if (g1 instanceof GuardNode && (a = ((GuardNode)g1).getAnchor()) instanceof FixedNode) {
                b1 = cfg.blockFor((FixedNode)((Object)a));
            }
        }
        return b1;
    }

    public static GuardingNode unproxifyHighestGuard(ValueNode value) {
        if (value != null) {
            ValueNode result = value;
            GuardingNode highestGuard = null;
            while (result instanceof ValueProxy) {
                GuardingNode curGuard = ((ValueProxy)((Object)result)).getGuard();
                if (curGuard != null) {
                    highestGuard = curGuard;
                }
                result = ((ValueProxy)((Object)result)).getOriginalNode();
            }
            return highestGuard;
        }
        return null;
    }
}

