/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GuardNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnreachableBeginNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.extended.ForeignCall;
import org.graalvm.compiler.nodes.extended.GuardedNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.memory.MemoryMapNode;
import org.graalvm.compiler.nodes.memory.MultiMemoryKill;
import org.graalvm.compiler.nodes.memory.SideEffectFreeWrite;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.CoreProvidersDelegate;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.virtual.CommitAllocationNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.util.EconomicSetNodeEventListener;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import org.graalvm.word.LocationIdentity;

public abstract class LoweringPhase
extends BasePhase<CoreProviders> {
    private final CanonicalizerPhase canonicalizer;
    private final LoweringTool.StandardLoweringStage loweringStage;
    private final boolean lowerOptimizableMacroNodes;
    private final StructuredGraph.StageFlag postRunStage;
    private static final ClassValue<LoweringStatistics> statisticsClassValue = new ClassValue<LoweringStatistics>(){

        @Override
        protected LoweringStatistics computeValue(Class<?> c) {
            return new LoweringStatistics(c);
        }
    };

    @Override
    public boolean checkContract() {
        return false;
    }

    LoweringPhase(CanonicalizerPhase canonicalizer, LoweringTool.StandardLoweringStage loweringStage, boolean lowerOptimizableMacroNodes, StructuredGraph.StageFlag postRunStage) {
        this.canonicalizer = canonicalizer;
        this.loweringStage = loweringStage;
        this.lowerOptimizableMacroNodes = lowerOptimizableMacroNodes;
        this.postRunStage = postRunStage;
    }

    LoweringPhase(CanonicalizerPhase canonicalizer, LoweringTool.StandardLoweringStage loweringStage, StructuredGraph.StageFlag postRunStage) {
        this(canonicalizer, loweringStage, false, postRunStage);
    }

    @Override
    protected boolean shouldDumpBeforeAtBasicLevel() {
        return this.loweringStage == LoweringTool.StandardLoweringStage.HIGH_TIER;
    }

    private boolean checkPostLowering(StructuredGraph graph, CoreProviders context) {
        Graph.Mark expectedMark = graph.getMark();
        this.lower(graph, context, LoweringMode.VERIFY_LOWERING);
        Graph.Mark mark = graph.getMark();
        assert (mark.equals(expectedMark)) : graph + ": a second round in the current lowering phase introduced these new nodes: " + graph.getNewNodes(expectedMark).snapshot();
        return true;
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        this.lower(graph, context, LoweringMode.LOWERING);
        assert (this.checkPostLowering(graph, context));
        graph.setAfterStage(this.postRunStage);
    }

    private void lower(StructuredGraph graph, CoreProviders context, LoweringMode mode) {
        boolean immutableSchedule = mode == LoweringMode.VERIFY_LOWERING;
        OptionValues options = graph.getOptions();
        new SchedulePhase(immutableSchedule, options).apply(graph, context);
        EconomicSetNodeEventListener listener = new EconomicSetNodeEventListener();
        try (Graph.NodeEventScope nes = graph.trackNodeEvents(listener);){
            StructuredGraph.ScheduleResult schedule = graph.getLastSchedule();
            schedule.getCFG().computePostdominators();
            Block startBlock = schedule.getCFG().getStartBlock();
            ProcessFrame rootFrame = new ProcessFrame(context, startBlock, graph.createNodeBitMap(), startBlock.getBeginNode(), null, schedule);
            LoweringPhase.processBlock(rootFrame);
        }
        if (!listener.getNodes().isEmpty()) {
            this.canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)listener.getNodes());
        }
        assert (graph.verify());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkPostNodeLowering(Node node, LoweringToolImpl loweringTool, Graph.Mark preLoweringMark, Collection<Node> unscheduledUsages) {
        StructuredGraph graph = (StructuredGraph)node.graph();
        Graph.Mark postLoweringMark = graph.getMark();
        NodeIterable<Node> newNodesAfterLowering = graph.getNewNodes(preLoweringMark);
        if (node instanceof FloatingNode && !unscheduledUsages.isEmpty()) {
            for (Node n : newNodesAfterLowering) {
                assert (!(n instanceof FixedNode)) : node.graph() + ": cannot lower floatable node " + node + " as it introduces fixed node(s) but has the following unscheduled usages: " + unscheduledUsages;
            }
        }
        boolean wasMemoryAccessBefore = node instanceof MemoryAccess;
        boolean wasMemoryKillBefore = MemoryKill.isMemoryKill(node);
        for (Node n : newNodesAfterLowering) {
            if (n instanceof Lowerable) {
                ((Lowerable)((Object)n)).lower(loweringTool);
                Graph.Mark mark = graph.getMark();
                assert (postLoweringMark.equals(mark)) : graph + ": lowering of " + node + " produced lowerable " + n + " that should have been recursively lowered as it introduces these new nodes: " + graph.getNewNodes(postLoweringMark).snapshot();
            }
            if (!graph.isSubstitution() && loweringTool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
                MemoryAccess access;
                if (!(n instanceof ForeignCall || n instanceof UnreachableBeginNode || node instanceof WithExceptionNode || n instanceof MemoryMapNode || node instanceof CommitAllocationNode || n instanceof SideEffectFreeWrite || !MemoryKill.isMemoryKill(n))) {
                    if (MemoryKill.isSingleMemoryKill(n)) {
                        SingleMemoryKill singleKill = (SingleMemoryKill)((Object)n);
                        if (!singleKill.getKilledLocationIdentity().equals(MemoryKill.NO_LOCATION)) {
                            if (!wasMemoryKillBefore) {
                                throw GraalError.shouldNotReachHere(String.format("Original node %s was not a kill but %s is", node, n));
                            }
                            if (!MemoryKill.isSingleMemoryKill(node)) {
                                throw GraalError.shouldNotReachHere(String.format("Original node %s was not a single kill but %s is", node, n));
                            }
                            SingleMemoryKill oldKill = (SingleMemoryKill)((Object)node);
                            if (!(!oldKill.getKilledLocationIdentity().isSingle() && singleKill.getKilledLocationIdentity().isSingle() || oldKill.getKilledLocationIdentity().equals(singleKill.getKilledLocationIdentity()))) {
                                throw GraalError.shouldNotReachHere(String.format("Original node %s kills %s while new node %s kills %s", node, oldKill.getKilledLocationIdentity(), singleKill, singleKill.getKilledLocationIdentity()));
                            }
                        }
                    } else {
                        if (!MemoryKill.isMultiMemoryKill(n)) throw GraalError.shouldNotReachHere("Unknown memory kill " + n);
                        if (!wasMemoryKillBefore) {
                            throw GraalError.shouldNotReachHere(String.format("Original node %s was not a kill but %s is", node, n));
                        }
                        if (!MemoryKill.isMultiMemoryKill(node)) {
                            throw GraalError.shouldNotReachHere(String.format("Original node %s was not a multi kill but %s is", node, n));
                        }
                        MultiMemoryKill newKill = (MultiMemoryKill)((Object)n);
                        MultiMemoryKill oldKill = (MultiMemoryKill)((Object)node);
                        EconomicSet killed = EconomicSet.create();
                        for (LocationIdentity loc : newKill.getKilledLocationIdentities()) {
                            killed.add((Object)loc);
                        }
                        for (LocationIdentity oldLoc : oldKill.getKilledLocationIdentities()) {
                            if (!killed.contains((Object)oldLoc)) {
                                throw GraalError.shouldNotReachHere(String.format("Original node %s kills %s while new node %s does not kill that location", oldKill, oldLoc, newKill));
                            }
                            killed.remove((Object)oldLoc);
                        }
                        Iterator iterator = killed.iterator();
                        if (iterator.hasNext()) {
                            LocationIdentity newLoc = (LocationIdentity)iterator.next();
                            throw GraalError.shouldNotReachHere(String.format("New kill %s kills location %s while old kill %s does not", newKill, newLoc, oldKill));
                        }
                    }
                } else if (n instanceof MemoryAccess && !(n instanceof MemoryMapNode) && (access = (MemoryAccess)((Object)n)).getLocationIdentity().isMutable()) {
                    if (wasMemoryKillBefore && !wasMemoryAccessBefore) {
                        if (MemoryKill.isSingleMemoryKill(node)) {
                            if (!((SingleMemoryKill)((Object)node)).getKilledLocationIdentity().overlaps(access.getLocationIdentity())) {
                                GraalError.shouldNotReachHere(String.format("Node %s was a memory kill killing %s but lowered to a memory access %s which accesses %s", node, ((SingleMemoryKill)((Object)node)).getKilledLocationIdentity(), n, access.getLocationIdentity()));
                            }
                        } else {
                            if (!MemoryKill.isMultiMemoryKill(node)) throw GraalError.shouldNotReachHere("Unknown type of memory kill " + node);
                            boolean found = false;
                            for (LocationIdentity ident : ((MultiMemoryKill)((Object)node)).getKilledLocationIdentities()) {
                                if (!ident.overlaps(access.getLocationIdentity())) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                GraalError.shouldNotReachHere(String.format("Node %s was a memory kill not killing the location accessed by the lowered node: %s which accesses %s", node, n, access.getLocationIdentity()));
                            }
                        }
                    } else if (wasMemoryAccessBefore) {
                        if (!access.getLocationIdentity().overlaps(((MemoryAccess)((Object)node)).getLocationIdentity())) {
                            GraalError.shouldNotReachHere(String.format("Node %s was a memory access (%s) but lowered to a memory access %s %s", node, ((MemoryAccess)((Object)node)).getLocationIdentity(), n, access.getLocationIdentity()));
                        }
                    } else {
                        GraalError.shouldNotReachHere(String.format("Node %s was not a memory access but lowered to a memory access %s", node, n));
                    }
                }
            }
            if (!MemoryKill.isMemoryKill(n) || n instanceof MemoryMapNode || wasMemoryKillBefore || node instanceof ControlSinkNode) continue;
            boolean isAny = false;
            if (MemoryKill.isSingleMemoryKill(n)) {
                isAny = ((SingleMemoryKill)((Object)n)).getKilledLocationIdentity().isAny();
            } else {
                if (!MemoryKill.isMultiMemoryKill(n)) throw GraalError.shouldNotReachHere("Unknown type of memory kill " + n);
                for (LocationIdentity ident : ((MultiMemoryKill)((Object)n)).getKilledLocationIdentities()) {
                    if (!ident.isAny()) continue;
                    isAny = true;
                }
            }
            if (isAny && n instanceof FixedWithNextNode) {
                for (FixedWithNextNode cur = (FixedWithNextNode)n; cur != null && graph.isNew(preLoweringMark, cur); cur = (FixedWithNextNode)cur.next()) {
                    if (cur.next() instanceof ControlSinkNode) {
                        isAny = false;
                        break;
                    }
                    if (!(cur.next() instanceof FixedWithNextNode)) break;
                }
            }
            assert (!isAny) : node + " " + n;
        }
        return true;
    }

    private AnchoringNode process(CoreProviders context, Block b, NodeBitMap activeGuards, AnchoringNode startAnchor, StructuredGraph.ScheduleResult schedule) {
        LoweringToolImpl loweringTool = new LoweringToolImpl(context, startAnchor, activeGuards, b.getBeginNode(), schedule.getNodeToBlockMap());
        DebugContext debug = startAnchor.asNode().getDebug();
        List<Node> nodes = schedule.nodesFor(b);
        for (Node node : nodes) {
            if (node.isDeleted()) continue;
            FixedNode nextNode = null;
            nextNode = node instanceof FixedWithNextNode ? ((FixedWithNextNode)node).next() : loweringTool.lastFixedNode().next();
            if (node instanceof Lowerable) {
                Collection<Node> unscheduledUsages = null;
                assert ((unscheduledUsages = LoweringPhase.getUnscheduledUsages(node, schedule)) != null);
                Graph.Mark preLoweringMark = node.graph().getMark();
                try (DebugCloseable s = node.graph().withNodeSourcePosition(node);){
                    TimerKey timer = null;
                    if (debug.areMetricsEnabled()) {
                        LoweringStatistics statistics = statisticsClassValue.get(node.getClass());
                        statistics.counters[this.loweringStage.ordinal()].increment(debug);
                        timer = statistics.timers[this.loweringStage.ordinal()];
                    }
                    try (DebugCloseable a = timer != null ? timer.start(debug) : null;
                         DebugCloseable a2 = this.loweringStage.timer.start(debug);){
                        ((Lowerable)((Object)node)).lower(loweringTool);
                    }
                }
                if (loweringTool.guardAnchor.asNode().isDeleted()) {
                    assert (nextNode.isAlive());
                    loweringTool.guardAnchor = AbstractBeginNode.prevBegin(nextNode);
                }
                assert (LoweringPhase.checkPostNodeLowering(node, loweringTool, preLoweringMark, unscheduledUsages));
            }
            if (!nextNode.isAlive()) break;
            Node nextLastFixed = nextNode.predecessor();
            if (!(nextLastFixed instanceof FixedWithNextNode)) {
                AbstractBeginNode begin = node.graph().add(new BeginNode());
                nextLastFixed.replaceFirstSuccessor(nextNode, begin);
                begin.setNext(nextNode);
                nextLastFixed = begin;
            }
            loweringTool.setLastFixedNode((FixedWithNextNode)nextLastFixed);
        }
        return loweringTool.getCurrentGuardAnchor();
    }

    private static Collection<Node> getUnscheduledUsages(Node node, StructuredGraph.ScheduleResult schedule) {
        ArrayList<Node> unscheduledUsages = new ArrayList<Node>();
        if (node instanceof FloatingNode) {
            for (Node usage : node.usages()) {
                if (!(usage instanceof ValueNode) || usage instanceof PhiNode || usage instanceof ProxyNode || !schedule.getCFG().getNodeToBlock().isNew(usage) && schedule.getCFG().blockFor(usage) != null) continue;
                unscheduledUsages.add(usage);
            }
        }
        return unscheduledUsages;
    }

    public static void processBlock(Frame<?> rootFrame) {
        ProcessBlockState state = ProcessBlockState.ST_PROCESS;
        Frame<Object> f = rootFrame;
        while (f != null) {
            ProcessBlockState nextState;
            if (state == ProcessBlockState.ST_PROCESS || state == ProcessBlockState.ST_PROCESS_ALWAYS_REACHED) {
                f.preprocess();
                nextState = state == ProcessBlockState.ST_PROCESS_ALWAYS_REACHED ? ProcessBlockState.ST_ENTER : ProcessBlockState.ST_ENTER_ALWAYS_REACHED;
            } else if (state == ProcessBlockState.ST_ENTER_ALWAYS_REACHED) {
                if (f.alwaysReachedBlock != null && f.alwaysReachedBlock.getDominator() == f.block) {
                    f = f.enterAlwaysReached(f.alwaysReachedBlock);
                    nextState = ProcessBlockState.ST_PROCESS;
                } else {
                    nextState = ProcessBlockState.ST_ENTER;
                }
            } else if (state == ProcessBlockState.ST_ENTER) {
                if (f.dominated != null) {
                    Block n = f.dominated;
                    f.dominated = (Block)n.getDominatedSibling();
                    if (n == f.alwaysReachedBlock) {
                        if (f.dominated != null) {
                            n = f.dominated;
                            f.dominated = (Block)n.getDominatedSibling();
                        } else {
                            n = null;
                        }
                    }
                    if (n == null) {
                        nextState = ProcessBlockState.ST_LEAVE;
                    } else {
                        f = f.enter(n);
                        assert (f.block.getDominator() == ((Frame)f.parent).block);
                        nextState = ProcessBlockState.ST_PROCESS;
                    }
                } else {
                    nextState = ProcessBlockState.ST_LEAVE;
                }
            } else if (state == ProcessBlockState.ST_LEAVE) {
                f.postprocess();
                f = f.parent;
                nextState = ProcessBlockState.ST_ENTER;
            } else {
                throw GraalError.shouldNotReachHere();
            }
            state = nextState;
        }
    }

    public static abstract class Frame<T extends Frame<?>> {
        protected final Block block;
        final T parent;
        Block dominated;
        final Block alwaysReachedBlock;

        public Frame(Block block, T parent) {
            this.block = block;
            this.alwaysReachedBlock = block.getPostdominator();
            this.dominated = (Block)block.getFirstDominated();
            this.parent = parent;
        }

        public Frame<?> enterAlwaysReached(Block b) {
            return this.enter(b);
        }

        public abstract Frame<?> enter(Block var1);

        public abstract void preprocess();

        public abstract void postprocess();
    }

    static enum ProcessBlockState {
        ST_ENTER,
        ST_PROCESS,
        ST_ENTER_ALWAYS_REACHED,
        ST_LEAVE,
        ST_PROCESS_ALWAYS_REACHED;

    }

    private class ProcessFrame
    extends Frame<ProcessFrame> {
        private final NodeBitMap activeGuards;
        private AnchoringNode anchor;
        private final StructuredGraph.ScheduleResult schedule;
        private final CoreProviders context;

        ProcessFrame(CoreProviders context, Block block, NodeBitMap activeGuards, AnchoringNode anchor, ProcessFrame parent, StructuredGraph.ScheduleResult schedule) {
            super(block, parent);
            this.context = context;
            this.activeGuards = activeGuards;
            this.anchor = anchor;
            this.schedule = schedule;
        }

        @Override
        public void preprocess() {
            this.anchor = LoweringPhase.this.process(this.context, this.block, this.activeGuards, this.anchor, this.schedule);
        }

        public ProcessFrame enter(Block b) {
            return new ProcessFrame(this.context, b, this.activeGuards, b.getBeginNode(), this, this.schedule);
        }

        @Override
        public Frame<?> enterAlwaysReached(Block b) {
            AnchoringNode newAnchor = this.anchor;
            if (this.parent != null && b.getLoop() != ((ProcessFrame)this.parent).block.getLoop() && !b.isLoopHeader()) {
                newAnchor = b.getBeginNode();
            }
            return new ProcessFrame(this.context, b, this.activeGuards, newAnchor, this, this.schedule);
        }

        @Override
        public void postprocess() {
            if (this.anchor == this.block.getBeginNode() && GraalOptions.OptEliminateGuards.getValue(this.activeGuards.graph().getOptions()).booleanValue()) {
                for (GuardNode guard : this.anchor.asNode().usages().filter(GuardNode.class)) {
                    if (!this.activeGuards.isMarkedAndGrow(guard)) continue;
                    this.activeGuards.clear(guard);
                }
            }
        }
    }

    public static class LoweringStatistics {
        static final EnumSet<LoweringTool.StandardLoweringStage> stages = EnumSet.allOf(LoweringTool.StandardLoweringStage.class);
        private final TimerKey[] timers = new TimerKey[stages.size()];
        private final CounterKey[] counters = new CounterKey[stages.size()];

        public LoweringStatistics(Class<?> clazz) {
            for (LoweringTool.StandardLoweringStage loweringStage : stages) {
                this.timers[loweringStage.ordinal()] = DebugContext.timer("LoweringTime_%s_%s", loweringStage, clazz);
                this.counters[loweringStage.ordinal()] = DebugContext.counter("LoweringCount_%s_%s", loweringStage, clazz);
            }
        }
    }

    private static enum LoweringMode {
        LOWERING,
        VERIFY_LOWERING;

    }

    final class LoweringToolImpl
    extends CoreProvidersDelegate
    implements LoweringTool {
        private final NodeBitMap activeGuards;
        private AnchoringNode guardAnchor;
        private FixedWithNextNode lastFixedNode;
        private NodeMap<Block> nodeMap;

        LoweringToolImpl(CoreProviders context, AnchoringNode guardAnchor, NodeBitMap activeGuards, FixedWithNextNode lastFixedNode, NodeMap<Block> nodeMap) {
            super(context);
            this.guardAnchor = guardAnchor;
            this.activeGuards = activeGuards;
            this.lastFixedNode = lastFixedNode;
            this.nodeMap = nodeMap;
        }

        @Override
        public LoweringTool.LoweringStage getLoweringStage() {
            return LoweringPhase.this.loweringStage;
        }

        @Override
        public AnchoringNode getCurrentGuardAnchor() {
            return this.guardAnchor;
        }

        @Override
        public boolean lowerOptimizableMacroNodes() {
            return LoweringPhase.this.lowerOptimizableMacroNodes;
        }

        @Override
        public GuardingNode createGuard(FixedNode before, LogicNode condition, DeoptimizationReason deoptReason, DeoptimizationAction action) {
            return this.createGuard(before, condition, deoptReason, action, SpeculationLog.NO_SPECULATION, false, null);
        }

        @Override
        public GuardingNode createGuard(FixedNode before, LogicNode condition, DeoptimizationReason deoptReason, DeoptimizationAction action, SpeculationLog.Speculation speculation, boolean negated, NodeSourcePosition noDeoptSucccessorPosition) {
            StructuredGraph graph = before.graph();
            if (GraalOptions.OptEliminateGuards.getValue(graph.getOptions()).booleanValue()) {
                for (Node usage : condition.usages()) {
                    if (this.activeGuards.isNew(usage) || !this.activeGuards.isMarked(usage) || ((GuardNode)usage).isNegated() != negated || !before.graph().isAfterStage(StructuredGraph.StageFlag.VALUE_PROXY_REMOVAL) && !this.nodeMap.get(((GuardNode)usage).getAnchor().asNode()).isInSameOrOuterLoopOf(this.nodeMap.get(before))) continue;
                    return (GuardNode)usage;
                }
            }
            if (!condition.graph().getGuardsStage().allowsFloatingGuards()) {
                FixedGuardNode fixedGuard = graph.add(new FixedGuardNode(condition, deoptReason, action, speculation, negated, noDeoptSucccessorPosition));
                graph.addBeforeFixed(before, fixedGuard);
                DummyGuardHandle handle = graph.add(new DummyGuardHandle(fixedGuard));
                fixedGuard.lower(this);
                GuardingNode result = handle.getGuard();
                handle.safeDelete();
                return result;
            }
            GuardNode newGuard = graph.unique(new GuardNode(condition, this.guardAnchor, deoptReason, action, negated, speculation, noDeoptSucccessorPosition));
            if (GraalOptions.OptEliminateGuards.getValue(graph.getOptions()).booleanValue()) {
                this.activeGuards.markAndGrow(newGuard);
            }
            return newGuard;
        }

        @Override
        public FixedWithNextNode lastFixedNode() {
            GraalError.guarantee(this.lastFixedNode.isAlive(), "The last fixed node %s was deleted by a previous lowering", (Object)this.lastFixedNode);
            return this.lastFixedNode;
        }

        private void setLastFixedNode(FixedWithNextNode n) {
            GraalError.guarantee(n.isAlive(), "Cannot add last fixed node %s because it is not alive", (Object)n);
            this.lastFixedNode = n;
        }
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
    static final class DummyGuardHandle
    extends ValueNode
    implements GuardedNode {
        public static final NodeClass<DummyGuardHandle> TYPE = NodeClass.create(DummyGuardHandle.class);
        @Node.Input(value=InputType.Guard)
        GuardingNode guard;

        protected DummyGuardHandle(GuardingNode guard) {
            super(TYPE, StampFactory.forVoid());
            this.guard = guard;
        }

        @Override
        public GuardingNode getGuard() {
            return this.guard;
        }

        @Override
        public void setGuard(GuardingNode guard) {
            this.updateUsagesInterface(this.guard, guard);
            this.guard = guard;
        }
    }
}

