/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.VirtualState;
import org.graalvm.compiler.nodes.calc.BinaryNode;
import org.graalvm.compiler.nodes.calc.ConvertNode;
import org.graalvm.compiler.nodes.calc.FloatDivNode;
import org.graalvm.compiler.nodes.calc.IntegerDivRemNode;
import org.graalvm.compiler.nodes.calc.MulNode;
import org.graalvm.compiler.nodes.calc.NotNode;
import org.graalvm.compiler.nodes.calc.ReinterpretNode;
import org.graalvm.compiler.nodes.calc.RemNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.debug.DynamicCounterNode;
import org.graalvm.compiler.nodes.extended.SwitchNode;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.java.AccessMonitorNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.memory.FloatingReadNode;
import org.graalvm.compiler.nodes.spi.ValueProxy;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.compiler.phases.schedule.SchedulePhase;

public class ProfileCompiledMethodsPhase
extends Phase {
    private static final String GROUP_NAME = "~profiled weight";
    private static final String GROUP_NAME_WITHOUT = "~profiled weight (invoke-free sections)";
    private static final String GROUP_NAME_INVOKES = "~profiled invokes";
    private static final boolean WITH_SECTION_HEADER = Boolean.parseBoolean(ProfileCompiledMethodsPhase.getProperty("ProfileCompiledMethodsPhase.WITH_SECTION_HEADER", "false"));
    private static final boolean WITH_INVOKE_FREE_SECTIONS = Boolean.parseBoolean(ProfileCompiledMethodsPhase.getProperty("ProfileCompiledMethodsPhase.WITH_FREE_SECTIONS", "false"));
    private static final boolean WITH_INVOKES = Boolean.parseBoolean(ProfileCompiledMethodsPhase.getProperty("ProfileCompiledMethodsPhase.WITH_INVOKES", "true"));

    private static String getProperty(String name, String def) {
        String value = (String)Services.getSavedProperties().get(name);
        if (value == null) {
            return def;
        }
        return value;
    }

    @Override
    protected void run(StructuredGraph graph) {
        ControlFlowGraph cfg = ControlFlowGraph.compute(graph, true, true, true, true);
        SchedulePhase.runWithoutContextOptimizations(graph, SchedulePhase.getDefaultStrategy(graph.getOptions()), cfg, true);
        for (Loop loop : cfg.getLoops()) {
            double loopProbability = cfg.blockFor(((Block)loop.getHeader()).getBeginNode()).getRelativeFrequency();
            if (!(loopProbability > 4.656612875245797E-10)) continue;
            ProfileCompiledMethodsPhase.addSectionCounters(((Block)loop.getHeader()).getBeginNode(), loop.getBlocks(), loop.getChildren(), graph.getLastSchedule(), cfg);
        }
        FixedWithNextNode current = graph.start();
        while (current.next() instanceof FixedWithNextNode) {
            current = (FixedWithNextNode)current.next();
        }
        ProfileCompiledMethodsPhase.addSectionCounters(current, Arrays.asList(cfg.getBlocks()), cfg.getLoops(), graph.getLastSchedule(), cfg);
        if (WITH_INVOKES) {
            for (Node node : graph.getNodes()) {
                if (!(node instanceof Invoke)) continue;
                Invoke invoke = (Invoke)((Object)node);
                DynamicCounterNode.addCounterBefore(GROUP_NAME_INVOKES, invoke.callTarget().targetName(), 1L, true, invoke.asFixedNode());
            }
        }
    }

    private static void addSectionCounters(FixedWithNextNode start, Collection<Block> sectionBlocks, Collection<Loop<Block>> childLoops, StructuredGraph.ScheduleResult schedule, ControlFlowGraph cfg) {
        HashSet<Block> blocks = new HashSet<Block>(sectionBlocks);
        for (Loop<Block> loop : childLoops) {
            blocks.removeAll(loop.getBlocks());
        }
        long increment = DynamicCounterNode.clampIncrement((long)(ProfileCompiledMethodsPhase.getSectionWeight(schedule, blocks) / cfg.blockFor(start).getRelativeFrequency()));
        DynamicCounterNode.addCounterBefore(GROUP_NAME, ProfileCompiledMethodsPhase.sectionHead(start), increment, true, start.next());
        if (WITH_INVOKE_FREE_SECTIONS && !ProfileCompiledMethodsPhase.hasInvoke(blocks)) {
            DynamicCounterNode.addCounterBefore(GROUP_NAME_WITHOUT, ProfileCompiledMethodsPhase.sectionHead(start), increment, true, start.next());
        }
    }

    private static String sectionHead(Node node) {
        if (WITH_SECTION_HEADER) {
            return node.toString();
        }
        return "";
    }

    private static double getSectionWeight(StructuredGraph.ScheduleResult schedule, Collection<Block> blocks) {
        double count = 0.0;
        for (Block block : blocks) {
            double blockProbability = block.getRelativeFrequency();
            for (Node node : schedule.getBlockToNodesMap().get(block)) {
                count += blockProbability * ProfileCompiledMethodsPhase.getNodeWeight(node);
            }
        }
        return count;
    }

    private static double getNodeWeight(Node node) {
        if (node instanceof AbstractMergeNode) {
            return ((AbstractMergeNode)node).phiPredecessorCount();
        }
        if (node instanceof AbstractBeginNode || node instanceof AbstractEndNode || node instanceof MonitorIdNode || node instanceof ConstantNode || node instanceof ParameterNode || node instanceof CallTargetNode || node instanceof ValueProxy || node instanceof VirtualObjectNode || node instanceof ReinterpretNode) {
            return 0.0;
        }
        if (node instanceof AccessMonitorNode) {
            return 10.0;
        }
        if (node instanceof FloatingReadNode) {
            return 2.0;
        }
        if (node instanceof LogicNode || node instanceof ConvertNode || node instanceof NotNode) {
            return 1.0;
        }
        if (node instanceof IntegerDivRemNode || node instanceof FloatDivNode || node instanceof RemNode) {
            return 10.0;
        }
        if (node instanceof MulNode) {
            return 3.0;
        }
        if (node instanceof Invoke) {
            return 5.0;
        }
        if (node instanceof IfNode || node instanceof SafepointNode || node instanceof BinaryNode) {
            return 1.0;
        }
        if (node instanceof SwitchNode) {
            return node.successors().count();
        }
        if (node instanceof ReturnNode || node instanceof UnwindNode || node instanceof DeoptimizeNode) {
            return node.successors().count();
        }
        if (node instanceof AbstractNewObjectNode) {
            return 10.0;
        }
        if (node instanceof VirtualState) {
            return 0.0;
        }
        return 2.0;
    }

    private static boolean hasInvoke(Collection<Block> blocks) {
        boolean hasInvoke = false;
        for (Block block : blocks) {
            for (FixedNode fixed : block.getNodes()) {
                if (!(fixed instanceof Invoke)) continue;
                hasInvoke = true;
            }
        }
        return hasInvoke;
    }

    @Override
    public boolean checkContract() {
        return false;
    }
}

