/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.PostRunCanonicalizationPhase;

public class RemoveValueProxyPhase
extends PostRunCanonicalizationPhase<CoreProviders> {
    public RemoveValueProxyPhase(CanonicalizerPhase canonicalizer) {
        super(canonicalizer);
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        for (LoopExitNode exit : graph.getNodes(LoopExitNode.TYPE)) {
            exit.removeProxies();
            FrameState frameState = exit.stateAfter();
            if (frameState == null || !frameState.isExceptionHandlingBCI()) continue;
            exit.setStateAfter(null);
            GraphUtil.tryKillUnused(frameState);
        }
        graph.setAfterStage(StructuredGraph.StageFlag.VALUE_PROXY_REMOVAL);
        graph.weakenFrameStateVerification(StructuredGraph.FrameStateVerification.ALL_EXCEPT_LOOP_EXIT);
    }
}

