/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractDeoptimizeNode;
import org.graalvm.compiler.nodes.CompressionNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.DeoptimizingFixedWithNextNode;
import org.graalvm.compiler.nodes.DynamicDeoptimizeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.extended.NullCheckNode;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.phases.common.UseTrappingOperationPhase;
import org.graalvm.compiler.phases.tiers.LowTierContext;

public class UseTrappingNullChecksPhase
extends UseTrappingOperationPhase {
    private static final CounterKey counterTrappingNullCheckExistingRead = DebugContext.counter("TrappingNullCheckExistingRead");

    @Override
    protected void run(StructuredGraph graph, LowTierContext context) {
        if (!Options.UseTrappingNullChecks.getValue(graph.getOptions()).booleanValue() || context.getTarget().implicitNullCheckLimit <= 0) {
            return;
        }
        assert (graph.getGuardsStage().areFrameStatesAtDeopts());
        MetaAccessProvider metaAccessProvider = context.getMetaAccess();
        for (DeoptimizeNode deoptimizeNode : graph.getNodes(DeoptimizeNode.TYPE)) {
            this.tryUseTrappingVersion(deoptimizeNode, deoptimizeNode.predecessor(), deoptimizeNode.getReason(), deoptimizeNode.getSpeculation(), deoptimizeNode.getActionAndReason(metaAccessProvider).asJavaConstant(), deoptimizeNode.getSpeculation(metaAccessProvider).asJavaConstant(), context);
        }
        for (DynamicDeoptimizeNode dynamicDeoptimizeNode : graph.getNodes(DynamicDeoptimizeNode.TYPE)) {
            this.tryUseTrappingVersion(metaAccessProvider, dynamicDeoptimizeNode, context);
        }
    }

    @Override
    public boolean canReplaceCondition(LogicNode condition, IfNode ifNode) {
        return condition instanceof IsNullNode;
    }

    @Override
    public boolean useAddressOptimization(AddressNode adr, LowTierContext context) {
        return adr.getMaxConstantDisplacement() < (long)context.getTarget().implicitNullCheckLimit;
    }

    @Override
    public boolean isSupportedReason(DeoptimizationReason reason) {
        return reason == DeoptimizationReason.NullCheckException || reason != DeoptimizationReason.UnreachedCode || reason == DeoptimizationReason.TypeCheckedInliningViolated;
    }

    @Override
    public DeoptimizingFixedWithNextNode tryReplaceExisting(StructuredGraph graph, AbstractBeginNode nonTrappingContinuation, AbstractBeginNode trappingContinuation, LogicNode condition, IfNode ifNode, AbstractDeoptimizeNode deopt, JavaConstant deoptReasonAndAction, JavaConstant deoptSpeculation, LowTierContext context) {
        IsNullNode isNullNode = (IsNullNode)condition;
        FixedNode nextNonTrapping = nonTrappingContinuation.next();
        ValueNode value = isNullNode.getValue();
        if (GraalOptions.OptImplicitNullChecks.getValue(graph.getOptions()).booleanValue() && nextNonTrapping instanceof FixedAccessNode) {
            FixedAccessNode fixedAccessNode = (FixedAccessNode)nextNonTrapping;
            AddressNode address = fixedAccessNode.getAddress();
            if (fixedAccessNode.canNullCheck() && this.useAddressOptimization(address, context)) {
                ValueNode base = address.getBase();
                ValueNode index = address.getIndex();
                if (base != null && base instanceof CompressionNode) {
                    base = ((CompressionNode)base).getValue();
                }
                if (index != null && index instanceof CompressionNode) {
                    index = ((CompressionNode)index).getValue();
                }
                if (base == value && index == null || base == null && index == value) {
                    fixedAccessNode.setStateBefore(deopt.stateBefore());
                    fixedAccessNode.setUsedAsNullCheck(true);
                    fixedAccessNode.setImplicitDeoptimization(deoptReasonAndAction, deoptSpeculation);
                    graph.removeSplit(ifNode, nonTrappingContinuation);
                    counterTrappingNullCheckExistingRead.increment(graph.getDebug());
                    graph.getDebug().log("Added implicit null check to %s", fixedAccessNode);
                    return fixedAccessNode;
                }
            }
        }
        return null;
    }

    @Override
    public DeoptimizingFixedWithNextNode createImplicitNode(StructuredGraph graph, LogicNode condition, JavaConstant deoptReasonAndAction, JavaConstant deoptSpeculation) {
        IsNullNode isNullNode = (IsNullNode)condition;
        return graph.add(NullCheckNode.create(isNullNode.getValue(), deoptReasonAndAction, deoptSpeculation));
    }

    @Override
    public boolean trueSuccessorIsDeopt() {
        return true;
    }

    @Override
    public void finalAction(DeoptimizingFixedWithNextNode trappingVersionNode, LogicNode condition) {
    }

    @Override
    public void actionBeforeGuardRewrite(DeoptimizingFixedWithNextNode trappingVersionNode) {
    }

    @Override
    public float codeSizeIncrease() {
        return 2.0f;
    }

    public static class Options {
        public static final OptionKey<Boolean> UseTrappingNullChecks = new OptionKey<Boolean>(true);
    }
}

