/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.List;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractDeoptimizeNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.DeoptimizingFixedWithNextNode;
import org.graalvm.compiler.nodes.DynamicDeoptimizeNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.tiers.LowTierContext;
import org.graalvm.compiler.serviceprovider.GraalServices;

public abstract class UseTrappingOperationPhase
extends BasePhase<LowTierContext> {
    public abstract boolean isSupportedReason(DeoptimizationReason var1);

    public abstract boolean canReplaceCondition(LogicNode var1, IfNode var2);

    public abstract boolean useAddressOptimization(AddressNode var1, LowTierContext var2);

    public abstract DeoptimizingFixedWithNextNode tryReplaceExisting(StructuredGraph var1, AbstractBeginNode var2, AbstractBeginNode var3, LogicNode var4, IfNode var5, AbstractDeoptimizeNode var6, JavaConstant var7, JavaConstant var8, LowTierContext var9);

    public abstract DeoptimizingFixedWithNextNode createImplicitNode(StructuredGraph var1, LogicNode var2, JavaConstant var3, JavaConstant var4);

    public abstract boolean trueSuccessorIsDeopt();

    public abstract void finalAction(DeoptimizingFixedWithNextNode var1, LogicNode var2);

    public abstract void actionBeforeGuardRewrite(DeoptimizingFixedWithNextNode var1);

    protected void tryUseTrappingVersion(MetaAccessProvider metaAccessProvider, DynamicDeoptimizeNode deopt, LowTierContext context) {
        Node predecessor = deopt.predecessor();
        if (predecessor instanceof AbstractMergeNode) {
            AbstractMergeNode merge = (AbstractMergeNode)predecessor;
            ValueNode reason = deopt.getActionAndReason();
            ValuePhiNode reasonPhi = null;
            List reasons = null;
            int expectedPhis = 0;
            if (reason instanceof ValuePhiNode) {
                reasonPhi = (ValuePhiNode)reason;
                if (reasonPhi.merge() != merge) {
                    return;
                }
                reasons = reasonPhi.values().snapshot();
                ++expectedPhis;
            } else if (!reason.isConstant()) {
                merge.getDebug().log("Non constant reason %s", merge);
                return;
            }
            ValueNode speculation = deopt.getSpeculation();
            ValuePhiNode speculationPhi = null;
            List speculations = null;
            if (speculation instanceof ValuePhiNode) {
                speculationPhi = (ValuePhiNode)speculation;
                if (speculationPhi.merge() != merge) {
                    return;
                }
                speculations = speculationPhi.values().snapshot();
                ++expectedPhis;
            }
            if (merge.phis().count() != expectedPhis) {
                return;
            }
            int index = 0;
            List predecessors = merge.cfgPredecessors().snapshot();
            for (AbstractEndNode end : predecessors) {
                ValueNode thisSpeculation;
                Node endPredecesssor = end.predecessor();
                ValueNode thisReason = reasons != null ? (ValueNode)reasons.get(index) : reason;
                ValueNode valueNode = thisSpeculation = speculations != null ? (ValueNode)speculations.get(index) : speculation;
                if (!merge.isAlive()) {
                    assert (predecessors.get(predecessors.size() - 1) == end) : "must be last end";
                    endPredecesssor = deopt.predecessor();
                    thisSpeculation = deopt.getSpeculation();
                    thisReason = deopt.getActionAndReason();
                }
                ++index;
                if (!thisReason.isConstant() || !thisSpeculation.isConstant()) {
                    end.getDebug().log("Non constant deopt %s", end);
                    continue;
                }
                DeoptimizationReason deoptimizationReason = metaAccessProvider.decodeDeoptReason(thisReason.asJavaConstant());
                SpeculationLog.Speculation speculationConstant = metaAccessProvider.decodeSpeculation(thisSpeculation.asJavaConstant(), deopt.graph().getSpeculationLog());
                this.tryUseTrappingVersion(deopt, endPredecesssor, deoptimizationReason, speculationConstant, thisReason.asJavaConstant(), thisSpeculation.asJavaConstant(), context);
            }
        }
    }

    protected void tryUseTrappingVersion(AbstractDeoptimizeNode deopt, Node predecessor, DeoptimizationReason deoptimizationReason, SpeculationLog.Speculation speculation, JavaConstant deoptReasonAndAction, JavaConstant deoptSpeculation, LowTierContext context) {
        assert (predecessor != null);
        if (!GraalServices.supportsArbitraryImplicitException() && !this.isSupportedReason(deoptimizationReason)) {
            deopt.getDebug().log(2, "Not a null check / unreached / arithmetic %s", (Object)predecessor);
            return;
        }
        assert (speculation != null);
        if (!GraalServices.supportsArbitraryImplicitException() && !speculation.equals((Object)SpeculationLog.NO_SPECULATION)) {
            deopt.getDebug().log(2, "Has a speculation %s", (Object)predecessor);
            return;
        }
        Node pred = predecessor;
        while (pred instanceof LoopExitNode) {
            pred = pred.predecessor();
        }
        if (pred instanceof AbstractMergeNode) {
            AbstractMergeNode merge = (AbstractMergeNode)pred;
            if (merge.phis().isEmpty()) {
                for (AbstractEndNode end : merge.cfgPredecessors().snapshot()) {
                    this.checkPredecessor(deopt, end.predecessor(), deoptReasonAndAction, deoptSpeculation, context);
                }
            }
        } else if (pred instanceof AbstractBeginNode) {
            this.checkPredecessor(deopt, pred, deoptReasonAndAction, deoptSpeculation, context);
        } else {
            deopt.getDebug().log(2, "Not a Begin or Merge %s", (Object)pred);
        }
    }

    protected void checkPredecessor(AbstractDeoptimizeNode deopt, Node predecessor, JavaConstant deoptReasonAndAction, JavaConstant deoptSpeculation, LowTierContext context) {
        Node current = predecessor;
        AbstractBeginNode branch = null;
        while (current instanceof AbstractBeginNode) {
            branch = (AbstractBeginNode)current;
            if (branch.anchored().isNotEmpty()) {
                return;
            }
            current = current.predecessor();
        }
        if (current instanceof IfNode) {
            IfNode ifNode = (IfNode)current;
            if (this.trueSuccessorIsDeopt() ? branch != ifNode.trueSuccessor() : branch != ifNode.falseSuccessor()) {
                return;
            }
            LogicNode condition = ifNode.condition();
            if (this.canReplaceCondition(condition, ifNode)) {
                this.replaceWithTrappingVersion(deopt, ifNode, condition, deoptReasonAndAction, deoptSpeculation, context);
            }
        }
    }

    protected void replaceWithTrappingVersion(AbstractDeoptimizeNode deopt, IfNode ifNode, LogicNode condition, JavaConstant deoptReasonAndAction, JavaConstant deoptSpeculation, LowTierContext context) {
        DebugContext debug = deopt.getDebug();
        StructuredGraph graph = deopt.graph();
        AbstractBeginNode nonTrappingContinuation = this.trueSuccessorIsDeopt() ? ifNode.falseSuccessor() : ifNode.trueSuccessor();
        AbstractBeginNode trappingContinuation = this.trueSuccessorIsDeopt() ? ifNode.trueSuccessor() : ifNode.falseSuccessor();
        DeoptimizingFixedWithNextNode trappingVersionNode = null;
        trappingVersionNode = this.tryReplaceExisting(graph, nonTrappingContinuation, trappingContinuation, condition, ifNode, deopt, deoptReasonAndAction, deoptSpeculation, context);
        if (trappingVersionNode == null) {
            trappingVersionNode = this.createImplicitNode(graph, condition, deoptReasonAndAction, deoptSpeculation);
            graph.replaceSplit(ifNode, trappingVersionNode, nonTrappingContinuation);
            debug.log("Inserted NullCheckNode %s", trappingVersionNode);
        }
        trappingVersionNode.setStateBefore(deopt.stateBefore());
        this.actionBeforeGuardRewrite(trappingVersionNode);
        nonTrappingContinuation.replaceAtUsages((Node)trappingVersionNode, InputType.Guard);
        if (nonTrappingContinuation instanceof BeginNode) {
            GraphUtil.unlinkFixedNode(nonTrappingContinuation);
            nonTrappingContinuation.safeDelete();
        }
        this.finalAction(trappingVersionNode, condition);
        GraphUtil.killCFG(trappingContinuation);
        GraphUtil.tryKillUnused(condition);
    }
}

