/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.gc.BarrierSet;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;

public class WriteBarrierAdditionPhase
extends BasePhase<CoreProviders> {
    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        BarrierSet barrierSet = context.getPlatformConfigurationProvider().getBarrierSet();
        for (FixedAccessNode n : graph.getNodes(FixedAccessNode.TYPE)) {
            DebugCloseable scope = n.graph().withNodeSourcePosition(n);
            try {
                barrierSet.addBarriers(n);
            }
            finally {
                if (scope == null) continue;
                scope.close();
            }
        }
    }

    @Override
    public boolean checkContract() {
        return false;
    }
}

