/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.util.Arrays;
import java.util.stream.Stream;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.StrideUtil;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.replacements.ArrayIndexOfNode;
import org.graalvm.word.LocationIdentity;

public class ArrayIndexOf {
    private static final LocationIdentity[] NO_LOCATIONS = new LocationIdentity[0];
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_B_S1 = ArrayIndexOf.foreignCallDescriptor("indexOfTwoConsecutiveBS1", byte[].class, 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_B_S2 = ArrayIndexOf.foreignCallDescriptor("indexOfTwoConsecutiveBS2", byte[].class, 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_C_S2 = ArrayIndexOf.foreignCallDescriptor("indexOfTwoConsecutiveCS2", char[].class, 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_B_1_S1 = ArrayIndexOf.foreignCallDescriptor("indexOfB1S1", byte[].class, 1);
    public static final ForeignCallDescriptor STUB_INDEX_OF_B_2_S1 = ArrayIndexOf.foreignCallDescriptor("indexOfB2S1", byte[].class, 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_B_3_S1 = ArrayIndexOf.foreignCallDescriptor("indexOfB3S1", byte[].class, 3);
    public static final ForeignCallDescriptor STUB_INDEX_OF_B_4_S1 = ArrayIndexOf.foreignCallDescriptor("indexOfB4S1", byte[].class, 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_B_1_S2 = ArrayIndexOf.foreignCallDescriptor("indexOfB1S2", byte[].class, 1);
    public static final ForeignCallDescriptor STUB_INDEX_OF_B_2_S2 = ArrayIndexOf.foreignCallDescriptor("indexOfB2S2", byte[].class, 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_B_3_S2 = ArrayIndexOf.foreignCallDescriptor("indexOfB3S2", byte[].class, 3);
    public static final ForeignCallDescriptor STUB_INDEX_OF_B_4_S2 = ArrayIndexOf.foreignCallDescriptor("indexOfB4S2", byte[].class, 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_C_1_S2 = ArrayIndexOf.foreignCallDescriptor("indexOfC1S2", char[].class, 1);
    public static final ForeignCallDescriptor STUB_INDEX_OF_C_2_S2 = ArrayIndexOf.foreignCallDescriptor("indexOfC2S2", char[].class, 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_C_3_S2 = ArrayIndexOf.foreignCallDescriptor("indexOfC3S2", char[].class, 3);
    public static final ForeignCallDescriptor STUB_INDEX_OF_C_4_S2 = ArrayIndexOf.foreignCallDescriptor("indexOfC4S2", char[].class, 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_S1 = ArrayIndexOf.foreignCallDescriptor("indexOfTwoConsecutiveS1", Object.class, 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_S2 = ArrayIndexOf.foreignCallDescriptor("indexOfTwoConsecutiveS2", Object.class, 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_S4 = ArrayIndexOf.foreignCallDescriptor("indexOfTwoConsecutiveS4", Object.class, 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_1_S1 = ArrayIndexOf.foreignCallDescriptor("indexOf1S1", Object.class, 1);
    public static final ForeignCallDescriptor STUB_INDEX_OF_2_S1 = ArrayIndexOf.foreignCallDescriptor("indexOf2S1", Object.class, 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_3_S1 = ArrayIndexOf.foreignCallDescriptor("indexOf3S1", Object.class, 3);
    public static final ForeignCallDescriptor STUB_INDEX_OF_4_S1 = ArrayIndexOf.foreignCallDescriptor("indexOf4S1", Object.class, 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_1_S2 = ArrayIndexOf.foreignCallDescriptor("indexOf1S2", Object.class, 1);
    public static final ForeignCallDescriptor STUB_INDEX_OF_2_S2 = ArrayIndexOf.foreignCallDescriptor("indexOf2S2", Object.class, 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_3_S2 = ArrayIndexOf.foreignCallDescriptor("indexOf3S2", Object.class, 3);
    public static final ForeignCallDescriptor STUB_INDEX_OF_4_S2 = ArrayIndexOf.foreignCallDescriptor("indexOf4S2", Object.class, 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_1_S4 = ArrayIndexOf.foreignCallDescriptor("indexOf1S4", Object.class, 1);
    public static final ForeignCallDescriptor STUB_INDEX_OF_2_S4 = ArrayIndexOf.foreignCallDescriptor("indexOf2S4", Object.class, 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_3_S4 = ArrayIndexOf.foreignCallDescriptor("indexOf3S4", Object.class, 3);
    public static final ForeignCallDescriptor STUB_INDEX_OF_4_S4 = ArrayIndexOf.foreignCallDescriptor("indexOf4S4", Object.class, 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_WITH_MASK_B_S1 = ArrayIndexOf.foreignCallDescriptor("indexOfWithMaskBS1", byte[].class, 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_WITH_MASK_B_S2 = ArrayIndexOf.foreignCallDescriptor("indexOfWithMaskBS2", byte[].class, 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_WITH_MASK_C_S2 = ArrayIndexOf.foreignCallDescriptor("indexOfWithMaskCS2", char[].class, 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_B_S1 = ArrayIndexOf.foreignCallDescriptor("indexOfTwoConsecutiveWithMaskBS1", byte[].class, 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_B_S2 = ArrayIndexOf.foreignCallDescriptor("indexOfTwoConsecutiveWithMaskBS2", byte[].class, 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_C_S2 = ArrayIndexOf.foreignCallDescriptor("indexOfTwoConsecutiveWithMaskCS2", char[].class, 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_WITH_MASK_S1 = ArrayIndexOf.foreignCallDescriptor("indexOfWithMaskS1", Object.class, 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_WITH_MASK_S2 = ArrayIndexOf.foreignCallDescriptor("indexOfWithMaskS2", Object.class, 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_WITH_MASK_S4 = ArrayIndexOf.foreignCallDescriptor("indexOfWithMaskS4", Object.class, 2);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S1 = ArrayIndexOf.foreignCallDescriptor("indexOfTwoConsecutiveWithMaskS1", Object.class, 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S2 = ArrayIndexOf.foreignCallDescriptor("indexOfTwoConsecutiveWithMaskS2", Object.class, 4);
    public static final ForeignCallDescriptor STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S4 = ArrayIndexOf.foreignCallDescriptor("indexOfTwoConsecutiveWithMaskS4", Object.class, 4);
    private static final ForeignCallDescriptor[] STUBS_INDEX_OF_ANY_B = new ForeignCallDescriptor[]{STUB_INDEX_OF_B_1_S1, STUB_INDEX_OF_B_2_S1, STUB_INDEX_OF_B_3_S1, STUB_INDEX_OF_B_4_S1, STUB_INDEX_OF_B_1_S2, STUB_INDEX_OF_B_2_S2, STUB_INDEX_OF_B_3_S2, STUB_INDEX_OF_B_4_S2};
    private static final ForeignCallDescriptor[] STUBS_INDEX_OF_ANY_C = new ForeignCallDescriptor[]{STUB_INDEX_OF_C_1_S2, STUB_INDEX_OF_C_2_S2, STUB_INDEX_OF_C_3_S2, STUB_INDEX_OF_C_4_S2};
    private static final ForeignCallDescriptor[] STUBS_INDEX_OF_ANY = new ForeignCallDescriptor[]{STUB_INDEX_OF_1_S1, STUB_INDEX_OF_2_S1, STUB_INDEX_OF_3_S1, STUB_INDEX_OF_4_S1, STUB_INDEX_OF_1_S2, STUB_INDEX_OF_2_S2, STUB_INDEX_OF_3_S2, STUB_INDEX_OF_4_S2, STUB_INDEX_OF_1_S4, STUB_INDEX_OF_2_S4, STUB_INDEX_OF_3_S4, STUB_INDEX_OF_4_S4};
    public static final ForeignCallDescriptor[] STUBS_AMD64 = (ForeignCallDescriptor[])Stream.concat(Stream.concat(Stream.concat(Stream.of(STUB_INDEX_OF_TWO_CONSECUTIVE_B_S1, STUB_INDEX_OF_TWO_CONSECUTIVE_B_S2, STUB_INDEX_OF_TWO_CONSECUTIVE_C_S2, STUB_INDEX_OF_TWO_CONSECUTIVE_S1, STUB_INDEX_OF_TWO_CONSECUTIVE_S2, STUB_INDEX_OF_TWO_CONSECUTIVE_S4, STUB_INDEX_OF_WITH_MASK_B_S1, STUB_INDEX_OF_WITH_MASK_B_S2, STUB_INDEX_OF_WITH_MASK_C_S2, STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_B_S1, STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_B_S2, STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_C_S2, STUB_INDEX_OF_WITH_MASK_S1, STUB_INDEX_OF_WITH_MASK_S2, STUB_INDEX_OF_WITH_MASK_S4, STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S1, STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S2, STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S4), Arrays.stream(STUBS_INDEX_OF_ANY_B)), Arrays.stream(STUBS_INDEX_OF_ANY_C)), Arrays.stream(STUBS_INDEX_OF_ANY)).toArray(ForeignCallDescriptor[]::new);
    public static final ForeignCallDescriptor[] STUBS_AARCH64 = new ForeignCallDescriptor[]{STUB_INDEX_OF_B_1_S1, STUB_INDEX_OF_B_1_S2, STUB_INDEX_OF_C_1_S2, STUB_INDEX_OF_1_S1, STUB_INDEX_OF_1_S2, STUB_INDEX_OF_1_S4, STUB_INDEX_OF_TWO_CONSECUTIVE_B_S1, STUB_INDEX_OF_TWO_CONSECUTIVE_B_S2, STUB_INDEX_OF_TWO_CONSECUTIVE_C_S2, STUB_INDEX_OF_TWO_CONSECUTIVE_S1, STUB_INDEX_OF_TWO_CONSECUTIVE_S2, STUB_INDEX_OF_TWO_CONSECUTIVE_S4};

    private static ForeignCallDescriptor foreignCallDescriptor(String name, Class<?> arrayArgType, int nValues) {
        Class[] argTypes = new Class[4 + nValues];
        argTypes[0] = arrayArgType;
        argTypes[1] = Long.TYPE;
        for (int i = 2; i < argTypes.length; ++i) {
            argTypes[i] = Integer.TYPE;
        }
        return new ForeignCallDescriptor(name, Integer.TYPE, argTypes, true, NO_LOCATIONS, false, false);
    }

    public static ForeignCallDescriptor getStub(ArrayIndexOfNode indexOfNode) {
        return ArrayIndexOf.getStub(indexOfNode.getArrayKind(), indexOfNode.getStride(), indexOfNode.getNumberOfValues(), indexOfNode.isFindTwoConsecutive(), indexOfNode.isWithMask());
    }

    public static ForeignCallDescriptor getStub(JavaKind arrayKind, JavaKind stride, int valueCount, boolean findTwoConsecutive, boolean withMask) {
        GraalError.guarantee(arrayKind == StrideUtil.S1 || arrayKind == StrideUtil.S2 || arrayKind == StrideUtil.NONE, "unsupported arrayKind");
        GraalError.guarantee(stride == StrideUtil.S1 || stride == StrideUtil.S2 || stride == StrideUtil.S4, "unsupported stride");
        GraalError.guarantee(valueCount >= 1 && valueCount <= 4, "unsupported valueCount");
        if (withMask) {
            if (findTwoConsecutive) {
                GraalError.guarantee(valueCount == 4, "findTwoConsecutive with mask requires 4 values");
                switch (arrayKind) {
                    case Byte: {
                        switch (stride) {
                            case Byte: {
                                return STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_B_S1;
                            }
                            case Char: {
                                return STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_B_S2;
                            }
                        }
                        throw GraalError.shouldNotReachHere();
                    }
                    case Char: {
                        GraalError.guarantee(stride == JavaKind.Char, "unsupported stride for char array");
                        return STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_C_S2;
                    }
                    case Void: {
                        switch (stride) {
                            case Byte: {
                                return STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S1;
                            }
                            case Char: {
                                return STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S2;
                            }
                            case Int: {
                                return STUB_INDEX_OF_TWO_CONSECUTIVE_WITH_MASK_S4;
                            }
                        }
                        throw GraalError.shouldNotReachHere();
                    }
                }
                throw GraalError.shouldNotReachHere();
            }
            GraalError.guarantee(valueCount == 2, "indexOf with mask requires 2 values");
            switch (arrayKind) {
                case Byte: {
                    assert (stride == StrideUtil.S1 || stride == StrideUtil.S2);
                    switch (stride) {
                        case Byte: {
                            return STUB_INDEX_OF_WITH_MASK_B_S1;
                        }
                        case Char: {
                            return STUB_INDEX_OF_WITH_MASK_B_S2;
                        }
                    }
                    throw GraalError.shouldNotReachHere();
                }
                case Char: {
                    GraalError.guarantee(stride == JavaKind.Char, "unsupported stride for char array");
                    return STUB_INDEX_OF_WITH_MASK_C_S2;
                }
                case Void: {
                    switch (stride) {
                        case Byte: {
                            return STUB_INDEX_OF_WITH_MASK_S1;
                        }
                        case Char: {
                            return STUB_INDEX_OF_WITH_MASK_S2;
                        }
                        case Int: {
                            return STUB_INDEX_OF_WITH_MASK_S4;
                        }
                    }
                    throw GraalError.shouldNotReachHere();
                }
            }
            throw GraalError.shouldNotReachHere();
        }
        if (findTwoConsecutive) {
            GraalError.guarantee(valueCount == 2, "findTwoConsecutive without mask requires 2 values");
            switch (arrayKind) {
                case Byte: {
                    switch (stride) {
                        case Byte: {
                            return STUB_INDEX_OF_TWO_CONSECUTIVE_B_S1;
                        }
                        case Char: {
                            return STUB_INDEX_OF_TWO_CONSECUTIVE_B_S2;
                        }
                    }
                    throw GraalError.shouldNotReachHere();
                }
                case Char: {
                    GraalError.guarantee(stride == JavaKind.Char, "unsupported stride for char array");
                    return STUB_INDEX_OF_TWO_CONSECUTIVE_C_S2;
                }
                case Void: {
                    switch (stride) {
                        case Byte: {
                            return STUB_INDEX_OF_TWO_CONSECUTIVE_S1;
                        }
                        case Char: {
                            return STUB_INDEX_OF_TWO_CONSECUTIVE_S2;
                        }
                        case Int: {
                            return STUB_INDEX_OF_TWO_CONSECUTIVE_S4;
                        }
                    }
                    throw GraalError.shouldNotReachHere();
                }
            }
            throw GraalError.shouldNotReachHere();
        }
        int index = 4 * ArrayIndexOf.strideAsPowerOf2(stride) + (valueCount - 1);
        switch (arrayKind) {
            case Byte: {
                return STUBS_INDEX_OF_ANY_B[index];
            }
            case Char: {
                return STUBS_INDEX_OF_ANY_C[valueCount - 1];
            }
            case Void: {
                return STUBS_INDEX_OF_ANY[index];
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public static int indexOfTwoConsecutiveBS1(byte[] array, int length, int fromIndex, byte b1, byte b2) {
        return ArrayIndexOfNode.indexOf2Consecutive(StrideUtil.S1, StrideUtil.S1, array, 0L, length, fromIndex, Byte.toUnsignedInt(b1), Byte.toUnsignedInt(b2));
    }

    public static int indexOfTwoConsecutiveBS2(byte[] array, int length, int fromIndex, char c1, char c2) {
        return ArrayIndexOfNode.indexOf2Consecutive(StrideUtil.S1, StrideUtil.S2, array, 0L, length, fromIndex, c1, c2);
    }

    public static int indexOfTwoConsecutiveCS2(char[] array, int length, int fromIndex, char c1, char c2) {
        return ArrayIndexOfNode.indexOf2Consecutive(StrideUtil.S2, StrideUtil.S2, array, 0L, length, fromIndex, c1, c2);
    }

    public static int indexOfB1S1(byte[] array, int length, int fromIndex, byte b) {
        return ArrayIndexOfNode.indexOf(StrideUtil.S1, StrideUtil.S1, array, 0L, length, fromIndex, Byte.toUnsignedInt(b));
    }

    public static int indexOfB1S2(byte[] array, int length, int fromIndex, char c) {
        return ArrayIndexOfNode.indexOf(StrideUtil.S1, StrideUtil.S2, array, 0L, length, fromIndex, c);
    }

    public static int indexOfC1S2(char[] array, int length, int fromIndex, char c) {
        return ArrayIndexOfNode.indexOf(StrideUtil.S2, StrideUtil.S2, array, 0L, length, fromIndex, c);
    }

    public static int strideAsPowerOf2(JavaKind stride) {
        return Integer.numberOfTrailingZeros(stride.getByteCount());
    }
}

