/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.StrideUtil;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.ConstantReflectionUtil;
import org.graalvm.word.LocationIdentity;

@NodeInfo(size=NodeSize.SIZE_512, cycles=NodeCycles.CYCLES_UNKNOWN)
public class ArrayIndexOfNode
extends FixedWithNextNode
implements Canonicalizable,
LIRLowerable,
MemoryAccess {
    public static final NodeClass<ArrayIndexOfNode> TYPE = NodeClass.create(ArrayIndexOfNode.class);
    private final JavaKind arrayKind;
    private final JavaKind stride;
    private final boolean findTwoConsecutive;
    private final boolean withMask;
    private final LocationIdentity locationIdentity;
    @Node.Input
    private ValueNode arrayPointer;
    @Node.Input
    private ValueNode arrayOffset;
    @Node.Input
    private ValueNode arrayLength;
    @Node.Input
    private ValueNode fromIndex;
    @Node.Input
    private NodeInputList<ValueNode> searchValues;
    @Node.OptionalInput(value=InputType.Memory)
    private MemoryKill lastLocationAccess;

    public ArrayIndexOfNode(@Node.ConstantNodeParameter JavaKind arrayKind, @Node.ConstantNodeParameter JavaKind stride, @Node.ConstantNodeParameter boolean findTwoConsecutive, @Node.ConstantNodeParameter boolean withMask, ValueNode arrayPointer, ValueNode arrayOffset, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        this(TYPE, arrayKind, stride, findTwoConsecutive, withMask, arrayKind == StrideUtil.NONE ? LocationIdentity.any() : NamedLocationIdentity.getArrayLocation(arrayKind), arrayPointer, arrayOffset, arrayLength, fromIndex, searchValues);
    }

    public ArrayIndexOfNode(JavaKind arrayKind, JavaKind stride, boolean findTwoConsecutive, boolean withMask, LocationIdentity locationIdentity, ValueNode arrayPointer, ValueNode arrayOffset, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        this(TYPE, arrayKind, stride, findTwoConsecutive, withMask, locationIdentity, arrayPointer, arrayOffset, arrayLength, fromIndex, searchValues);
    }

    public ArrayIndexOfNode(NodeClass<? extends ArrayIndexOfNode> c, JavaKind arrayKind, JavaKind stride, boolean findTwoConsecutive, boolean withMask, LocationIdentity locationIdentity, ValueNode arrayPointer, ValueNode arrayOffset, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        super((NodeClass<? extends FixedWithNextNode>)c, StampFactory.forKind(JavaKind.Int));
        GraalError.guarantee(arrayKind == StrideUtil.S1 || arrayKind == StrideUtil.S2 || arrayKind == StrideUtil.S4 || arrayKind == StrideUtil.NONE, "unsupported arrayKind");
        GraalError.guarantee(withMask || !findTwoConsecutive || searchValues.length == 2, "findTwoConsecutive without mask requires exactly two search values");
        GraalError.guarantee(!withMask || !findTwoConsecutive || searchValues.length == 4, "findTwoConsecutive with mask requires exactly four search values");
        GraalError.guarantee(!withMask || findTwoConsecutive || searchValues.length == 2, "indexOf with mask requires exactly two search values");
        this.arrayKind = arrayKind;
        this.stride = stride;
        this.findTwoConsecutive = findTwoConsecutive;
        this.withMask = withMask;
        this.locationIdentity = locationIdentity;
        this.arrayPointer = arrayPointer;
        this.arrayOffset = arrayOffset;
        this.arrayLength = arrayLength;
        this.fromIndex = fromIndex;
        this.searchValues = new NodeInputList((Node)this, (Node[])searchValues);
    }

    public JavaKind getArrayKind() {
        return this.arrayKind;
    }

    public boolean isFindTwoConsecutive() {
        return this.findTwoConsecutive;
    }

    public boolean isWithMask() {
        return this.withMask;
    }

    public ValueNode getArrayPointer() {
        return this.arrayPointer;
    }

    public ValueNode getArrayOffset() {
        return this.arrayOffset;
    }

    public ValueNode getArrayLength() {
        return this.arrayLength;
    }

    public ValueNode getFromIndex() {
        return this.fromIndex;
    }

    public NodeInputList<ValueNode> getSearchValues() {
        return this.searchValues;
    }

    public int getNumberOfValues() {
        return this.searchValues.size();
    }

    public JavaKind getStride() {
        return this.stride;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        ForeignCallLinkage linkage;
        if (GraalOptions.UseGraalStubs.getValue(this.graph().getOptions()).booleanValue() && (linkage = gen.lookupGraalStub(this)) != null) {
            Value[] operands = new Value[4 + this.searchValues.size()];
            operands[0] = gen.operand(this.arrayPointer);
            operands[1] = gen.operand(this.arrayOffset);
            operands[2] = gen.operand(this.arrayLength);
            operands[3] = gen.operand(this.fromIndex);
            for (int i = 0; i < this.searchValues.size(); ++i) {
                operands[4 + i] = gen.operand((Node)this.searchValues.get(i));
            }
            Variable result = gen.getLIRGeneratorTool().emitForeignCall(linkage, null, operands);
            gen.setResult(this, (Value)result);
            return;
        }
        this.generateArrayIndexOf(gen);
    }

    private void generateArrayIndexOf(NodeLIRBuilderTool gen) {
        int arrayBaseOffset = this.arrayKind == JavaKind.Void ? 0 : this.getArrayBaseOffset(gen.getLIRGeneratorTool().getMetaAccess(), this.arrayPointer, this.arrayKind);
        Variable result = gen.getLIRGeneratorTool().emitArrayIndexOf(arrayBaseOffset, this.stride, this.findTwoConsecutive, this.withMask, gen.operand(this.arrayPointer), gen.operand(this.arrayOffset), gen.operand(this.arrayLength), gen.operand(this.fromIndex), this.searchValuesAsOperands(gen));
        gen.setResult(this, (Value)result);
    }

    protected int getArrayBaseOffset(MetaAccessProvider metaAccessProvider, ValueNode array, JavaKind kind) {
        return metaAccessProvider.getArrayBaseOffset(kind);
    }

    private Value[] searchValuesAsOperands(NodeLIRBuilderTool gen) {
        Value[] searchValueOperands = new Value[this.searchValues.size()];
        for (int i = 0; i < this.searchValues.size(); ++i) {
            searchValueOperands[i] = gen.operand((Node)this.searchValues.get(i));
        }
        return searchValueOperands;
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return this.locationIdentity;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.arrayPointer.isJavaConstant() && ((ConstantNode)this.arrayPointer).getStableDimension() > 0 && this.arrayOffset.isJavaConstant() && this.arrayLength.isJavaConstant() && this.fromIndex.isJavaConstant() && this.searchValuesConstant()) {
            int i;
            ConstantReflectionProvider provider = tool.getConstantReflection();
            JavaConstant arrayConstant = this.arrayPointer.asJavaConstant();
            JavaKind constantArrayKind = this.arrayPointer.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess()).getComponentType().getJavaKind();
            int actualArrayLength = provider.readArrayLength(arrayConstant);
            long arrayBaseOffsetBytesConstant = this.arrayOffset.asJavaConstant().asLong();
            if (this.arrayKind == StrideUtil.NONE) {
                arrayBaseOffsetBytesConstant -= (long)this.getArrayBaseOffset(tool.getMetaAccess(), this.arrayPointer, constantArrayKind);
            }
            long arrayOffsetConstant = arrayBaseOffsetBytesConstant / (long)this.stride.getByteCount();
            int arrayLengthConstant = this.arrayLength.asJavaConstant().asInt();
            assert (arrayLengthConstant * this.stride.getByteCount() <= actualArrayLength * constantArrayKind.getByteCount());
            int fromIndexConstant = this.fromIndex.asJavaConstant().asInt();
            int[] valuesConstant = new int[this.searchValues.size()];
            for (i = 0; i < this.searchValues.size(); ++i) {
                valuesConstant[i] = ((ValueNode)this.searchValues.get(i)).asJavaConstant().asInt();
            }
            if (arrayLengthConstant * this.stride.getByteCount() < GraalOptions.StringIndexOfConstantLimit.getValue(tool.getOptions())) {
                if (this.findTwoConsecutive) {
                    assert (valuesConstant.length == (this.withMask ? 4 : 2));
                    for (i = fromIndexConstant; i < arrayLengthConstant - 1; ++i) {
                        int v0 = ConstantReflectionUtil.readTypePunned(provider, arrayConstant, constantArrayKind, this.stride, (int)(arrayOffsetConstant + (long)i));
                        int v1 = ConstantReflectionUtil.readTypePunned(provider, arrayConstant, constantArrayKind, this.stride, (int)(arrayOffsetConstant + (long)i + 1L));
                        if (!(this.withMask ? (v0 | valuesConstant[2]) == valuesConstant[0] && (v1 | valuesConstant[3]) == valuesConstant[1] : v0 == valuesConstant[0] && v1 == valuesConstant[1])) continue;
                        return ConstantNode.forInt(i);
                    }
                } else {
                    assert (!this.withMask || valuesConstant.length == 2);
                    for (i = fromIndexConstant; i < arrayLengthConstant; ++i) {
                        int value = ConstantReflectionUtil.readTypePunned(provider, arrayConstant, constantArrayKind, this.stride, (int)(arrayOffsetConstant + (long)i));
                        if (this.withMask) {
                            if ((value | valuesConstant[1]) != valuesConstant[0]) continue;
                            return ConstantNode.forInt(i);
                        }
                        for (int searchValue : valuesConstant) {
                            if (value != searchValue) continue;
                            return ConstantNode.forInt(i);
                        }
                    }
                }
                return ConstantNode.forInt(-1);
            }
        }
        return this;
    }

    private boolean searchValuesConstant() {
        for (ValueNode s : this.searchValues) {
            if (s.isJavaConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lastLocationAccess), ValueNodeUtil.asNode(lla));
        this.lastLocationAccess = lla;
    }

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, @Node.ConstantNodeParameter boolean var3, Object var4, long var5, int var7, int var8, int var9);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, @Node.ConstantNodeParameter boolean var3, Object var4, long var5, int var7, int var8, int var9, int var10);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, @Node.ConstantNodeParameter boolean var3, Object var4, long var5, int var7, int var8, int var9, int var10, int var11);

    @Node.NodeIntrinsic
    public static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, @Node.ConstantNodeParameter boolean var3, Object var4, long var5, int var7, int var8, int var9, int var10, int var11, int var12);

    public static int indexOf(JavaKind arrayKind, JavaKind stride, Object array, long arrayOffset, int arrayLength, int fromIndex, int v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(arrayKind, stride, false, false, array, arrayOffset, arrayLength, fromIndex, v1);
    }

    public static int indexOf2Consecutive(JavaKind arrayKind, JavaKind stride, Object array, long arrayOffset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(arrayKind, stride, true, false, array, arrayOffset, arrayLength, fromIndex, v1, v2);
    }
}

