/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.graph.SourceLanguagePositionProvider;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.GraphEncoder;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.DominatorBasedGlobalValueNumberingPhase;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.PEGraphDecoder;

public class CachingPEGraphDecoder
extends PEGraphDecoder {
    private static final TimerKey BuildGraphTimer = DebugContext.timer("PartialEvaluation-GraphBuilding");
    protected final Providers providers;
    protected final GraphBuilderConfiguration graphBuilderConfig;
    protected final OptimisticOptimizations optimisticOpts;
    private final StructuredGraph.AllowAssumptions allowAssumptions;
    private final EconomicMap<ResolvedJavaMethod, EncodedGraph> persistentGraphCache;
    private final EconomicMap<ResolvedJavaMethod, EncodedGraph> localGraphCache;
    private final Supplier<AutoCloseable> createPersistentCachedGraphScope;
    private final BasePhase<? super CoreProviders> postParsingPhase;

    public CachingPEGraphDecoder(Architecture architecture, StructuredGraph graph, Providers providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, StructuredGraph.AllowAssumptions allowAssumptions, LoopExplosionPlugin loopExplosionPlugin, InvocationPlugins invocationPlugins, InlineInvokePlugin[] inlineInvokePlugins, ParameterPlugin parameterPlugin, NodePlugin[] nodePlugins, ResolvedJavaMethod peRootForInlining, SourceLanguagePositionProvider sourceLanguagePositionProvider, BasePhase<? super CoreProviders> postParsingPhase, EconomicMap<ResolvedJavaMethod, EncodedGraph> persistentGraphCache, Supplier<AutoCloseable> createPersistentCachedGraphScope, boolean needsExplicitException) {
        super(architecture, graph, providers, loopExplosionPlugin, invocationPlugins, inlineInvokePlugins, parameterPlugin, nodePlugins, peRootForInlining, sourceLanguagePositionProvider, new ConcurrentHashMap<PEGraphDecoder.SpecialCallTargetCacheKey, Object>(), new ConcurrentHashMap<ResolvedJavaMethod, Object>(), needsExplicitException);
        this.providers = providers;
        this.graphBuilderConfig = graphBuilderConfig;
        this.optimisticOpts = optimisticOpts;
        this.allowAssumptions = allowAssumptions;
        this.postParsingPhase = postParsingPhase;
        this.persistentGraphCache = persistentGraphCache;
        this.createPersistentCachedGraphScope = createPersistentCachedGraphScope;
        this.localGraphCache = EconomicMap.create();
    }

    protected GraphBuilderPhase.Instance createGraphBuilderPhaseInstance(IntrinsicContext initialIntrinsicContext) {
        return new GraphBuilderPhase.Instance(this.providers, this.graphBuilderConfig, this.optimisticOpts, initialIntrinsicContext);
    }

    private EncodedGraph createGraph(ResolvedJavaMethod method, BytecodeProvider intrinsicBytecodeProvider, boolean isSubstitution) {
        CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
        if (isSubstitution && Services.IS_IN_NATIVE_IMAGE) {
            throw GraalError.shouldNotReachHere("dead path");
        }
        StructuredGraph graphToEncode = this.buildGraph(method, intrinsicBytecodeProvider, isSubstitution, canonicalizer);
        try (DebugContext.Scope scope = this.debug.scope((Object)"createGraph", graphToEncode);){
            new ConvertDeoptimizeToGuardPhase(canonicalizer).apply(graphToEncode, this.providers);
            if (GraalOptions.EarlyGVN.getValue(graphToEncode.getOptions()).booleanValue()) {
                new DominatorBasedGlobalValueNumberingPhase().apply(graphToEncode, this.providers);
            }
        }
        catch (Throwable t) {
            throw this.debug.handle(t);
        }
        EncodedGraph encodedGraph = GraphEncoder.encodeSingleGraph(graphToEncode, this.architecture);
        this.persistentGraphCache.put((Object)method, (Object)encodedGraph);
        return encodedGraph;
    }

    private StructuredGraph buildGraph(ResolvedJavaMethod method, BytecodeProvider intrinsicBytecodeProvider, boolean isSubstitution, CanonicalizerPhase canonicalizer) {
        StructuredGraph graphToEncode = new StructuredGraph.Builder(this.options, this.debug, this.allowAssumptions).profileProvider(null).trackNodeSourcePosition(this.graphBuilderConfig.trackNodeSourcePosition()).method(method).setIsSubstitution(isSubstitution).cancellable(this.graph.getCancellable()).build();
        try (DebugContext.Scope scope = this.debug.scope((Object)"buildGraph", graphToEncode);
             DebugCloseable a = BuildGraphTimer.start(this.debug);){
            if (intrinsicBytecodeProvider != null) {
                throw GraalError.shouldNotReachHere("isn't this dead?");
            }
            IntrinsicContext initialIntrinsicContext = null;
            GraphBuilderPhase.Instance graphBuilderPhaseInstance = this.createGraphBuilderPhaseInstance(initialIntrinsicContext);
            graphBuilderPhaseInstance.apply(graphToEncode);
            canonicalizer.apply(graphToEncode, this.providers);
            if (this.postParsingPhase != null) {
                this.postParsingPhase.apply(graphToEncode, this.providers);
            }
        }
        catch (Throwable ex) {
            throw this.debug.handle(ex);
        }
        return graphToEncode;
    }

    private static boolean verifyAssumptions(EncodedGraph graph) {
        Assumptions assumptions = graph.getAssumptions();
        if (assumptions == null || assumptions.isEmpty()) {
            return true;
        }
        for (Assumptions.Assumption assumption : assumptions) {
            ResolvedJavaType candidate;
            Assumptions.AssumptionResult assumptionResult;
            if (assumption instanceof Assumptions.LeafType) {
                Assumptions.LeafType leafType = (Assumptions.LeafType)assumption;
                assumptionResult = leafType.context.findLeafConcreteSubtype();
                if (assumptionResult == null || leafType.context.equals(candidate = (ResolvedJavaType)assumptionResult.getResult())) continue;
                return false;
            }
            if (assumption instanceof Assumptions.ConcreteSubtype) {
                Assumptions.ConcreteSubtype concreteSubtype = (Assumptions.ConcreteSubtype)assumption;
                assumptionResult = concreteSubtype.context.findLeafConcreteSubtype();
                if (assumptionResult == null || concreteSubtype.subtype.isAssignableFrom(candidate = (ResolvedJavaType)assumptionResult.getResult())) continue;
                return false;
            }
            if (assumption instanceof Assumptions.ConcreteMethod) {
                Assumptions.ConcreteMethod concreteMethod = (Assumptions.ConcreteMethod)assumption;
                assumptionResult = concreteMethod.context.findUniqueConcreteMethod(concreteMethod.method);
                if (assumptionResult != null && concreteMethod.impl.equals(assumptionResult.getResult())) continue;
                return false;
            }
            if (assumption instanceof Assumptions.NoFinalizableSubclass || assumption instanceof Assumptions.CallSiteTargetValue || "org.graalvm.compiler.truffle.compiler.nodes.TruffleAssumption".equals(assumption.getClass().getName())) continue;
            throw GraalError.shouldNotReachHere("unexpected assumption " + assumption);
        }
        return true;
    }

    private EncodedGraph lookupOrCreatePersistentEncodedGraph(ResolvedJavaMethod method, BytecodeProvider intrinsicBytecodeProvider, boolean isSubstitution, boolean trackNodeSourcePosition) {
        EncodedGraph result = (EncodedGraph)this.persistentGraphCache.get((Object)method);
        if (result == null && method.hasBytecodes()) {
            try (AutoCloseable scope = this.createPersistentCachedGraphScope.get();){
                result = this.createGraph(method, intrinsicBytecodeProvider, isSubstitution);
            }
            catch (Throwable ex) {
                throw this.debug.handle(ex);
            }
        }
        return result;
    }

    @Override
    protected EncodedGraph lookupEncodedGraph(ResolvedJavaMethod method, BytecodeProvider intrinsicBytecodeProvider, boolean isSubstitution, boolean trackNodeSourcePosition) {
        EncodedGraph result = (EncodedGraph)this.localGraphCache.get((Object)method);
        if (result != null) {
            return result;
        }
        result = (EncodedGraph)this.persistentGraphCache.get((Object)method);
        if (result == null) {
            result = this.lookupOrCreatePersistentEncodedGraph(method, intrinsicBytecodeProvider, isSubstitution, trackNodeSourcePosition);
            if (result != null) {
                this.localGraphCache.put((Object)method, (Object)result);
            }
        } else if (!CachingPEGraphDecoder.verifyAssumptions(result)) {
            this.persistentGraphCache.removeKey((Object)method);
            result = this.lookupOrCreatePersistentEncodedGraph(method, intrinsicBytecodeProvider, isSubstitution, trackNodeSourcePosition);
            if (result != null) {
                this.localGraphCache.put((Object)method, (Object)result);
            }
        } else {
            this.localGraphCache.put((Object)method, (Object)result);
        }
        return result;
    }
}

