/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.StrideUtil;
import org.graalvm.compiler.nodes.ValueNode;

public final class NodeStrideUtil {
    public static JavaKind getConstantStrideA(ValueNode dynamicStrides, JavaKind strideA) {
        if (strideA != null) {
            return strideA;
        }
        return StrideUtil.getConstantStrideA(dynamicStrides.asJavaConstant().asInt());
    }

    public static JavaKind getConstantStrideB(ValueNode dynamicStrides, JavaKind strideB) {
        if (strideB != null) {
            return strideB;
        }
        return StrideUtil.getConstantStrideB(dynamicStrides.asJavaConstant().asInt());
    }

    public static int getDirectStubCallIndex(ValueNode dynamicStrides, JavaKind strideA, JavaKind strideB) {
        if (strideA != null && strideB != null) {
            return StrideUtil.getDirectStubCallIndex(StrideUtil.log2(strideA), StrideUtil.log2(strideB));
        }
        if (dynamicStrides != null && dynamicStrides.isJavaConstant()) {
            return dynamicStrides.asJavaConstant().asInt();
        }
        return -1;
    }
}

