/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.ArrayIndexOf;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.StringHelperIntrinsics;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsNode;
import org.graalvm.word.LocationIdentity;

public class StringLatin1Snippets
implements Snippets {
    public static final MetaAccessProvider INJECTED = null;

    private static long byteArrayOffset(long offset) {
        return (long)ReplacementsUtil.byteArrayBaseOffset(INJECTED) + offset * (long)ReplacementsUtil.byteArrayIndexScale(INJECTED);
    }

    @Snippet
    public static int indexOf(byte[] source, int sourceCount, byte[] target, int targetCount, int fromIndex) {
        ReplacementsUtil.dynamicAssert(fromIndex >= 0, "StringLatin1.indexOf invalid args: fromIndex negative");
        ReplacementsUtil.dynamicAssert(targetCount > 0, "StringLatin1.indexOf invalid args: targetCount <= 0");
        if (GraalDirectives.injectBranchProbability(0.25, sourceCount - fromIndex < targetCount)) {
            return -1;
        }
        if (GraalDirectives.injectBranchProbability(0.25, targetCount == 1)) {
            return ArrayIndexOf.indexOfB1S1(source, sourceCount, fromIndex, StringHelperIntrinsics.getByte(target, 0));
        }
        int offset = fromIndex;
        int haystackLength = sourceCount - (targetCount - 2);
        if (GraalDirectives.injectBranchProbability(0.75, offset < haystackLength)) {
            byte b1 = StringHelperIntrinsics.getByte(target, 0);
            byte b2 = StringHelperIntrinsics.getByte(target, 1);
            do {
                int indexOfResult;
                if (GraalDirectives.injectBranchProbability(0.25, (indexOfResult = ArrayIndexOf.indexOfTwoConsecutiveBS1(source, haystackLength, offset, b1, b2)) < 0)) {
                    return -1;
                }
                offset = indexOfResult;
                if (GraalDirectives.injectBranchProbability(0.25, targetCount == 2)) {
                    return offset;
                }
                if (!GraalDirectives.injectBranchProbability(0.25, ArrayRegionEqualsNode.regionEquals((Object)source, StringLatin1Snippets.byteArrayOffset(offset), (Object)target, StringLatin1Snippets.byteArrayOffset(0L), targetCount, JavaKind.Byte))) continue;
                return offset;
            } while (GraalDirectives.injectBranchProbability(0.75, ++offset < haystackLength));
        }
        return -1;
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        public final SnippetTemplate.SnippetInfo indexOf = this.snippet(StringLatin1Snippets.class, "indexOf", new LocationIdentity[0]);

        public Templates(OptionValues options, Providers providers) {
            super(options, providers);
        }
    }
}

