/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.ArrayIndexOf;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.StringHelperIntrinsics;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsNode;
import org.graalvm.word.LocationIdentity;

public class StringUTF16Snippets
implements Snippets {
    protected static final MetaAccessProvider INJECTED = null;

    private static int length(byte[] value) {
        return value.length >> 1;
    }

    private static long byteArrayCharOffset(long offset) {
        return (long)ReplacementsUtil.byteArrayBaseOffset(INJECTED) + offset * (long)ReplacementsUtil.charArrayIndexScale(INJECTED);
    }

    private static native char getChar(byte[] var0, int var1);

    @Snippet
    public static int indexOfUnsafe(byte[] source, int sourceCount, byte[] target, int targetCount, int fromIndex) {
        ReplacementsUtil.dynamicAssert(fromIndex >= 0, "StringUTF16.indexOfUnsafe invalid args: fromIndex negative");
        ReplacementsUtil.dynamicAssert(targetCount > 0, "StringUTF16.indexOfUnsafe invalid args: targetCount <= 0");
        ReplacementsUtil.dynamicAssert(targetCount <= StringUTF16Snippets.length(target), "StringUTF16.indexOfUnsafe invalid args: targetCount > length(target)");
        ReplacementsUtil.dynamicAssert(sourceCount >= targetCount, "StringUTF16.indexOfUnsafe invalid args: sourceCount < targetCount");
        if (targetCount == 1) {
            return ArrayIndexOf.indexOfB1S2(source, sourceCount, fromIndex, StringUTF16Snippets.getChar(target, 0));
        }
        int haystackLength = sourceCount - (targetCount - 2);
        int offset = fromIndex;
        while (GraalDirectives.injectBranchProbability(0.75, offset < haystackLength)) {
            int indexOfResult = ArrayIndexOf.indexOfTwoConsecutiveBS2(source, haystackLength, offset, StringUTF16Snippets.getChar(target, 0), StringUTF16Snippets.getChar(target, 1));
            if (GraalDirectives.injectBranchProbability(0.25, indexOfResult < 0)) {
                return -1;
            }
            offset = indexOfResult;
            if (GraalDirectives.injectBranchProbability(0.25, targetCount == 2)) {
                return offset;
            }
            if (GraalDirectives.injectBranchProbability(0.25, ArrayRegionEqualsNode.regionEquals((Object)source, StringUTF16Snippets.byteArrayCharOffset(offset), (Object)target, StringUTF16Snippets.byteArrayCharOffset(0L), targetCount, JavaKind.Char))) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    @Snippet
    public static int indexOfLatin1Unsafe(byte[] source, int sourceCount, byte[] target, int targetCount, int fromIndex) {
        ReplacementsUtil.dynamicAssert(fromIndex >= 0, "StringUTF16.indexOfLatin1Unsafe invalid args: fromIndex negative");
        ReplacementsUtil.dynamicAssert(targetCount > 0, "StringUTF16.indexOfLatin1Unsafe invalid args: targetCount <= 0");
        ReplacementsUtil.dynamicAssert(targetCount <= target.length, "StringUTF16.indexOfLatin1Unsafe invalid args: targetCount > length(target)");
        ReplacementsUtil.dynamicAssert(sourceCount >= targetCount, "StringUTF16.indexOfLatin1Unsafe invalid args: sourceCount < targetCount");
        if (targetCount == 1) {
            return ArrayIndexOf.indexOfB1S2(source, sourceCount, fromIndex, (char)Byte.toUnsignedInt(StringHelperIntrinsics.getByte(target, 0)));
        }
        int offset = fromIndex;
        int haystackLength = sourceCount - (targetCount - 2);
        if (GraalDirectives.injectBranchProbability(0.75, offset < haystackLength)) {
            char c1 = (char)Byte.toUnsignedInt(StringHelperIntrinsics.getByte(target, 0));
            char c2 = (char)Byte.toUnsignedInt(StringHelperIntrinsics.getByte(target, 1));
            do {
                int indexOfResult;
                if (GraalDirectives.injectBranchProbability(0.25, (indexOfResult = ArrayIndexOf.indexOfTwoConsecutiveBS2(source, haystackLength, offset, c1, c2)) < 0)) {
                    return -1;
                }
                offset = indexOfResult;
                if (GraalDirectives.injectBranchProbability(0.25, targetCount == 2)) {
                    return offset;
                }
                if (!GraalDirectives.injectBranchProbability(0.25, ArrayRegionEqualsNode.regionEquals(source, StringUTF16Snippets.byteArrayCharOffset(offset), target, StringUTF16Snippets.byteArrayCharOffset(0L), targetCount, JavaKind.Char, JavaKind.Byte))) continue;
                return offset;
            } while (GraalDirectives.injectBranchProbability(0.75, ++offset < haystackLength));
        }
        return -1;
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        public final SnippetTemplate.SnippetInfo indexOfLatin1Unsafe = this.snippet(StringUTF16Snippets.class, "indexOfLatin1Unsafe", new LocationIdentity[0]);
        public final SnippetTemplate.SnippetInfo indexOfUnsafe = this.snippet(StringUTF16Snippets.class, "indexOfUnsafe", new LocationIdentity[0]);

        public Templates(OptionValues options, Providers providers) {
            super(options, providers);
        }
    }
}

