/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.StrideUtil;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.ConstantReflectionUtil;
import org.graalvm.compiler.replacements.NodeStrideUtil;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_128)
public final class AMD64ArrayRegionEqualsWithMaskNode
extends FixedWithNextNode
implements Canonicalizable,
LIRLowerable,
MemoryAccess,
ConstantReflectionUtil.ArrayBaseOffsetProvider {
    public static final NodeClass<AMD64ArrayRegionEqualsWithMaskNode> TYPE = NodeClass.create(AMD64ArrayRegionEqualsWithMaskNode.class);
    private final JavaKind arrayKind;
    private final JavaKind strideA;
    private final JavaKind strideB;
    private final JavaKind strideMask;
    private final LocationIdentity locationIdentity;
    @Node.Input
    protected ValueNode arrayA;
    @Node.Input
    protected ValueNode offsetA;
    @Node.Input
    protected ValueNode arrayB;
    @Node.Input
    protected ValueNode offsetB;
    @Node.Input
    protected ValueNode arrayMask;
    @Node.Input
    protected ValueNode length;
    @Node.OptionalInput
    protected ValueNode dynamicStrides;
    @Node.OptionalInput(value=InputType.Memory)
    private MemoryKill lastLocationAccess;

    public AMD64ArrayRegionEqualsWithMaskNode(@Node.ConstantNodeParameter JavaKind arrayKind, @Node.ConstantNodeParameter JavaKind strideA, @Node.ConstantNodeParameter JavaKind strideB, @Node.ConstantNodeParameter JavaKind strideMask, ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode arrayMask, ValueNode length) {
        this(arrayKind, strideA, strideB, strideMask, AMD64ArrayRegionEqualsWithMaskNode.defaultLocationIdentity(arrayKind, strideA, strideB, strideMask), arrayA, offsetA, arrayB, offsetB, arrayMask, length, null);
    }

    public AMD64ArrayRegionEqualsWithMaskNode(ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode arrayMask, ValueNode length, ValueNode dynamicStrides) {
        this(StrideUtil.NONE, null, null, null, LocationIdentity.ANY_LOCATION, arrayA, offsetA, arrayB, offsetB, arrayMask, length, dynamicStrides);
    }

    public AMD64ArrayRegionEqualsWithMaskNode(JavaKind arrayKind, JavaKind strideA, JavaKind strideB, JavaKind strideMask, LocationIdentity locationIdentity, ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode arrayMask, ValueNode length, ValueNode dynamicStrides) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(JavaKind.Boolean));
        assert (AMD64ArrayRegionEqualsWithMaskNode.validStride(strideA));
        assert (AMD64ArrayRegionEqualsWithMaskNode.validStride(strideB));
        assert (AMD64ArrayRegionEqualsWithMaskNode.validStride(strideMask));
        this.arrayKind = arrayKind;
        this.strideA = strideA;
        this.strideB = strideB;
        this.strideMask = strideMask;
        this.locationIdentity = locationIdentity;
        this.arrayA = arrayA;
        this.offsetA = offsetA;
        this.arrayB = arrayB;
        this.offsetB = offsetB;
        this.arrayMask = arrayMask;
        this.length = length;
        this.dynamicStrides = dynamicStrides;
    }

    private static boolean validStride(JavaKind stride) {
        return stride == null || stride == StrideUtil.S1 || stride == StrideUtil.S2 || stride == StrideUtil.S4;
    }

    public JavaKind getArrayKind() {
        return this.arrayKind;
    }

    public JavaKind getStrideA() {
        return this.strideA;
    }

    public JavaKind getStrideB() {
        return this.strideB;
    }

    public JavaKind getStrideMask() {
        return this.strideMask;
    }

    public ValueNode getDynamicStrides() {
        return this.dynamicStrides;
    }

    public ValueNode getLength() {
        return this.length;
    }

    private static boolean sameKinds(JavaKind arrayKind, JavaKind strideA, JavaKind strideB, JavaKind strideMask) {
        return strideA == arrayKind && strideB == arrayKind && strideMask == arrayKind;
    }

    private static LocationIdentity defaultLocationIdentity(JavaKind arrayKind, JavaKind strideA, JavaKind strideB, JavaKind strideMask) {
        return !AMD64ArrayRegionEqualsWithMaskNode.sameKinds(arrayKind, strideA, strideB, strideMask) || arrayKind == StrideUtil.NONE ? LocationIdentity.any() : NamedLocationIdentity.getArrayLocation(arrayKind);
    }

    public int getDirectStubCallIndex() {
        return NodeStrideUtil.getDirectStubCallIndex(this.dynamicStrides, this.strideA, this.strideB);
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        ForeignCallLinkage linkage;
        if (GraalOptions.UseGraalStubs.getValue(this.graph().getOptions()).booleanValue() && (linkage = gen.lookupGraalStub(this)) != null) {
            Variable result = this.getDirectStubCallIndex() < 0 ? gen.getLIRGeneratorTool().emitForeignCall(linkage, null, gen.operand(this.arrayA), gen.operand(this.offsetA), gen.operand(this.arrayB), gen.operand(this.offsetB), gen.operand(this.arrayMask), gen.operand(this.length), gen.operand(this.dynamicStrides)) : gen.getLIRGeneratorTool().emitForeignCall(linkage, null, gen.operand(this.arrayA), gen.operand(this.offsetA), gen.operand(this.arrayB), gen.operand(this.offsetB), gen.operand(this.arrayMask), gen.operand(this.length));
            gen.setResult(this, (Value)result);
            return;
        }
        this.generateArrayRegionEquals(gen);
    }

    @Override
    public int getArrayBaseOffset(MetaAccessProvider metaAccess, ValueNode array, JavaKind elementKind) {
        return metaAccess.getArrayBaseOffset(elementKind);
    }

    private void generateArrayRegionEquals(NodeLIRBuilderTool gen) {
        MetaAccessProvider metaAccess = gen.getLIRGeneratorTool().getMetaAccess();
        int maskBaseOffset = metaAccess.getArrayBaseOffset(this.arrayKind == StrideUtil.NONE ? JavaKind.Byte : this.arrayKind);
        Variable result = this.getDirectStubCallIndex() < 0 ? gen.getLIRGeneratorTool().emitArrayEquals(0, 0, maskBaseOffset, gen.operand(this.arrayA), gen.operand(this.offsetA), gen.operand(this.arrayB), gen.operand(this.offsetB), gen.operand(this.arrayMask), gen.operand(this.length), gen.operand(this.dynamicStrides)) : gen.getLIRGeneratorTool().emitArrayEquals(NodeStrideUtil.getConstantStrideA(this.dynamicStrides, this.strideA), NodeStrideUtil.getConstantStrideB(this.dynamicStrides, this.strideB), NodeStrideUtil.getConstantStrideB(this.dynamicStrides, this.strideMask), 0, 0, maskBaseOffset, gen.operand(this.arrayA), gen.operand(this.offsetA), gen.operand(this.arrayB), gen.operand(this.offsetB), gen.operand(this.arrayMask), gen.operand(this.length));
        gen.setResult(this, (Value)result);
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return this.locationIdentity;
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lastLocationAccess), ValueNodeUtil.asNode(lla));
        this.lastLocationAccess = lla;
    }

    @Node.NodeIntrinsic
    public static native boolean regionEquals(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, @Node.ConstantNodeParameter JavaKind var3, Object var4, long var5, Object var7, long var8, Object var10, int var11);

    @Node.NodeIntrinsic
    public static native boolean regionEquals(Object var0, long var1, Object var3, long var4, Object var6, int var7, int var8);

    @Override
    public ValueNode canonical(CanonicalizerTool tool) {
        if ((this.dynamicStrides == null || this.dynamicStrides.isJavaConstant()) && this.length.isJavaConstant()) {
            int len = this.length.asJavaConstant().asInt();
            JavaKind constStrideA = NodeStrideUtil.getConstantStrideA(this.dynamicStrides, this.strideA);
            JavaKind constStrideB = NodeStrideUtil.getConstantStrideB(this.dynamicStrides, this.strideB);
            JavaKind constStrideMask = NodeStrideUtil.getConstantStrideB(this.dynamicStrides, this.strideMask);
            if (len * Math.max(constStrideA.getByteCount(), constStrideB.getByteCount()) < GraalOptions.ArrayRegionEqualsConstantLimit.getValue(tool.getOptions()) && ConstantReflectionUtil.canFoldReads(tool, this.arrayA, this.offsetA, constStrideA, len, this) && ConstantReflectionUtil.canFoldReads(tool, this.arrayB, this.offsetB, constStrideB, len, this) && ConstantReflectionUtil.canFoldReads(tool, this.arrayMask, null, constStrideMask, len, this)) {
                Integer startIndex1 = ConstantReflectionUtil.startIndex(tool, this.arrayA, this.offsetA.asJavaConstant(), constStrideA, this);
                Integer startIndex2 = ConstantReflectionUtil.startIndex(tool, this.arrayB, this.offsetB.asJavaConstant(), constStrideB, this);
                return ConstantNode.forBoolean(AMD64ArrayRegionEqualsWithMaskNode.constantFold(tool, this.arrayA, startIndex1, this.arrayB, startIndex2, this.arrayMask, len, constStrideA, constStrideB, constStrideMask));
            }
        }
        return this;
    }

    private static boolean constantFold(CanonicalizerTool tool, ValueNode a, int startIndexA, ValueNode b, int startIndexB, ValueNode mask, int len, JavaKind constStrideA, JavaKind constStrideB, JavaKind constStrideMask) {
        JavaKind arrayKindA = a.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess()).getComponentType().getJavaKind();
        JavaKind arrayKindB = b.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess()).getComponentType().getJavaKind();
        JavaKind arrayKindM = mask.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess()).getComponentType().getJavaKind();
        ConstantReflectionProvider constantReflection = tool.getConstantReflection();
        for (int i = 0; i < len; ++i) {
            int valueA = ConstantReflectionUtil.readTypePunned(constantReflection, a.asJavaConstant(), arrayKindA, constStrideA, startIndexA + i);
            int valueB = ConstantReflectionUtil.readTypePunned(constantReflection, b.asJavaConstant(), arrayKindB, constStrideB, startIndexB + i);
            int valueM = ConstantReflectionUtil.readTypePunned(constantReflection, mask.asJavaConstant(), arrayKindM, constStrideMask, i);
            if ((valueA | valueM) == valueB) continue;
            return false;
        }
        return true;
    }
}

