/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.amd64.AMD64CalcStringAttributesOp;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_128)
public final class AMD64CalcStringAttributesNode
extends FixedWithNextNode
implements LIRLowerable,
MemoryAccess {
    public static final NodeClass<AMD64CalcStringAttributesNode> TYPE = NodeClass.create(AMD64CalcStringAttributesNode.class);
    private final AMD64CalcStringAttributesOp.Op op;
    private final boolean assumeValid;
    private final LocationIdentity locationIdentity;
    @Node.Input
    protected ValueNode array;
    @Node.Input
    protected ValueNode offset;
    @Node.Input
    protected ValueNode length;
    @Node.OptionalInput(value=InputType.Memory)
    private MemoryKill lastLocationAccess;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateBefore;

    protected AMD64CalcStringAttributesNode(@Node.ConstantNodeParameter AMD64CalcStringAttributesOp.Op op, @Node.ConstantNodeParameter boolean assumeValid, ValueNode array, ValueNode offset, ValueNode length) {
        this(op, assumeValid, LocationIdentity.any(), array, offset, length);
    }

    public AMD64CalcStringAttributesNode(@Node.ConstantNodeParameter AMD64CalcStringAttributesOp.Op op, @Node.ConstantNodeParameter boolean assumeValid, LocationIdentity locationIdentity, ValueNode array, ValueNode offset, ValueNode length) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(op == AMD64CalcStringAttributesOp.Op.UTF_8 || op == AMD64CalcStringAttributesOp.Op.UTF_16 ? JavaKind.Long : JavaKind.Int));
        this.op = op;
        this.assumeValid = assumeValid;
        this.locationIdentity = locationIdentity;
        this.array = array;
        this.offset = offset;
        this.length = length;
    }

    public AMD64CalcStringAttributesOp.Op getOp() {
        return this.op;
    }

    public boolean isAssumeValid() {
        return this.assumeValid;
    }

    public ValueNode getArray() {
        return this.array;
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    public ValueNode getLength() {
        return this.length;
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return this.locationIdentity;
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lastLocationAccess), ValueNodeUtil.asNode(lla));
        this.lastLocationAccess = lla;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        ForeignCallLinkage linkage;
        if (GraalOptions.UseGraalStubs.getValue(this.graph().getOptions()).booleanValue() && (linkage = gen.lookupGraalStub(this)) != null) {
            Variable result = gen.getLIRGeneratorTool().emitForeignCall(linkage, null, gen.operand(this.array), gen.operand(this.offset), gen.operand(this.length));
            gen.setResult(this, (Value)result);
            return;
        }
        Variable result = gen.getLIRGeneratorTool().emitCalcStringAttributes((Object)this.op, gen.operand(this.array), gen.operand(this.offset), gen.operand(this.length), this.assumeValid);
        gen.setResult(this, (Value)result);
    }

    @Node.NodeIntrinsic
    private static native int intReturnValue(@Node.ConstantNodeParameter AMD64CalcStringAttributesOp.Op var0, @Node.ConstantNodeParameter boolean var1, Object var2, long var3, int var5);

    @Node.NodeIntrinsic
    private static native long longReturnValue(@Node.ConstantNodeParameter AMD64CalcStringAttributesOp.Op var0, @Node.ConstantNodeParameter boolean var1, Object var2, long var3, int var5);

    public static int latin1Internal(Object array, long offset, int length) {
        return AMD64CalcStringAttributesNode.intReturnValue(AMD64CalcStringAttributesOp.Op.LATIN1, false, array, offset, length);
    }

    public static int bmpInternal(Object array, long offset, int length) {
        return AMD64CalcStringAttributesNode.intReturnValue(AMD64CalcStringAttributesOp.Op.BMP, false, array, offset, length);
    }

    public static long utf8Internal(boolean assumeValid, Object array, long offset, int length) {
        return AMD64CalcStringAttributesNode.longReturnValue(AMD64CalcStringAttributesOp.Op.UTF_8, assumeValid, array, offset, length);
    }

    public static long utf16Internal(boolean assumeValid, Object array, long offset, int length) {
        return AMD64CalcStringAttributesNode.longReturnValue(AMD64CalcStringAttributesOp.Op.UTF_16, assumeValid, array, offset, length);
    }

    public static int utf32Internal(Object array, long offset, int length) {
        return AMD64CalcStringAttributesNode.intReturnValue(AMD64CalcStringAttributesOp.Op.UTF_32, false, array, offset, length);
    }
}

