/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.AbstractMemoryCheckpoint;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.memory.MultiMemoryKill;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.NodeStrideUtil;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_128)
public class ArrayCopyWithConversionsNode
extends AbstractMemoryCheckpoint
implements LIRLowerable,
MemoryAccess,
MultiMemoryKill {
    public static final NodeClass<ArrayCopyWithConversionsNode> TYPE = NodeClass.create(ArrayCopyWithConversionsNode.class);
    public static final LocationIdentity[] KILLED_LOCATIONS = new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(JavaKind.Byte), NamedLocationIdentity.OFF_HEAP_LOCATION};
    private final JavaKind strideSrc;
    private final JavaKind strideDst;
    @Node.Input
    protected ValueNode arraySrc;
    @Node.Input
    protected ValueNode offsetSrc;
    @Node.Input
    protected ValueNode arrayDst;
    @Node.Input
    protected ValueNode offsetDst;
    @Node.Input
    protected ValueNode length;
    @Node.OptionalInput
    protected ValueNode dynamicStrides;
    @Node.OptionalInput(value=InputType.Memory)
    protected MemoryKill lastLocationAccess;

    public ArrayCopyWithConversionsNode(ValueNode arraySrc, ValueNode offsetSrc, ValueNode arrayDst, ValueNode offsetDst, ValueNode length, @Node.ConstantNodeParameter JavaKind strideSrc, @Node.ConstantNodeParameter JavaKind strideDst) {
        this(TYPE, arraySrc, offsetSrc, arrayDst, offsetDst, length, null, strideSrc, strideDst);
    }

    public ArrayCopyWithConversionsNode(ValueNode arraySrc, ValueNode offsetSrc, ValueNode arrayDst, ValueNode offsetDst, ValueNode length, ValueNode dynamicStrides) {
        this(TYPE, arraySrc, offsetSrc, arrayDst, offsetDst, length, dynamicStrides, null, null);
    }

    protected ArrayCopyWithConversionsNode(NodeClass<? extends ArrayCopyWithConversionsNode> c, ValueNode arraySrc, ValueNode offsetSrc, ValueNode arrayDst, ValueNode offsetDst, ValueNode length, ValueNode dynamicStrides, @Node.ConstantNodeParameter JavaKind strideSrc, @Node.ConstantNodeParameter JavaKind strideDst) {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)c, StampFactory.forKind(JavaKind.Void));
        this.strideSrc = strideSrc;
        this.strideDst = strideDst;
        this.arraySrc = arraySrc;
        this.offsetSrc = offsetSrc;
        this.arrayDst = arrayDst;
        this.offsetDst = offsetDst;
        this.length = length;
        this.dynamicStrides = dynamicStrides;
    }

    @Node.NodeIntrinsic
    public static native void arrayCopy(Object var0, long var1, Object var3, long var4, int var6, @Node.ConstantNodeParameter JavaKind var7, @Node.ConstantNodeParameter JavaKind var8);

    @Node.NodeIntrinsic
    public static native void arrayCopy(Object var0, long var1, Object var3, long var4, int var6, int var7);

    public int getDirectStubCallIndex() {
        return NodeStrideUtil.getDirectStubCallIndex(this.dynamicStrides, this.strideSrc, this.strideDst);
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        ForeignCallLinkage linkage;
        if (GraalOptions.UseGraalStubs.getValue(this.graph().getOptions()).booleanValue() && (linkage = gen.lookupGraalStub(this)) != null) {
            if (this.getDirectStubCallIndex() < 0) {
                gen.getLIRGeneratorTool().emitForeignCall(linkage, null, gen.operand(this.arraySrc), gen.operand(this.offsetSrc), gen.operand(this.arrayDst), gen.operand(this.offsetDst), gen.operand(this.length), gen.operand(this.dynamicStrides));
            } else {
                gen.getLIRGeneratorTool().emitForeignCall(linkage, null, gen.operand(this.arraySrc), gen.operand(this.offsetSrc), gen.operand(this.arrayDst), gen.operand(this.offsetDst), gen.operand(this.length));
            }
            return;
        }
        this.generateArrayCopy(gen);
    }

    protected void generateArrayCopy(NodeLIRBuilderTool gen) {
        if (this.getDirectStubCallIndex() < 0) {
            gen.getLIRGeneratorTool().emitArrayCopyWithConversion(gen.operand(this.arraySrc), gen.operand(this.offsetSrc), gen.operand(this.arrayDst), gen.operand(this.offsetDst), gen.operand(this.length), gen.operand(this.dynamicStrides));
        } else {
            gen.getLIRGeneratorTool().emitArrayCopyWithConversion(NodeStrideUtil.getConstantStrideA(this.dynamicStrides, this.strideSrc), NodeStrideUtil.getConstantStrideB(this.dynamicStrides, this.strideDst), gen.operand(this.arraySrc), gen.operand(this.offsetSrc), gen.operand(this.arrayDst), gen.operand(this.offsetDst), gen.operand(this.length));
        }
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return LocationIdentity.any();
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return KILLED_LOCATIONS;
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsagesInterface(this.lastLocationAccess, lla);
        this.lastLocationAccess = lla;
    }
}

