/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.ConstantReflectionUtil;
import org.graalvm.compiler.replacements.NodeStrideUtil;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_128)
public class ArrayRegionCompareToNode
extends FixedWithNextNode
implements Canonicalizable,
LIRLowerable,
MemoryAccess,
ConstantReflectionUtil.ArrayBaseOffsetProvider {
    public static final NodeClass<ArrayRegionCompareToNode> TYPE = NodeClass.create(ArrayRegionCompareToNode.class);
    protected final JavaKind strideA;
    protected final JavaKind strideB;
    protected final LocationIdentity locationIdentity;
    @Node.Input
    protected ValueNode arrayA;
    @Node.Input
    protected ValueNode offsetA;
    @Node.Input
    protected ValueNode arrayB;
    @Node.Input
    protected ValueNode offsetB;
    @Node.Input
    protected ValueNode length;
    @Node.OptionalInput
    protected ValueNode dynamicStrides;
    @Node.OptionalInput(value=InputType.Memory)
    protected MemoryKill lastLocationAccess;

    public ArrayRegionCompareToNode(ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length, JavaKind strideA, JavaKind strideB, LocationIdentity locationIdentity) {
        this(TYPE, arrayA, offsetA, arrayB, offsetB, length, null, strideA, strideB, locationIdentity);
    }

    public ArrayRegionCompareToNode(ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length, ValueNode dynamicStrides, LocationIdentity locationIdentity) {
        this(TYPE, arrayA, offsetA, arrayB, offsetB, length, dynamicStrides, null, null, locationIdentity);
    }

    public ArrayRegionCompareToNode(ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length, ValueNode dynamicStrides) {
        this(TYPE, arrayA, offsetA, arrayB, offsetB, length, dynamicStrides, null, null, LocationIdentity.ANY_LOCATION);
    }

    public ArrayRegionCompareToNode(ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length, @Node.ConstantNodeParameter JavaKind strideA, @Node.ConstantNodeParameter JavaKind strideB) {
        this(TYPE, arrayA, offsetA, arrayB, offsetB, length, null, strideA, strideB, strideA != strideB ? LocationIdentity.ANY_LOCATION : NamedLocationIdentity.getArrayLocation(strideA));
    }

    protected ArrayRegionCompareToNode(NodeClass<? extends ArrayRegionCompareToNode> c, ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length, ValueNode dynamicStrides, JavaKind strideA, JavaKind strideB, LocationIdentity locationIdentity) {
        super((NodeClass<? extends FixedWithNextNode>)c, StampFactory.forKind(JavaKind.Int));
        this.strideA = strideA;
        this.strideB = strideB;
        this.locationIdentity = locationIdentity;
        this.arrayA = arrayA;
        this.offsetA = offsetA;
        this.arrayB = arrayB;
        this.offsetB = offsetB;
        this.length = length;
        this.dynamicStrides = dynamicStrides;
        GraalError.guarantee(strideA == null || ArrayRegionCompareToNode.allowedStrides().contains(strideA), "unsupported strideA");
        GraalError.guarantee(strideB == null || ArrayRegionCompareToNode.allowedStrides().contains(strideB), "unsupported strideB");
    }

    private static EnumSet<JavaKind> allowedStrides() {
        return EnumSet.of(JavaKind.Byte, JavaKind.Char, JavaKind.Int);
    }

    @Node.NodeIntrinsic
    public static native int compare(Object var0, long var1, Object var3, long var4, int var6, @Node.ConstantNodeParameter JavaKind var7, @Node.ConstantNodeParameter JavaKind var8);

    @Node.NodeIntrinsic
    public static native int compare(Object var0, long var1, Object var3, long var4, int var6, int var7);

    public ValueNode getArrayA() {
        return this.arrayA;
    }

    public ValueNode getOffsetA() {
        return this.offsetA;
    }

    public ValueNode getArrayB() {
        return this.arrayB;
    }

    public ValueNode getOffsetB() {
        return this.offsetB;
    }

    public JavaKind getStrideA() {
        return this.strideA;
    }

    public JavaKind getStrideB() {
        return this.strideB;
    }

    public ValueNode getLength() {
        return this.length;
    }

    public int getDirectStubCallIndex() {
        return NodeStrideUtil.getDirectStubCallIndex(this.dynamicStrides, this.strideA, this.strideB);
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        ForeignCallLinkage linkage;
        if (GraalOptions.UseGraalStubs.getValue(this.graph().getOptions()).booleanValue() && (linkage = gen.lookupGraalStub(this)) != null) {
            Variable result = this.getDirectStubCallIndex() < 0 ? gen.getLIRGeneratorTool().emitForeignCall(linkage, null, gen.operand(this.arrayA), gen.operand(this.offsetA), gen.operand(this.arrayB), gen.operand(this.offsetB), gen.operand(this.length), gen.operand(this.dynamicStrides)) : gen.getLIRGeneratorTool().emitForeignCall(linkage, null, gen.operand(this.arrayA), gen.operand(this.offsetA), gen.operand(this.arrayB), gen.operand(this.offsetB), gen.operand(this.length));
            gen.setResult(this, (Value)result);
            return;
        }
        this.generateArrayCompare(gen);
    }

    @Override
    public int getArrayBaseOffset(MetaAccessProvider metaAccess, ValueNode array, JavaKind elementKind) {
        return metaAccess.getArrayBaseOffset(elementKind);
    }

    protected void generateArrayCompare(NodeLIRBuilderTool gen) {
        if (this.getDirectStubCallIndex() < 0) {
            gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitArrayRegionCompareTo(gen.operand(this.arrayA), gen.operand(this.offsetA), gen.operand(this.arrayB), gen.operand(this.offsetB), gen.operand(this.length), gen.operand(this.dynamicStrides)));
        } else {
            gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitArrayRegionCompareTo(NodeStrideUtil.getConstantStrideA(this.dynamicStrides, this.strideA), NodeStrideUtil.getConstantStrideB(this.dynamicStrides, this.strideB), gen.operand(this.arrayA), gen.operand(this.offsetA), gen.operand(this.arrayB), gen.operand(this.offsetB), gen.operand(this.length)));
        }
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return this.locationIdentity;
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill lla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lastLocationAccess), ValueNodeUtil.asNode(lla));
        this.lastLocationAccess = lla;
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool) {
        if ((this.dynamicStrides == null || this.dynamicStrides.isJavaConstant()) && this.length.isJavaConstant()) {
            int len = this.length.asJavaConstant().asInt();
            JavaKind constStrideA = NodeStrideUtil.getConstantStrideA(this.dynamicStrides, this.strideA);
            JavaKind constStrideB = NodeStrideUtil.getConstantStrideB(this.dynamicStrides, this.strideB);
            if (len * Math.max(constStrideA.getByteCount(), constStrideB.getByteCount()) < GraalOptions.ArrayRegionEqualsConstantLimit.getValue(tool.getOptions()) && ConstantReflectionUtil.canFoldReads(tool, this.arrayA, this.offsetA, constStrideA, len, this) && ConstantReflectionUtil.canFoldReads(tool, this.arrayB, this.offsetB, constStrideB, len, this)) {
                Integer startIndex1 = ConstantReflectionUtil.startIndex(tool, this.arrayA, this.offsetA.asJavaConstant(), constStrideA, this);
                Integer startIndex2 = ConstantReflectionUtil.startIndex(tool, this.arrayB, this.offsetB.asJavaConstant(), constStrideB, this);
                return ConstantNode.forInt(ArrayRegionCompareToNode.foldResult(tool, constStrideA, constStrideB, this.arrayA, startIndex1, this.arrayB, startIndex2, len));
            }
        }
        return this;
    }

    private static int foldResult(CanonicalizerTool tool, JavaKind constStrideA, JavaKind constStrideB, ValueNode a, int startIndexA, ValueNode b, int startIndexB, int len) {
        JavaKind arrayKindA = a.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess()).getComponentType().getJavaKind();
        JavaKind arrayKindB = b.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess()).getComponentType().getJavaKind();
        ConstantReflectionProvider constantReflection = tool.getConstantReflection();
        for (int i = 0; i < len; ++i) {
            int valueB;
            int valueA = ConstantReflectionUtil.readTypePunned(constantReflection, a.asJavaConstant(), arrayKindA, constStrideA, startIndexA + i);
            int cmp = valueA - (valueB = ConstantReflectionUtil.readTypePunned(constantReflection, b.asJavaConstant(), arrayKindB, constStrideB, startIndexB + i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }
}

