/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.serviceprovider;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicLong;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.VirtualObject;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.runtime.JVMCI;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.serviceprovider.JMXService;
import org.graalvm.compiler.serviceprovider.SpeculationEncodingAdapter;
import org.graalvm.compiler.serviceprovider.UnencodedSpeculationReason;

public final class GraalServices {
    private static final Map<Class<?>, List<?>> servicesCache = Services.IS_BUILDING_NATIVE_IMAGE ? new HashMap() : null;
    private static final Constructor<? extends SpeculationLog.SpeculationReason> encodedSpeculationReasonConstructor;
    private static final Method constantPoolLookupReferencedType;
    private static final Method virtualObjectGet;
    private static final Constructor<? extends Infopoint> implicitExceptionDispatchConstructor;
    private static final Module JVMCI_MODULE;
    private static final String JVMCI_RUNTIME_PACKAGE = "jdk.vm.ci.runtime";
    private static final AtomicLong globalTimeStamp;

    private GraalServices() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S> Iterable<S> load(Class<S> service) {
        if (Services.IS_IN_NATIVE_IMAGE || Services.IS_BUILDING_NATIVE_IMAGE) {
            List<?> list = servicesCache.get(service);
            if (list != null) {
                return list;
            }
            if (Services.IS_IN_NATIVE_IMAGE) {
                throw new InternalError(String.format("No %s providers found when building native image", service.getName()));
            }
        }
        Iterable<S> providers = GraalServices.load0(service);
        if (Services.IS_BUILDING_NATIVE_IMAGE) {
            Map<Class<?>, List<?>> map = servicesCache;
            synchronized (map) {
                ArrayList<S> providersList = new ArrayList<S>();
                for (S provider : providers) {
                    Module module = provider.getClass().getModule();
                    if (!GraalServices.isHotSpotGraalModule(module.getName())) continue;
                    providersList.add(provider);
                }
                providers = providersList;
                servicesCache.put(service, providersList);
                return providers;
            }
        }
        return providers;
    }

    private static boolean isHotSpotGraalModule(String name) {
        if (name != null) {
            return name.equals("jdk.internal.vm.compiler") || name.equals("jdk.internal.vm.compiler.management") || name.equals("com.oracle.graal.graal_enterprise");
        }
        return false;
    }

    private static <S> Iterable<S> load0(Class<S> service) {
        Module module = GraalServices.class.getModule();
        if (!module.canUse(service)) {
            module.addUses(service);
        }
        ModuleLayer layer = module.getLayer();
        final ServiceLoader<S> iterable = ServiceLoader.load(layer, service);
        return new Iterable<S>(){

            @Override
            public Iterator<S> iterator() {
                final Iterator iterator = iterable.iterator();
                return new Iterator<S>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public S next() {
                        Object provider = iterator.next();
                        GraalServices.openJVMCITo(provider.getClass());
                        return provider;
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }

    static void openJVMCITo(Class<?> other) {
        if (Services.IS_IN_NATIVE_IMAGE) {
            return;
        }
        Module jvmciModule = JVMCI_MODULE;
        Module otherModule = other.getModule();
        if (jvmciModule != otherModule) {
            for (String pkg : jvmciModule.getPackages()) {
                if (jvmciModule.isOpen(pkg, otherModule)) continue;
                JVMCI.getRuntime();
                jvmciModule.addOpens(pkg, otherModule);
            }
        }
    }

    public static <S> S loadSingle(Class<S> service, boolean required) {
        assert (!service.getName().startsWith("jdk.vm.ci")) : "JVMCI services must be loaded via " + Services.class.getName();
        Iterable<S> providers = GraalServices.load(service);
        Object singleProvider = null;
        try {
            Iterator<S> it = providers.iterator();
            while (it.hasNext()) {
                singleProvider = it.next();
                if (!it.hasNext()) continue;
                S other = it.next();
                throw new InternalError(String.format("Multiple %s providers found: %s, %s", service.getName(), singleProvider.getClass().getName(), other.getClass().getName()));
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            // empty catch block
        }
        if (singleProvider == null && required) {
            throw new InternalError(String.format("No provider for %s found", service.getName()));
        }
        return (S)singleProvider;
    }

    public static InputStream getClassfileAsStream(Class<?> c) throws IOException {
        String classfilePath = c.getName().replace('.', '/') + ".class";
        return c.getModule().getResourceAsStream(classfilePath);
    }

    public static boolean isToStringTrusted(Class<?> c) {
        Module jvmciModule;
        if (Services.IS_IN_NATIVE_IMAGE) {
            return true;
        }
        Module module = c.getModule();
        return module == (jvmciModule = JVMCI_MODULE) || jvmciModule.isOpen(JVMCI_RUNTIME_PACKAGE, module);
    }

    static SpeculationLog.SpeculationReason createSpeculationReason(int groupId, String groupName, Object ... context) {
        if (encodedSpeculationReasonConstructor != null) {
            SpeculationEncodingAdapter adapter = new SpeculationEncodingAdapter();
            try {
                Object[] flattened = adapter.flatten(context);
                return encodedSpeculationReasonConstructor.newInstance(groupId, groupName, flattened);
            }
            catch (Throwable throwable) {
                throw new InternalError(throwable);
            }
        }
        return new UnencodedSpeculationReason(groupId, groupName, context);
    }

    public static String getExecutionID() {
        return Long.toString(ProcessHandle.current().pid());
    }

    public static long getGlobalTimeStamp() {
        if (globalTimeStamp.get() == 0L) {
            globalTimeStamp.compareAndSet(0L, System.currentTimeMillis());
        }
        return globalTimeStamp.get();
    }

    public static long getThreadAllocatedBytes(long id) {
        JMXService jmx = JMXService.instance;
        if (jmx == null) {
            throw new UnsupportedOperationException();
        }
        return jmx.getThreadAllocatedBytes(id);
    }

    public static long getCurrentThreadAllocatedBytes() {
        return GraalServices.getThreadAllocatedBytes(Thread.currentThread().getId());
    }

    public static long getCurrentThreadCpuTime() {
        JMXService jmx = JMXService.instance;
        if (jmx == null) {
            throw new UnsupportedOperationException();
        }
        return jmx.getCurrentThreadCpuTime();
    }

    public static boolean isThreadAllocatedMemorySupported() {
        JMXService jmx = JMXService.instance;
        if (jmx == null) {
            return false;
        }
        return jmx.isThreadAllocatedMemorySupported();
    }

    public static boolean isCurrentThreadCpuTimeSupported() {
        JMXService jmx = JMXService.instance;
        if (jmx == null) {
            return false;
        }
        return jmx.isCurrentThreadCpuTimeSupported();
    }

    public static List<String> getInputArguments() {
        JMXService jmx = JMXService.instance;
        if (jmx == null) {
            return null;
        }
        return jmx.getInputArguments();
    }

    public static float fma(float a, float b, float c) {
        return Math.fma(a, b, c);
    }

    public static double fma(double a, double b, double c) {
        return Math.fma(a, b, c);
    }

    public static VirtualObject createVirtualObject(ResolvedJavaType type, int id, boolean isAutoBox) {
        if (virtualObjectGet != null) {
            try {
                return (VirtualObject)virtualObjectGet.invoke(null, type, id, isAutoBox);
            }
            catch (Throwable throwable) {
                throw new InternalError(throwable);
            }
        }
        return VirtualObject.get((ResolvedJavaType)type, (int)id);
    }

    public static int getJavaUpdateVersion() {
        return Runtime.version().update();
    }

    public static JavaType lookupReferencedType(ConstantPool constantPool, int cpi, int opcode) {
        if (constantPoolLookupReferencedType != null) {
            try {
                return (JavaType)constantPoolLookupReferencedType.invoke((Object)constantPool, cpi, opcode);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new InternalError(throwable);
            }
        }
        throw new InternalError("This JVMCI version doesn't support ConstantPool.lookupReferencedType()");
    }

    public static boolean hasLookupReferencedType() {
        return constantPoolLookupReferencedType != null;
    }

    public static boolean supportsArbitraryImplicitException() {
        return implicitExceptionDispatchConstructor != null;
    }

    public static Infopoint genImplicitException(int pcOffset, int dispatchOffset, DebugInfo debugInfo) {
        if (implicitExceptionDispatchConstructor == null) {
            if (pcOffset != dispatchOffset) {
                throw new InternalError("This JVMCI version doesn't support dispatching implicit exception to an arbitrary address.");
            }
            return new Infopoint(pcOffset, debugInfo, InfopointReason.IMPLICIT_EXCEPTION);
        }
        try {
            return implicitExceptionDispatchConstructor.newInstance(pcOffset, dispatchOffset, debugInfo);
        }
        catch (Throwable e) {
            throw new InternalError("Exception when instantiating implicit exception dispatch", e);
        }
    }

    static {
        Method get = null;
        Method lookupReferencedType = null;
        Constructor<?> esrConstructor = null;
        Constructor<?> iedConstructor = null;
        try {
            Class<?> theClass = Class.forName("jdk.vm.ci.meta.EncodedSpeculationReason");
            esrConstructor = theClass.getDeclaredConstructor(Integer.TYPE, String.class, Object[].class);
        }
        catch (ClassNotFoundException theClass) {
        }
        catch (NoSuchMethodException e) {
            throw new InternalError("EncodedSpeculationReason exists but constructor is missing or inaccessible", e);
        }
        try {
            get = VirtualObject.class.getDeclaredMethod("get", ResolvedJavaType.class, Integer.TYPE, Boolean.TYPE);
            lookupReferencedType = ConstantPool.class.getDeclaredMethod("lookupReferencedType", Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            Class<?> implicitExceptionDispatch = Class.forName("jdk.vm.ci.code.site.ImplicitExceptionDispatch");
            iedConstructor = implicitExceptionDispatch.getConstructor(Integer.TYPE, Integer.TYPE, DebugInfo.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        encodedSpeculationReasonConstructor = esrConstructor;
        virtualObjectGet = get;
        constantPoolLookupReferencedType = lookupReferencedType;
        implicitExceptionDispatchConstructor = iedConstructor;
        JVMCI_MODULE = Services.class.getModule();
        assert (JVMCI_MODULE.getPackages().contains(JVMCI_RUNTIME_PACKAGE));
        globalTimeStamp = new AtomicLong();
    }
}

