/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases;

import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.TruffleTierContext;

public final class InliningAcrossTruffleBoundaryPhase
extends BasePhase<TruffleTierContext> {
    @Override
    protected void run(StructuredGraph graph, TruffleTierContext context) {
        graph.checkCancellation();
        TruffleCompilerRuntime rt = TruffleCompilerRuntime.getRuntime();
        for (MethodCallTargetNode mct : graph.getNodes(MethodCallTargetNode.TYPE)) {
            TruffleCompilerRuntime.InlineKind inlineKind = rt.getInlineKind(mct.targetMethod(), false);
            if (inlineKind.allowsInlining()) continue;
            mct.invoke().setUseForInlining(false);
        }
    }
}

