/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.phases.HighTier;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.common.AbstractInliningPhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.contract.NodeCostUtil;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;

public class TruffleHostInliningPhase
extends AbstractInliningPhase {
    static final String INDENT = "  ";
    private static final int TRIVIAL_SIZE = 30;
    private static final int TRIVIAL_INVOKES = 0;
    protected final CanonicalizerPhase canonicalizer;

    public TruffleHostInliningPhase(CanonicalizerPhase canonicalizer) {
        this.canonicalizer = canonicalizer;
    }

    protected boolean isEnabledFor(ResolvedJavaMethod method) {
        return this.isBytecodeInterpreterSwitch(method);
    }

    private boolean isTransferToInterpreterMethod(ResolvedJavaMethod method) {
        return TruffleCompilerRuntime.getRuntimeIfAvailable().isTransferToInterpreterMethod(this.translateMethod(method));
    }

    private boolean isInInterpreter(ResolvedJavaMethod targetMethod) {
        return TruffleCompilerRuntime.getRuntimeIfAvailable().isInInterpreter(this.translateMethod(targetMethod));
    }

    protected boolean isTruffleBoundary(ResolvedJavaMethod targetMethod) {
        return TruffleCompilerRuntime.getRuntimeIfAvailable().isTruffleBoundary(this.translateMethod(targetMethod));
    }

    private boolean isBytecodeInterpreterSwitch(ResolvedJavaMethod targetMethod) {
        return TruffleCompilerRuntime.getRuntimeIfAvailable().isBytecodeInterpreterSwitch(this.translateMethod(targetMethod));
    }

    protected ResolvedJavaMethod translateMethod(ResolvedJavaMethod method) {
        return method;
    }

    @Override
    protected final void run(StructuredGraph graph, HighTierContext highTierContext) {
        ResolvedJavaMethod method = graph.method();
        if (!this.isEnabledFor(method)) {
            return;
        }
        this.runImpl(new InliningPhaseContext(highTierContext, graph, TruffleCompilerRuntime.getRuntimeIfAvailable(), this.isBytecodeInterpreterSwitch(method)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runImpl(InliningPhaseContext context) {
        ResolvedJavaMethod rootMethod = context.graph.method();
        int sizeLimit = context.isBytecodeSwitch ? Options.TruffleHostInliningByteCodeInterpreterBudget.getValue(context.graph.getOptions()).intValue() : Options.TruffleHostInliningBaseBudget.getValue(context.graph.getOptions()).intValue();
        DebugContext debug = context.graph.getDebug();
        debug.dump(3, context.graph, "Before Truffle host inlining");
        CallTree root = new CallTree(rootMethod);
        int round = 0;
        int inlineIndex = 0;
        int previousInlineIndex = -1;
        boolean budgetLimitReached = false;
        ArrayList<CallTree> toProcess = null;
        EconomicSet canonicalizableNodes = EconomicSet.create();
        int graphSize = 0;
        int beforeGraphSize = 0;
        try {
            while (previousInlineIndex < inlineIndex) {
                ArrayList<CallTree> newTargets;
                previousInlineIndex = inlineIndex;
                if (!canonicalizableNodes.isEmpty()) {
                    this.canonicalizer.applyIncremental(context.graph, (CoreProviders)context.highTierContext, (Iterable<? extends Node>)canonicalizableNodes);
                    canonicalizableNodes.clear();
                }
                graphSize = NodeCostUtil.computeNodesSize(context.graph.getNodes());
                if (round == 0) {
                    beforeGraphSize = graphSize;
                    root.children = this.exploreGraph(context, null, root, context.graph, round, sizeLimit, 0);
                    toProcess = new ArrayList<CallTree>(root.children.size());
                    toProcess.addAll(root.children);
                } else {
                    budgetLimitReached = false;
                    toProcess.clear();
                    this.exploreAndQueueInlinableCalls(context, root, (Collection<CallTree>)toProcess, round, sizeLimit);
                }
                ArrayList<CallTree> targets = toProcess;
                do {
                    newTargets = new ArrayList<CallTree>();
                    for (CallTree call : targets) {
                        if (!call.forceShallowInline || !this.shouldInline(context, call)) continue;
                        assert (call.children == null && call.exploredIndex == -1) : "force shallow inline already explored";
                        call.children = this.exploreGraph(context, null, call, this.lookupGraph(context, call.getTargetMethod()), round, sizeLimit, 0);
                        newTargets.addAll(call.children);
                        graphSize += call.graphSize;
                        this.inline(context, (EconomicSet<Node>)canonicalizableNodes, call, inlineIndex++, false);
                    }
                    toProcess.addAll(newTargets);
                    targets = newTargets;
                } while (!newTargets.isEmpty());
                Collections.sort(toProcess);
                for (CallTree call : toProcess) {
                    if (!this.shouldInline(context, call) || !TruffleHostInliningPhase.isInBudget(call, graphSize, sizeLimit)) continue;
                    assert (!call.forceShallowInline) : "should already be inlined";
                    graphSize += call.subTreeSize;
                    this.inline(context, (EconomicSet<Node>)canonicalizableNodes, call, inlineIndex++, true);
                    if (!debug.isDumpEnabled(5)) continue;
                    debug.dump(5, (Object)context.graph, "After Truffle host inlining %s", call.getTargetMethod().format("%H.%n(%P)"));
                }
                debug.dump(4, (Object)context.graph, "After Truffle host inlining round %s", round);
                ++round;
            }
        }
        finally {
            if (debug.isLogEnabled()) {
                if (budgetLimitReached) {
                    debug.log("Warning method host inlining limit exceeded limit %s with graph size %s.", sizeLimit, graphSize);
                }
                debug.log("Truffle host inlining completed after %s rounds. Graph cost changed from %s to %s after inlining: %n%s", round, (Object)beforeGraphSize, (Object)graphSize, (Object)this.printCallTree(context, root));
            }
        }
    }

    private static boolean isInBudget(CallTree call, int graphSize, int sizeLimit) {
        boolean trivial;
        if (call.forceShallowInline) {
            return true;
        }
        int newSize = graphSize + call.subTreeSize;
        if (newSize <= sizeLimit) {
            call.reason = "within budget";
            return true;
        }
        boolean bl = trivial = call.subTreeInvokes == 0 && call.subTreeSize < 30;
        if (trivial) {
            call.reason = "out of budget but simple enough";
            return true;
        }
        call.reason = "Out of budget";
        return false;
    }

    private List<CallTree> exploreGraph(InliningPhaseContext context, CallTree root, CallTree caller, StructuredGraph graph, int exploreRound, int exploreBudget, int depth) {
        caller.exploredIndex = exploreRound;
        ControlFlowGraph cfg = ControlFlowGraph.compute(graph, true, false, true, false);
        EconomicSet deoptimizedBlocks = EconomicSet.create();
        EconomicSet inInterpreterBlocks = EconomicSet.create();
        ArrayList<CallTree> children = new ArrayList<CallTree>();
        for (Block block : cfg.reversePostOrder()) {
            if (block.getEndNode() instanceof IfNode) {
                IfNode ifNode = (IfNode)block.getEndNode();
                LogicNode condition = ifNode.condition();
                for (Node input : condition.inputs()) {
                    ResolvedJavaMethod targetMethod;
                    if (!(input instanceof Invoke) || (targetMethod = ((Invoke)((Object)input)).getTargetMethod()) == null || !this.isInInterpreter(targetMethod)) continue;
                    inInterpreterBlocks.add((Object)ifNode.falseSuccessor());
                    break;
                }
            }
            boolean guardedByInInterpreter = false;
            block2: for (FixedNode node : block.getNodes()) {
                boolean deoptimized;
                Invoke invoke;
                ResolvedJavaMethod newTargetMethod;
                FixedGuardNode guard;
                if (root != null && root.explorationIncomplete) {
                    return children;
                }
                if (node instanceof FixedGuardNode && (guard = (FixedGuardNode)node).isNegated()) {
                    LogicNode condition = guard.condition();
                    for (Node input : condition.inputs()) {
                        ResolvedJavaMethod targetMethod;
                        if (!(input instanceof Invoke) || (targetMethod = ((Invoke)((Object)input)).getTargetMethod()) == null || !this.isInInterpreter(targetMethod)) continue;
                        for (Block dominatedSilbling = (Block)block.getFirstDominated(); dominatedSilbling != null; dominatedSilbling = (Block)dominatedSilbling.getDominatedSibling()) {
                            inInterpreterBlocks.add((Object)dominatedSilbling.getBeginNode());
                        }
                        guardedByInInterpreter = true;
                        break;
                    }
                }
                if (!(node instanceof Invoke) || (newTargetMethod = (invoke = (Invoke)((Object)node)).getTargetMethod()) == null) continue;
                boolean bl = deoptimized = caller.deoptimized || TruffleHostInliningPhase.isBlockOrDominatorContainedIn(block, (EconomicSet<AbstractBeginNode>)deoptimizedBlocks);
                if (this.isTransferToInterpreterMethod(newTargetMethod)) {
                    deoptimizedBlocks.add((Object)block.getBeginNode());
                    if (block.getBeginNode() == graph.start()) {
                        caller.propagatesDeopt = true;
                    }
                }
                boolean inInterpreter = guardedByInInterpreter || caller.inInterpreter || TruffleHostInliningPhase.isBlockOrDominatorContainedIn(block, (EconomicSet<AbstractBeginNode>)inInterpreterBlocks);
                boolean forceShallowInline = context.isBytecodeSwitch && (caller.forceShallowInline || caller.parent == null) && this.isBytecodeInterpreterSwitch(invoke.getTargetMethod());
                CallTree callee = new CallTree(caller, invoke, deoptimized, inInterpreter, forceShallowInline);
                children.add(callee);
                if (forceShallowInline) continue;
                CallTree exploreRoot = root == null ? callee : root;
                if (this.shouldInline(context, callee)) {
                    callee.children = this.exploreInlinableCall(context, exploreRoot, callee, exploreRound, exploreBudget, depth);
                    if (!callee.propagatesDeopt) continue;
                    deoptimizedBlocks.add((Object)block.getBeginNode());
                    if (block.getBeginNode() != graph.start()) continue;
                    caller.propagatesDeopt = true;
                    continue;
                }
                if (deoptimized || inInterpreter) continue;
                CallTree current = callee;
                while (current != null) {
                    ++current.subTreeInvokes;
                    if (current == exploreRoot) continue block2;
                    current = current.parent;
                }
            }
        }
        return children;
    }

    private static boolean isBlockOrDominatorContainedIn(Block currentBlock, EconomicSet<AbstractBeginNode> blocks) {
        if (blocks.isEmpty()) {
            return false;
        }
        for (Block dominator = currentBlock; dominator != null; dominator = (Block)dominator.getDominator()) {
            if (!blocks.contains((Object)dominator.getBeginNode())) continue;
            return true;
        }
        return false;
    }

    private List<CallTree> exploreInlinableCall(InliningPhaseContext context, CallTree exploreRoot, CallTree callee, int exploreRound, int exploreBudget, int depth) {
        ResolvedJavaMethod targetMethod;
        if (callee.invoke.getInvokeKind().isDirect()) {
            targetMethod = callee.getTargetMethod();
        } else {
            assert (callee.monomorphicTargetMethod != null);
            targetMethod = callee.monomorphicTargetMethod;
        }
        StructuredGraph calleeGraph = this.lookupGraph(context, targetMethod);
        assert (calleeGraph != null) : "There must be a graph available for an inlinable call.";
        callee.graphSize = NodeCostUtil.computeNodesSize(calleeGraph.getNodes());
        if (TruffleHostInliningPhase.shouldContinueExploring(context, exploreRoot, exploreBudget, callee.graphSize, depth)) {
            CallTree current = callee;
            while (current != null) {
                current.subTreeSize += callee.graphSize;
                if (current == exploreRoot) break;
                current = current.parent;
            }
            return this.exploreGraph(context, exploreRoot, callee, calleeGraph, exploreRound, exploreBudget, depth + 1);
        }
        exploreRoot.explorationIncomplete = true;
        return Collections.emptyList();
    }

    private static boolean shouldContinueExploring(InliningPhaseContext context, CallTree exploreRoot, int exploreBudget, int graphSize, int depth) {
        int useBudget = Math.max(30, exploreBudget);
        return exploreRoot.subTreeSize + graphSize <= useBudget && depth < Options.TruffleHostInliningMaxExplorationDepth.getValue(context.options);
    }

    private boolean shouldInline(InliningPhaseContext context, CallTree call) {
        if (call.parent == null) {
            return true;
        }
        Invoke invoke = call.invoke;
        if (call.isInlined()) {
            return false;
        }
        if (!(invoke.callTarget() instanceof MethodCallTargetNode)) {
            call.reason = "not a method call target";
            return false;
        }
        ResolvedJavaMethod targetMethod = invoke.getTargetMethod();
        if (!TruffleHostInliningPhase.shouldInlineTarget(context, call, targetMethod)) {
            return false;
        }
        String failureMessage = InliningUtil.checkInvokeConditions(call.invoke);
        if (failureMessage != null) {
            call.reason = failureMessage;
            return false;
        }
        if (!invoke.getInvokeKind().isDirect() && !TruffleHostInliningPhase.shouldInlineMonomorphic(context, call, targetMethod)) {
            return false;
        }
        if (this.isTransferToInterpreterMethod(targetMethod)) {
            return true;
        }
        if (this.isInInterpreter(targetMethod)) {
            return true;
        }
        if (call.forceShallowInline) {
            return true;
        }
        if (call.deoptimized) {
            call.reason = "dominated by transferToInterpreter()";
            return false;
        }
        if (call.inInterpreter) {
            call.reason = "protected by inInterpreter()";
            return false;
        }
        if (call.propagatesDeopt) {
            call.reason = "propagates transferToInterpreter";
            return false;
        }
        if (call.explorationIncomplete) {
            call.reason = "too big to explore";
            return false;
        }
        if (call.parent.isRecursive(targetMethod)) {
            call.reason = "recursive";
            return false;
        }
        if (context.highTierContext.getReplacements().hasSubstitution(targetMethod, context.graph.getOptions())) {
            call.reason = "has substituion";
            return false;
        }
        if (this.isTruffleBoundary(targetMethod)) {
            call.reason = "truffle boundary";
            return false;
        }
        if (this.isBytecodeInterpreterSwitch(targetMethod)) {
            call.reason = "bytecode interpreter switch must not be inlined";
            return false;
        }
        ProfilingInfo info = context.graph.getProfilingInfo(targetMethod);
        if (info != null && new OptimisticOptimizations(context.graph.getProfilingInfo(targetMethod), context.options).lessOptimisticThan(context.highTierContext.getOptimisticOptimizations())) {
            call.reason = "the callee uses less optimistic optimizations than caller";
            return false;
        }
        return true;
    }

    private static boolean shouldInlineTarget(InliningPhaseContext context, CallTree call, ResolvedJavaMethod targetMethod) {
        if (targetMethod == null) {
            call.reason = "target method is not resolved";
            return false;
        }
        if (!targetMethod.canBeInlined()) {
            call.reason = "target method not inlinable";
            return false;
        }
        if (targetMethod.isNative() && (!GraalOptions.Intrinsify.getValue(context.options).booleanValue() || context.highTierContext.getReplacements().getInlineSubstitution(targetMethod, call.invoke.bci(), call.invoke.getInlineControl(), context.graph.trackNodeSourcePosition(), null, context.graph.allowAssumptions(), context.options) == null)) {
            call.reason = "target method is a non-intrinsic native method";
            return false;
        }
        if (!targetMethod.getDeclaringClass().isInitialized()) {
            call.reason = "target method's class is not initialized";
            return false;
        }
        return true;
    }

    private void exploreAndQueueInlinableCalls(InliningPhaseContext context, CallTree call, Collection<CallTree> toProcess, int round, int exploreBudget) {
        if (call.isInlined()) {
            for (CallTree callee : call.children) {
                this.exploreAndQueueInlinableCalls(context, callee, toProcess, round, exploreBudget);
            }
        } else if (this.shouldInline(context, call)) {
            if (call.exploredIndex == -1) {
                call.subTreeInvokes = 0;
                call.subTreeSize = 0;
                call.children = this.exploreInlinableCall(context, call, call, round, exploreBudget, 1);
            }
            toProcess.add(call);
        }
    }

    private static boolean shouldInlineMonomorphic(InliningPhaseContext context, CallTree call, ResolvedJavaMethod targetMethod) {
        Invoke invoke = call.invoke;
        JavaTypeProfile typeProfile = ((MethodCallTargetNode)invoke.callTarget()).getTypeProfile();
        if (typeProfile == null) {
            call.reason = "not direct call: no type profile";
            return false;
        }
        if (typeProfile.getNotRecordedProbability() != 0.0) {
            call.reason = "not direct call: type might be imprecise";
            return false;
        }
        JavaTypeProfile.ProfiledType[] ptypes = typeProfile.getTypes();
        if (ptypes == null || ptypes.length <= 0) {
            call.reason = "not direct call: no parameter types in profile";
            return false;
        }
        if (ptypes.length != 1) {
            call.reason = "not direct call: polymorphic inlining not supported";
            return false;
        }
        SpeculationLog speculationLog = context.graph.getSpeculationLog();
        if (speculationLog == null) {
            call.reason = "not direct call: no speculation log";
            return false;
        }
        OptimisticOptimizations optimisticOpts = context.highTierContext.getOptimisticOptimizations();
        if (!optimisticOpts.inlineMonomorphicCalls(context.options)) {
            call.reason = "not direct call: inlining monomorphic calls is disabled";
            return false;
        }
        SpeculationLog.SpeculationReason speculationReason = InliningUtil.createSpeculation(invoke, typeProfile);
        if (!speculationLog.maySpeculate(speculationReason)) {
            call.reason = "not direct call: speculation disabled";
            return false;
        }
        ResolvedJavaType type = ptypes[0].getType();
        ResolvedJavaMethod concrete = type.resolveConcreteMethod(targetMethod, invoke.getContextType());
        if (!TruffleHostInliningPhase.shouldInlineTarget(context, call, concrete)) {
            return false;
        }
        call.monomorphicTargetMethod = concrete;
        return true;
    }

    private void inline(InliningPhaseContext context, EconomicSet<Node> canonicalizableNodes, CallTree call, int inlineIndex, boolean recursive) {
        assert (call.invoke.asFixedNode().graph() == context.graph) : "invalid graph";
        assert (call.children != null) : "Call not yet explored or marked incomplete.";
        assert (this.shouldInline(context, call)) : "Call should be inlined.";
        call.reason = null;
        call.inlinedIndex = inlineIndex;
        UnmodifiableEconomicMap<Node, Node> oldToNew = this.inline(context, canonicalizableNodes, call);
        for (CallTree child : call.children) {
            child.invoke = (Invoke)oldToNew.get((Object)child.invoke.asFixedNode());
            assert (child.invoke != null) : "new invoke not found";
        }
        if (!recursive) {
            return;
        }
        for (CallTree child : call.children) {
            if (!this.shouldInline(context, child)) continue;
            this.inline(context, canonicalizableNodes, child, inlineIndex, false);
        }
    }

    private UnmodifiableEconomicMap<Node, Node> inline(InliningPhaseContext context, EconomicSet<Node> canonicalizableNodes, CallTree call) {
        ResolvedJavaMethod targetMethod;
        Invoke invoke = call.invoke;
        if (invoke.getInvokeKind().isDirect()) {
            targetMethod = invoke.getTargetMethod();
        } else {
            targetMethod = call.monomorphicTargetMethod;
            assert (targetMethod != null);
            JavaTypeProfile typeProfile = ((MethodCallTargetNode)invoke.callTarget()).getTypeProfile();
            SpeculationLog.SpeculationReason speculationReason = InliningUtil.createSpeculation(invoke, typeProfile);
            SpeculationLog speculationLog = context.graph.getSpeculationLog();
            ResolvedJavaType resolvedType = typeProfile.getTypes()[0].getType();
            InliningUtil.insertTypeGuard(context.highTierContext, invoke, resolvedType, speculationLog.speculate(speculationReason));
            InliningUtil.replaceInvokeCallTarget(invoke, context.graph, CallTargetNode.InvokeKind.Special, targetMethod);
        }
        StructuredGraph inlineGraph = this.lookupGraph(context, targetMethod);
        AtomicReference duplicates = new AtomicReference();
        canonicalizableNodes.addAll(InliningUtil.inlineForCanonicalization(invoke, inlineGraph, true, targetMethod, d -> duplicates.set(d), "Truffle Host Inlining", "Truffle Host Inlining"));
        return (UnmodifiableEconomicMap)duplicates.get();
    }

    private StructuredGraph lookupGraph(InliningPhaseContext context, ResolvedJavaMethod method) {
        StructuredGraph graph = (StructuredGraph)context.graphCache.get((Object)method);
        if (graph == null) {
            graph = this.parseGraph(context.highTierContext, context.graph, method);
            context.graphCache.put((Object)method, (Object)graph);
        }
        return graph;
    }

    protected StructuredGraph parseGraph(HighTierContext context, StructuredGraph graph, ResolvedJavaMethod method) {
        DebugContext debug = graph.getDebug();
        StructuredGraph newGraph = new StructuredGraph.Builder(graph.getOptions(), debug, graph.allowAssumptions()).method(method).trackNodeSourcePosition(graph.trackNodeSourcePosition()).profileProvider(graph.getProfileProvider()).speculationLog(graph.getSpeculationLog()).build();
        DebugContext.Scope s = debug.scope((Object)"InlineGraph", newGraph);
        try {
            if (!graph.isUnsafeAccessTrackingEnabled()) {
                newGraph.disableUnsafeAccessTracking();
            }
            if (context.getGraphBuilderSuite() != null) {
                context.getGraphBuilderSuite().apply(newGraph, context);
            }
            assert (newGraph.start().next() != null) : "graph needs to be populated by the GraphBuilderSuite " + method + ", " + method.canBeInlined();
            new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Optional).apply(newGraph);
            this.canonicalizer.apply(newGraph, context);
            StructuredGraph structuredGraph = newGraph;
            if (s != null) {
                s.close();
            }
            return structuredGraph;
        }
        catch (Throwable throwable) {
            try {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
        }
    }

    private String printCallTree(InliningPhaseContext context, CallTree root) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream writer = new PrintStream(out, true);
        this.printTree(context, writer, INDENT, root, this.maxLabelWidth(context, root, 0, 1));
        return new String(out.toByteArray());
    }

    private int maxLabelWidth(InliningPhaseContext context, CallTree tree, int maxLabelWidth, int depth) {
        int maxLabel = 0;
        maxLabel = tree.parent == null ? 0 : Math.max(tree.buildLabel().length() + depth * INDENT.length(), maxLabelWidth);
        if (tree.children != null && (Options.TruffleHostInliningPrintExplored.getValue(context.options).booleanValue() || tree.inlinedIndex != -1 || tree.parent == null)) {
            for (CallTree child : tree.children) {
                maxLabel = this.maxLabelWidth(context, child, maxLabel, depth + 1);
            }
        }
        return maxLabel;
    }

    private void printTree(InliningPhaseContext context, PrintStream out, String indent, CallTree tree, int maxLabelWidth) {
        out.printf("%s%n", tree.toString(indent, maxLabelWidth));
        if (tree.children != null && (Options.TruffleHostInliningPrintExplored.getValue(context.options).booleanValue() || tree.inlinedIndex != -1 || tree.parent == null)) {
            for (CallTree child : tree.children) {
                this.printTree(context, out, indent + INDENT, child, maxLabelWidth);
            }
        }
    }

    public static void install(HighTier highTier, OptionValues options) {
        TruffleCompilerRuntime rt = TruffleCompilerRuntime.getRuntimeIfAvailable();
        if (rt == null) {
            return;
        }
        if (!Options.TruffleHostInlining.getValue(options).booleanValue()) {
            return;
        }
        TruffleHostInliningPhase phase = new TruffleHostInliningPhase(highTier.createCanonicalizerPhase());
        ListIterator insertionPoint = highTier.findPhase(AbstractInliningPhase.class);
        if (insertionPoint == null) {
            highTier.prependPhase(phase);
            return;
        }
        insertionPoint.previous();
        insertionPoint.add(phase);
    }

    public static void installInlineInvokePlugin(GraphBuilderConfiguration.Plugins plugins, OptionValues options) {
        if (Options.TruffleHostInlining.getValue(options).booleanValue()) {
            plugins.prependInlineInvokePlugin(new BytecodeParserInlineInvokePlugin());
        }
    }

    public static boolean shouldDenyTrivialInlining(ResolvedJavaMethod callee) {
        TruffleCompilerRuntime r = TruffleCompilerRuntime.getRuntimeIfAvailable();
        assert (r != null);
        return r.isBytecodeInterpreterSwitch(callee) || r.isTruffleBoundary(callee) || r.isInInterpreter(callee) || r.isTransferToInterpreterMethod(callee);
    }

    static final class CallTree
    implements Comparable<CallTree> {
        Invoke invoke;
        final CallTree parent;
        List<CallTree> children;
        final boolean deoptimized;
        final boolean inInterpreter;
        final boolean forceShallowInline;
        boolean propagatesDeopt;
        String reason;
        int inlinedIndex = -1;
        ResolvedJavaMethod cachedTargetMethod;
        ResolvedJavaMethod monomorphicTargetMethod;
        int subTreeInvokes;
        int subTreeSize;
        int graphSize;
        boolean explorationIncomplete;
        int exploredIndex = -1;

        CallTree(CallTree parent, Invoke invoke, boolean deoptimized, boolean inInterpreter, boolean forceShallowInline) {
            this.invoke = invoke;
            this.deoptimized = deoptimized;
            this.inInterpreter = inInterpreter;
            this.parent = parent;
            this.cachedTargetMethod = invoke.getTargetMethod();
            this.forceShallowInline = forceShallowInline;
            Objects.requireNonNull(this.cachedTargetMethod);
        }

        CallTree(ResolvedJavaMethod root) {
            this.invoke = null;
            this.deoptimized = false;
            this.inInterpreter = false;
            this.forceShallowInline = false;
            this.cachedTargetMethod = root;
            this.parent = null;
        }

        ResolvedJavaMethod getTargetMethod() {
            if (this.invoke == null) {
                return this.cachedTargetMethod;
            }
            ResolvedJavaMethod targetMethod = this.invoke.getTargetMethod();
            if (targetMethod != null) {
                this.cachedTargetMethod = targetMethod;
            } else {
                targetMethod = this.cachedTargetMethod;
            }
            return targetMethod;
        }

        boolean isInlined() {
            return this.inlinedIndex != -1 || this.parent == null;
        }

        @Override
        public int compareTo(CallTree o) {
            int compare = Integer.compare(this.subTreeInvokes, o.subTreeInvokes);
            if (compare == 0) {
                return Integer.compare(this.subTreeSize, o.subTreeSize);
            }
            return compare;
        }

        private boolean isRecursive(ResolvedJavaMethod other) {
            if (this.getTargetMethod().equals(other)) {
                return true;
            }
            if (this.parent != null) {
                return this.parent.isRecursive(other);
            }
            return false;
        }

        public String toString(String indent, int maxIndent) {
            ResolvedJavaMethod targetMethod = this.getTargetMethod();
            if (this.invoke == null) {
                return "Root[" + targetMethod.format("%H.%n") + "]";
            }
            return String.format("%-" + maxIndent + "s [inlined %4s, explored %4s, monomorphic %5s, deopt %5s, inInterpreter %5s, propDeopt %5s, graphSize %4s, subTreeInvokes %4s, subTreeCost %4s, forced %5s, incomplete %5s,  reason %s]", indent + this.buildLabel(), this.inlinedIndex, this.exploredIndex, this.monomorphicTargetMethod != null, this.deoptimized, this.inInterpreter, this.propagatesDeopt, this.graphSize, this.subTreeInvokes, this.subTreeSize, this.forceShallowInline, this.explorationIncomplete, this.reason);
        }

        private String buildLabel() {
            String label = this.reason == null && this.inlinedIndex == -1 ? "NEW" : (this.inlinedIndex != -1 ? "INLINE" : (this.invoke.isAlive() ? "CUTOFF" : "DEAD"));
            StringBuilder b = new StringBuilder(label);
            b.append(" ");
            String name = this.getTargetMethod().format("%H.%n(%p)");
            if (name.length() > 140) {
                name = this.getTargetMethod().format("%H.%n(...)");
            }
            b.append(name);
            return b.toString();
        }

        public String toString() {
            return this.toString("", 1);
        }
    }

    static final class InliningPhaseContext {
        final HighTierContext highTierContext;
        final StructuredGraph graph;
        final OptionValues options;
        final TruffleCompilerRuntime truffle;
        final boolean isBytecodeSwitch;
        final EconomicMap<ResolvedJavaMethod, StructuredGraph> graphCache = EconomicMap.create((Equivalence)Equivalence.DEFAULT);

        InliningPhaseContext(HighTierContext context, StructuredGraph graph, TruffleCompilerRuntime truffle, boolean isBytecodeSwitch) {
            this.highTierContext = context;
            this.graph = graph;
            this.options = graph.getOptions();
            this.truffle = truffle;
            this.isBytecodeSwitch = isBytecodeSwitch;
        }
    }

    static final class BytecodeParserInlineInvokePlugin
    implements InlineInvokePlugin {
        BytecodeParserInlineInvokePlugin() {
        }

        @Override
        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod targetMethod, ValueNode[] args) {
            TruffleCompilerRuntime rt = TruffleCompilerRuntime.getRuntimeIfAvailable();
            if (rt != null && TruffleHostInliningPhase.shouldDenyTrivialInlining(targetMethod)) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            return null;
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> TruffleHostInlining = new OptionKey<Boolean>(true);
        public static final OptionKey<Integer> TruffleHostInliningBaseBudget = new OptionKey<Integer>(5000);
        public static final OptionKey<Integer> TruffleHostInliningByteCodeInterpreterBudget = new OptionKey<Integer>(100000);
        public static final OptionKey<Boolean> TruffleHostInliningPrintExplored = new OptionKey<Boolean>(false);
        public static final OptionKey<Integer> TruffleHostInliningMaxExplorationDepth = new OptionKey<Integer>(1000);
    }
}

